/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.request;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.snmp4j.agent.request.Request;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.OID;

public abstract class AbstractRequest
implements Request {
    protected List subrequests;
    protected int phase = -1;
    protected int errorStatus = 0;
    protected int repeaterStartIndex;
    protected int repeaterRowSize;
    protected int reprocessCounter = 0;
    protected int transactionID;

    public abstract boolean isBulkRequest();

    public SubRequest find(OID prefix) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            SubRequest sreq = (SubRequest)it.next();
            if (!sreq.getVariableBinding().getOid().startsWith(prefix)) continue;
            return sreq;
        }
        return null;
    }

    protected synchronized void initSubRequests() {
        if (this.subrequests == null) {
            this.setupSubRequests();
        }
    }

    protected abstract void setupSubRequests();

    protected abstract int getMaxPhase();

    public int nextPhase() {
        if (this.phase >= this.getMaxPhase()) {
            throw new NoSuchElementException("Requested phase does not exists");
        }
        this.resetCompletionStatus();
        switch (this.phase) {
            case 1: {
                if (this.getErrorStatus() != 0) {
                    this.phase = 4;
                    break;
                }
                this.phase = 2;
                break;
            }
            case 2: {
                if (this.getErrorStatus() != 0) {
                    this.phase = 3;
                    break;
                }
                this.phase = 4;
                break;
            }
            case 3: {
                this.phase = 4;
                break;
            }
            default: {
                this.phase = 1;
            }
        }
        return this.phase;
    }

    public boolean isComplete() {
        if (this.getPhase() >= this.getMaxPhase()) {
            return this.isPhaseComplete();
        }
        return false;
    }

    public SubRequest get(int index) {
        return (SubRequest)this.subrequests.get(index);
    }

    public int getPhase() {
        return this.phase;
    }

    public int getErrorIndex() {
        if (this.errorStatus == 0) {
            return 0;
        }
        this.initSubRequests();
        int index = 1;
        Iterator it = this.subrequests.iterator();
        while (it.hasNext()) {
            SubRequest sreq = (SubRequest)it.next();
            if (sreq.getStatus().getErrorStatus() != 0) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    public int getErrorStatus() {
        this.initSubRequests();
        if (this.errorStatus == 0) {
            Iterator it = this.subrequests.iterator();
            while (it.hasNext()) {
                SubRequest sreq = (SubRequest)it.next();
                if (sreq.getStatus().getErrorStatus() == 0) continue;
                return sreq.getStatus().getErrorStatus();
            }
        }
        return this.errorStatus;
    }

    public int getTransactionID() {
        return this.transactionID;
    }

    public void setPhase(int phase) throws NoSuchElementException {
        if (phase < 0 || phase > this.getMaxPhase()) {
            throw new NoSuchElementException("Illegal phase identifier: " + phase);
        }
        if (this.phase != phase) {
            this.resetCompletionStatus();
        }
        this.phase = phase;
    }

    protected void resetCompletionStatus() {
        this.initSubRequests();
        Iterator it = this.subrequests.iterator();
        while (it.hasNext()) {
            SubRequest subReq = (SubRequest)it.next();
            subReq.getStatus().setPhaseComplete(false);
            subReq.getStatus().setProcessed(false);
        }
    }

    public synchronized void resetProcessedStatus() {
        Iterator it = this.subrequests.iterator();
        while (it.hasNext()) {
            SubRequest sreq = (SubRequest)it.next();
            sreq.getStatus().setProcessed(sreq.getStatus().isPhaseComplete());
        }
    }

    public void setErrorStatus(int errorStatus) {
        this.errorStatus = errorStatus;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Request) {
            return this.transactionID == ((Request)obj).getTransactionID();
        }
        return false;
    }

    public int hashCode() {
        return this.transactionID;
    }

    public int getReprocessCounter() {
        return this.reprocessCounter;
    }

    public void incReprocessCounter() {
        ++this.reprocessCounter;
    }
}

