/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PCFactory;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.DefaultMOTableRow;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.snmp.Enumerated;
import org.snmp4j.agent.mo.snmp.RowStatus;
import org.snmp4j.agent.mo.snmp.SnmpAdminString;
import org.snmp4j.agent.mo.snmp.StorageType;
import org.snmp4j.agent.mo.snmp.TestAndIncr;
import org.snmp4j.agent.mo.util.LexicographicOctetStringComparator;
import org.snmp4j.agent.security.MutableVACM;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class VacmMIB
implements MOGroup,
MutableVACM {
    private static final LogAdapter logger = LogFactory.getLogger(VacmMIB.class);
    private static final OID vacmContextEntryOID = new OID(new int[]{1, 3, 6, 1, 6, 3, 16, 1, 1, 1});
    private static final int colVacmGroupName = 3;
    private static final int colVacmSecurityToGroupStorageType = 4;
    private static final int colVacmSecurityToGroupRowStatus = 5;
    private static final int idxVacmGroupName = 0;
    private static final int idxVacmSecurityToGroupStorageType = 1;
    private static final int idxVacmSecurityToGroupRowStatus = 2;
    private static final OID vacmSecurityToGroupEntryOID = new OID(new int[]{1, 3, 6, 1, 6, 3, 16, 1, 2, 1});
    private static final int colVacmAccessContextMatch = 4;
    private static final int colVacmAccessReadViewName = 5;
    private static final int colVacmAccessWriteViewName = 6;
    private static final int colVacmAccessNotifyViewName = 7;
    private static final int colVacmAccessStorageType = 8;
    private static final int colVacmAccessRowStatus = 9;
    private static final int idxVacmAccessContextPrefix = 1;
    private static final int idxVacmAccessSecurityModel = 2;
    private static final int idxVacmAccessSecurityLevel = 3;
    private static final int idxVacmAccessContextMatch = 0;
    private static final int idxVacmAccessReadViewName = 1;
    private static final int idxVacmAccessWriteViewName = 2;
    private static final int idxVacmAccessNotifyViewName = 3;
    private static final int idxVacmAccessStorageType = 4;
    private static final int idxVacmAccessRowStatus = 5;
    private static final OID vacmAccessEntryOID = new OID(new int[]{1, 3, 6, 1, 6, 3, 16, 1, 4, 1});
    public static final int vacmExactMatch = 1;
    public static final int vacmPrefixMatch = 2;
    private static final OID vacmViewSpinLockOID = new OID(new int[]{1, 3, 6, 1, 6, 3, 16, 1, 5, 1, 0});
    private static final int colVacmViewTreeFamilyMask = 3;
    private static final int colVacmViewTreeFamilyType = 4;
    private static final int colVacmViewTreeFamilyStorageType = 5;
    private static final int colVacmViewTreeFamilyRowStatus = 6;
    private static final int idxVacmViewTreeSubtree = 1;
    private static final int idxVacmViewTreeFamilyMask = 0;
    private static final int idxVacmViewTreeFamilyType = 1;
    private static final int idxVacmViewTreeFamilyStorageType = 2;
    private static final int idxVacmViewTreeFamilyRowStatus = 3;
    private static final OID vacmViewTreeFamilyEntryOID = new OID(new int[]{1, 3, 6, 1, 6, 3, 16, 1, 5, 2, 1});
    public static final int vacmViewIncluded = 1;
    public static final int vacmViewExcluded = 2;
    private static final int[] vacmViewTreeFamilyTypeValues = new int[]{1, 2};
    private static MOTableSubIndex[] vacmViewTreeFamilyIndexes = new MOTableSubIndex[]{new MOTableSubIndex(4, 1, 32), new MOTableSubIndex(6, 0, 96)};
    private static MOTableIndex vacmViewTreeFamilyIndex = new MOTableIndex(vacmViewTreeFamilyIndexes);
    private static MOTableSubIndex[] vacmAccessIndexes = new MOTableSubIndex[]{new MOTableSubIndex(4, 1, 32), new MOTableSubIndex(4, 0, 32), new MOTableSubIndex(2, 1, 1), new MOTableSubIndex(2, 1, 1)};
    private static MOTableIndex vacmAccessIndex = new MOTableIndex(vacmAccessIndexes){

        @Override
        public boolean isValidIndex(OID oID) {
            boolean bl = super.isValidIndex(oID);
            if (bl) {
                Integer32 integer32;
                SecurityModels securityModels = SecurityModels.getInstance();
                if (securityModels.getSecurityModel(integer32 = new Integer32(oID.get(oID.size() - 2))) == null) {
                    return false;
                }
                int n = oID.get(oID.size() - 1);
                if (n < 1 || n > 3) {
                    return false;
                }
            }
            return bl;
        }
    };
    private MOServer server;
    private DefaultMOTable vacmContextTable;
    private DefaultMOTable vacmSecurityToGroupTable;
    private DefaultMOMutableTableModel vacmSecurityToGroupTableModel;
    private DefaultMOTable vacmAccessTable;
    private DefaultMOMutableTableModel vacmAccessTableModel;
    private TestAndIncr vacmViewSpinLock;
    private DefaultMOTable vacmViewTreeFamilyTable;
    private DefaultMOMutableTableModel vacmViewTreeFamilyTableModel;

    public VacmMIB(MOServer mOServer) {
        this.server = mOServer;
        this.createVacmContextTable();
        this.createVacmSecuritToGroupTable();
        this.createVacmAccessTable();
        this.createVacmViewTreeFamilyTable();
        this.vacmViewSpinLock = new TestAndIncr(vacmViewSpinLockOID);
    }

    @Override
    public void registerMOs(MOServer mOServer, OctetString octetString) throws DuplicateRegistrationException {
        mOServer.register(this.vacmContextTable, octetString);
        mOServer.register(this.vacmSecurityToGroupTable, octetString);
        mOServer.register(this.vacmAccessTable, octetString);
        mOServer.register(this.vacmViewSpinLock, octetString);
        mOServer.register(this.vacmViewTreeFamilyTable, octetString);
    }

    private void createVacmContextTable() {
        MOTableSubIndex[] mOTableSubIndexArray = new MOTableSubIndex[]{new MOTableSubIndex(4, 0, 32)};
        MOTableIndex mOTableIndex = new MOTableIndex(mOTableSubIndexArray);
        MOColumn[] mOColumnArray = new MOColumn[]{new MOColumn(1, 4, MOAccessImpl.ACCESS_READ_ONLY)};
        this.vacmContextTable = new DefaultMOTable(vacmContextEntryOID, mOTableIndex, mOColumnArray);
        this.vacmContextTable.setModel(new VacmContextTableModel());
    }

    private void createVacmSecuritToGroupTable() {
        MOTableSubIndex[] mOTableSubIndexArray = new MOTableSubIndex[]{new MOTableSubIndex(2, 1, 1), new MOTableSubIndex(4, 1, 32)};
        MOTableIndex mOTableIndex = new MOTableIndex(mOTableSubIndexArray){

            @Override
            public boolean isValidIndex(OID oID) {
                boolean bl = super.isValidIndex(oID);
                if (bl) {
                    switch (oID.get(0)) {
                        case 0: {
                            return true;
                        }
                        case 1: {
                            return true;
                        }
                        case 2: {
                            return true;
                        }
                        case 3: {
                            return true;
                        }
                    }
                    return false;
                }
                return bl;
            }
        };
        MOColumn[] mOColumnArray = new MOColumn[]{new SnmpAdminString(3, MOAccessImpl.ACCESS_READ_CREATE, null, true, 1, 32), new StorageType(4, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(3), true), new RowStatus(5)};
        this.vacmSecurityToGroupTable = new DefaultMOTable(vacmSecurityToGroupEntryOID, mOTableIndex, mOColumnArray);
        this.vacmSecurityToGroupTableModel = new DefaultMOMutableTableModel();
        this.vacmSecurityToGroupTableModel.setRowFactory(new DefaultMOMutableRow2PCFactory());
        this.vacmSecurityToGroupTable.setModel(this.vacmSecurityToGroupTableModel);
    }

    private void createVacmAccessTable() {
        MOColumn[] mOColumnArray = new MOColumn[]{new Enumerated(4, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(1), true, new int[]{1, 2}), new SnmpAdminString(5, MOAccessImpl.ACCESS_READ_CREATE, (Variable)new OctetString(), true, 0, 32), new SnmpAdminString(6, MOAccessImpl.ACCESS_READ_CREATE, (Variable)new OctetString(), true, 0, 32), new SnmpAdminString(7, MOAccessImpl.ACCESS_READ_CREATE, (Variable)new OctetString(), true, 0, 32), new StorageType(8, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(3), true), new RowStatus(9)};
        this.vacmAccessTable = new DefaultMOTable(vacmAccessEntryOID, vacmAccessIndex, mOColumnArray);
        this.vacmAccessTableModel = new DefaultMOMutableTableModel();
        this.vacmAccessTableModel.setRowFactory(new DefaultMOMutableRow2PCFactory());
        this.vacmAccessTable.setModel(this.vacmAccessTableModel);
    }

    private void createVacmViewTreeFamilyTable() {
        MOColumn[] mOColumnArray = new MOColumn[]{new SnmpAdminString(3, MOAccessImpl.ACCESS_READ_CREATE, (Variable)new OctetString(), true, 0, 16), new Enumerated(4, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(1), true, vacmViewTreeFamilyTypeValues), new StorageType(5, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(3), true), new RowStatus(6)};
        this.vacmViewTreeFamilyTable = new DefaultMOTable(vacmViewTreeFamilyEntryOID, vacmViewTreeFamilyIndex, mOColumnArray);
        this.vacmViewTreeFamilyTableModel = new DefaultMOMutableTableModel();
        this.vacmViewTreeFamilyTableModel.setRowFactory(new DefaultMOMutableRow2PCFactory());
        this.vacmViewTreeFamilyTable.setModel(this.vacmViewTreeFamilyTableModel);
    }

    @Override
    public void unregisterMOs(MOServer mOServer, OctetString octetString) {
        mOServer.unregister(this.vacmContextTable, octetString);
        mOServer.unregister(this.vacmSecurityToGroupTable, octetString);
        mOServer.unregister(this.vacmAccessTable, octetString);
        mOServer.unregister(this.vacmViewSpinLock, octetString);
        mOServer.unregister(this.vacmViewTreeFamilyTable, octetString);
    }

    @Override
    public int isAccessAllowed(OctetString octetString, OctetString octetString2, int n, int n2, int n3, OID oID) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("VACM access requested for context=" + octetString + ", securityName=" + octetString2 + ", securityModel=" + n + ", securityLevel=" + n2 + ", viewType=" + n3 + ", OID=" + oID));
        }
        if (!this.server.isContextSupported(octetString)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Context '" + octetString + "' ist not supported"));
            }
            return 3;
        }
        OctetString octetString3 = this.getGroupName(octetString2, n);
        if (octetString3 == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No group name for securityName=" + octetString2 + " and securityModel=" + n));
            }
            return 4;
        }
        OctetString octetString4 = this.getViewNameByGroup(octetString, n, n2, n3, octetString3);
        if (octetString4 == null) {
            return 5;
        }
        if (octetString4.length() == 0) {
            return 2;
        }
        return this.isAccessAllowed(octetString4, oID);
    }

    @Override
    public OctetString getViewName(OctetString octetString, OctetString octetString2, int n, int n2, int n3) {
        OctetString octetString3 = this.getGroupName(octetString2, n);
        if (octetString3 == null) {
            return null;
        }
        return this.getViewNameByGroup(octetString, n, n2, n3, octetString3);
    }

    private OctetString getViewNameByGroup(OctetString octetString, int n, int n2, int n3, OctetString octetString2) {
        List list = this.getAccessEntries(octetString2);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Got views " + list + " for group name '" + octetString2 + "'"));
        }
        MOTableRow mOTableRow = null;
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        int n5 = 0;
        for (MOTableRow mOTableRow2 : list) {
            boolean bl3;
            if (((Integer32)mOTableRow2.getValue(5)).getValue() != 1) continue;
            Variable[] variableArray = vacmAccessIndex.getIndexValues(mOTableRow2.getIndex());
            OctetString octetString3 = (OctetString)variableArray[1];
            int n6 = ((Integer32)variableArray[2]).getValue();
            int n7 = ((Integer32)variableArray[3]).getValue();
            int n8 = ((Integer32)mOTableRow2.getValue(0)).getValue();
            boolean bl4 = octetString3.equals((Object)octetString);
            boolean bl5 = !bl4 && n8 == 2 && octetString.startsWith(octetString3);
            boolean bl6 = n6 == n;
            boolean bl7 = bl3 = n7 <= n2;
            if (!bl4 && !bl5 || !bl6 && n6 != 0 || !bl3 || mOTableRow != null && (bl2 || !bl6) && (bl2 && !bl6 || bl || !bl4) && (bl && !bl4 || n4 >= octetString3.length()) && (n4 != octetString3.length() || n5 >= n7)) continue;
            mOTableRow = mOTableRow2;
            bl = bl4;
            if (bl5) {
                n4 = octetString3.length();
            }
            bl2 = bl6;
            n5 = n2;
        }
        if (mOTableRow != null) {
            OctetString octetString4 = null;
            switch (n3) {
                case 1: {
                    octetString4 = (OctetString)mOTableRow.getValue(1);
                    break;
                }
                case 2: {
                    octetString4 = (OctetString)mOTableRow.getValue(2);
                    break;
                }
                case 0: {
                    octetString4 = (OctetString)mOTableRow.getValue(3);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Matching view found for group name '" + octetString2 + "' is '" + octetString4 + "'"));
            }
            return octetString4;
        }
        return null;
    }

    private OctetString getGroupName(OctetString octetString, int n) {
        OID oID = new OID();
        oID.append(n);
        oID.append(octetString.toSubIndex(false));
        MOTableRow mOTableRow = this.vacmSecurityToGroupTableModel.getRow(oID);
        if (mOTableRow != null) {
            OctetString octetString2 = (OctetString)mOTableRow.getValue(0);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found group name '" + octetString2 + "' for secName '" + octetString + " and secModel " + n));
            }
            return octetString2;
        }
        return null;
    }

    @Override
    public int isAccessAllowed(OctetString octetString, OID oID) {
        List list = this.getViews(octetString);
        if (list.size() == 0) {
            return 2;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            MOTableRow mOTableRow = (MOTableRow)list.get(i);
            if (((Integer32)mOTableRow.getValue(3)).getValue() != 1) continue;
            OID oID2 = mOTableRow.getIndex();
            Variable[] variableArray = vacmViewTreeFamilyIndex.getIndexValues(oID2);
            OID oID3 = (OID)variableArray[1];
            if (oID.size() < oID3.size()) continue;
            OctetString octetString2 = (OctetString)mOTableRow.getValue(0);
            boolean bl = true;
            for (int j = 0; j < oID3.size(); ++j) {
                if (oID3.get(j) == oID.get(j) || !VacmMIB.isBitSet(j, octetString2)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            if (((Integer32)mOTableRow.getValue(1)).getValue() == 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Access allowed for view '" + octetString + "' by subtree " + oID3 + " for OID " + oID));
                }
                return 0;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Access denied for view '" + octetString + "' by subtree " + oID3 + " for OID " + oID));
            }
            return 1;
        }
        return 1;
    }

    @Override
    public void addGroup(int n, OctetString octetString, OctetString octetString2, int n2) {
        OID oID = VacmMIB.createGroupIndex(n, octetString);
        Variable[] variableArray = new Variable[this.vacmSecurityToGroupTable.getColumnCount()];
        variableArray[0] = octetString2;
        variableArray[1] = new Integer32(n2);
        variableArray[2] = new Integer32(1);
        MOTableRow mOTableRow = this.vacmSecurityToGroupTable.createRow(oID, variableArray);
        this.vacmSecurityToGroupTableModel.addRow(mOTableRow);
    }

    private static OID createGroupIndex(int n, OctetString octetString) {
        OID oID = new OID();
        oID.append(n);
        oID.append(octetString.toSubIndex(false));
        return oID;
    }

    @Override
    public boolean removeGroup(int n, OctetString octetString) {
        OID oID = VacmMIB.createGroupIndex(n, octetString);
        return this.vacmSecurityToGroupTableModel.removeRow(oID) != null;
    }

    @Override
    public void addAccess(OctetString octetString, OctetString octetString2, int n, int n2, int n3, OctetString octetString3, OctetString octetString4, OctetString octetString5, int n4) {
        OID oID = VacmMIB.createAccessIndex(octetString, octetString2, n, n2);
        Variable[] variableArray = new Variable[this.vacmAccessTable.getColumnCount()];
        variableArray[0] = new Integer32(n3);
        variableArray[1] = octetString3;
        variableArray[2] = octetString4;
        variableArray[3] = octetString5;
        variableArray[4] = new Integer32(n4);
        variableArray[5] = new Integer32(1);
        this.vacmAccessTableModel.addRow(this.vacmAccessTableModel.createRow(oID, variableArray));
    }

    @Override
    public boolean removeAccess(OctetString octetString, OctetString octetString2, int n, int n2) {
        OID oID = VacmMIB.createAccessIndex(octetString, octetString2, n, n2);
        return this.vacmAccessTableModel.removeRow(oID) != null;
    }

    private static OID createAccessIndex(OctetString octetString, OctetString octetString2, int n, int n2) {
        OID oID = octetString.toSubIndex(false);
        oID.append(octetString2.toSubIndex(false));
        oID.append(n);
        oID.append(n2);
        return oID;
    }

    @Override
    public void addViewTreeFamily(OctetString octetString, OID oID, OctetString octetString2, int n, int n2) {
        OID oID2 = VacmMIB.createViewIndex(octetString, oID);
        Variable[] variableArray = new Variable[this.vacmViewTreeFamilyTable.getColumnCount()];
        variableArray[0] = octetString2;
        variableArray[1] = new Integer32(n);
        variableArray[2] = new Integer32(n2);
        variableArray[3] = new Integer32(1);
        MOTableRow mOTableRow = this.vacmViewTreeFamilyTableModel.createRow(oID2, variableArray);
        this.vacmViewTreeFamilyTableModel.addRow(mOTableRow);
    }

    @Override
    public boolean removeViewTreeFamily(OctetString octetString, OID oID) {
        OID oID2 = VacmMIB.createViewIndex(octetString, oID);
        return this.vacmViewTreeFamilyTableModel.removeRow(oID2) != null;
    }

    private static OID createViewIndex(OctetString octetString, OID oID) {
        OID oID2 = octetString.toSubIndex(false);
        oID2.append(oID.toSubIndex(false));
        return oID2;
    }

    private static boolean isBitSet(int n, OctetString octetString) {
        if (octetString.length() <= n / 8) {
            return true;
        }
        return (octetString.get(n / 8) & 1 << 7 - n % 8) > 0;
    }

    private List getAccessEntries(OctetString octetString) {
        OctetString octetString2 = new OctetString(octetString);
        int n = -1;
        if (octetString2.length() > 0) {
            n = octetString2.get(octetString2.length() - 1);
        }
        if (n == -1) {
            octetString2.append((byte)0);
        } else {
            octetString2.set(octetString2.length() - 1, (byte)(n + 1));
        }
        OID oID = octetString.toSubIndex(false);
        OID oID2 = octetString2.toSubIndex(false);
        List list = this.vacmAccessTableModel.getRows(oID, oID2);
        return list;
    }

    private List getViews(OctetString octetString) {
        OctetString octetString2 = new OctetString(octetString);
        byte by = octetString2.get(octetString2.length() - 1);
        if (by == -1) {
            octetString2.append((byte)0);
        } else {
            octetString2.set(octetString2.length() - 1, (byte)(by + 1));
        }
        OID oID = octetString.toSubIndex(false);
        OID oID2 = octetString2.toSubIndex(false);
        List list = this.vacmViewTreeFamilyTableModel.getRows(oID, oID2);
        return list;
    }

    private static OctetString getContextFromIndex(OID oID) {
        if (oID.size() > 0) {
            return new OctetString(oID.toByteArray(), 1, oID.size() - 1);
        }
        return new OctetString();
    }

    class VacmContextTableModel
    implements MOTableModel {
        VacmContextTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return VacmMIB.this.server.getContexts().length;
        }

        @Override
        public boolean containsRow(OID oID) {
            return VacmMIB.this.server.isContextSupported(VacmMIB.getContextFromIndex(oID));
        }

        @Override
        public MOTableRow getRow(OID oID) {
            if (oID == null) {
                return null;
            }
            OctetString octetString = VacmMIB.getContextFromIndex(oID);
            if (VacmMIB.this.server.isContextSupported(octetString)) {
                DefaultMOTableRow defaultMOTableRow = new DefaultMOTableRow(oID, new Variable[]{octetString});
                return defaultMOTableRow;
            }
            return null;
        }

        @Override
        public Iterator iterator() {
            return this.tailIterator(new OID());
        }

        @Override
        public Iterator tailIterator(OID oID) {
            Object[] objectArray = VacmMIB.this.server.getContexts();
            if (objectArray == null) {
                return new VacmContextIterator(new OctetString[0], 0);
            }
            Arrays.sort(objectArray, new LexicographicOctetStringComparator());
            int n = 0;
            if (oID != null) {
                n = Arrays.binarySearch(objectArray, VacmMIB.getContextFromIndex(oID));
            }
            if (n < 0) {
                n = -(n + 1);
            }
            return new VacmContextIterator((OctetString[])objectArray, n);
        }

        @Override
        public OID lastIndex() {
            OctetString[] octetStringArray = VacmMIB.this.server.getContexts();
            if (octetStringArray == null || octetStringArray.length == 0) {
                return null;
            }
            Arrays.sort(octetStringArray, new LexicographicOctetStringComparator());
            return octetStringArray[octetStringArray.length - 1].toSubIndex(false);
        }

        @Override
        public OID firstIndex() {
            OctetString[] octetStringArray = VacmMIB.this.server.getContexts();
            if (octetStringArray == null || octetStringArray.length > 0) {
                return null;
            }
            Arrays.sort(octetStringArray, new LexicographicOctetStringComparator());
            return octetStringArray[0].toSubIndex(false);
        }

        @Override
        public MOTableRow firstRow() {
            return this.getRow(this.firstIndex());
        }

        @Override
        public MOTableRow lastRow() {
            return this.getRow(this.lastIndex());
        }
    }

    public static class VacmContextIterator
    implements Iterator {
        private int index = 0;
        private OctetString[] contexts;

        VacmContextIterator(OctetString[] octetStringArray, int n) {
            this.contexts = octetStringArray;
            this.index = n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.contexts.length;
        }

        public Object next() {
            if (this.index < this.contexts.length) {
                OctetString octetString = this.contexts[this.index++];
                DefaultMOTableRow defaultMOTableRow = new DefaultMOTableRow(octetString.toSubIndex(false), new Variable[]{octetString});
                return defaultMOTableRow;
            }
            throw new NoSuchElementException();
        }
    }
}

