/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.snmp4j.CommunityTarget;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PCFactory;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.DefaultMOTableRow;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowEvent;
import org.snmp4j.agent.mo.MOTableRowFactory;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.mo.snmp.CoexistenceInfoProvider;
import org.snmp4j.agent.mo.snmp.Enumerated;
import org.snmp4j.agent.mo.snmp.RowStatus;
import org.snmp4j.agent.mo.snmp.RowStatusEvent;
import org.snmp4j.agent.mo.snmp.RowStatusListener;
import org.snmp4j.agent.mo.snmp.SnmpAdminString;
import org.snmp4j.agent.mo.snmp.SnmpTagList;
import org.snmp4j.agent.mo.snmp.StorageType;
import org.snmp4j.agent.mo.snmp.TDomainAddressFactory;
import org.snmp4j.agent.mo.snmp.TDomainAddressFactoryImpl;
import org.snmp4j.agent.mo.snmp.TestAndIncr;
import org.snmp4j.agent.mo.snmp.TransportDomains;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class SnmpTargetMIB
implements MOGroup,
CounterListener,
MOTableRowListener {
    private static final LogAdapter logger = LogFactory.getLogger(SnmpTargetMIB.class);
    private static final OID oidSnmpTargetSpinLock = new OID(new int[]{1, 3, 6, 1, 6, 3, 12, 1, 1, 0});
    private MOScalar snmpTargetSpinLock;
    private static final OID oidSnmpUnknownContexts = new OID(new int[]{1, 3, 6, 1, 6, 3, 12, 1, 5, 0});
    private MOScalar snmpUnknownContexts;
    private static final OID oidSnmpUnavailableContexts = new OID(new int[]{1, 3, 6, 1, 6, 3, 12, 1, 4, 0});
    private MOScalar snmpUnavailableContexts;
    private static final OID oidSnmpTargetParamsEntry = new OID(new int[]{1, 3, 6, 1, 6, 3, 12, 1, 3, 1});
    private static final int colSnmpTargetParamsMPModel = 2;
    private static final int colSnmpTargetParamsSecurityModel = 3;
    private static final int colSnmpTargetParamsSecurityName = 4;
    private static final int colSnmpTargetParamsSecurityLevel = 5;
    private static final int colSnmpTargetParamsStorageType = 6;
    private static final int colSnmpTargetParamsRowStatus = 7;
    static final int idxSnmpTargetParamsMPModel = 0;
    static final int idxSnmpTargetParamsSecurityModel = 1;
    static final int idxSnmpTargetParamsSecurityName = 2;
    static final int idxSnmpTargetParamsSecurityLevel = 3;
    static final int idxSnmpTargetParamsStorageType = 4;
    static final int idxSnmpTargetParamsRowStatus = 5;
    private static MOTableSubIndex[] snmpTargetParamsEntryIndexes = new MOTableSubIndex[]{new MOTableSubIndex(4, 1, 32)};
    private static MOTableIndex snmpTargetParamsEntryIndex = new MOTableIndex(snmpTargetParamsEntryIndexes, true){

        @Override
        public boolean isValidIndex(OID oID) {
            boolean bl = super.isValidIndex(oID);
            if (bl) {
                // empty if block
            }
            return bl;
        }
    };
    private DefaultMOTable snmpTargetParamsEntry;
    private DefaultMOMutableTableModel snmpTargetParamsEntryModel;
    private static final OID oidSnmpTargetAddrEntry = new OID(new int[]{1, 3, 6, 1, 6, 3, 12, 1, 2, 1});
    private static final int colSnmpTargetAddrTDomain = 2;
    private static final int colSnmpTargetAddrTAddress = 3;
    private static final int colSnmpTargetAddrTimeout = 4;
    private static final int colSnmpTargetAddrRetryCount = 5;
    private static final int colSnmpTargetAddrTagList = 6;
    private static final int colSnmpTargetAddrParams = 7;
    private static final int colSnmpTargetAddrStorageType = 8;
    private static final int colSnmpTargetAddrRowStatus = 9;
    static final int idxSnmpTargetAddrTDomain = 0;
    static final int idxSnmpTargetAddrTAddress = 1;
    static final int idxSnmpTargetAddrTimeout = 2;
    static final int idxSnmpTargetAddrRetryCount = 3;
    static final int idxSnmpTargetAddrTagList = 4;
    static final int idxSnmpTargetAddrParams = 5;
    static final int idxSnmpTargetAddrStorageType = 6;
    static final int idxSnmpTargetAddrRowStatus = 7;
    private static MOTableSubIndex[] snmpTargetAddrEntryIndexes = new MOTableSubIndex[]{new MOTableSubIndex(4, 1, 32)};
    private static MOTableIndex snmpTargetAddrEntryIndex = new MOTableIndex(snmpTargetAddrEntryIndexes, true){

        @Override
        public boolean isValidIndex(OID oID) {
            boolean bl = super.isValidIndex(oID);
            if (bl) {
                // empty if block
            }
            return bl;
        }
    };
    private static final OID[] DEFAULT_TDOMAINS = new OID[]{TransportDomains.snmpUDPDomain, TransportDomains.transportDomainTcpIpv4, TransportDomains.transportDomainTcpIpv6, TransportDomains.transportDomainUdpIpv4, TransportDomains.transportDomainUdpIpv6};
    private DefaultMOTable snmpTargetAddrEntry;
    private DefaultMOMutableTableModel snmpTargetAddrEntryModel;
    private Hashtable snmpTargetAddrTagIndex = new Hashtable();
    private Hashtable supportedAddressClasses = new Hashtable();
    private Snmp session;
    private CoexistenceInfoProvider coexistenceProvider;

    public SnmpTargetMIB(Snmp snmp) {
        this.session = snmp;
        this.snmpTargetSpinLock = new TestAndIncr(oidSnmpTargetSpinLock);
        this.snmpUnknownContexts = new MOScalar(oidSnmpUnknownContexts, MOAccessImpl.ACCESS_READ_ONLY, (Variable)new Counter32());
        this.snmpUnavailableContexts = new MOScalar(oidSnmpUnavailableContexts, MOAccessImpl.ACCESS_READ_ONLY, (Variable)new Counter32());
        this.createSnmpTargetParamsEntry();
        this.createSnmpTargetAddrEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTargetAddrRowsForTag(OctetString octetString) {
        ArrayList arrayList = (ArrayList)this.snmpTargetAddrTagIndex.get(octetString);
        if (arrayList == null) {
            return Collections.EMPTY_SET;
        }
        ArrayList arrayList2 = arrayList;
        synchronized (arrayList2) {
            arrayList = new ArrayList(arrayList);
        }
        return arrayList;
    }

    public Address getTargetAddress(OctetString octetString) {
        OID oID = octetString.toSubIndex(true);
        SnmpTargetAddrEntryRow snmpTargetAddrEntryRow = (SnmpTargetAddrEntryRow)this.snmpTargetAddrEntryModel.getRow(oID);
        if (snmpTargetAddrEntryRow != null) {
            return snmpTargetAddrEntryRow.getAddress();
        }
        return null;
    }

    public Target getTarget(OctetString octetString, OctetString octetString2, OctetString octetString3) {
        OID oID = octetString.toSubIndex(true);
        SnmpTargetAddrEntryRow snmpTargetAddrEntryRow = (SnmpTargetAddrEntryRow)this.snmpTargetAddrEntryModel.getRow(oID);
        if (snmpTargetAddrEntryRow != null) {
            return snmpTargetAddrEntryRow.getTarget(octetString2, octetString3);
        }
        return null;
    }

    public void addDefaultTDomains() {
        TDomainAddressFactoryImpl tDomainAddressFactoryImpl = new TDomainAddressFactoryImpl();
        for (int i = 0; i < DEFAULT_TDOMAINS.length; ++i) {
            this.supportedAddressClasses.put(DEFAULT_TDOMAINS[i], tDomainAddressFactoryImpl);
        }
    }

    public void addSupportedTDomain(OID oID, TDomainAddressFactory tDomainAddressFactory) {
        this.supportedAddressClasses.put(oID, tDomainAddressFactory);
    }

    public boolean addTargetAddress(OctetString octetString, OID oID, OctetString octetString2, int n, int n2, OctetString octetString3, OctetString octetString4, int n3) {
        Variable[] variableArray = new Variable[this.snmpTargetAddrEntry.getColumnCount()];
        int n4 = 0;
        variableArray[n4++] = oID;
        variableArray[n4++] = octetString2;
        variableArray[n4++] = new Integer32(n);
        variableArray[n4++] = new Integer32(n2);
        variableArray[n4++] = octetString3;
        variableArray[n4++] = octetString4;
        variableArray[n4++] = new Integer32(n3);
        variableArray[n4++] = new Integer32(1);
        OID oID2 = octetString.toSubIndex(true);
        MOTableRow mOTableRow = this.snmpTargetAddrEntry.createRow(oID2, variableArray);
        this.snmpTargetAddrEntry.addRow(mOTableRow);
        return true;
    }

    public MOTableRow removeTargetAddress(OctetString octetString) {
        OID oID = octetString.toSubIndex(true);
        MOTableRow mOTableRow = this.snmpTargetAddrEntryModel.removeRow(oID);
        if (mOTableRow != null) {
            this.removeRowFromTargetAddrTagIndex(mOTableRow);
        }
        return mOTableRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRowFromTargetAddrTagIndex(MOTableRow mOTableRow) {
        OctetString octetString = (OctetString)mOTableRow.getValue(4);
        Set set = SnmpTagList.getTags(octetString);
        if (set != null && this.snmpTargetAddrTagIndex != null) {
            for (Object e : set) {
                Collection collection = (Collection)this.snmpTargetAddrTagIndex.get(e);
                if (collection == null) continue;
                Collection collection2 = collection;
                synchronized (collection2) {
                    collection.remove(mOTableRow);
                    if (collection.isEmpty()) {
                        this.snmpTargetAddrTagIndex.remove(e);
                    }
                }
            }
        }
    }

    public boolean addTargetParams(OctetString octetString, int n, int n2, OctetString octetString2, int n3, int n4) {
        Variable[] variableArray = new Variable[this.snmpTargetParamsEntry.getColumnCount()];
        int n5 = 0;
        variableArray[n5++] = new Integer32(n);
        variableArray[n5++] = new Integer32(n2);
        variableArray[n5++] = octetString2;
        variableArray[n5++] = new Integer32(n3);
        variableArray[n5++] = new Integer32(n4);
        variableArray[n5++] = new Integer32(1);
        OID oID = octetString.toSubIndex(true);
        MOTableRow mOTableRow = this.snmpTargetParamsEntry.createRow(oID, variableArray);
        this.snmpTargetParamsEntry.addRow(mOTableRow);
        return true;
    }

    public MOTableRow removeTargetParams(OctetString octetString) {
        OID oID = octetString.toSubIndex(true);
        return this.snmpTargetParamsEntry.removeRow(oID);
    }

    private void createSnmpTargetParamsEntry() {
        MOColumn[] mOColumnArray = new MOColumn[6];
        mOColumnArray[0] = new MOMutableColumn(2, 2, MOAccessImpl.ACCESS_READ_CREATE, null, true);
        ((MOMutableColumn)mOColumnArray[0]).addMOValueValidationListener(new SnmpTargetParamsMPModelValidator());
        mOColumnArray[1] = new MOMutableColumn(3, 2, MOAccessImpl.ACCESS_READ_CREATE, null, true);
        ((MOMutableColumn)mOColumnArray[1]).addMOValueValidationListener(new SnmpTargetParamsSecurityModelValidator());
        mOColumnArray[2] = new SnmpAdminString(4, MOAccessImpl.ACCESS_READ_CREATE, null, true);
        mOColumnArray[3] = new Enumerated(5, MOAccessImpl.ACCESS_READ_CREATE, null, true, new int[]{1, 3, 2});
        mOColumnArray[4] = new StorageType(6, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(3), true);
        mOColumnArray[5] = new RowStatus(7, MOAccessImpl.ACCESS_READ_CREATE);
        ((RowStatus)mOColumnArray[5]).addRowStatusListener(new SnmpTargetParamsEntryRowStatusListener());
        this.snmpTargetParamsEntry = new DefaultMOTable(oidSnmpTargetParamsEntry, snmpTargetParamsEntryIndex, mOColumnArray);
        this.snmpTargetParamsEntryModel = new DefaultMOMutableTableModel();
        this.snmpTargetParamsEntryModel.setRowFactory(new DefaultMOMutableRow2PCFactory());
        this.snmpTargetParamsEntry.setModel(this.snmpTargetParamsEntryModel);
    }

    private void createSnmpTargetAddrEntry() {
        MOColumn[] mOColumnArray = new MOColumn[8];
        mOColumnArray[0] = new MOMutableColumn(2, 6, MOAccessImpl.ACCESS_READ_CREATE, null, true);
        ((MOMutableColumn)mOColumnArray[0]).addMOValueValidationListener(new SnmpTargetAddrTDomainValidator());
        mOColumnArray[1] = new MOMutableColumn(3, 4, MOAccessImpl.ACCESS_READ_CREATE, null, true);
        ((MOMutableColumn)mOColumnArray[1]).addMOValueValidationListener(new SnmpTargetAddrTAddressValidator());
        mOColumnArray[2] = new MOMutableColumn(4, 2, MOAccessImpl.ACCESS_READ_CREATE, (Variable)new Integer32(1500), true);
        ((MOMutableColumn)mOColumnArray[2]).addMOValueValidationListener(new SnmpTargetAddrTimeoutValidator());
        mOColumnArray[3] = new MOMutableColumn(5, 2, MOAccessImpl.ACCESS_READ_CREATE, (Variable)new Integer32(3), true);
        ((MOMutableColumn)mOColumnArray[3]).addMOValueValidationListener(new SnmpTargetAddrRetryCountValidator());
        mOColumnArray[4] = new SnmpTagList(6, MOAccessImpl.ACCESS_READ_CREATE, (Variable)new OctetString(new byte[0]), true);
        mOColumnArray[5] = new MOMutableColumn(7, 4, MOAccessImpl.ACCESS_READ_CREATE, (Variable)new OctetString(), true);
        ((MOMutableColumn)mOColumnArray[5]).addMOValueValidationListener(new SnmpTargetAddrParamsValidator());
        mOColumnArray[6] = new StorageType(8, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(3), true);
        mOColumnArray[7] = new RowStatus(9);
        this.snmpTargetAddrEntry = new DefaultMOTable(oidSnmpTargetAddrEntry, snmpTargetAddrEntryIndex, mOColumnArray);
        this.snmpTargetAddrEntryModel = new DefaultMOMutableTableModel();
        this.snmpTargetAddrEntryModel.setRowFactory(new SnmpTargetAddrEntryFactory());
        this.snmpTargetAddrEntry.setModel(this.snmpTargetAddrEntryModel);
    }

    @Override
    public void registerMOs(MOServer mOServer, OctetString octetString) throws DuplicateRegistrationException {
        mOServer.register(this.snmpTargetSpinLock, octetString);
        mOServer.register(this.snmpUnknownContexts, octetString);
        mOServer.register(this.snmpUnavailableContexts, octetString);
        mOServer.register(this.snmpTargetParamsEntry, octetString);
        mOServer.register(this.snmpTargetAddrEntry, octetString);
    }

    @Override
    public void unregisterMOs(MOServer mOServer, OctetString octetString) {
        mOServer.unregister(this.snmpTargetSpinLock, octetString);
        mOServer.unregister(this.snmpUnknownContexts, octetString);
        mOServer.unregister(this.snmpUnavailableContexts, octetString);
        mOServer.unregister(this.snmpTargetParamsEntry, octetString);
        mOServer.unregister(this.snmpTargetAddrEntry, octetString);
    }

    public void incrementCounter(CounterEvent counterEvent) {
        if (counterEvent.getOid().equals((Object)this.snmpUnavailableContexts.getOid())) {
            ((Counter32)this.snmpUnavailableContexts.getValue()).increment();
            counterEvent.setCurrentValue(this.snmpUnavailableContexts.getValue());
        } else if (counterEvent.getOid().equals((Object)this.snmpUnknownContexts.getOid())) {
            ((Counter32)this.snmpUnknownContexts.getValue()).increment();
            counterEvent.setCurrentValue(this.snmpUnknownContexts.getValue());
        }
    }

    @Override
    public void rowChanged(MOTableRowEvent mOTableRowEvent) {
        if (mOTableRowEvent.getType() == 3 && mOTableRowEvent.getRow() instanceof SnmpTargetAddrEntryRow) {
            Variable[] variableArray = new Variable[mOTableRowEvent.getRow().size()];
            variableArray[4] = new OctetString();
            DefaultMOTableRow defaultMOTableRow = new DefaultMOTableRow(mOTableRowEvent.getRow().getIndex(), variableArray);
            ((SnmpTargetAddrEntryRow)mOTableRowEvent.getRow()).updateUserObject(defaultMOTableRow);
        }
    }

    public MOTableRow getTargetParamsRow(OctetString octetString) {
        if (octetString == null) {
            return null;
        }
        OID oID = octetString.toSubIndex(true);
        return this.snmpTargetParamsEntryModel.getRow(oID);
    }

    public MOTableRow getTargetParamsRow(OctetString octetString, boolean bl) {
        MOTableRow mOTableRow = this.getTargetParamsRow(octetString);
        if (bl && mOTableRow != null && ((Integer32)mOTableRow.getValue(5)).getValue() != 1) {
            return null;
        }
        return mOTableRow;
    }

    public DefaultMOTable getSnmpTargetAddrEntry() {
        return this.snmpTargetAddrEntry;
    }

    public CoexistenceInfoProvider getCoexistenceProvider() {
        return this.coexistenceProvider;
    }

    public void setCoexistenceProvider(CoexistenceInfoProvider coexistenceInfoProvider) {
        this.coexistenceProvider = coexistenceInfoProvider;
    }

    public static final class SnmpTargetParamsSecurityLevelEnum {
        public static final int noAuthNoPriv = 1;
        public static final int authNoPriv = 2;
        public static final int authPriv = 3;
    }

    class SnmpTargetAddrParamsValidator
    implements MOValueValidationListener {
        SnmpTargetAddrParamsValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent mOValueValidationEvent) {
            Variable variable = mOValueValidationEvent.getNewValue();
            OctetString octetString = (OctetString)variable;
            if (octetString.length() < 1 || octetString.length() > 32) {
                mOValueValidationEvent.setValidationStatus(8);
                return;
            }
            OID oID = octetString.toSubIndex(true);
            MOTableRow mOTableRow = SnmpTargetMIB.this.snmpTargetParamsEntryModel.getRow(oID);
            if (mOTableRow == null) {
                mOValueValidationEvent.setValidationStatus(12);
            }
        }
    }

    static class SnmpTargetAddrRetryCountValidator
    implements MOValueValidationListener {
        SnmpTargetAddrRetryCountValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent mOValueValidationEvent) {
            Variable variable = mOValueValidationEvent.getNewValue();
            long l = ((Integer32)variable).getValue();
            if (l < 0L || l > 255L) {
                mOValueValidationEvent.setValidationStatus(10);
                return;
            }
        }
    }

    static class SnmpTargetAddrTimeoutValidator
    implements MOValueValidationListener {
        SnmpTargetAddrTimeoutValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent mOValueValidationEvent) {
            Variable variable = mOValueValidationEvent.getNewValue();
            long l = ((Integer32)variable).getValue();
            if (l < 0L) {
                mOValueValidationEvent.setValidationStatus(10);
                return;
            }
        }
    }

    static class SnmpTargetAddrTAddressValidator
    implements MOValueValidationListener {
        SnmpTargetAddrTAddressValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent mOValueValidationEvent) {
            Variable variable = mOValueValidationEvent.getNewValue();
            OctetString octetString = (OctetString)variable;
            if (octetString.length() < 1 || octetString.length() > 255) {
                mOValueValidationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    class SnmpTargetAddrTDomainValidator
    implements MOValueValidationListener {
        SnmpTargetAddrTDomainValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent mOValueValidationEvent) {
            Variable variable = mOValueValidationEvent.getNewValue();
            if (variable instanceof OID) {
                OID oID = (OID)variable;
                if (!SnmpTargetMIB.this.supportedAddressClasses.containsKey(oID)) {
                    mOValueValidationEvent.setValidationStatus(3);
                }
            } else {
                mOValueValidationEvent.setValidationStatus(7);
            }
        }
    }

    static class SnmpTargetParamsSecurityModelValidator
    implements MOValueValidationListener {
        SnmpTargetParamsSecurityModelValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent mOValueValidationEvent) {
            Variable variable = mOValueValidationEvent.getNewValue();
            switch (((Integer32)variable).getValue()) {
                case 3: {
                    if (SecurityModels.getInstance().getSecurityModel((Integer32)variable) != null) break;
                    mOValueValidationEvent.setValidationStatus(10);
                    return;
                }
            }
        }
    }

    class SnmpTargetParamsMPModelValidator
    implements MOValueValidationListener {
        SnmpTargetParamsMPModelValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent mOValueValidationEvent) {
            Variable variable = mOValueValidationEvent.getNewValue();
            int n = ((Integer32)variable).getValue();
            if (SnmpTargetMIB.this.session.getMessageProcessingModel(n) == null) {
                mOValueValidationEvent.setValidationStatus(10);
                return;
            }
        }
    }

    public class SnmpTargetAddrEntryRow
    extends DefaultMOMutableRow2PC {
        public SnmpTargetAddrEntryRow(OID oID, Variable[] variableArray) {
            super(oID, variableArray);
            this.updateUserObject(this);
        }

        private void updateUserObject(MOTableRow mOTableRow) {
            Variable variable = mOTableRow.getValue(4);
            if (variable != null) {
                Set set = (Set)this.getUserObject();
                Set set2 = SnmpTagList.getTags((OctetString)variable);
                if (set != null) {
                    set.removeAll(set2);
                }
                this.setUserObject(set2);
                this.updateIndex(set, set2);
            }
        }

        @Override
        public void commitRow(SubRequest subRequest, MOTableRow mOTableRow) {
            super.commitRow(subRequest, mOTableRow);
            this.updateUserObject(mOTableRow);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateIndex(Set set, Set set2) {
            HashSet<SnmpTargetAddrEntryRow> hashSet;
            Set<SnmpTargetAddrEntryRow> set3;
            if (set != null) {
                for (Object e : set) {
                    set3 = (HashSet<SnmpTargetAddrEntryRow>)SnmpTargetMIB.this.snmpTargetAddrTagIndex.get(e);
                    if (set3 != null) {
                        hashSet = set3;
                        synchronized (hashSet) {
                            if (!set3.remove(this)) {
                                logger.error((Object)("Inconsistent tag value '" + e + "' for rows: " + set3));
                            }
                            continue;
                        }
                    }
                    logger.error((Object)("Tag value '" + e + "' not found in tag index"));
                }
            }
            for (Object e : set2) {
                set3 = (Set)SnmpTargetMIB.this.snmpTargetAddrTagIndex.get(e);
                if (set3 == null) {
                    set3 = new HashSet<SnmpTargetAddrEntryRow>();
                }
                hashSet = set3;
                synchronized (hashSet) {
                    set3.add(this);
                }
                SnmpTargetMIB.this.snmpTargetAddrTagIndex.put(e, set3);
            }
        }

        @Override
        public void prepareRow(SubRequest subRequest, MOTableRow mOTableRow) {
            OID oID = (OID)this.getResultingValue(0, mOTableRow);
            OctetString octetString = (OctetString)this.getResultingValue(1, mOTableRow);
            if (oID != null) {
                TDomainAddressFactory tDomainAddressFactory = (TDomainAddressFactory)SnmpTargetMIB.this.supportedAddressClasses.get(oID);
                if (tDomainAddressFactory == null || !tDomainAddressFactory.isValidAddress(oID, octetString)) {
                    subRequest.getStatus().setErrorStatus(12);
                }
            } else if (octetString != null) {
                subRequest.getStatus().setErrorStatus(12);
            }
        }

        public Address getAddress() {
            OID oID = (OID)this.getValue(0);
            TDomainAddressFactory tDomainAddressFactory = (TDomainAddressFactory)SnmpTargetMIB.this.supportedAddressClasses.get(oID);
            if (tDomainAddressFactory != null) {
                OctetString octetString = (OctetString)this.getValue(1);
                return tDomainAddressFactory.createAddress(oID, octetString);
            }
            return null;
        }

        public OctetString getTAddress(Address address) {
            TDomainAddressFactory tDomainAddressFactory;
            OID oID;
            OID oID2 = (OID)this.getValue(0);
            if (!oID2.equals((Object)(oID = (tDomainAddressFactory = (TDomainAddressFactory)SnmpTargetMIB.this.supportedAddressClasses.get(oID2)).getTransportDomain(address)))) {
                return null;
            }
            return tDomainAddressFactory.getAddress(address);
        }

        public Target getTarget(OctetString octetString, OctetString octetString2) {
            UserTarget userTarget;
            Address address = this.getAddress();
            OctetString octetString3 = (OctetString)this.getValue(5);
            OID oID = octetString3.toSubIndex(true);
            MOTableRow mOTableRow = SnmpTargetMIB.this.snmpTargetParamsEntryModel.getRow(oID);
            if (mOTableRow == null) {
                return null;
            }
            if (mOTableRow.getValue(0).toInt() == 3) {
                userTarget = new UserTarget(address, (OctetString)mOTableRow.getValue(2), octetString.getValue(), mOTableRow.getValue(3).toInt());
            } else {
                OctetString octetString4 = (OctetString)mOTableRow.getValue(2);
                if (SnmpTargetMIB.this.coexistenceProvider != null && (octetString4 = SnmpTargetMIB.this.coexistenceProvider.getCommunity(octetString4, octetString, octetString2)) == null) {
                    return null;
                }
                userTarget = new CommunityTarget(address, octetString4);
            }
            userTarget.setRetries(this.getValue(3).toInt());
            userTarget.setTimeout((long)(this.getValue(2).toInt() * 10));
            userTarget.setVersion(mOTableRow.getValue(0).toInt());
            return userTarget;
        }
    }

    class SnmpTargetParamsEntryRowStatusListener
    implements RowStatusListener {
        SnmpTargetParamsEntryRowStatusListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rowStatusChanged(RowStatusEvent rowStatusEvent) {
            if (rowStatusEvent.getNewStatus() == 6) {
                OID oID = rowStatusEvent.getRow().getIndex();
                OctetString octetString = (OctetString)snmpTargetParamsEntryIndex.getIndexValues(oID)[0];
                DefaultMOMutableTableModel defaultMOMutableTableModel = SnmpTargetMIB.this.snmpTargetAddrEntryModel;
                synchronized (defaultMOMutableTableModel) {
                    Iterator iterator = SnmpTargetMIB.this.snmpTargetAddrEntryModel.iterator();
                    while (iterator.hasNext()) {
                        MOTableRow mOTableRow = (MOTableRow)iterator.next();
                        Integer32 integer32 = (Integer32)mOTableRow.getValue(7);
                        if (integer32 == null || integer32.getValue() != 1 || !octetString.equals((Object)mOTableRow.getValue(5))) continue;
                        rowStatusEvent.setDenyReason(12);
                        return;
                    }
                }
            }
        }
    }

    class SnmpTargetAddrEntryFactory
    implements MOTableRowFactory {
        SnmpTargetAddrEntryFactory() {
        }

        @Override
        public MOTableRow createRow(OID oID, Variable[] variableArray) throws UnsupportedOperationException {
            SnmpTargetAddrEntryRow snmpTargetAddrEntryRow = new SnmpTargetAddrEntryRow(oID, variableArray);
            return snmpTargetAddrEntryRow;
        }

        @Override
        public void freeRow(MOTableRow mOTableRow) {
        }
    }
}

