/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.DefaultMOTableRow;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.snmp.AgentCapabilityList;
import org.snmp4j.agent.mo.snmp.DisplayString;
import org.snmp4j.agent.mo.snmp.DisplayStringScalar;
import org.snmp4j.agent.mo.snmp.EnumeratedScalar;
import org.snmp4j.agent.mo.snmp.SysUpTime;
import org.snmp4j.agent.mo.snmp.TestAndIncr;
import org.snmp4j.agent.mo.snmp.TimeStampScalar;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;

public class SNMPv2MIB
implements MOGroup,
CounterListener,
AgentCapabilityList {
    private static final OID snmpStatsPrefix = new OID(new int[]{1, 3, 6, 1, 2, 1, 11});
    private static final OID oidSnmpInPkts = SnmpConstants.snmpInPkts;
    private static final OID oidSnmpInBadVersions = SnmpConstants.snmpInBadVersions;
    private static final OID oidSnmpInBadCommunityNames = SnmpConstants.snmpInBadCommunityNames;
    private static final OID oidSnmpInBadCommunityUses = SnmpConstants.snmpInBadCommunityUses;
    private static final OID oidSnmpInASNParseErrs = SnmpConstants.snmpInASNParseErrs;
    private static final OID oidSnmpSilentDrops = SnmpConstants.snmpSilentDrops;
    private static final OID oidSnmpProxyDrops = SnmpConstants.snmpProxyDrops;
    private static final OID oidSysORLastChange = new OID(new int[]{1, 3, 6, 1, 2, 1, 1, 8, 0});
    private static final OID oidSnmpEnableAuthenTraps = new OID(new int[]{1, 3, 6, 1, 2, 1, 11, 30, 0});
    private static final OID oidSnmpSetSerialNo = new OID(new int[]{1, 3, 6, 1, 6, 3, 1, 1, 6, 1, 0});
    private MOScalar descr;
    private SysUpTimeImpl upTime;
    private MOScalar objectID;
    private MOScalar contact;
    private MOScalar name;
    private MOScalar location;
    private MOScalar services;
    private MOScalar snmpEnableAuthenTraps;
    private MOScalar snmpSetSerialNo;
    private MOScalar sysORLastChange;
    private static final OID[] snmpStatsOIDs = new OID[]{oidSnmpInPkts, oidSnmpInBadVersions, oidSnmpInBadCommunityNames, oidSnmpInBadCommunityUses, oidSnmpInASNParseErrs, oidSnmpSilentDrops, oidSnmpProxyDrops};
    private MOScalar[] snmpStats;
    private static final OID oidSysOREntry = new OID(new int[]{1, 3, 6, 1, 2, 1, 1, 9, 1});
    private static final int colSysORID = 2;
    private static final int colSysORDescr = 3;
    private static final int colSysORUpTime = 4;
    private static final int idxSysORID = 0;
    private static final int idxSysORDescr = 1;
    private static final int idxSysORUpTime = 2;
    private static MOTableSubIndex[] sysOREntryIndexes = new MOTableSubIndex[]{new MOTableSubIndex(2, 1, 1)};
    private static MOTableIndex sysOREntryIndex = new MOTableIndex(sysOREntryIndexes, false);
    private DefaultMOTable sysOREntry;
    private DefaultMOMutableTableModel sysOREntryModel;
    private static Map sysUpTimes = Collections.synchronizedMap(new HashMap());

    public SNMPv2MIB(OctetString octetString, OID oID, Integer32 integer32) {
        this.descr = new MOScalar(new OID(SnmpConstants.sysDescr), MOAccessImpl.ACCESS_READ_ONLY, (Variable)octetString);
        this.upTime = new SysUpTimeImpl();
        this.objectID = new MOScalar(new OID(SnmpConstants.sysObjectID), MOAccessImpl.ACCESS_READ_ONLY, (Variable)oID);
        this.contact = new DisplayStringScalar(new OID(SnmpConstants.sysContact), MOAccessImpl.ACCESS_READ_WRITE, new OctetString());
        this.name = new DisplayStringScalar(new OID(SnmpConstants.sysName), MOAccessImpl.ACCESS_READ_WRITE, new OctetString());
        this.location = new DisplayStringScalar(new OID(SnmpConstants.sysLocation), MOAccessImpl.ACCESS_READ_WRITE, new OctetString());
        this.services = new MOScalar(new OID(SnmpConstants.sysServices), MOAccessImpl.ACCESS_READ_ONLY, (Variable)integer32);
        this.snmpEnableAuthenTraps = new EnumeratedScalar(oidSnmpEnableAuthenTraps, MOAccessImpl.ACCESS_READ_WRITE, new Integer32(1), new int[]{1, 2});
        this.snmpSetSerialNo = new TestAndIncr(oidSnmpSetSerialNo);
        this.sysORLastChange = new TimeStampScalar(oidSysORLastChange, MOAccessImpl.ACCESS_READ_ONLY, this.upTime);
        this.createSysOREntry();
        this.createSnmpStats();
    }

    private void createSnmpStats() {
        this.snmpStats = new MOScalar[snmpStatsOIDs.length];
        for (int i = 0; i < snmpStatsOIDs.length; ++i) {
            this.snmpStats[i] = new MOScalar(snmpStatsOIDs[i], MOAccessImpl.ACCESS_READ_ONLY, (Variable)new Counter32(0L));
        }
    }

    private void createSysOREntry() {
        MOColumn[] mOColumnArray = new MOColumn[]{new MOColumn(2, 6, MOAccessImpl.ACCESS_READ_ONLY), new DisplayString(3, MOAccessImpl.ACCESS_READ_ONLY, null, true), new MOColumn(4, 67, MOAccessImpl.ACCESS_READ_ONLY)};
        this.sysOREntry = new SysOREntry(oidSysOREntry, sysOREntryIndex, mOColumnArray);
        this.sysOREntryModel = new DefaultMOMutableTableModel();
        this.sysOREntry.setModel(this.sysOREntryModel);
    }

    protected void updateSysORLastChange() {
        this.sysORLastChange.setValue((Variable)this.getUpTime());
    }

    @Override
    public OID addSysOREntry(OID oID, OctetString octetString) {
        OID oID2 = new OID(new int[]{this.sysOREntryModel.getRowCount() + 1});
        Variable[] variableArray = new Variable[this.sysOREntry.getColumnCount()];
        int n = 0;
        variableArray[n++] = oID;
        variableArray[n++] = octetString;
        variableArray[n++] = this.upTime.get();
        DefaultMOTableRow defaultMOTableRow = new DefaultMOTableRow(oID2, variableArray);
        this.sysOREntryModel.addRow(defaultMOTableRow);
        this.updateSysORLastChange();
        return oID2;
    }

    @Override
    public MOTableRow removeSysOREntry(OID oID) {
        this.updateSysORLastChange();
        return this.sysOREntryModel.removeRow(oID);
    }

    @Override
    public void registerMOs(MOServer mOServer, OctetString octetString) throws DuplicateRegistrationException {
        mOServer.register(this.descr, octetString);
        mOServer.register(this.upTime, octetString);
        sysUpTimes.put(octetString, this.upTime);
        mOServer.register(this.objectID, octetString);
        mOServer.register(this.contact, octetString);
        mOServer.register(this.name, octetString);
        mOServer.register(this.location, octetString);
        mOServer.register(this.services, octetString);
        mOServer.register(this.snmpEnableAuthenTraps, octetString);
        mOServer.register(this.snmpSetSerialNo, octetString);
        mOServer.register(this.sysORLastChange, octetString);
        for (int i = 0; i < this.snmpStats.length; ++i) {
            mOServer.register(this.snmpStats[i], octetString);
        }
    }

    @Override
    public void unregisterMOs(MOServer mOServer, OctetString octetString) {
        mOServer.unregister(this.descr, octetString);
        mOServer.unregister(this.upTime, octetString);
        sysUpTimes.remove(octetString);
        mOServer.unregister(this.objectID, octetString);
        mOServer.unregister(this.contact, octetString);
        mOServer.unregister(this.name, octetString);
        mOServer.unregister(this.location, octetString);
        mOServer.unregister(this.services, octetString);
        mOServer.unregister(this.snmpEnableAuthenTraps, octetString);
        mOServer.unregister(this.snmpSetSerialNo, octetString);
        for (int i = 0; i < this.snmpStats.length; ++i) {
            mOServer.unregister(this.snmpStats[i], octetString);
        }
    }

    public OctetString getContact() {
        return (OctetString)this.contact.getValue();
    }

    public void setContact(OctetString octetString) {
        this.contact.setValue((Variable)octetString);
    }

    public OctetString getDescr() {
        return (OctetString)this.descr.getValue();
    }

    public OctetString getLocation() {
        return (OctetString)this.location.getValue();
    }

    public void setLocation(OctetString octetString) {
        this.location.setValue((Variable)octetString);
    }

    public OctetString getName() {
        return (OctetString)this.name.getValue();
    }

    public void setName(OctetString octetString) {
        this.name.setValue((Variable)octetString);
    }

    public OID getObjectID() {
        return (OID)this.objectID.getValue();
    }

    public Integer32 getServices() {
        return (Integer32)this.services.getValue();
    }

    public TimeTicks getUpTime() {
        return (TimeTicks)this.upTime.getValue();
    }

    public SysUpTime getSysUpTime() {
        return this.upTime;
    }

    public void incrementCounter(CounterEvent counterEvent) {
        if (counterEvent.getOid().startsWith(snmpStatsPrefix) && counterEvent.getOid().size() > snmpStatsPrefix.size()) {
            int n = counterEvent.getOid().get(snmpStatsPrefix.size());
            for (int i = 0; i < snmpStatsOIDs.length; ++i) {
                if (n != snmpStatsOIDs[i].get(snmpStatsPrefix.size())) continue;
                Counter32 counter32 = (Counter32)this.snmpStats[i].getValue();
                counter32.increment();
                counterEvent.setCurrentValue((Variable)((Counter32)counter32.clone()));
            }
        }
    }

    public static SysUpTime getSysUpTime(OctetString octetString) {
        return (SysUpTime)sysUpTimes.get(octetString);
    }

    public class SysOREntry
    extends DefaultMOTable
    implements AgentCapabilityList {
        public SysOREntry(OID oID, MOTableIndex mOTableIndex, MOColumn[] mOColumnArray) {
            super(oID, mOTableIndex, mOColumnArray);
        }

        @Override
        public OID addSysOREntry(OID oID, OctetString octetString) {
            return SNMPv2MIB.this.addSysOREntry(oID, octetString);
        }

        @Override
        public MOTableRow removeSysOREntry(OID oID) {
            return SNMPv2MIB.this.removeSysOREntry(oID);
        }
    }

    public static class SysUpTimeImpl
    extends MOScalar
    implements SysUpTime {
        private long startTime = System.currentTimeMillis();
        private long sysUpTime = 0L;

        public SysUpTimeImpl() {
            super(new OID(SnmpConstants.sysUpTime), MOAccessImpl.ACCESS_READ_ONLY, (Variable)new TimeTicks(0L));
        }

        @Override
        public Variable getValue() {
            TimeTicks timeTicks;
            long l = System.currentTimeMillis();
            if (l >= this.startTime) {
                this.sysUpTime = l - this.startTime;
                timeTicks = new TimeTicks(this.sysUpTime / 10L);
            } else {
                ++this.startTime;
                this.startTime = l;
                timeTicks = new TimeTicks(this.sysUpTime / 10L);
            }
            return timeTicks;
        }

        @Override
        public TimeTicks get() {
            return (TimeTicks)this.getValue();
        }
    }

    public static final class SnmpEnableAuthenTrapsEnum {
        public static final int enabled = 1;
        public static final int disabled = 2;
    }
}

