/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.agent.NotificationOriginator;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.RowStatus;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.SysUpTime;
import org.snmp4j.agent.security.VACM;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class NotificationOriginatorImpl
implements NotificationOriginator {
    private static final LogAdapter logger = LogFactory.getLogger(NotificationOriginatorImpl.class);
    private Snmp session;
    private VACM vacm;
    private SnmpTargetMIB targetMIB;
    private SnmpNotificationMIB notificationMIB;
    private SnmpCommunityMIB communityMIB;
    private SysUpTime sysUpTime;

    public NotificationOriginatorImpl(Snmp snmp, VACM vACM, SysUpTime sysUpTime, SnmpTargetMIB snmpTargetMIB, SnmpNotificationMIB snmpNotificationMIB) {
        this.session = snmp;
        this.sysUpTime = sysUpTime;
        this.vacm = vACM;
        this.targetMIB = snmpTargetMIB;
        this.notificationMIB = snmpNotificationMIB;
    }

    public NotificationOriginatorImpl(Snmp snmp, VACM vACM, SysUpTime sysUpTime, SnmpTargetMIB snmpTargetMIB, SnmpNotificationMIB snmpNotificationMIB, SnmpCommunityMIB snmpCommunityMIB) {
        this(snmp, vACM, sysUpTime, snmpTargetMIB, snmpNotificationMIB);
        this.communityMIB = snmpCommunityMIB;
    }

    @Override
    public Object notify(OctetString octetString, OID oID, VariableBinding[] variableBindingArray) {
        return this.notify(octetString, oID, null, variableBindingArray);
    }

    private ResponseEvent sendNotification(MOTableRow mOTableRow, MOTableRow mOTableRow2, OctetString octetString, OID oID, TimeTicks timeTicks, VariableBinding[] variableBindingArray, int n) {
        ScopedPDU scopedPDU;
        Object object;
        Object object2;
        CommunityTarget communityTarget;
        Integer32 integer32 = (Integer32)mOTableRow2.getValue(0);
        OctetString octetString2 = (OctetString)mOTableRow2.getValue(2);
        Integer32 integer322 = (Integer32)mOTableRow2.getValue(3);
        Integer32 integer323 = (Integer32)mOTableRow2.getValue(1);
        OctetString octetString3 = octetString2;
        if (this.communityMIB != null) {
            octetString3 = this.communityMIB.getCommunity(octetString2, null, octetString);
        }
        Address address = ((SnmpTargetMIB.SnmpTargetAddrEntryRow)mOTableRow).getAddress();
        switch (integer32.getValue()) {
            case 0: {
                communityTarget = new CommunityTarget(address, octetString3);
                object2 = new PDUv1();
                object = object2;
                if (timeTicks != null) {
                    object2.setTimestamp(timeTicks.getValue());
                } else {
                    object2.setTimestamp(this.sysUpTime.get().getValue());
                }
                int n2 = SnmpConstants.getGenericTrapID((OID)oID);
                if (n2 < 0) {
                    if (oID.size() > 2 && oID.get(oID.size() - 2) == 0) {
                        scopedPDU = new OID(oID.getValue(), 0, oID.size() - 2);
                        object2.setEnterprise((OID)scopedPDU);
                    } else {
                        scopedPDU = new OID(oID.getValue(), 0, oID.size() - 1);
                        object2.setEnterprise((OID)scopedPDU);
                    }
                    object2.setSpecificTrap(oID.last());
                } else {
                    object2.setGenericTrap(n2);
                    object2.setEnterprise(new OID(new int[]{0, 0}));
                }
                scopedPDU = this.session.getMessageDispatcher().getTransport(address);
                if (scopedPDU == null || !(scopedPDU.getListenAddress() instanceof IpAddress)) break;
                InetAddress inetAddress = ((IpAddress)scopedPDU.getListenAddress()).getInetAddress();
                object2.setAgentAddress(new IpAddress(inetAddress));
                break;
            }
            case 1: {
                communityTarget = new CommunityTarget(address, octetString3);
                object = new PDU();
                break;
            }
            default: {
                object2 = n == 2 ? new byte[]{} : this.session.getLocalEngineID();
                UserTarget userTarget = new UserTarget(address, octetString2, object2, integer322.getValue());
                communityTarget = userTarget;
                scopedPDU = new ScopedPDU();
                scopedPDU.setContextName(octetString);
                object = scopedPDU;
            }
        }
        communityTarget.setVersion(integer32.getValue());
        object2 = (Integer32)mOTableRow.getValue(2);
        Integer32 integer324 = (Integer32)mOTableRow.getValue(3);
        communityTarget.setTimeout((long)(object2.getValue() * 10));
        communityTarget.setRetries(integer324.getValue());
        if (integer32.getValue() != 0) {
            if (timeTicks != null) {
                object.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)timeTicks));
            } else {
                object.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)this.sysUpTime.get()));
            }
            object.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)oID));
        }
        object.addAll(variableBindingArray);
        object.setType(n == 2 ? -90 : (integer32.getValue() == 0 ? -92 : -89));
        try {
            scopedPDU = this.session.send(object, (Target)communityTarget);
            logger.info((Object)("Sent notification " + object + " to " + communityTarget));
            return scopedPDU;
        }
        catch (IOException iOException) {
            logger.error((Object)("Failed to send notification: " + iOException.getMessage()));
            return null;
        }
    }

    private boolean isAccessGranted(MOTableRow mOTableRow, MOTableRow mOTableRow2, OctetString octetString, OID oID, VariableBinding[] variableBindingArray) {
        if (!this.notificationMIB.passesFilter(mOTableRow2.getIndex(), oID, variableBindingArray)) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Notification " + oID + " did not pass filter " + mOTableRow2.getIndex()));
            }
            return false;
        }
        OctetString octetString2 = (OctetString)mOTableRow2.getValue(2);
        Integer32 integer32 = (Integer32)mOTableRow2.getValue(3);
        Integer32 integer322 = (Integer32)mOTableRow2.getValue(1);
        int n = this.vacm.isAccessAllowed(octetString, octetString2, integer322.getValue(), integer32.getValue(), 0, oID);
        for (int i = 0; n == 0 && i < variableBindingArray.length; ++i) {
            n = this.vacm.isAccessAllowed(octetString, octetString2, integer322.getValue(), integer32.getValue(), 0, variableBindingArray[i].getOid());
        }
        return n == 0;
    }

    @Override
    public Object notify(OctetString octetString, OID oID, TimeTicks timeTicks, VariableBinding[] variableBindingArray) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Notification " + oID + " issued with " + Arrays.asList(variableBindingArray)));
        }
        LinkedList<ResponseEvent> linkedList = new LinkedList<ResponseEvent>();
        Iterator iterator = this.notificationMIB.getNotifyTable().getModel().iterator();
        while (iterator.hasNext()) {
            MOTableRow mOTableRow = (MOTableRow)iterator.next();
            OctetString octetString2 = (OctetString)mOTableRow.getValue(0);
            Integer32 integer32 = (Integer32)mOTableRow.getValue(1);
            Collection collection = this.targetMIB.getTargetAddrRowsForTag(octetString2);
            RowStatus.ActiveRowsFilter activeRowsFilter = new RowStatus.ActiveRowsFilter(7);
            for (MOTableRow mOTableRow2 : collection) {
                if (!activeRowsFilter.passesFilter(mOTableRow2)) continue;
                OctetString octetString3 = (OctetString)mOTableRow2.getValue(5);
                MOTableRow mOTableRow3 = this.targetMIB.getTargetParamsRow(octetString3);
                if (RowStatus.isRowActive(mOTableRow3, 5)) {
                    if (this.isAccessGranted(mOTableRow2, mOTableRow3, octetString, oID, variableBindingArray)) {
                        ResponseEvent responseEvent = this.sendNotification(mOTableRow2, mOTableRow3, octetString, oID, timeTicks, variableBindingArray, integer32.getValue());
                        linkedList.add(responseEvent);
                        continue;
                    }
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn((Object)("Access denied by VACM for " + oID));
                    continue;
                }
                logger.warn((Object)"Found active target address but corrsponding params are not active");
            }
        }
        return linkedList.toArray(new ResponseEvent[0]);
    }
}

