/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import org.snmp4j.agent.mo.MOTableIndexValidator;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;

public class MOTableIndex
implements MOTableIndexValidator {
    public static final int MAX_INDEX_OID_LENGTH = 127;
    private MOTableSubIndex[] subindexes;
    private boolean impliedLength = false;
    private MOTableIndexValidator validator;

    public MOTableIndex(MOTableSubIndex[] mOTableSubIndexArray) {
        if (mOTableSubIndexArray == null || mOTableSubIndexArray.length < 1) {
            throw new IllegalArgumentException("Index definition must have at least one sub-index");
        }
        this.subindexes = mOTableSubIndexArray;
    }

    public MOTableIndex(MOTableSubIndex[] mOTableSubIndexArray, boolean bl) {
        this(mOTableSubIndexArray);
        this.impliedLength = bl;
    }

    public MOTableIndex(MOTableSubIndex[] mOTableSubIndexArray, boolean bl, MOTableIndexValidator mOTableIndexValidator) {
        this(mOTableSubIndexArray, bl);
        this.validator = mOTableIndexValidator;
    }

    public MOTableSubIndex getIndex(int n) {
        return this.subindexes[n];
    }

    public boolean isImpliedLength() {
        return this.impliedLength;
    }

    public MOTableIndexValidator getValidator() {
        return this.validator;
    }

    public void setValidator(MOTableIndexValidator mOTableIndexValidator) {
        this.validator = mOTableIndexValidator;
    }

    public int size() {
        return this.subindexes.length;
    }

    private static boolean checkIndexBytes(OID oID, long l, long l2) {
        if (l < 0L || l > 127L || l2 < 0L || l2 > 127L) {
            return false;
        }
        for (int i = (int)l; i < oID.size() && (long)i < l2; ++i) {
            if (oID.getUnsigned(i) <= 255L) continue;
            return false;
        }
        return true;
    }

    private static boolean isStringSyntax(int n) {
        switch (n) {
            case 4: 
            case 64: 
            case 68: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValidIndex(OID oID) {
        int n;
        if (oID.size() > 127) {
            return false;
        }
        int n2 = 0;
        for (n = 0; n < this.size() && n2 < oID.size(); ++n) {
            MOTableSubIndex mOTableSubIndex = this.getIndex(n);
            if (n + 1 == this.size() && this.isImpliedLength()) {
                int n3 = mOTableSubIndex.getSmiSyntax();
                switch (n3) {
                    case 4: 
                    case 64: {
                        if (MOTableIndex.checkIndexBytes(oID, n2, oID.size())) break;
                        return false;
                    }
                }
                return true;
            }
            if (mOTableSubIndex.getMinLength() != mOTableSubIndex.getMaxLength()) {
                if (oID.size() < oID.get(n2) + 1) {
                    return false;
                }
                if (oID.get(n2) < mOTableSubIndex.getMinLength() || oID.get(n2) > mOTableSubIndex.getMaxLength()) {
                    return false;
                }
                if (MOTableIndex.isStringSyntax(mOTableSubIndex.getSmiSyntax()) && !MOTableIndex.checkIndexBytes(oID, n2, (long)n2 + oID.getUnsigned(n2) + 1L)) {
                    return false;
                }
                n2 = (int)((long)n2 + (oID.getUnsigned(n2) + 1L));
                continue;
            }
            if (MOTableIndex.isStringSyntax(mOTableSubIndex.getSmiSyntax()) && !MOTableIndex.checkIndexBytes(oID, n2, n2 + mOTableSubIndex.getMaxLength())) {
                return false;
            }
            n2 += mOTableSubIndex.getMaxLength();
        }
        return oID.size() == n2 && n >= this.size() && (this.validator == null || this.validator.isValidIndex(oID));
    }

    private static Variable getIndexVariable(MOTableSubIndex mOTableSubIndex, OID oID, boolean bl) {
        switch (mOTableSubIndex.getSmiSyntax()) {
            case 4: {
                if (bl || mOTableSubIndex.getMinLength() == mOTableSubIndex.getMaxLength()) {
                    OctetString octetString = new OctetString(oID.toByteArray());
                    return octetString;
                }
                OID oID2 = new OID(oID.getValue(), 1, oID.size() - 1);
                return new OctetString(oID2.toByteArray());
            }
            case 6: {
                if (bl || mOTableSubIndex.getMinLength() == mOTableSubIndex.getMaxLength()) {
                    return oID;
                }
                OID oID3 = new OID(oID.getValue(), 1, oID.size() - 1);
                return oID3;
            }
            case 66: {
                return new Gauge32((long)oID.get(oID.size() - 1));
            }
            case 67: {
                return new TimeTicks((long)oID.get(oID.size() - 1));
            }
            case 2: {
                return new Integer32(oID.get(oID.size() - 1));
            }
            case 64: {
                return new IpAddress(oID.toString());
            }
        }
        return null;
    }

    public OID[] getIndexOIDs(OID oID) {
        OID[] oIDArray = new OID[this.size()];
        int[] nArray = oID.getValue();
        int n = 0;
        for (int i = 0; i < this.subindexes.length; ++i) {
            if (i + 1 == this.size() && this.isImpliedLength()) {
                oIDArray[i] = new OID(nArray, n, oID.size() - n);
                break;
            }
            oIDArray[i] = this.subindexes[i].getMinLength() != this.subindexes[i].getMaxLength() ? new OID(nArray, n, oID.get(n) + 1) : new OID(oID.getValue(), n, this.subindexes[i].getMaxLength());
            n += oIDArray[i].size();
        }
        return oIDArray;
    }

    public Variable[] getIndexValues(OID oID) {
        OID[] oIDArray = this.getIndexOIDs(oID);
        Variable[] variableArray = new Variable[oIDArray.length];
        for (int i = 0; i < oIDArray.length; ++i) {
            boolean bl = this.isImpliedLength() && i + 1 == this.size();
            variableArray[i] = MOTableIndex.getIndexVariable(this.subindexes[i], oIDArray[i], bl);
        }
        return variableArray;
    }

    public OID getIndexOID(Variable[] variableArray) {
        if (variableArray.length != this.size()) {
            throw new IllegalArgumentException("Index value length != size()");
        }
        OID oID = new OID();
        for (int i = 0; i < variableArray.length; ++i) {
            if (variableArray[i].getSyntax() != this.subindexes[i].getSmiSyntax()) {
                throw new IllegalArgumentException("Syntax of index value #" + i + " = " + variableArray[i].getSyntaxString() + " does not match index definition " + Variable.getSyntaxString((int)this.subindexes[i].getSmiSyntax()));
            }
            oID.append(variableArray[i].toSubIndex(i + 1 == variableArray.length && this.impliedLength));
        }
        return oID;
    }
}

