/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOMutableRow2PC;
import org.snmp4j.agent.mo.MOMutableTableRow;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.Variable;

public class MOMutableColumn
extends MOColumn {
    private Vector validators;
    private Variable defaultValue;
    private boolean mutableInService = true;

    public MOMutableColumn(int columnID, int syntax) {
        super(columnID, syntax);
    }

    public MOMutableColumn(int columnID, int syntax, MOAccess access) {
        super(columnID, syntax, access);
    }

    public MOMutableColumn(int columnID, int syntax, MOAccess access, Variable defaultValue) {
        super(columnID, syntax, access);
        this.defaultValue = defaultValue;
    }

    public MOMutableColumn(int columnID, int syntax, MOAccess access, Variable defaultValue, boolean mutableInService) {
        super(columnID, syntax, access);
        this.defaultValue = defaultValue;
        this.mutableInService = mutableInService;
    }

    public synchronized void addMOValueValidationListener(MOValueValidationListener validator) {
        if (this.validators == null) {
            this.validators = new Vector(2);
        }
        this.validators.add(validator);
    }

    public synchronized void removeMOValueValidationListener(MOValueValidationListener validator) {
        if (this.validators == null) {
            this.validators.remove(validator);
        }
    }

    public synchronized int validate(Variable newValue, Variable oldValue) {
        int status = 0;
        if (this.validators != null) {
            Iterator it = ((AbstractList)this.validators).iterator();
            while (it.hasNext()) {
                MOValueValidationListener v = (MOValueValidationListener)it.next();
                MOValueValidationEvent event = new MOValueValidationEvent(this, oldValue, newValue);
                v.validate(event);
                if (event.getValidationStatus() == 0) continue;
                status = event.getValidationStatus();
                break;
            }
        }
        return status;
    }

    protected boolean validateSetRequest(SubRequest subRequest, MOTableRow row, int column) {
        int status;
        Variable value = subRequest.getVariableBinding().getVariable();
        if (value.getSyntax() != this.getSyntax()) {
            subRequest.getStatus().setErrorStatus(7);
        }
        if ((status = this.validate(value, row.size() > column ? row.getValue(column) : null)) != 0) {
            subRequest.getStatus().setErrorStatus(status);
            return false;
        }
        return true;
    }

    public void prepare(SubRequest subRequest, MOTableRow row, MOTableRow changeSet, int column) {
        if (row instanceof MOMutableRow2PC) {
            if (this.validateSetRequest(subRequest, row, column)) {
                ((MOMutableRow2PC)row).prepare(subRequest, changeSet, column);
            }
        } else if (row instanceof MOMutableTableRow) {
            if (this.validateSetRequest(subRequest, row, column)) {
                subRequest.completed();
            }
        } else {
            subRequest.getStatus().setErrorStatus(17);
        }
    }

    public void commit(SubRequest subRequest, MOTableRow row, MOTableRow changeSet, int column) {
        if (row instanceof MOMutableRow2PC) {
            ((MOMutableRow2PC)row).commit(subRequest, changeSet, column);
        } else if (row instanceof MOMutableTableRow) {
            if (subRequest.getUndoValue() == null) {
                subRequest.setUndoValue(row.getValue(column));
            }
            ((MOMutableTableRow)row).setValue(column, (Variable)subRequest.getVariableBinding().getVariable().clone());
            subRequest.completed();
        } else {
            subRequest.getStatus().setErrorStatus(14);
        }
    }

    public void undo(SubRequest subRequest, MOTableRow row, int column) {
        if (row instanceof MOMutableRow2PC) {
            ((MOMutableRow2PC)row).undo(subRequest, column);
        }
        if (row instanceof MOMutableTableRow && subRequest.getUndoValue() instanceof Variable) {
            ((MOMutableTableRow)row).setValue(column, (Variable)subRequest.getUndoValue());
            subRequest.completed();
        } else {
            subRequest.getStatus().setErrorStatus(15);
        }
    }

    public void cleanup(SubRequest subRequest, MOTableRow row, int column) {
        if (row instanceof MOMutableRow2PC) {
            ((MOMutableRow2PC)row).cleanup(subRequest, column);
        }
        subRequest.completed();
    }

    public void setDefaultValue(Variable defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setMutableInService(boolean mutableInService) {
        this.mutableInService = mutableInService;
    }

    public Variable getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isMutableInService() {
        return this.mutableInService;
    }

    public boolean isMandatory() {
        return this.defaultValue == null && this.getAccess().isAccessibleForCreate();
    }

    public String toString() {
        return this.getClass().getName() + "[columnID=" + this.getColumnID() + ",syntax=" + this.getSyntax() + ",default=" + this.getDefaultValue() + ",mode=]";
    }
}

