/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import org.snmp4j.agent.DefaultMOScope;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.SerializableManagedObject;
import org.snmp4j.agent.io.IndexedVariables;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.MOOutput;
import org.snmp4j.agent.io.Sequence;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTableRow;
import org.snmp4j.agent.mo.MOChangeEvent;
import org.snmp4j.agent.mo.MOChangeListener;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOMutableRow2PC;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOMutableTableRow;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableCellInfo;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowEvent;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.agent.request.Request;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.util.OIDScope;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class DefaultMOTable
implements MOTable,
MOScope,
SerializableManagedObject {
    private static LogAdapter logger = LogFactory.getLogger(DefaultMOTable.class);
    private OID oid;
    private MOTableIndex indexDef;
    private MOColumn[] columns;
    private MOTableModel model;
    private boolean isVolatile;
    protected WeakHashMap newRows;
    protected WeakHashMap pendingChanges;
    private transient Vector moChangeListeners;
    private transient Vector moTableRowListeners;
    private static Comparator columnComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            int n = object instanceof MOColumn ? ((MOColumn)object).getColumnID() : ((Integer)object).intValue();
            int n2 = object2 instanceof MOColumn ? ((MOColumn)object2).getColumnID() : ((Integer)object2).intValue();
            return n - n2;
        }
    };

    public DefaultMOTable(OID oID, MOTableIndex mOTableIndex, MOColumn[] mOColumnArray) {
        this(oID, mOTableIndex, mOColumnArray, new DefaultMOMutableTableModel());
    }

    public DefaultMOTable(OID oID, MOTableIndex mOTableIndex, MOColumn[] mOColumnArray, MOTableModel mOTableModel) {
        this.oid = oID;
        this.indexDef = mOTableIndex;
        this.columns = mOColumnArray;
        this.model = mOTableModel;
        this.registerColumns();
    }

    private void registerColumns() {
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].setTable(this);
        }
    }

    @Override
    public MOTableCellInfo getCellInfo(OID oID) {
        return new CellInfo(oID);
    }

    @Override
    public int getColumnIndex(int n) {
        int n2 = Arrays.binarySearch(this.columns, new Integer(n), columnComparator);
        return n2;
    }

    @Override
    public MOColumn getColumn(int n) {
        return this.columns[n];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public MOTableRow createRow(OID oID, Variable[] variableArray) {
        if (this.model instanceof MOMutableTableModel) {
            Variable[] variableArray2 = variableArray;
            if (variableArray2.length < this.getColumnCount()) {
                variableArray2 = this.getDefaultValues();
                System.arraycopy(variableArray, 0, variableArray2, 0, variableArray.length);
            }
            MOTableRow mOTableRow = ((MOMutableTableModel)this.model).createRow(oID, variableArray2);
            MOTableRowEvent mOTableRowEvent = new MOTableRowEvent(this, this, mOTableRow, 1);
            this.fireRowChanged(mOTableRowEvent);
            if (mOTableRowEvent.getVetoStatus() == 0) {
                return mOTableRow;
            }
        }
        return null;
    }

    @Override
    public MOTableRow createRow(OID oID) {
        return this.createRow(oID, this.getDefaultValues());
    }

    @Override
    public boolean addRow(MOTableRow mOTableRow) {
        if (this.model instanceof MOMutableTableModel) {
            MOTableRowEvent mOTableRowEvent = new MOTableRowEvent(this, this, mOTableRow, 2);
            this.fireRowChanged(mOTableRowEvent);
            if (mOTableRowEvent.getVetoStatus() == 0) {
                ((MOMutableTableModel)this.model).addRow(mOTableRow);
            }
            return true;
        }
        return false;
    }

    @Override
    public MOTableRow removeRow(OID oID) {
        if (this.model instanceof MOMutableTableModel) {
            MOTableRow mOTableRow = this.model.getRow(oID);
            if (mOTableRow == null) {
                return null;
            }
            MOTableRowEvent mOTableRowEvent = new MOTableRowEvent(this, this, mOTableRow, 3);
            this.fireRowChanged(mOTableRowEvent);
            if (mOTableRowEvent.getVetoStatus() == 0) {
                return ((MOMutableTableModel)this.model).removeRow(oID);
            }
        }
        return null;
    }

    public int removeAll() {
        int n = 0;
        while (this.model.getRowCount() > 0) {
            MOTableRow mOTableRow = this.model.firstRow();
            if (mOTableRow == null) continue;
            MOTableRowEvent mOTableRowEvent = new MOTableRowEvent(this, this, mOTableRow, 3);
            this.fireRowChanged(mOTableRowEvent);
            if (mOTableRowEvent.getVetoStatus() != 0) continue;
            ((MOMutableTableModel)this.model).removeRow(mOTableRow.getIndex());
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(SubRequest subRequest) {
        OID oID = subRequest.getVariableBinding().getOid();
        MOTableCellInfo mOTableCellInfo = this.getCellInfo(oID);
        MOMutableColumn mOMutableColumn = (MOMutableColumn)this.getColumn(mOTableCellInfo.getColumn());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Committing sub-request (" + subRequest.getVariableBinding() + ") for column: " + mOMutableColumn));
        }
        MOTableModel mOTableModel = this.model;
        synchronized (mOTableModel) {
            EventObject eventObject;
            Object object;
            MOMutableTableRow mOMutableTableRow;
            if (this.hasNewRows(subRequest.getRequest())) {
                mOMutableTableRow = (MOMutableTableRow)this.getNewRows(subRequest.getRequest()).get(mOTableCellInfo.getIndex());
                this.addRow(mOMutableTableRow);
            } else {
                mOMutableTableRow = (MOMutableTableRow)this.model.getRow(mOTableCellInfo.getIndex());
            }
            Variable variable = null;
            if (this.moChangeListeners != null) {
                variable = mOMutableTableRow.getValue(mOTableCellInfo.getColumn());
                object = new MOChangeEvent(this, new CellProxy(mOTableCellInfo), mOTableCellInfo.getCellOID(), variable, subRequest.getVariableBinding().getVariable());
                this.fireBeforeMOChange((MOChangeEvent)object);
            }
            object = this.getPendingChangeSet(subRequest, mOTableCellInfo.getIndex());
            mOMutableColumn.commit(subRequest, mOMutableTableRow, (MOTableRow)object, mOTableCellInfo.getColumn());
            if (this.moChangeListeners != null) {
                eventObject = new MOChangeEvent(this, new CellProxy(mOTableCellInfo), mOTableCellInfo.getCellOID(), variable, subRequest.getVariableBinding().getVariable());
                this.fireAfterMOChange((MOChangeEvent)eventObject);
            }
            if (this.isChangeSetComplete(subRequest, mOTableCellInfo.getIndex(), mOTableCellInfo.getColumn())) {
                if (mOMutableTableRow instanceof MOMutableRow2PC) {
                    ((MOMutableRow2PC)mOMutableTableRow).commitRow(subRequest, (MOTableRow)object);
                }
                if (this.moTableRowListeners != null) {
                    eventObject = new MOTableRowEvent(this, this, mOMutableTableRow, 4);
                    this.fireRowChanged((MOTableRowEvent)eventObject);
                }
            }
        }
    }

    @Override
    public final OID getIndexPart(OID oID) {
        int n = this.oid.size() + 1;
        if (oID.size() <= n || !oID.startsWith(this.oid)) {
            return null;
        }
        return new OID(oID.getValue(), n, oID.size() - n);
    }

    public OID getCellOID(OID oID, int n) {
        OID oID2 = new OID(this.oid);
        oID2.append(this.columns[n].getColumnID());
        oID2.append(oID);
        return oID2;
    }

    private MOTableCellInfo getNextCell(int n, OID oID, boolean bl) {
        for (int i = n; i < this.columns.length; ++i) {
            MOTableRow mOTableRow;
            Iterator iterator = this.model.tailIterator(oID);
            if (!iterator.hasNext()) {
                if (oID == null) {
                    return null;
                }
                oID = null;
                bl = true;
                continue;
            }
            if (oID != null && !bl && (mOTableRow = (MOTableRow)iterator.next()).getIndex().compareTo((Object)oID) > 0) {
                return new CellInfo(mOTableRow.getIndex(), i, this.columns[i].getColumnID());
            }
            oID = null;
            bl = true;
            if (!iterator.hasNext()) continue;
            mOTableRow = (MOTableRow)iterator.next();
            return new CellInfo(mOTableRow.getIndex(), i, this.columns[i].getColumnID());
        }
        return null;
    }

    @Override
    public OID find(MOScope mOScope) {
        MOTableCellInfo mOTableCellInfo = this.findCell(mOScope);
        if (mOTableCellInfo != null) {
            return mOTableCellInfo.getCellOID();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MOTableCellInfo findCell(MOScope mOScope) {
        MOTableModel mOTableModel = this.model;
        synchronized (mOTableModel) {
            OID oID;
            if (this.model.getRowCount() == 0) {
                return null;
            }
            MOTableCellInfo mOTableCellInfo = this.getCellInfo(mOScope.getLowerBound());
            int n = mOTableCellInfo.getColumn();
            boolean bl = true;
            if (n < 0) {
                n = -n - 1;
                bl = false;
            }
            if (n >= this.columns.length) {
                return null;
            }
            MOTableCellInfo mOTableCellInfo2 = this.getNextCell(n, mOTableCellInfo.getIndex(), !bl || mOScope.isLowerIncluded());
            if (mOTableCellInfo2 != null && mOScope.isCovered(new OIDScope(oID = mOTableCellInfo2.getCellOID()))) {
                return mOTableCellInfo2;
            }
        }
        return null;
    }

    @Override
    public MOScope getScope() {
        return this;
    }

    @Override
    public Variable getValue(OID oID) {
        MOTableCellInfo mOTableCellInfo = this.getCellInfo(oID);
        if (mOTableCellInfo.getIndex() != null && mOTableCellInfo.getColumn() >= 0 && mOTableCellInfo.getColumn() < this.columns.length) {
            return this.getValue(mOTableCellInfo.getIndex(), mOTableCellInfo.getColumn());
        }
        return null;
    }

    @Override
    public Variable getValue(OID oID, int n) {
        MOTableRow mOTableRow = this.model.getRow(oID);
        if (mOTableRow != null) {
            return this.columns[n].getValue(mOTableRow, n);
        }
        return null;
    }

    @Override
    public void get(SubRequest subRequest) {
        OID oID = subRequest.getVariableBinding().getOid();
        MOTableCellInfo mOTableCellInfo = this.getCellInfo(oID);
        if (mOTableCellInfo.getIndex() != null && mOTableCellInfo.getColumn() >= 0 && mOTableCellInfo.getColumn() < this.columns.length) {
            MOColumn mOColumn = this.getColumn(mOTableCellInfo.getColumn());
            MOTableRow mOTableRow = this.model.getRow(mOTableCellInfo.getIndex());
            if (mOTableRow == null) {
                subRequest.getVariableBinding().setVariable((Variable)Null.noSuchInstance);
            } else if (mOColumn != null) {
                mOColumn.get(subRequest, mOTableRow, mOTableCellInfo.getColumn());
            } else {
                subRequest.getStatus().setErrorStatus(6);
            }
        } else if (mOTableCellInfo.getIndex() == null) {
            subRequest.getVariableBinding().setVariable((Variable)Null.noSuchInstance);
        } else {
            subRequest.getVariableBinding().setVariable((Variable)Null.noSuchObject);
        }
        subRequest.completed();
    }

    @Override
    public boolean next(SubRequest subRequest) {
        MOTableCellInfo mOTableCellInfo;
        DefaultMOScope defaultMOScope = new DefaultMOScope(subRequest.getScope());
        while ((mOTableCellInfo = this.findCell(defaultMOScope)) != null) {
            Variable variable;
            if (this.columns[mOTableCellInfo.getColumn()].getAccess().isAccessibleForRead()) {
                variable = this.getValue(mOTableCellInfo.getIndex(), mOTableCellInfo.getColumn());
                if (variable == null) {
                    defaultMOScope.setLowerBound(mOTableCellInfo.getCellOID());
                    defaultMOScope.setLowerIncluded(false);
                    continue;
                }
                subRequest.getVariableBinding().setOid(mOTableCellInfo.getCellOID());
                subRequest.getVariableBinding().setVariable(variable);
                subRequest.completed();
                return true;
            }
            if (mOTableCellInfo.getColumn() + 1 < this.getColumnCount()) {
                variable = new OID(this.getOID());
                variable.append(this.columns[mOTableCellInfo.getColumn() + 1].getColumnID());
                defaultMOScope.setLowerBound((OID)variable);
                defaultMOScope.setLowerIncluded(false);
                continue;
            }
            return false;
        }
        return false;
    }

    @Override
    public void prepare(SubRequest subRequest) {
        block17: {
            OID oID = subRequest.getVariableBinding().getOid();
            MOTableCellInfo mOTableCellInfo = this.getCellInfo(oID);
            if (mOTableCellInfo.getIndex() == null) {
                subRequest.getStatus().setErrorStatus(18);
                return;
            }
            if (mOTableCellInfo.getColumn() >= 0 && mOTableCellInfo.getColumn() < this.columns.length) {
                MOColumn mOColumn = this.getColumn(mOTableCellInfo.getColumn());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Preparing sub-request (" + subRequest.getVariableBinding() + ")" + " for column: " + mOColumn));
                }
                if (mOColumn instanceof MOMutableColumn && mOColumn.getAccess().isAccessibleForWrite()) {
                    MOMutableColumn mOMutableColumn = (MOMutableColumn)mOColumn;
                    if (this.getIndexDef().isValidIndex(mOTableCellInfo.getIndex())) {
                        MOTableRow mOTableRow = this.model.getRow(mOTableCellInfo.getIndex());
                        if (mOTableRow == null) {
                            mOTableRow = (MOTableRow)this.getNewRows(subRequest.getRequest()).get(mOTableCellInfo.getIndex());
                        }
                        if (mOTableRow != null) {
                            this.prepare(subRequest, mOTableCellInfo, mOMutableColumn, mOTableRow, false);
                            subRequest.completed();
                            return;
                        }
                        if (this.model instanceof MOMutableTableModel) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Trying to create new row '" + mOTableCellInfo.getIndex() + "'"));
                            }
                            MOMutableTableModel mOMutableTableModel = (MOMutableTableModel)this.model;
                            try {
                                mOTableRow = this.createRow(subRequest, mOTableCellInfo, mOMutableTableModel);
                                if (mOTableRow == null) {
                                    subRequest.getStatus().setErrorStatus(11);
                                    break block17;
                                }
                                this.prepare(subRequest, mOTableCellInfo, mOMutableColumn, mOTableRow, true);
                                subRequest.completed();
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {
                                subRequest.getStatus().setErrorStatus(11);
                            }
                        } else {
                            subRequest.getStatus().setErrorStatus(11);
                        }
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Invalid index '" + mOTableCellInfo.getIndex() + "' for row creation in table " + this.getID()));
                        }
                        subRequest.getStatus().setErrorStatus(11);
                    }
                } else {
                    subRequest.getStatus().setErrorStatus(17);
                }
            } else {
                subRequest.getStatus().setErrorStatus(11);
            }
        }
    }

    private MOTableRow createRow(SubRequest subRequest, MOTableCellInfo mOTableCellInfo, MOMutableTableModel mOMutableTableModel) throws UnsupportedOperationException {
        MOColumn mOColumn = this.getColumn(mOTableCellInfo.getColumn());
        if (!mOColumn.getAccess().isAccessibleForCreate()) {
            return null;
        }
        Variable[] variableArray = new Variable[this.getColumnCount()];
        this.getChangesFromRequest(mOTableCellInfo.getIndex(), null, subRequest, variableArray, true, true);
        MOTableRow mOTableRow = mOMutableTableModel.createRow(mOTableCellInfo.getIndex(), variableArray);
        this.getNewRows(subRequest.getRequest()).put(mOTableRow.getIndex(), mOTableRow);
        return mOTableRow;
    }

    private void prepare(SubRequest subRequest, MOTableCellInfo mOTableCellInfo, MOMutableColumn mOMutableColumn, MOTableRow mOTableRow, boolean bl) {
        EventObject eventObject;
        Object object;
        if (this.moChangeListeners != null) {
            object = new MOChangeEvent(this, new CellProxy(mOTableCellInfo), mOTableCellInfo.getCellOID(), bl ? null : mOTableRow.getValue(mOTableCellInfo.getColumn()), subRequest.getVariableBinding().getVariable());
            this.fireBeforePrepareMOChange((MOChangeEvent)object);
            if (((MOChangeEvent)object).getDenyReason() != 0) {
                subRequest.getStatus().setErrorStatus(((MOChangeEvent)object).getDenyReason());
            }
        }
        if ((object = this.getPendingChangeSet(subRequest, mOTableCellInfo.getIndex())) == null) {
            object = this.addPendingChanges(subRequest, mOTableRow, bl);
        }
        if (this.moTableRowListeners != null && !subRequest.hasError() && this.isChangeSetComplete(subRequest, mOTableRow.getIndex(), mOTableCellInfo.getColumn())) {
            eventObject = new MOTableRowEvent(this, this, mOTableRow, (MOTableRow)object, bl ? 1 : 0);
            this.fireRowChanged((MOTableRowEvent)eventObject);
            if (((MOTableRowEvent)eventObject).getVetoStatus() != 0) {
                if (((MOTableRowEvent)eventObject).getVetoColumn() >= 0) {
                    int n = this.columns[((MOTableRowEvent)eventObject).getVetoColumn()].getColumnID();
                    OID oID = new OID(this.getOID());
                    oID.append(n);
                    SubRequest subRequest2 = subRequest.getRequest().find(oID);
                    if (subRequest2 != null) {
                        subRequest2.getStatus().setErrorStatus(((MOTableRowEvent)eventObject).getVetoStatus());
                    } else {
                        subRequest.getRequest().setErrorStatus(((MOTableRowEvent)eventObject).getVetoStatus());
                    }
                } else {
                    subRequest.getRequest().setErrorStatus(((MOTableRowEvent)eventObject).getVetoStatus());
                }
            }
        }
        if (subRequest.getStatus().getErrorStatus() == 0) {
            mOMutableColumn.prepare(subRequest, mOTableRow, (MOTableRow)object, mOTableCellInfo.getColumn());
            eventObject = new MOChangeEvent(this, new CellProxy(mOTableCellInfo), mOTableCellInfo.getCellOID(), mOTableRow.getValue(mOTableCellInfo.getColumn()), subRequest.getVariableBinding().getVariable());
            this.fireAfterPrepareMOChange((MOChangeEvent)eventObject);
            if (((MOChangeEvent)eventObject).getDenyReason() != 0) {
                subRequest.getStatus().setErrorStatus(((MOChangeEvent)eventObject).getDenyReason());
            } else if (mOTableRow instanceof MOMutableRow2PC && this.isChangeSetComplete(subRequest, mOTableRow.getIndex(), mOTableCellInfo.getColumn())) {
                ((MOMutableRow2PC)mOTableRow).prepareRow(subRequest, (MOTableRow)object);
            }
        }
    }

    protected int getChangesFromRequest(OID oID, MOTableRow mOTableRow, SubRequest subRequest, Variable[] variableArray, boolean bl, boolean bl2) {
        int n = -1;
        if (bl) {
            for (int i = 0; i < variableArray.length && i < this.getColumnCount(); ++i) {
                if (!(this.columns[i] instanceof MOMutableColumn)) continue;
                variableArray[i] = ((MOMutableColumn)this.columns[i]).getDefaultValue();
            }
        }
        Request request = subRequest.getRequest();
        Iterator iterator = request.iterator();
        while (iterator.hasNext()) {
            Variable variable;
            int n2;
            SubRequest subRequest2 = (SubRequest)iterator.next();
            OID oID2 = subRequest2.getVariableBinding().getOid();
            MOTableCellInfo mOTableCellInfo = this.getCellInfo(oID2);
            if (!oID.equals((Object)mOTableCellInfo.getIndex()) || (n2 = mOTableCellInfo.getColumn()) < 0 || n2 >= variableArray.length || (variable = subRequest2.getVariableBinding().getVariable()) == null || mOTableRow != null && !bl2 && mOTableRow.size() > n2 && variable.equals((Object)mOTableRow.getValue(n2))) continue;
            variableArray[n2] = variable;
            n = n2;
        }
        return n;
    }

    protected boolean hasNewRows(Object object) {
        return this.newRows != null && this.newRows.get(object) != null;
    }

    protected Map getNewRows(Object object) {
        HashMap hashMap;
        if (this.newRows == null) {
            this.newRows = new WeakHashMap(4);
        }
        if ((hashMap = (HashMap)this.newRows.get(object)) == null) {
            hashMap = new HashMap(5);
            this.newRows.put(object, hashMap);
        }
        return hashMap;
    }

    protected synchronized boolean isChangeSetComplete(SubRequest subRequest, OID oID, int n) {
        ChangeSet changeSet = this.getPendingChangeSet(subRequest, oID);
        if (changeSet != null) {
            return changeSet.getLastChangedColumn() == n;
        }
        return true;
    }

    protected synchronized ChangeSet addPendingChanges(SubRequest subRequest, MOTableRow mOTableRow, boolean bl) {
        HashMap<OID, ChangeSet> hashMap;
        if (this.pendingChanges == null) {
            this.pendingChanges = new WeakHashMap(4);
        }
        if ((hashMap = (HashMap<OID, ChangeSet>)this.pendingChanges.get(subRequest.getRequest())) == null) {
            hashMap = new HashMap<OID, ChangeSet>(5);
            this.pendingChanges.put(subRequest.getRequest(), hashMap);
        }
        Variable[] variableArray = new Variable[this.getColumnCount()];
        int n = this.getChangesFromRequest(mOTableRow.getIndex(), mOTableRow, subRequest, variableArray, bl, bl);
        ChangeSet changeSet = new ChangeSet(mOTableRow.getIndex(), variableArray);
        changeSet.lastChangedColumn = n;
        hashMap.put(mOTableRow.getIndex(), changeSet);
        return changeSet;
    }

    protected ChangeSet getPendingChangeSet(SubRequest subRequest, OID oID) {
        Map map;
        if (this.pendingChanges != null && (map = (Map)this.pendingChanges.get(subRequest.getRequest())) != null) {
            return (ChangeSet)map.get(oID);
        }
        return null;
    }

    @Override
    public void cleanup(SubRequest subRequest) {
        MOMutableTableRow mOMutableTableRow;
        OID oID = subRequest.getVariableBinding().getOid();
        MOTableCellInfo mOTableCellInfo = this.getCellInfo(oID);
        if (mOTableCellInfo.getIndex() == null) {
            return;
        }
        MOColumn mOColumn = this.getColumn(mOTableCellInfo.getColumn());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cleaning-up sub-request (" + subRequest.getVariableBinding() + ") for column: " + mOColumn));
        }
        if ((mOMutableTableRow = (MOMutableTableRow)this.model.getRow(mOTableCellInfo.getIndex())) != null && mOColumn instanceof MOMutableColumn) {
            ((MOMutableColumn)mOColumn).cleanup(subRequest, mOMutableTableRow, mOTableCellInfo.getColumn());
        }
        if (mOMutableTableRow instanceof MOMutableRow2PC && this.isChangeSetComplete(subRequest, mOMutableTableRow.getIndex(), mOTableCellInfo.getColumn())) {
            ((MOMutableRow2PC)mOMutableTableRow).cleanupRow(subRequest, this.getPendingChangeSet(subRequest, mOMutableTableRow.getIndex()));
        }
        subRequest.completed();
    }

    @Override
    public void undo(SubRequest subRequest) {
        OID oID = subRequest.getVariableBinding().getOid();
        MOTableCellInfo mOTableCellInfo = this.getCellInfo(oID);
        MOMutableColumn mOMutableColumn = (MOMutableColumn)this.getColumn(mOTableCellInfo.getColumn());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Undoing sub-request (" + subRequest.getVariableBinding() + ") for column: " + mOMutableColumn));
        }
        if (this.hasNewRows(subRequest.getRequest())) {
            ((MOMutableTableModel)this.model).removeRow(mOTableCellInfo.getIndex());
        } else {
            MOMutableTableRow mOMutableTableRow = (MOMutableTableRow)this.model.getRow(mOTableCellInfo.getIndex());
            if (mOMutableTableRow != null) {
                mOMutableColumn.undo(subRequest, mOMutableTableRow, mOTableCellInfo.getColumn());
            }
            if (mOMutableTableRow instanceof MOMutableRow2PC && this.isChangeSetComplete(subRequest, mOMutableTableRow.getIndex(), mOTableCellInfo.getColumn())) {
                ((MOMutableRow2PC)mOMutableTableRow).undoRow(subRequest, this.getPendingChangeSet(subRequest, mOMutableTableRow.getIndex()));
            }
        }
    }

    @Override
    public OID getOID() {
        return this.oid;
    }

    public void setModel(MOTableModel mOTableModel) {
        this.model = mOTableModel;
    }

    public void setVolatile(boolean bl) {
        this.isVolatile = bl;
    }

    @Override
    public MOTableModel getModel() {
        return this.model;
    }

    @Override
    public MOColumn[] getColumns() {
        return this.columns;
    }

    @Override
    public MOTableIndex getIndexDef() {
        return this.indexDef;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public OID getLowerBound() {
        return this.oid;
    }

    @Override
    public OID getUpperBound() {
        OID oID = new OID(this.oid);
        int n = this.oid.size() - 1;
        oID.set(n, this.oid.get(n) + 1);
        return oID;
    }

    @Override
    public boolean isLowerIncluded() {
        return false;
    }

    @Override
    public boolean isUpperIncluded() {
        return false;
    }

    @Override
    public boolean isCovered(MOScope mOScope) {
        return DefaultMOScope.covers(this, mOScope);
    }

    @Override
    public boolean isOverlapping(MOScope mOScope) {
        return DefaultMOScope.overlaps(this, mOScope);
    }

    @Override
    public synchronized void addMOChangeListener(MOChangeListener mOChangeListener) {
        if (this.moChangeListeners == null) {
            this.moChangeListeners = new Vector(2);
        }
        this.moChangeListeners.add(mOChangeListener);
    }

    @Override
    public synchronized void removeMOChangeListener(MOChangeListener mOChangeListener) {
        if (this.moChangeListeners != null) {
            this.moChangeListeners.remove(mOChangeListener);
        }
    }

    protected void fireBeforePrepareMOChange(MOChangeEvent mOChangeEvent) {
        if (this.moChangeListeners != null) {
            Vector vector = this.moChangeListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((MOChangeListener)vector.elementAt(i)).beforePrepareMOChange(mOChangeEvent);
            }
        }
    }

    protected void fireAfterPrepareMOChange(MOChangeEvent mOChangeEvent) {
        if (this.moChangeListeners != null) {
            Vector vector = this.moChangeListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((MOChangeListener)vector.elementAt(i)).afterPrepareMOChange(mOChangeEvent);
            }
        }
    }

    protected void fireBeforeMOChange(MOChangeEvent mOChangeEvent) {
        if (this.moChangeListeners != null) {
            Vector vector = this.moChangeListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((MOChangeListener)vector.elementAt(i)).beforeMOChange(mOChangeEvent);
            }
        }
    }

    protected void fireAfterMOChange(MOChangeEvent mOChangeEvent) {
        if (this.moChangeListeners != null) {
            Vector vector = this.moChangeListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((MOChangeListener)vector.elementAt(i)).afterMOChange(mOChangeEvent);
            }
        }
    }

    @Override
    public synchronized void addMOTableRowListener(MOTableRowListener mOTableRowListener) {
        if (this.moTableRowListeners == null) {
            this.moTableRowListeners = new Vector(2);
        }
        this.moTableRowListeners.add(mOTableRowListener);
    }

    @Override
    public synchronized void removeMOTableRowListener(MOTableRowListener mOTableRowListener) {
        if (this.moTableRowListeners != null) {
            this.moTableRowListeners.remove(mOTableRowListener);
        }
    }

    protected void fireRowChanged(MOTableRowEvent mOTableRowEvent) {
        if (this.moTableRowListeners != null) {
            Vector vector = this.moTableRowListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((MOTableRowListener)vector.elementAt(i)).rowChanged(mOTableRowEvent);
            }
        }
    }

    @Override
    public OID getID() {
        return this.getLowerBound();
    }

    @Override
    public void load(MOInput mOInput) throws IOException {
        if (mOInput.getImportMode() == 1) {
            int n = this.removeAll();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removed " + n + " rows from " + this.getID() + " because importing with a REPLACE import mode"));
            }
        }
        Sequence sequence = mOInput.readSequence();
        for (int i = 0; i < sequence.getSize(); ++i) {
            IndexedVariables indexedVariables = mOInput.readIndexedVariables();
            boolean bl = this.model.containsRow(indexedVariables.getIndex());
            if (mOInput.getImportMode() == 4 && bl) {
                logger.debug((Object)("Row '" + indexedVariables.getIndex() + "' not imported because it already exists in table " + this.getID() + " and import mode is CREATE"));
                continue;
            }
            if (bl) {
                this.removeRow(indexedVariables.getIndex());
            }
            if (!bl && mOInput.getImportMode() != 4 && mOInput.getImportMode() != 1 && mOInput.getImportMode() != 2) continue;
            MOTableRow mOTableRow = null;
            try {
                mOTableRow = this.createRow(indexedVariables.getIndex(), indexedVariables.getValues());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                logger.debug((Object)("Could not create row by row factory: " + unsupportedOperationException.getMessage()));
            }
            if (mOTableRow == null) {
                mOTableRow = new DefaultMOTableRow(indexedVariables.getIndex(), indexedVariables.getValues());
                this.fireRowChanged(new MOTableRowEvent(this, this, mOTableRow, 1));
            }
            this.addRow(mOTableRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(MOOutput mOOutput) throws IOException {
        LinkedList<IndexedVariables> linkedList = new LinkedList<IndexedVariables>();
        Object object = this.model;
        synchronized (object) {
            Iterator iterator = this.model.iterator();
            while (iterator.hasNext()) {
                MOTableRow object2 = (MOTableRow)iterator.next();
                boolean bl = false;
                for (int i = 0; i < this.columns.length; ++i) {
                    if (!this.columns[i].isVolatile(object2, i)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                Variable[] variableArray = new Variable[this.columns.length];
                for (int i = 0; i < this.columns.length; ++i) {
                    variableArray[i] = object2.getValue(i);
                }
                IndexedVariables indexedVariables = new IndexedVariables(object2.getIndex(), variableArray);
                linkedList.add(indexedVariables);
            }
        }
        object = new Sequence(linkedList.size());
        mOOutput.writeSequence((Sequence)object);
        for (IndexedVariables indexedVariables : linkedList) {
            mOOutput.writeIndexedVariables(indexedVariables);
        }
    }

    @Override
    public Variable[] getDefaultValues() {
        Variable[] variableArray = new Variable[this.getColumnCount()];
        for (int i = 0; i < variableArray.length; ++i) {
            if (!(this.columns[i] instanceof MOMutableColumn)) continue;
            variableArray[i] = ((MOMutableColumn)this.columns[i]).getDefaultValue();
        }
        return variableArray;
    }

    public String toString() {
        return "DefaultMOTable[id=" + this.getID() + ",index=" + this.getIndexDef() + ",columns=" + Arrays.asList(this.getColumns()) + "]";
    }

    @Override
    public boolean covers(OID oID) {
        return this.isCovered(new DefaultMOScope(oID, true, oID, true));
    }

    class CellInfo
    implements MOTableCellInfo {
        private OID index;
        private int id = 0;
        private int col = -1;

        public CellInfo(OID oID) {
            this.index = DefaultMOTable.this.getIndexPart(oID);
            if (oID.size() > DefaultMOTable.this.oid.size() && oID.startsWith(DefaultMOTable.this.oid)) {
                this.id = oID.get(DefaultMOTable.this.oid.size());
            }
        }

        public CellInfo(OID oID, int n, int n2) {
            this.index = oID;
            this.col = n;
            this.id = n2;
        }

        @Override
        public OID getIndex() {
            return this.index;
        }

        @Override
        public int getColumn() {
            if (this.col < 0) {
                this.col = DefaultMOTable.this.getColumnIndex(this.id);
            }
            return this.col;
        }

        @Override
        public int getColumnID() {
            return this.id;
        }

        @Override
        public OID getCellOID() {
            return DefaultMOTable.this.getCellOID(this.index, this.col);
        }
    }

    class CellProxy
    implements ManagedObject {
        private MOTableCellInfo cellInfo;
        private MOScope scope;

        public CellProxy(MOTableCellInfo mOTableCellInfo) {
            this.cellInfo = mOTableCellInfo;
            this.scope = new OIDScope(mOTableCellInfo.getCellOID());
        }

        @Override
        public MOScope getScope() {
            return this.scope;
        }

        @Override
        public OID find(MOScope mOScope) {
            if (mOScope.isCovered(this.scope)) {
                return this.cellInfo.getCellOID();
            }
            return null;
        }

        @Override
        public void get(SubRequest subRequest) {
            DefaultMOTable.this.get(subRequest);
        }

        @Override
        public boolean next(SubRequest subRequest) {
            return DefaultMOTable.this.next(subRequest);
        }

        @Override
        public void prepare(SubRequest subRequest) {
            DefaultMOTable.this.prepare(subRequest);
        }

        @Override
        public void commit(SubRequest subRequest) {
            DefaultMOTable.this.commit(subRequest);
        }

        @Override
        public void undo(SubRequest subRequest) {
            DefaultMOTable.this.undo(subRequest);
        }

        @Override
        public void cleanup(SubRequest subRequest) {
            DefaultMOTable.this.cleanup(subRequest);
        }

        public MOTable getTable() {
            return DefaultMOTable.this;
        }
    }

    public class ChangeSet
    implements MOTableRow {
        private OID index;
        private Variable[] values;
        private int lastChangedColumn = -1;

        public ChangeSet(OID oID, Variable[] variableArray) {
            this.index = oID;
            this.values = variableArray;
        }

        @Override
        public OID getIndex() {
            return this.index;
        }

        public int getLastChangedColumn() {
            return this.lastChangedColumn;
        }

        public void setValue(int n, Variable variable) {
            this.values[n] = variable;
            this.lastChangedColumn = n;
        }

        @Override
        public Variable getValue(int n) {
            return this.values[n];
        }

        @Override
        public MOTableRow getBaseRow() {
            return null;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        public void setBaseRow(MOTableRow mOTableRow) {
            throw new UnsupportedOperationException();
        }
    }
}

