/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mscapi;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.ProviderException;
import java.util.HashMap;
import java.util.Map;
import sun.security.action.PutAllAction;
import sun.security.mscapi.JarVerifierImpl;

public final class SunMSCAPI
extends Provider {
    private static final long serialVersionUID = 8622598936488630849L;
    private static final String INFO = "Sun's Microsoft Crypto API provider";
    private static volatile boolean integrityVerified;

    public SunMSCAPI() {
        super("SunMSCAPI", 1.6, INFO);
        Map<Object, Object> map = System.getSecurityManager() == null ? this : new HashMap();
        map.put("SecureRandom.PRNG", "sun.security.mscapi.PRNG");
        map.put("KeyStore.Windows-MY", "sun.security.mscapi.KeyStore$MY");
        map.put("KeyStore.Windows-ROOT", "sun.security.mscapi.KeyStore$ROOT");
        map.put("Signature.SHA1withRSA", "sun.security.mscapi.RSASignature$SHA1");
        map.put("Signature.MD5withRSA", "sun.security.mscapi.RSASignature$MD5");
        map.put("Signature.MD2withRSA", "sun.security.mscapi.RSASignature$MD2");
        map.put("Signature.SHA1withRSA SupportedKeyClasses", "sun.security.mscapi.Key");
        map.put("Signature.MD5withRSA SupportedKeyClasses", "sun.security.mscapi.Key");
        map.put("Signature.MD2withRSA SupportedKeyClasses", "sun.security.mscapi.Key");
        map.put("Signature.NONEwithRSA SupportedKeyClasses", "sun.security.mscapi.Key");
        map.put("KeyPairGenerator.RSA", "sun.security.mscapi.RSAKeyPairGenerator");
        map.put("KeyPairGenerator.RSA KeySize", "1024");
        map.put("Cipher.RSA", "sun.security.mscapi.RSACipher");
        map.put("Cipher.RSA/ECB/PKCS1Padding", "sun.security.mscapi.RSACipher");
        map.put("Cipher.RSA SupportedModes", "ECB");
        map.put("Cipher.RSA SupportedPaddings", "PKCS1PADDING");
        map.put("Cipher.RSA SupportedKeyClasses", "sun.security.mscapi.Key");
        if (map != this) {
            AccessController.doPrivileged(new PutAllAction(this, map));
        }
    }

    static void verifySelfIntegrity(Class clazz) {
        if (integrityVerified) {
            return;
        }
        SunMSCAPI.doVerifySelfIntegrity(clazz);
    }

    private static synchronized void doVerifySelfIntegrity(Class clazz) {
        integrityVerified = JarVerifierImpl.doVerification(clazz, "-----BEGIN CERTIFICATE-----\nMIICnTCCAlugAwIBAgICAh8wCwYHKoZIzjgEAwUAMIGQMQswCQYDVQQGEwJVUzELMAkGA1UECBMCQ0ExEjAQBgNVBAcTCVBhbG8gQWx0bzEdMBsGA1UEChMUU3VuIE1pY3Jvc3lzdGVtcyBJbmMxIzAhBgNVBAsTGkphdmEgU29mdHdhcmUgQ29kZSBTaWduaW5nMRwwGgYDVQQDExNKQ0UgQ29kZSBTaWduaW5nIENBMB4XDTA1MTEyMzIyNDk0MVoXDTEwMTEyNzIyNDk0MVowYzEdMBsGA1UEChMUU3VuIE1pY3Jvc3lzdGVtcyBJbmMxIzAhBgNVBAsTGkphdmEgU29mdHdhcmUgQ29kZSBTaWduaW5nMR0wGwYDVQQDExRTdW4gTWljcm9zeXN0ZW1zIEluYzCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA16bKo6tC3OHFDNfPXLKXMCMtIyeubNnsEtlvrH34HhfF+ZmpSliLCvQ15ms705vy4XgZUbZ3mgSOlLRMAGRo6596ePhc+0Z6yeKhbb3LZ8iz97ZIptkHGOshj9cfcSRPYmorUug9OsybMdIfQXazxT9mZJ9Yx5IDw6xak7kVbpUCAwEAAaOBiDCBhTARBglghkgBhvhCAQEEBAMCBBAwDgYDVR0PAQH/BAQDAgXgMB0GA1UdDgQWBBRI319jCbhc9DWJVltXgfrMybHNjzAfBgNVHSMEGDAWgBRl4vSGydNO8JFOWKJq9dh4WprBpjAgBgNVHREEGTAXgRV5dS1jaGluZy5wZW5nQHN1bi5jb20wCwYHKoZIzjgEAwUAAy8AMCwCFFBFmED9s3OoN9rbXfQV3+brJPW/AhQr+Wq1MlubAvnfjrlqeksh0QaDAQ==\n-----END CERTIFICATE-----");
        if (!integrityVerified) {
            throw new ProviderException("The SunMSCAPI provider may have been tampered with.");
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("sunmscapi");
                return null;
            }
        });
    }
}

