/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mscapi;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.UUID;
import sun.security.mscapi.RSAKeyPair;

public final class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final int KEY_SIZE_MIN = 512;
    private static final int KEY_SIZE_MAX = 16384;
    private static final int KEY_SIZE_DEFAULT = 1024;
    private int keySize;

    public RSAKeyPairGenerator() {
        this.initialize(1024, null);
    }

    public void initialize(int n, SecureRandom secureRandom) {
        this.checkKeySize(n);
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            this.checkKeySize(1024);
        } else if (algorithmParameterSpec instanceof RSAKeyGenParameterSpec) {
            if (((RSAKeyGenParameterSpec)algorithmParameterSpec).getPublicExponent() != null) {
                throw new InvalidAlgorithmParameterException("Exponent parameter is not supported");
            }
            this.checkKeySize(((RSAKeyGenParameterSpec)algorithmParameterSpec).getKeysize());
        } else {
            throw new InvalidAlgorithmParameterException("Params must be an instance of RSAKeyGenParameterSpec");
        }
    }

    public KeyPair generateKeyPair() {
        RSAKeyPair rSAKeyPair = RSAKeyPairGenerator.generateRSAKeyPair(this.keySize, "{" + UUID.randomUUID().toString() + "}");
        return new KeyPair(rSAKeyPair.getPublic(), rSAKeyPair.getPrivate());
    }

    private void checkKeySize(int n) throws InvalidParameterException {
        if (n < 512) {
            throw new InvalidParameterException("Key size must be at least 512 bits");
        }
        if (n > 16384) {
            throw new InvalidParameterException("Key size must be 16384 bits or less");
        }
        this.keySize = n;
    }

    private static native RSAKeyPair generateRSAKeyPair(int var0, String var1);
}

