/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.util.EventObject;
import org.snmp4j.PDU;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public class TableEvent
extends EventObject {
    public static final int STATUS_OK = 0;
    public static final int STATUS_TIMEOUT = -1;
    public static final int STATUS_WRONG_ORDER = -2;
    public static final int STATUS_REPORT = -3;
    public static final int STATUS_EXCEPTION = -4;
    private OID index;
    private VariableBinding[] columns;
    private int status = 0;
    private Object userObject;
    private Exception exception;
    private PDU reportPDU;

    protected TableEvent(Object source, Object userObject) {
        super(source);
        this.userObject = userObject;
    }

    public TableEvent(Object source, Object userObject, int status) {
        this(source, userObject);
        this.status = status;
    }

    public TableEvent(Object source, Object userObject, Exception exception) {
        this(source, userObject);
        this.exception = exception;
        this.status = -4;
    }

    public TableEvent(Object source, Object userObject, PDU report) {
        this(source, userObject);
        this.reportPDU = report;
        this.status = -3;
    }

    public TableEvent(Object source, Object userObject, OID index, VariableBinding[] cols) {
        this(source, userObject);
        this.index = index;
        this.columns = cols;
    }

    public OID getIndex() {
        return this.index;
    }

    public VariableBinding[] getColumns() {
        return this.columns;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isError() {
        return this.status != 0;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public Exception getException() {
        return this.exception;
    }

    public PDU getReportPDU() {
        return this.reportPDU;
    }
}

