/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.tools.console;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.CommunityTarget;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.asn1.BER;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.log.JavaLogFactory;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogLevel;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.DefaultCounterListener;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.AbstractTransportMapping;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.MultiThreadedMessageDispatcher;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableListener;
import org.snmp4j.util.TableUtils;
import org.snmp4j.util.ThreadPool;

public class SnmpRequest
implements CommandResponder,
PDUFactory {
    public static final int DEFAULT = 0;
    public static final int WALK = 1;
    public static final int LISTEN = 2;
    public static final int TABLE = 3;
    public static final int CVS_TABLE = 4;
    public static final int TIME_BASED_CVS_TABLE = 5;
    Target target;
    Address address;
    OID authProtocol;
    OID privProtocol;
    OctetString privPassphrase;
    OctetString authPassphrase;
    OctetString community = new OctetString("public");
    OctetString authoritativeEngineID;
    OctetString contextEngineID;
    OctetString contextName = new OctetString();
    OctetString securityName = new OctetString();
    TimeTicks sysUpTime = new TimeTicks(0L);
    OID trapOID = SnmpConstants.coldStart;
    PDUv1 v1TrapPDU = new PDUv1();
    int version = 3;
    int retries = 1;
    int timeout = 1000;
    int pduType = -95;
    int maxRepetitions = 10;
    int nonRepeaters = 0;
    Vector vbs = new Vector();
    protected int operation = 0;
    int numDispatcherThreads = 2;
    boolean useDenseTableOperation = false;
    OID lowerBoundIndex;
    OID upperBoundIndex;
    static /* synthetic */ Class class$org$snmp4j$tools$console$SnmpRequest;

    public SnmpRequest(String[] args) {
        CounterSupport.getInstance().addCounterListener(new DefaultCounterListener());
        this.vbs.add(new VariableBinding(new OID("1.3.6")));
        int paramStart = this.parseArgs(args);
        if (paramStart >= args.length) {
            SnmpRequest.printUsage();
            System.exit(1);
        } else {
            this.checkOptions();
            this.address = SnmpRequest.getAddress(args[paramStart++]);
            Vector vbs = SnmpRequest.getVariableBindings(args, paramStart);
            this.checkTrapVariables(vbs);
            if (vbs.size() > 0) {
                this.vbs = vbs;
            }
        }
    }

    public int getPduType() {
        return this.pduType;
    }

    public int getVersion() {
        return this.version;
    }

    public Vector getVbs() {
        return this.vbs;
    }

    public boolean isUseDenseTableOperation() {
        return this.useDenseTableOperation;
    }

    public OID getUpperBoundIndex() {
        return this.upperBoundIndex;
    }

    public OID getTrapOID() {
        return this.trapOID;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public Target getTarget() {
        return this.target;
    }

    public TimeTicks getSysUpTime() {
        return this.sysUpTime;
    }

    public OctetString getSecurityName() {
        return this.securityName;
    }

    public int getRetries() {
        return this.retries;
    }

    public OID getPrivProtocol() {
        return this.privProtocol;
    }

    public OctetString getPrivPassphrase() {
        return this.privPassphrase;
    }

    public int getOperation() {
        return this.operation;
    }

    public int getNumDispatcherThreads() {
        return this.numDispatcherThreads;
    }

    public int getNonRepeaters() {
        return this.nonRepeaters;
    }

    public int getMaxRepetitions() {
        return this.maxRepetitions;
    }

    public OID getLowerBoundIndex() {
        return this.lowerBoundIndex;
    }

    public OctetString getContextName() {
        return this.contextName;
    }

    public OctetString getContextEngineID() {
        return this.contextEngineID;
    }

    public OctetString getCommunity() {
        return this.community;
    }

    public OctetString getAuthoritativeEngineID() {
        return this.authoritativeEngineID;
    }

    public OID getAuthProtocol() {
        return this.authProtocol;
    }

    public OctetString getAuthPassphrase() {
        return this.authPassphrase;
    }

    public Address getAddress() {
        return this.address;
    }

    private void checkOptions() {
        if (this.operation == 1 && this.pduType != -91 && this.pduType != -95) {
            throw new IllegalArgumentException("Walk operation is not supported for PDU type: " + PDU.getTypeString(this.pduType));
        }
        if (this.operation == 1 && this.vbs.size() != 1) {
            throw new IllegalArgumentException("There must be exactly one OID supplied for walk operations");
        }
        if (this.pduType == -92 && this.version != 0) {
            throw new IllegalArgumentException("V1TRAP PDU type is only available for SNMP version 1");
        }
    }

    private void checkTrapVariables(Vector vbs) {
        if (this.pduType == -90 || this.pduType == -89) {
            if (vbs.size() == 0 || vbs.size() > 1 && !((VariableBinding)vbs.get(0)).getOid().equals(SnmpConstants.sysUpTime)) {
                vbs.add(0, new VariableBinding(SnmpConstants.sysUpTime, this.sysUpTime));
            }
            if (vbs.size() == 1 || vbs.size() > 2 && !((VariableBinding)vbs.get(1)).getOid().equals(SnmpConstants.snmpTrapOID)) {
                vbs.add(1, new VariableBinding(SnmpConstants.snmpTrapOID, this.trapOID));
            }
        }
    }

    public synchronized void listen() throws IOException {
        AbstractTransportMapping transport = this.address instanceof TcpAddress ? new DefaultTcpTransportMapping((TcpAddress)this.address) : new DefaultUdpTransportMapping((UdpAddress)this.address);
        ThreadPool threadPool = ThreadPool.create("DispatcherPool", this.numDispatcherThreads);
        MultiThreadedMessageDispatcher mtDispatcher = new MultiThreadedMessageDispatcher(threadPool, new MessageDispatcherImpl());
        mtDispatcher.addMessageProcessingModel(new MPv1());
        mtDispatcher.addMessageProcessingModel(new MPv2c());
        mtDispatcher.addMessageProcessingModel(new MPv3());
        SecurityProtocols.getInstance().addDefaultProtocols();
        Snmp snmp = new Snmp(mtDispatcher, transport);
        if (this.version == 3) {
            USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
            SecurityModels.getInstance().addSecurityModel(usm);
            if (this.authoritativeEngineID != null) {
                snmp.setLocalEngine(this.authoritativeEngineID.getValue(), 0, 0);
            }
            this.addUsmUser(snmp);
        } else {
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(this.community);
            this.target = target;
        }
        snmp.addCommandResponder(this);
        transport.listen();
        System.out.println("Listening on " + this.address);
        try {
            this.wait();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    private void addUsmUser(Snmp snmp) {
        snmp.getUSM().addUser(this.securityName, new UsmUser(this.securityName, this.authProtocol, this.authPassphrase, this.privProtocol, this.privPassphrase));
    }

    private Snmp createSnmpSession() throws IOException {
        AbstractTransportMapping transport = this.address instanceof TcpAddress ? new DefaultTcpTransportMapping() : new DefaultUdpTransportMapping();
        Snmp snmp = new Snmp(transport);
        if (this.version == 3) {
            USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
            SecurityModels.getInstance().addSecurityModel(usm);
            this.addUsmUser(snmp);
        }
        return snmp;
    }

    private Target createTarget() {
        if (this.version == 3) {
            UserTarget target = new UserTarget();
            if (this.authPassphrase != null) {
                if (this.privPassphrase != null) {
                    target.setSecurityLevel(3);
                } else {
                    target.setSecurityLevel(2);
                }
            } else {
                target.setSecurityLevel(1);
            }
            target.setSecurityName(this.securityName);
            return target;
        }
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(this.community);
        return target;
    }

    public PDU send() throws IOException {
        Snmp snmp = this.createSnmpSession();
        this.target = this.createTarget();
        this.target.setVersion(this.version);
        this.target.setAddress(this.address);
        this.target.setRetries(this.retries);
        this.target.setTimeout(this.timeout);
        snmp.listen();
        PDU request = this.createPDU(this.target);
        if (request.getType() == -91) {
            request.setMaxRepetitions(this.maxRepetitions);
            request.setNonRepeaters(this.nonRepeaters);
        }
        for (int i = 0; i < this.vbs.size(); ++i) {
            request.add((VariableBinding)this.vbs.get(i));
        }
        PDU response = null;
        if (this.operation == 1) {
            response = SnmpRequest.walk(snmp, request, this.target);
        } else {
            long startTime = System.currentTimeMillis();
            ResponseEvent responseEvent = snmp.send(request, this.target);
            if (responseEvent != null) {
                response = responseEvent.getResponse();
                System.out.println("Received response after " + (System.currentTimeMillis() - startTime) + " millis");
            }
        }
        snmp.close();
        return response;
    }

    private static PDU walk(Snmp snmp, PDU request, Target target) throws IOException {
        request.setNonRepeaters(0);
        OID rootOID = request.get(0).getOid();
        PDU response = null;
        int objects = 0;
        int requests = 0;
        long startTime = System.currentTimeMillis();
        do {
            ++requests;
            ResponseEvent responseEvent = snmp.send(request, target);
            response = responseEvent.getResponse();
            if (response == null) continue;
            objects += response.size();
        } while (!SnmpRequest.processWalk(response, request, rootOID));
        System.out.println();
        System.out.println("Total requests sent:    " + requests);
        System.out.println("Total objects received: " + objects);
        System.out.println("Total walk time:        " + (System.currentTimeMillis() - startTime) + " milliseconds");
        return response;
    }

    private static boolean processWalk(PDU response, PDU request, OID rootOID) {
        if (response == null || response.getErrorStatus() != 0 || response.getType() == -88) {
            return true;
        }
        boolean finished = false;
        OID lastOID = request.get(0).getOid();
        for (int i = 0; !finished && i < response.size(); ++i) {
            VariableBinding vb = response.get(i);
            if (vb.getOid() == null || vb.getOid().size() < rootOID.size() || rootOID.leftMostCompare(rootOID.size(), vb.getOid()) != 0) {
                finished = true;
                continue;
            }
            if (Null.isExceptionSyntax(vb.getVariable().getSyntax())) {
                System.out.println(vb.toString());
                finished = true;
                continue;
            }
            if (vb.getOid().compareTo(lastOID) <= 0) {
                System.out.println("Variable received is not lexicographic successor of requested one:");
                System.out.println(vb.toString() + " <= " + lastOID);
                finished = true;
                continue;
            }
            System.out.println(vb.toString());
            lastOID = vb.getOid();
        }
        if (response.size() == 0) {
            finished = true;
        }
        if (!finished) {
            VariableBinding next = response.get(response.size() - 1);
            next.setVariable(new Null());
            request.set(0, next);
            request.setRequestID(new Integer32(0));
        }
        return finished;
    }

    /*
     * WARNING - void declaration
     */
    private static Vector getVariableBindings(String[] args, int position) {
        Vector<VariableBinding> v = new Vector<VariableBinding>(args.length - position + 1);
        for (int i = position; i < args.length; ++i) {
            String oid = args[i];
            char type = 'i';
            String value = null;
            int equal = oid.indexOf("={");
            if (equal > 0) {
                oid = args[i].substring(0, equal);
                type = args[i].charAt(equal + 2);
                value = args[i].substring(args[i].indexOf(125) + 1);
            } else if (oid.indexOf(45) > 0) {
                StringTokenizer st = new StringTokenizer(oid, "-");
                if (st.countTokens() != 2) {
                    throw new IllegalArgumentException("Illegal OID range specified: '" + oid);
                }
                oid = st.nextToken();
                VariableBinding vbLower = new VariableBinding(new OID(oid));
                v.add(vbLower);
                long last = Long.parseLong(st.nextToken());
                long first = vbLower.getOid().lastUnsigned();
                for (long k = first + 1L; k <= last; ++k) {
                    OID nextOID = new OID(vbLower.getOid().getValue(), 0, vbLower.getOid().size() - 1);
                    nextOID.appendUnsigned(k);
                    VariableBinding next = new VariableBinding(nextOID);
                    v.add(next);
                }
                continue;
            }
            VariableBinding vb = new VariableBinding(new OID(oid));
            if (value != null) {
                void var9_9;
                switch (type) {
                    case 'i': {
                        Variable variable = new Integer32(Integer.parseInt(value));
                        break;
                    }
                    case 'u': {
                        Variable variable = new UnsignedInteger32(Long.parseLong(value));
                        break;
                    }
                    case 's': {
                        Variable variable = new OctetString(value);
                        break;
                    }
                    case 'x': {
                        Variable variable = OctetString.fromString(value, ':', 16);
                        break;
                    }
                    case 'd': {
                        Variable variable = OctetString.fromString(value, '.', 10);
                        break;
                    }
                    case 'b': {
                        Variable variable = OctetString.fromString(value, ' ', 2);
                        break;
                    }
                    case 'n': {
                        Variable variable = new Null();
                        break;
                    }
                    case 'o': {
                        Variable variable = new OID(value);
                        break;
                    }
                    case 't': {
                        Variable variable = new TimeTicks(Long.parseLong(value));
                        break;
                    }
                    case 'a': {
                        Variable variable = new IpAddress(value);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Variable type " + type + " not supported");
                    }
                }
                vb.setVariable((Variable)var9_9);
            }
            v.add(vb);
        }
        return v;
    }

    private static Address getAddress(String transportAddress) {
        String transport = "udp";
        int colon = transportAddress.indexOf(58);
        if (colon > 0) {
            transport = transportAddress.substring(0, colon);
            transportAddress = transportAddress.substring(colon + 1);
        }
        if (transportAddress.indexOf(47) < 0) {
            transportAddress = transportAddress + "/161";
        }
        if (transport.equalsIgnoreCase("udp")) {
            return new UdpAddress(transportAddress);
        }
        if (transport.equalsIgnoreCase("tcp")) {
            return new TcpAddress(transportAddress);
        }
        throw new IllegalArgumentException("Unknown transport " + transport);
    }

    private static String nextOption(String[] args, int position) {
        if (position + 1 >= args.length) {
            throw new IllegalArgumentException("Missing option value for " + args[position]);
        }
        return args[position + 1];
    }

    private static OctetString createOctetString(String s) {
        OctetString octetString = s.startsWith("0x") ? OctetString.fromHexString(s.substring(2), ':') : new OctetString(s);
        return octetString;
    }

    private int parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String s;
            if (args[i].equals("-a")) {
                if ((s = SnmpRequest.nextOption(args, i++)).equals("MD5")) {
                    this.authProtocol = AuthMD5.ID;
                    continue;
                }
                if (s.equals("SHA")) {
                    this.authProtocol = AuthSHA.ID;
                    continue;
                }
                throw new IllegalArgumentException("Authentication protocol unsupported: " + s);
            }
            if (args[i].equals("-A")) {
                this.authPassphrase = SnmpRequest.createOctetString(SnmpRequest.nextOption(args, i++));
                continue;
            }
            if (args[i].equals("-X") || args[i].equals("-P")) {
                this.privPassphrase = SnmpRequest.createOctetString(SnmpRequest.nextOption(args, i++));
                continue;
            }
            if (args[i].equals("-c")) {
                this.community = SnmpRequest.createOctetString(SnmpRequest.nextOption(args, i++));
                continue;
            }
            if (args[i].equals("-d")) {
                String debugOption = SnmpRequest.nextOption(args, i++);
                LogFactory.getLogFactory().getRootLogger().setLogLevel(LogLevel.toLevel(debugOption));
                continue;
            }
            if (args[i].equals("-e")) {
                this.authoritativeEngineID = SnmpRequest.createOctetString(SnmpRequest.nextOption(args, i++));
                continue;
            }
            if (args[i].equals("-E")) {
                this.contextEngineID = SnmpRequest.createOctetString(SnmpRequest.nextOption(args, i++));
                continue;
            }
            if (args[i].equals("-h")) {
                SnmpRequest.printUsage();
                System.exit(0);
                continue;
            }
            if (args[i].equals("-n")) {
                this.contextName = SnmpRequest.createOctetString(SnmpRequest.nextOption(args, i++));
                continue;
            }
            if (args[i].equals("-r")) {
                this.retries = Integer.parseInt(SnmpRequest.nextOption(args, i++));
                continue;
            }
            if (args[i].equals("-t")) {
                this.timeout = Integer.parseInt(SnmpRequest.nextOption(args, i++));
                continue;
            }
            if (args[i].equals("-u")) {
                this.securityName = SnmpRequest.createOctetString(SnmpRequest.nextOption(args, i++));
                continue;
            }
            if (args[i].equals("-V")) {
                SnmpRequest.printVersion();
                System.exit(0);
                continue;
            }
            if (args[i].equals("-Cr")) {
                this.maxRepetitions = Integer.parseInt(SnmpRequest.nextOption(args, i++));
                continue;
            }
            if (args[i].equals("-Cn")) {
                this.nonRepeaters = Integer.parseInt(SnmpRequest.nextOption(args, i++));
                continue;
            }
            if (args[i].equals("-Ce")) {
                this.v1TrapPDU.setEnterprise(new OID(SnmpRequest.nextOption(args, i++)));
                continue;
            }
            if (args[i].equals("-Ct")) {
                this.trapOID = new OID(SnmpRequest.nextOption(args, i++));
                continue;
            }
            if (args[i].equals("-Cg")) {
                this.v1TrapPDU.setGenericTrap(Integer.parseInt(SnmpRequest.nextOption(args, i++)));
                continue;
            }
            if (args[i].equals("-Cs")) {
                this.v1TrapPDU.setSpecificTrap(Integer.parseInt(SnmpRequest.nextOption(args, i++)));
                continue;
            }
            if (args[i].equals("-Ca")) {
                this.v1TrapPDU.setAgentAddress(new IpAddress(SnmpRequest.nextOption(args, i++)));
                continue;
            }
            if (args[i].equals("-Cu")) {
                String upTime = SnmpRequest.nextOption(args, i++);
                this.v1TrapPDU.setTimestamp(Long.parseLong(upTime));
                this.sysUpTime.setValue(Long.parseLong(upTime));
                continue;
            }
            if (args[i].equals("-Ow")) {
                this.operation = 1;
                continue;
            }
            if (args[i].equals("-Ol")) {
                this.operation = 2;
                continue;
            }
            if (args[i].equals("-OtCSV")) {
                this.operation = 4;
                continue;
            }
            if (args[i].equals("-OttCSV")) {
                this.operation = 5;
                continue;
            }
            if (args[i].equals("-Ot")) {
                this.operation = 3;
                continue;
            }
            if (args[i].equals("-Otd")) {
                this.operation = 3;
                this.useDenseTableOperation = true;
                continue;
            }
            if (args[i].equals("-Cil")) {
                this.lowerBoundIndex = new OID(SnmpRequest.nextOption(args, i++));
                continue;
            }
            if (args[i].equals("-Ciu")) {
                this.upperBoundIndex = new OID(SnmpRequest.nextOption(args, i++));
                continue;
            }
            if (args[i].equals("-v")) {
                String v;
                if ((v = SnmpRequest.nextOption(args, i++)).equals("1")) {
                    this.version = 0;
                    continue;
                }
                if (v.equals("2c")) {
                    this.version = 1;
                    continue;
                }
                if (v.equals("3")) {
                    this.version = 3;
                    continue;
                }
                throw new IllegalArgumentException("Version " + v + " not supported");
            }
            if (args[i].equals("-x")) {
                if ((s = SnmpRequest.nextOption(args, i++)).equals("DES")) {
                    this.privProtocol = PrivDES.ID;
                    continue;
                }
                if (s.equals("AES128") || s.equals("AES")) {
                    this.privProtocol = PrivAES128.ID;
                    continue;
                }
                if (s.equals("AES192")) {
                    this.privProtocol = PrivAES192.ID;
                    continue;
                }
                if (s.equals("AES256")) {
                    this.privProtocol = PrivAES256.ID;
                    continue;
                }
                throw new IllegalArgumentException("Privacy protocol " + s + " not supported");
            }
            if (args[i].equals("-p")) {
                s = SnmpRequest.nextOption(args, i++);
                this.pduType = PDU.getTypeFromString(s);
                if (this.pduType != Integer.MIN_VALUE) continue;
                throw new IllegalArgumentException("Unknown PDU type " + s);
            }
            if (!args[i].startsWith("-")) {
                return i;
            }
            throw new IllegalArgumentException("Unknown option " + args[i]);
        }
        return 0;
    }

    protected static void printVersion() {
        System.out.println();
        System.out.println("SNMP4J Command Line Tool v1.7.5 Copyright \u00a9 2004-2006, Frank Fock and Jochen Katz");
        System.out.println("http://www.snmp4j.org");
        System.out.println();
        System.out.println("SNMP4J is licensed under the Apache License 2.0:");
        System.out.println("http://www.apache.org/licenses/LICENSE-2.0.txt");
        System.out.println();
    }

    protected static void printUsage() {
        String[] usage = new String[]{"", "Usage: SNMP4J [options] [transport:]address [OID[={type}value] ...]", "", "  -a  authProtocol      Sets the authentication protocol used to", "                        authenticate SNMPv3 messages. Valid values are", "                        MD5 and SHA.", "  -A  authPassphrase    Sets the authentication pass phrase for authenticated", "                        SNMPv3 messages.", "  -c  community         Sets the community for SNMPv1/v2c messages.", "  -Ca agentAddress      Sets the agent address field of a V1TRAP PDU.", "                        The default value is '0.0.0.0'.", "  -Cg genericID         Sets the generic ID for SNMPv1 TRAPs (V1TRAP).", "                        The default is 1 (coldStart).", "  -Ce enterpriseOID     Sets the enterprise OID field of a V1TRAP PDU.", "  -Cil lowerBoundIndex  Sets the lower bound index for TABLE operations.", "  -Ciu upperBoundIndex  Sets the upper bound index for TABLE operations.", "  -Cn non-repeaters     Sets  the  non-repeaters field for GETBULK PDUs.", "                        It specifies the number of supplied variables that", "                        should not be iterated over. The default is 0.", "  -Cr max-repetitions   Sets the max-repetitions field for GETBULK PDUs.", "                        This specifies the maximum number of iterations", "                        over the repeating variables. The default is 10.", "  -Cs specificID        Sets the specific ID for V1TRAP PDU. The default is 0.", "  -Ct trapOID           Sets the trapOID (1.3.6.1.6.3.1.1.4.1.0) of an INFORM", "                        or TRAP PDU. The default is 1.3.6.1.6.3.1.1.5.1.", "  -Cu upTime            Sets the sysUpTime field of an INFORM, TRAP, or", "                        V1TRAP PDU.", "  -d  debugLevel        Sets the global debug level for Log4J logging output.", "                        Valid values are OFF, ERROR, WARN, INFO, and DEBUG.", "  -e  engineID          Sets the authoritative engine ID of the command", "                        responder used for SNMPv3 request messages. If not", "                        supplied, the engine ID will be discovered.", "  -E  contextEngineID   Sets the context engine ID used for the SNMPv3 scoped", "                        PDU. The authoritative engine ID will be used for the", "                        context engine ID, if the latter is not specified.", "  -h                    Displays this message and then exits the application.", "  -n  contextName       Sets the target context name for SNMPv3 messages. ", "                        Default is the empty string.", "  -Ol                   Activates listen operation mode. In this mode, the", "                        application will listen for incoming TRAPs and INFORMs", "                        on the supplied address. Received request will be", "                        dumped to the console until the application is stopped.", "  -Ot                   Activates table operation mode. In this mode, the", "                        application receives tabular data from the column", "                        OIDs specified as parameters. The retrieved rows will", "                        be dumped to the console ordered by their index values.", "  -Otd                  Activates dense table operation mode. In this mode, the", "                        application receives tabular data from the column", "                        OIDs specified as parameters. The retrieved rows will", "                        be dumped to the console ordered by their index values.", "                        In contrast to -Ot this option must not be used with", "                        sparse tables. ", "  -OtCSV                Same as -Ot except that for each SNMP row received", "                        exactly one row of comma separated values will printed", "                        to the console where the first column contains the row", "                        index.", "  -OttCSV               Same as -OtCSV except that each row's first column", "                        will report the current time (millis after 1.1.1970)", "                        when the request has been sent.", "  -Ow                   Activates walk operation mode for GETNEXT and GETBULK", "                        PDUs. If activated, the GETNEXT and GETBULK operations", "                        will be repeated until all instances within the", "                        OID subtree of the supplied OID have been retrieved", "                        successfully or until an error occurred.", "  -p  pduType           Specifies the PDU type to be used for the message.", "                        Valid types are GET, GETNEXT, GETBULK (SNMPv2c/v3),", "                        SET, INFORM, TRAP, and V1TRAP (SNMPv1).", "  -P  privacyPassphrase Sets the privacy pass phrase for encrypted", "                        SNMPv3 messages (same as -X).", "  -r  retries           Sets the number of retries used for requests. A zero", "                        value will send out a request exactly once.", "                        Default is 1.", "  -t  timeout           Sets the timeout in milliseconds between retries.", "                        Default is 1000 milliseconds.", "  -u  securityName      Sets the security name for authenticated v3 messages.", "  -v  1|2c|3            Sets the SNMP protocol version to be used.", "                        Default is 3.", "  -V                    Displays version information and then exits.", "  -x  privacyProtocol   Sets the privacy protocol to be used to encrypt", "                        SNMPv3 messages. Valid values are DES, AES (AES128),", "                        AES192, and AES256.", "  -X  privacyPassphrase Sets the privacy pass phrase for encrypted", "                        SNMPv3 messages (same as -P).", "", "The address of the target SNMP engine is parsed according to the", "specified <transport> selector (default selector is udp):", "", "  udp | tcp             hostname[/port]", "                        ipv4Address[/port]", "                        ipv6Address[/port]", "", "The OIDs have to be specified in numerical form, for example:", "  1.3.6.1.2.1.1.5.0  (which will return the sysName.0 instance with a GET)", "To request multiple instances, add additional OIDs with a space as", "separator. For the last sub-identifier of a plain OID (without an assigned", "value) a range can be specified, for example '1.3.6.1.2.1.2.2.1-10' will", "has the same effect as enumerating all OIDs from '1.3.6.1.2.1.2.2.1' to", "'1.3.6.1.2.1.2.2.10'.", "For SET and INFORM request, you can specify a value for each OID by", "using the following form: OID={type}value where <type> is one of", "the following single characters enclosed by '{' and '}':", "  i                     Integer32", "  u                     UnsingedInteger32, Gauge32", "  s                     OCTET STRING", "  x                     OCTET STRING specified as hex string where", "                        bytes separated by colons (':').", "  d                     OCTET STRING specified as decimal string", "                        where bytes are separated by dots ('.').", "  n                     Null", "  o                     OBJECT IDENTIFIER", "  t                     TimeTicks", "  a                     IpAddress", "  b                     OCTET STRING specified as binary string where", "                        bytes are separated by spaces.", "", "An example for a complete SNMPv2c SET request to set sysName:", " SNMP4J -c private -v 2c -p SET udp:localhost/161 \"1.3.6.1.2.1.1.5.0={s}SNMP4J\"", "", "To walk the whole MIB tree with GETBULK and using SNMPv3 MD5 authentication:", " SNMP4J -a MD5 -A MD5UserAuthPassword -u MD5User -p GETBULK -Ow 127.0.0.1/161", "", "Listen for unauthenticated SNMPv3 INFORMs and TRAPs and all v1/v2c TRAPs:", " SNMP4J -u aSecurityName -Ol 0.0.0.0/162", "", "Send an unauthenticated SNMPv3 notification (trap):", " SNMP4J -p TRAP -v 3 -u aSecurityName 127.0.0.1/162 \"1.3.6.1.2.1.1.3.0={t}0\" \\", "  \"1.3.6.1.6.3.1.1.4.1.0={o}1.3.6.1.6.3.1.1.5.1\" \\", "  \"1.3.6.1.2.1.1.1.0={s}System XYZ, Version N.M\"", "Retrieve rows of the columnar objects ifDescr to ifInOctets and ifOutOctets:", " SNMP4J -c public -v 2c -Ot localhost 1.3.6.1.2.1.2.2.1.2-10\\", "  1.3.6.1.2.1.2.2.1.16", ""};
        for (int i = 0; i < usage.length; ++i) {
            System.out.println(usage[i]);
        }
    }

    protected static void printVariableBindings(PDU response) {
        for (int i = 0; i < response.size(); ++i) {
            VariableBinding vb = response.get(i);
            System.out.println(vb.toString());
        }
    }

    protected static void printReport(PDU response) {
        if (response.size() < 1) {
            System.out.println("REPORT PDU does not contain a variable binding.");
            return;
        }
        VariableBinding vb = response.get(0);
        OID oid = vb.getOid();
        if (SnmpConstants.usmStatsUnsupportedSecLevels.equals(oid)) {
            System.out.print("REPORT: Unsupported Security Level.");
        } else if (SnmpConstants.usmStatsNotInTimeWindows.equals(oid)) {
            System.out.print("REPORT: Message not within time window.");
        } else if (SnmpConstants.usmStatsUnknownUserNames.equals(oid)) {
            System.out.print("REPORT: Unknown user name.");
        } else if (SnmpConstants.usmStatsUnknownEngineIDs.equals(oid)) {
            System.out.print("REPORT: Unknown engine id.");
        } else if (SnmpConstants.usmStatsWrongDigests.equals(oid)) {
            System.out.print("REPORT: Wrong digest.");
        } else if (SnmpConstants.usmStatsDecryptionErrors.equals(oid)) {
            System.out.print("REPORT: Decryption error.");
        } else if (SnmpConstants.snmpUnknownSecurityModels.equals(oid)) {
            System.out.print("REPORT: Unknown security model.");
        } else if (SnmpConstants.snmpInvalidMsgs.equals(oid)) {
            System.out.print("REPORT: Invalid message.");
        } else if (SnmpConstants.snmpUnknownPDUHandlers.equals(oid)) {
            System.out.print("REPORT: Unknown PDU handler.");
        } else if (SnmpConstants.snmpUnavailableContexts.equals(oid)) {
            System.out.print("REPORT: Unavailable context.");
        } else if (SnmpConstants.snmpUnknownContexts.equals(oid)) {
            System.out.print("REPORT: Unknown context.");
        } else {
            System.out.print("REPORT contains unknown OID (" + oid.toString() + ").");
        }
        System.out.println(" Current counter value is " + vb.getVariable().toString() + ".");
    }

    public synchronized void processPdu(CommandResponderEvent e) {
        PDU command = e.getPDU();
        if (command != null) {
            System.out.println(command.toString());
            if (command.getType() != -89 && command.getType() != -92 && command.getType() != -88 && command.getType() != -94) {
                command.setErrorIndex(0);
                command.setErrorStatus(0);
                command.setType(-94);
                StatusInformation statusInformation = new StatusInformation();
                StateReference ref = e.getStateReference();
                try {
                    e.getMessageDispatcher().returnResponsePdu(e.getMessageProcessingModel(), e.getSecurityModel(), e.getSecurityName(), e.getSecurityLevel(), command, e.getMaxSizeResponsePDU(), ref, statusInformation);
                }
                catch (MessageException ex) {
                    System.err.println("Error while sending response: " + ex.getMessage());
                    LogFactory.getLogFactory();
                    LogFactory.getLogger(class$org$snmp4j$tools$console$SnmpRequest == null ? (class$org$snmp4j$tools$console$SnmpRequest = SnmpRequest.class$("org.snmp4j.tools.console.SnmpRequest")) : class$org$snmp4j$tools$console$SnmpRequest).error(ex);
                }
            }
        }
    }

    public PDU createPDU(Target target) {
        PDU request;
        if (target.getVersion() == 3) {
            request = new ScopedPDU();
            ScopedPDU scopedPDU = request;
            if (this.contextEngineID != null) {
                scopedPDU.setContextEngineID(this.contextEngineID);
            }
            if (this.contextName != null) {
                scopedPDU.setContextName(this.contextName);
            }
        } else {
            request = this.pduType == -92 ? this.v1TrapPDU : new PDU();
        }
        request.setType(this.pduType);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void table() throws IOException {
        Snmp snmp = this.createSnmpSession();
        this.target = this.createTarget();
        this.target.setVersion(this.version);
        this.target.setAddress(this.address);
        this.target.setRetries(this.retries);
        this.target.setTimeout(this.timeout);
        snmp.listen();
        TableUtils tableUtils = new TableUtils(snmp, this);
        tableUtils.setMaxNumRowsPerPDU(this.maxRepetitions);
        Counter32 counter = new Counter32();
        OID[] columns = new OID[this.vbs.size()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = ((VariableBinding)this.vbs.get(i)).getOid();
        }
        long startTime = System.currentTimeMillis();
        Counter32 counter32 = counter;
        synchronized (counter32) {
            TableListener listener = this.operation == 3 ? new TextTableListener() : new CVSTableListener(System.currentTimeMillis());
            if (this.useDenseTableOperation) {
                tableUtils.getDenseTable(this.target, columns, listener, counter, this.lowerBoundIndex, this.upperBoundIndex);
            } else {
                tableUtils.getTable(this.target, columns, listener, counter, this.lowerBoundIndex, this.upperBoundIndex);
            }
            try {
                counter.wait(this.timeout);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        System.out.println("Table received in " + (System.currentTimeMillis() - startTime) + " milliseconds.");
        snmp.close();
    }

    public static void main(String[] args) {
        block11: {
            try {
                SnmpRequest snmpRequest = new SnmpRequest(args);
                try {
                    if (snmpRequest.operation == 2) {
                        snmpRequest.listen();
                        break block11;
                    }
                    if (snmpRequest.operation == 3 || snmpRequest.operation == 4 || snmpRequest.operation == 5) {
                        snmpRequest.table();
                        break block11;
                    }
                    PDU response = snmpRequest.send();
                    if (snmpRequest.getPduType() == -89 || snmpRequest.getPduType() == -88 || snmpRequest.getPduType() == -92 || snmpRequest.getPduType() == -94) {
                        System.out.println(PDU.getTypeString(snmpRequest.getPduType()) + " sent successfully");
                        break block11;
                    }
                    if (response == null) {
                        System.out.println("Request timed out.");
                        break block11;
                    }
                    if (response.getType() == -88) {
                        SnmpRequest.printReport(response);
                        break block11;
                    }
                    if (snmpRequest.operation == 0) {
                        System.out.println("Response received with requestID=" + response.getRequestID() + ", errorIndex=" + response.getErrorIndex() + ", " + "errorStatus=" + response.getErrorStatusText() + "(" + response.getErrorStatus() + ")");
                        SnmpRequest.printVariableBindings(response);
                        break block11;
                    }
                    if (snmpRequest.operation == 1) {
                        System.out.println("End of walked subtree '" + ((VariableBinding)snmpRequest.vbs.get(0)).getOid() + "' reached at:");
                        SnmpRequest.printVariableBindings(response);
                        break block11;
                    }
                    System.out.println("Received something strange: requestID=" + response.getRequestID() + ", errorIndex=" + response.getErrorIndex() + ", " + "errorStatus=" + response.getErrorStatusText() + "(" + response.getErrorStatus() + ")");
                    SnmpRequest.printVariableBindings(response);
                }
                catch (IOException ex) {
                    System.err.println("Error while trying to send request: " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
            catch (IllegalArgumentException iaex) {
                System.err.print("Error: " + iaex.getMessage());
                iaex.printStackTrace();
            }
        }
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setVbs(Vector vbs) {
        this.vbs = vbs;
    }

    public void setUseDenseTableOperation(boolean useDenseTableOperation) {
        this.useDenseTableOperation = useDenseTableOperation;
    }

    public void setUpperBoundIndex(OID upperBoundIndex) {
        this.upperBoundIndex = upperBoundIndex;
    }

    public void setTrapOID(OID trapOID) {
        this.trapOID = trapOID;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public void setSysUpTime(TimeTicks sysUpTime) {
        this.sysUpTime = sysUpTime;
    }

    public void setSecurityName(OctetString securityName) {
        this.securityName = securityName;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setPrivProtocol(OID privProtocol) {
        this.privProtocol = privProtocol;
    }

    public void setPrivPassphrase(OctetString privPassphrase) {
        this.privPassphrase = privPassphrase;
    }

    public void setPduType(int pduType) {
        this.pduType = pduType;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public void setNumDispatcherThreads(int numDispatcherThreads) {
        this.numDispatcherThreads = numDispatcherThreads;
    }

    public void setNonRepeaters(int nonRepeaters) {
        this.nonRepeaters = nonRepeaters;
    }

    public void setMaxRepetitions(int maxRepetitions) {
        this.maxRepetitions = maxRepetitions;
    }

    public void setLowerBoundIndex(OID lowerBoundIndex) {
        this.lowerBoundIndex = lowerBoundIndex;
    }

    public void setContextName(OctetString contextName) {
        this.contextName = contextName;
    }

    public void setContextEngineID(OctetString contextEngineID) {
        this.contextEngineID = contextEngineID;
    }

    public void setCommunity(OctetString community) {
        this.community = community;
    }

    public void setAuthoritativeEngineID(OctetString authoritativeEngineID) {
        this.authoritativeEngineID = authoritativeEngineID;
    }

    public void setAuthProtocol(OID authProtocol) {
        this.authProtocol = authProtocol;
    }

    public void setAuthPassphrase(OctetString authPassphrase) {
        this.authPassphrase = authPassphrase;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LogFactory.setLogFactory(new JavaLogFactory());
        BER.setCheckSequenceLength(false);
    }

    class TextTableListener
    implements TableListener {
        TextTableListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished(TableEvent event) {
            System.out.println();
            System.out.println("Table walk completed with status " + event.getStatus() + ". Received " + event.getUserObject() + " rows.");
            Object object = event.getUserObject();
            synchronized (object) {
                event.getUserObject().notify();
            }
        }

        public boolean next(TableEvent event) {
            System.out.println("Index = " + event.getIndex() + ":");
            for (int i = 0; i < event.getColumns().length; ++i) {
                System.out.println(event.getColumns()[i]);
            }
            System.out.println();
            ((Counter32)event.getUserObject()).increment();
            return true;
        }
    }

    class CVSTableListener
    implements TableListener {
        private long requestTime;

        public CVSTableListener(long time) {
            this.requestTime = time;
        }

        public boolean next(TableEvent event) {
            if (SnmpRequest.this.operation == 5) {
                System.out.print(this.requestTime);
                System.out.print(",");
            }
            System.out.print("\"" + event.getIndex() + "\",");
            for (int i = 0; i < event.getColumns().length; ++i) {
                Variable v = event.getColumns()[i].getVariable();
                String value = v.toString();
                switch (v.getSyntax()) {
                    case 4: {
                        StringBuffer escapedString = new StringBuffer(value.length());
                        StringTokenizer st = new StringTokenizer(value, "\"", true);
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            escapedString.append(token);
                            if (!token.equals("\"")) continue;
                            escapedString.append("\"");
                        }
                    }
                    case 6: 
                    case 64: 
                    case 68: {
                        System.out.print("\"");
                        System.out.print(value);
                        System.out.print("\"");
                        break;
                    }
                    default: {
                        System.out.print(value);
                    }
                }
                if (i + 1 >= event.getColumns().length) continue;
                System.out.print(",");
            }
            System.out.println();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished(TableEvent event) {
            Object object = event.getUserObject();
            synchronized (object) {
                event.getUserObject().notify();
            }
        }
    }
}

