/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.AssignableFromByteArray;
import org.snmp4j.smi.AssignableFromInteger;
import org.snmp4j.smi.AssignableFromLong;
import org.snmp4j.smi.AssignableFromString;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariantVariableCallback;

public class VariantVariable
extends Variable
implements AssignableFromInteger,
AssignableFromLong,
AssignableFromString,
AssignableFromByteArray {
    private Variable variable;
    private VariantVariableCallback callback;

    public VariantVariable(Variable initialVariable) {
        if (initialVariable == null) {
            throw new NullPointerException();
        }
        this.variable = initialVariable;
    }

    public VariantVariable(Variable initialVariable, VariantVariableCallback callback) {
        this(initialVariable);
        this.callback = callback;
    }

    public synchronized int compareTo(Object o) {
        this.updateVariable();
        return this.variable.compareTo(o);
    }

    protected void updateVariable() {
        if (this.callback != null) {
            this.callback.updateVariable(this);
        }
    }

    protected void variableUpdated() {
        if (this.callback != null) {
            this.callback.variableUpdated(this);
        }
    }

    public synchronized void decodeBER(BERInputStream inputStream) throws IOException {
        this.variable.decodeBER(inputStream);
        this.variableUpdated();
    }

    public synchronized void encodeBER(OutputStream outputStream) throws IOException {
        this.updateVariable();
        this.variable.encodeBER(outputStream);
    }

    public synchronized void fromSubIndex(OID subIndex, boolean impliedLength) {
        this.variable.fromSubIndex(subIndex, impliedLength);
        this.variableUpdated();
    }

    public synchronized int getBERLength() {
        this.updateVariable();
        return this.variable.getBERLength();
    }

    public int getSyntax() {
        return this.variable.getSyntax();
    }

    public synchronized int toInt() {
        this.updateVariable();
        return this.variable.toInt();
    }

    public synchronized long toLong() {
        this.updateVariable();
        return this.variable.toLong();
    }

    public synchronized OID toSubIndex(boolean impliedLength) {
        this.updateVariable();
        return this.variable.toSubIndex(impliedLength);
    }

    public synchronized boolean equals(Object o) {
        this.updateVariable();
        return this.variable.equals(o);
    }

    public synchronized int hashCode() {
        this.updateVariable();
        return this.variable.hashCode();
    }

    public synchronized String toString() {
        this.updateVariable();
        return this.variable.toString();
    }

    public Object clone() {
        return new VariantVariable((Variable)this.variable.clone());
    }

    public void setValue(int value) {
        if (!(this.variable instanceof AssignableFromInteger)) {
            throw new ClassCastException("An integer value cannot be assigned to " + this.variable);
        }
        ((AssignableFromInteger)((Object)this.variable)).setValue(value);
    }

    public void setValue(long value) {
        if (!(this.variable instanceof AssignableFromLong)) {
            throw new ClassCastException("A long value cannot be assigned to " + this.variable);
        }
        ((AssignableFromLong)((Object)this.variable)).setValue(value);
    }

    public void setValue(OctetString value) {
        if (!(this.variable instanceof AssignableFromByteArray)) {
            throw new ClassCastException("An OctetString value cannot be assigned to " + this.variable);
        }
        ((AssignableFromByteArray)((Object)this.variable)).setValue(value.getValue());
    }

    public void setValue(byte[] value) {
        if (!(this.variable instanceof AssignableFromByteArray)) {
            throw new ClassCastException("A byte array value cannot be assigned to " + this.variable);
        }
        ((AssignableFromByteArray)((Object)this.variable)).setValue(value);
    }

    public void setValue(String value) {
        if (!(this.variable instanceof AssignableFromString)) {
            throw new ClassCastException("A string value cannot be assigned to " + this.variable);
        }
        ((AssignableFromString)((Object)this.variable)).setValue(value);
    }

    public Variable getVariable() {
        return this.variable;
    }
}

