/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BERSerializable;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class VariableBinding
implements Serializable,
BERSerializable,
Cloneable {
    static final long serialVersionUID = 1032709950031514113L;
    private OID oid;
    private Variable variable;

    public VariableBinding() {
        this.oid = new OID();
        this.variable = new Null();
    }

    public VariableBinding(OID oid) {
        this.setOid(oid);
        this.variable = new Null();
    }

    public VariableBinding(OID oid, Variable variable) {
        this.setOid(oid);
        this.setVariable(variable);
    }

    public OID getOid() {
        return this.oid;
    }

    public void setOid(OID oid) {
        if (oid == null) {
            throw new IllegalArgumentException("OID of a VariableBinding must not be null");
        }
        this.oid = oid;
    }

    public void setVariable(Variable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Variable of a VariableBinding must not be null");
        }
        this.variable = variable;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public final int getSyntax() {
        return this.variable.getSyntax();
    }

    public boolean isException() {
        return this.variable.isException();
    }

    public final int getBERPayloadLength() {
        return this.oid.getBERLength() + this.variable.getBERLength();
    }

    public final int getBERLength() {
        int length = this.getBERPayloadLength();
        length += BER.getBERLengthOfLength(length) + 1;
        return length;
    }

    public final void decodeBER(BERInputStream inputStream) throws IOException {
        BER.MutableByte type = new BER.MutableByte();
        int length = BER.decodeHeader(inputStream, type);
        long startPos = inputStream.getPosition();
        if (type.getValue() != 48) {
            throw new IOException("Invalid sequence encoding: " + type.getValue());
        }
        this.oid.decodeBER(inputStream);
        this.variable = Variable.createFromBER(inputStream);
        if (BER.isCheckSequenceLength()) {
            BER.checkSequenceLength(length, (int)(inputStream.getPosition() - startPos), this);
        }
    }

    public final void encodeBER(OutputStream outputStream) throws IOException {
        int length = this.getBERPayloadLength();
        BER.encodeHeader(outputStream, 48, length);
        this.oid.encodeBER(outputStream);
        this.variable.encodeBER(outputStream);
    }

    public String toString() {
        return this.oid.toString() + " = " + this.variable;
    }

    public Object clone() {
        return new VariableBinding((OID)this.oid.clone(), (Variable)this.variable.clone());
    }
}

