/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BERSerializable;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Opaque;
import org.snmp4j.smi.TimeTicks;

public abstract class Variable
implements Cloneable,
Comparable,
BERSerializable {
    private static final long serialVersionUID = 1395840752909725320L;
    public static final String SMISYNTAXES_PROPERTIES = "org.snmp4j.smisyntaxes";
    private static final String SMISYNTAXES_PROPERTIES_DEFAULT = "smisyntaxes.properties";
    private static final Object[][] SYNTAX_NAME_MAPPING = new Object[][]{{"Integer32", new Integer(2)}, {"BIT STRING", new Integer(3)}, {"OCTET STRING", new Integer(4)}, {"OBJECT IDENTIFIER", new Integer(6)}, {"TimeTicks", new Integer(67)}, {"Counter", new Integer(65)}, {"Counter64", new Integer(70)}, {"EndOfMibView", new Integer(130)}, {"Gauge", new Integer(66)}, {"IpAddress", new Integer(64)}, {"NoSuchInstance", new Integer(129)}, {"NoSuchObject", new Integer(128)}, {"Null", new Integer(5)}, {"Opaque", new Integer(68)}};
    private static Hashtable registeredSyntaxes = null;
    private static final LogAdapter logger = LogFactory.getLogger(class$org$snmp4j$smi$Variable == null ? (class$org$snmp4j$smi$Variable = Variable.class$("org.snmp4j.smi.Variable")) : class$org$snmp4j$smi$Variable);
    static /* synthetic */ Class class$org$snmp4j$smi$Variable;

    public abstract boolean equals(Object var1);

    public abstract int compareTo(Object var1);

    public abstract int hashCode();

    public abstract int getBERLength();

    public int getBERPayloadLength() {
        return this.getBERLength();
    }

    public abstract void decodeBER(BERInputStream var1) throws IOException;

    public abstract void encodeBER(OutputStream var1) throws IOException;

    public static Variable createFromBER(BERInputStream inputStream) throws IOException {
        Variable variable;
        if (!inputStream.markSupported()) {
            throw new IOException("InputStream for decoding a Variable must support marks");
        }
        if (SNMP4JSettings.isExtensibilityEnabled() && registeredSyntaxes == null) {
            Variable.registerSyntaxes();
        }
        inputStream.mark(2);
        int type = inputStream.read();
        if (SNMP4JSettings.isExtensibilityEnabled()) {
            Class c = (Class)registeredSyntaxes.get(new Integer(type));
            if (c == null) {
                throw new IOException("Encountered unsupported variable syntax: " + type);
            }
            try {
                variable = (Variable)c.newInstance();
            }
            catch (IllegalAccessException aex) {
                throw new IOException("Could not access variable syntax class for: " + c.getName());
            }
            catch (InstantiationException iex) {
                throw new IOException("Could not instantiate variable syntax class for: " + c.getName());
            }
        } else {
            variable = Variable.createVariable(type);
        }
        inputStream.reset();
        variable.decodeBER(inputStream);
        return variable;
    }

    private static Variable createVariable(int smiSyntax) {
        switch (smiSyntax) {
            case 6: {
                return new OID();
            }
            case 2: {
                return new Integer32();
            }
            case 4: {
                return new OctetString();
            }
            case 66: {
                return new Gauge32();
            }
            case 65: {
                return new Counter32();
            }
            case 70: {
                return new Counter64();
            }
            case 5: {
                return new Null();
            }
            case 67: {
                return new TimeTicks();
            }
            case 130: {
                return new Null(130);
            }
            case 129: {
                return new Null(129);
            }
            case 128: {
                return new Null(128);
            }
            case 68: {
                return new Opaque();
            }
            case 64: {
                return new IpAddress();
            }
        }
        throw new IllegalArgumentException("Unsupported variable syntax: " + smiSyntax);
    }

    public static Variable createFromSyntax(int smiSyntax) {
        Class c;
        if (!SNMP4JSettings.isExtensibilityEnabled()) {
            return Variable.createVariable(smiSyntax);
        }
        if (registeredSyntaxes == null) {
            Variable.registerSyntaxes();
        }
        if ((c = (Class)registeredSyntaxes.get(new Integer(smiSyntax))) == null) {
            throw new IllegalArgumentException("Unsupported variable syntax: " + smiSyntax);
        }
        try {
            Variable variable = (Variable)c.newInstance();
            return variable;
        }
        catch (IllegalAccessException aex) {
            throw new RuntimeException("Could not access variable syntax class for: " + c.getName());
        }
        catch (InstantiationException iex) {
            throw new RuntimeException("Could not instantiate variable syntax class for: " + c.getName());
        }
    }

    private static synchronized void registerSyntaxes() {
        String syntaxes;
        InputStream is = (class$org$snmp4j$smi$Variable == null ? (class$org$snmp4j$smi$Variable = Variable.class$("org.snmp4j.smi.Variable")) : class$org$snmp4j$smi$Variable).getResourceAsStream(syntaxes = System.getProperty(SMISYNTAXES_PROPERTIES, SMISYNTAXES_PROPERTIES_DEFAULT));
        if (is == null) {
            throw new InternalError("Could not read '" + syntaxes + "' from classpath!");
        }
        Properties props = new Properties();
        try {
            props.load(is);
            Hashtable regSyntaxes = new Hashtable(((Hashtable)props).size());
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String id = (String)en.nextElement();
                String className = props.getProperty(id);
                try {
                    Class<?> c = Class.forName(className);
                    regSyntaxes.put(new Integer(id), c);
                }
                catch (ClassNotFoundException cnfe) {
                    logger.error(cnfe);
                }
            }
            registeredSyntaxes = regSyntaxes;
        }
        catch (IOException iox) {
            String txt = "Could not read '" + syntaxes + "': " + iox.getMessage();
            logger.error(txt);
            throw new InternalError(txt);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {
                logger.warn(ex);
            }
        }
    }

    public abstract int getSyntax();

    public boolean isException() {
        return Null.isExceptionSyntax(this.getSyntax());
    }

    public abstract String toString();

    public abstract int toInt();

    public abstract long toLong();

    public abstract Object clone();

    public static String getSyntaxString(int syntax) {
        switch (syntax) {
            case 2: {
                return "Integer32";
            }
            case 3: {
                return "BIT STRING";
            }
            case 4: {
                return "OCTET STRING";
            }
            case 6: {
                return "OBJECT IDENTIFIER";
            }
            case 67: {
                return "TimeTicks";
            }
            case 65: {
                return "Counter";
            }
            case 70: {
                return "Counter64";
            }
            case 130: {
                return "EndOfMibView";
            }
            case 66: {
                return "Gauge";
            }
            case 64: {
                return "IpAddress";
            }
            case 129: {
                return "NoSuchInstance";
            }
            case 128: {
                return "NoSuchObject";
            }
            case 5: {
                return "Null";
            }
            case 68: {
                return "Opaque";
            }
        }
        return "?";
    }

    public final String getSyntaxString() {
        return Variable.getSyntaxString(this.getSyntax());
    }

    public static int getSyntaxFromString(String syntaxString) {
        for (int i = 0; i < SYNTAX_NAME_MAPPING.length; ++i) {
            if (!SYNTAX_NAME_MAPPING[i][0].equals(syntaxString)) continue;
            return (Integer)SYNTAX_NAME_MAPPING[i][1];
        }
        return 5;
    }

    public abstract OID toSubIndex(boolean var1);

    public abstract void fromSubIndex(OID var1, boolean var2);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

