/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.DecryptParams;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.Salt;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public abstract class PrivAES
implements PrivacyProtocol {
    private static final int DECRYPT_PARAMS_LENGTH = 8;
    private static final LogAdapter logger = LogFactory.getLogger(class$org$snmp4j$security$PrivAES == null ? (class$org$snmp4j$security$PrivAES = PrivAES.class$("org.snmp4j.security.PrivAES")) : class$org$snmp4j$security$PrivAES);
    private int keyBytes;
    protected Salt salt;
    static /* synthetic */ Class class$org$snmp4j$security$PrivAES;

    public PrivAES(int keyBytes) {
        if (keyBytes != 16 && keyBytes != 24 && keyBytes != 32) {
            throw new IllegalArgumentException("Only 128, 192 and 256 bit AES is allowed. Requested (" + 8 * keyBytes + ").");
        }
        this.keyBytes = keyBytes;
        this.salt = Salt.getInstance();
    }

    public byte[] encrypt(byte[] unencryptedData, int offset, int length, byte[] encryptionKey, long engineBoots, long engineTime, DecryptParams decryptParams) {
        byte[] initVect = new byte[16];
        long my_salt = this.salt.getNext();
        if (encryptionKey.length < this.keyBytes) {
            throw new IllegalArgumentException("Needed key length is " + this.keyBytes + ". Got only " + encryptionKey.length + ".");
        }
        if (decryptParams.array == null || decryptParams.length < 8) {
            decryptParams.array = new byte[8];
        }
        decryptParams.length = 8;
        decryptParams.offset = 0;
        initVect[0] = (byte)(engineBoots >> 24 & 0xFFL);
        initVect[1] = (byte)(engineBoots >> 16 & 0xFFL);
        initVect[2] = (byte)(engineBoots >> 8 & 0xFFL);
        initVect[3] = (byte)(engineBoots & 0xFFL);
        initVect[4] = (byte)(engineTime >> 24 & 0xFFL);
        initVect[5] = (byte)(engineTime >> 16 & 0xFFL);
        initVect[6] = (byte)(engineTime >> 8 & 0xFFL);
        initVect[7] = (byte)(engineTime & 0xFFL);
        int i = 56;
        int j = 8;
        while (i >= 0) {
            initVect[j] = (byte)(my_salt >> i & 0xFFL);
            i -= 8;
            ++j;
        }
        for (i = 0; i < 8; ++i) {
            decryptParams.array[i] = initVect[i + 8];
        }
        if (logger.isDebugEnabled()) {
            logger.debug("initVect is " + PrivAES.asHex(initVect));
        }
        byte[] encryptedData = null;
        try {
            Cipher alg = Cipher.getInstance("AES/CFB/NoPadding");
            SecretKeySpec key = new SecretKeySpec(encryptionKey, 0, this.keyBytes, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(initVect);
            alg.init(1, (Key)key, ivSpec);
            encryptedData = alg.doFinal(unencryptedData, offset, length);
            if (logger.isDebugEnabled()) {
                logger.debug("aes encrypt: Data to encrypt " + PrivAES.asHex(unencryptedData));
                logger.debug("aes encrypt: used key " + PrivAES.asHex(encryptionKey));
                logger.debug("aes encrypt: created privacy_params " + PrivAES.asHex(decryptParams.array));
                logger.debug("aes encrypt: encrypted Data  " + PrivAES.asHex(encryptedData));
            }
        }
        catch (Exception e) {
            logger.error("Encrypt Exception " + e.toString() + " " + e.getMessage());
            logger.error("Encrypt Exception " + e.getMessage());
        }
        return encryptedData;
    }

    public byte[] decrypt(byte[] cryptedData, int offset, int length, byte[] decryptionKey, long engineBoots, long engineTime, DecryptParams decryptParams) {
        byte[] initVect = new byte[16];
        if (decryptionKey.length < this.keyBytes) {
            throw new IllegalArgumentException("Needed key length is " + this.keyBytes + ". Got only " + decryptionKey.length + ".");
        }
        initVect[0] = (byte)(engineBoots >> 24 & 0xFFL);
        initVect[1] = (byte)(engineBoots >> 16 & 0xFFL);
        initVect[2] = (byte)(engineBoots >> 8 & 0xFFL);
        initVect[3] = (byte)(engineBoots & 0xFFL);
        initVect[4] = (byte)(engineTime >> 24 & 0xFFL);
        initVect[5] = (byte)(engineTime >> 16 & 0xFFL);
        initVect[6] = (byte)(engineTime >> 8 & 0xFFL);
        initVect[7] = (byte)(engineTime & 0xFFL);
        for (int i = 0; i < 8; ++i) {
            initVect[i + 8] = decryptParams.array[i + decryptParams.offset];
        }
        if (logger.isDebugEnabled()) {
            logger.debug("initVect is " + PrivAES.asHex(initVect));
        }
        byte[] decryptedData = null;
        try {
            Cipher alg = Cipher.getInstance("AES/CFB/NoPadding");
            SecretKeySpec key = new SecretKeySpec(decryptionKey, 0, this.keyBytes, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(initVect);
            alg.init(2, (Key)key, ivSpec);
            decryptedData = alg.doFinal(cryptedData, offset, length);
            if (logger.isDebugEnabled()) {
                logger.debug("aes decrypt: Data to decrypt " + PrivAES.asHex(cryptedData));
                logger.debug("aes decrypt: used key " + PrivAES.asHex(decryptionKey));
                logger.debug("aes decrypt: used privacy_params " + PrivAES.asHex(decryptParams.array));
                logger.debug("aes decrypt: decrypted Data  " + PrivAES.asHex(decryptedData));
            }
        }
        catch (Exception e) {
            logger.error("Decrypt Exception " + e.toString() + " " + e.getMessage());
            logger.error("Decrypt Exception " + e.getMessage());
        }
        return decryptedData;
    }

    public int getEncryptedLength(int scopedPDULength) {
        return scopedPDULength;
    }

    public static String asHex(byte[] buf) {
        return new OctetString(buf).toHexString();
    }

    public int getMinKeyLength() {
        return this.keyBytes;
    }

    public int getMaxKeyLength() {
        return this.getMinKeyLength();
    }

    public int getDecryptParamsLength() {
        return 8;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ OID getID();
}

