/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogLevel;
import org.snmp4j.util.EnumerationIterator;

public class Log4jLogAdapter
implements LogAdapter,
Comparable {
    private Logger logger;

    public Log4jLogAdapter(Logger logger) {
        this.logger = logger;
    }

    public void debug(Object message) {
        this.logger.debug(message);
    }

    public void error(Object message) {
        this.logger.error(message);
    }

    public void error(Object message, Throwable throwable) {
        this.logger.error(message, throwable);
    }

    public void info(Object message) {
        this.logger.info(message);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    public void warn(Object message) {
        this.logger.warn(message);
    }

    public void fatal(Object message) {
        this.logger.fatal(message);
    }

    public void fatal(Object message, Throwable throwable) {
        this.logger.fatal(message, throwable);
    }

    public void setLogLevel(LogLevel level) {
        Level l;
        switch (level.getLevel()) {
            case 1: {
                l = Level.OFF;
                break;
            }
            case 2: {
                l = Level.ALL;
                break;
            }
            case 3: {
                l = Level.DEBUG;
                break;
            }
            case 4: {
                l = Level.DEBUG;
                break;
            }
            case 5: {
                l = Level.INFO;
                break;
            }
            case 6: {
                l = Level.WARN;
                break;
            }
            case 7: {
                l = Level.ERROR;
                break;
            }
            case 8: {
                l = Level.FATAL;
                break;
            }
            default: {
                l = null;
            }
        }
        this.logger.setLevel(l);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getName() {
        return this.logger.getName();
    }

    public LogLevel getLogLevel() {
        Level l = this.logger.getLevel();
        return this.toLogLevel(l);
    }

    private LogLevel toLogLevel(Level l) {
        if (l == null) {
            return LogLevel.NONE;
        }
        switch (l.toInt()) {
            case 0x7FFFFFFF: {
                return LogLevel.OFF;
            }
            case -2147483648: {
                return LogLevel.ALL;
            }
            case 10000: {
                return LogLevel.DEBUG;
            }
            case 20000: {
                return LogLevel.INFO;
            }
            case 30000: {
                return LogLevel.WARN;
            }
            case 40000: {
                return LogLevel.ERROR;
            }
            case 50000: {
                return LogLevel.FATAL;
            }
        }
        return LogLevel.DEBUG;
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((Log4jLogAdapter)o).getName());
    }

    public LogLevel getEffectiveLogLevel() {
        Level l = this.logger.getEffectiveLevel();
        return this.toLogLevel(l);
    }

    public Iterator getLogHandler() {
        return new EnumerationIterator(this.logger.getAllAppenders());
    }
}

