/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.VariableBinding;

public class PDUv1
extends PDU {
    public static final int COLDSTART = 0;
    public static final int WARMSTART = 1;
    public static final int LINKDOWN = 2;
    public static final int LINKUP = 3;
    public static final int AUTHENTICATIONFAILURE = 4;
    public static final int ENTERPRISE_SPECIFIC = 6;
    private static final String OPERATION_NOT_SUPPORTED = "Operation not supported for SNMPv1 PDUs";
    private OID enterprise = new OID();
    private IpAddress agentAddress = new IpAddress("0.0.0.0");
    private Integer32 genericTrap = new Integer32(0);
    private Integer32 specificTrap = new Integer32(0);
    private TimeTicks timestamp = new TimeTicks(0L);

    public PDUv1() {
        this.setType(-92);
    }

    public void decodeBER(BERInputStream inputStream) throws IOException {
        BER.MutableByte pduType = new BER.MutableByte();
        int length = BER.decodeHeader(inputStream, pduType);
        int pduStartPos = (int)inputStream.getPosition();
        switch (pduType.getValue()) {
            case -96: 
            case -95: 
            case -94: 
            case -93: 
            case -92: {
                break;
            }
            default: {
                throw new IOException("Unsupported PDU type: " + pduType.getValue());
            }
        }
        this.setType(pduType.getValue());
        if (this.getType() == -92) {
            this.enterprise.decodeBER(inputStream);
            this.agentAddress.decodeBER(inputStream);
            this.genericTrap.decodeBER(inputStream);
            this.specificTrap.decodeBER(inputStream);
            this.timestamp.decodeBER(inputStream);
        } else {
            this.requestID.decodeBER(inputStream);
            this.errorStatus.decodeBER(inputStream);
            this.errorIndex.decodeBER(inputStream);
        }
        pduType = new BER.MutableByte();
        int vbLength = BER.decodeHeader(inputStream, pduType);
        if (pduType.getValue() != 48) {
            throw new IOException("Encountered invalid tag, SEQUENCE expected: " + pduType.getValue());
        }
        int startPos = (int)inputStream.getPosition();
        this.variableBindings = new Vector();
        while (inputStream.getPosition() - (long)startPos < (long)vbLength) {
            VariableBinding vb = new VariableBinding();
            vb.decodeBER(inputStream);
            if (vb.getSyntax() == 70) {
                throw new MessageException("Counter64 encountered in SNMPv1 PDU (RFC 2576 \u00a74.1.2.1)");
            }
            this.variableBindings.add(vb);
        }
        if (BER.isCheckSequenceLength()) {
            BER.checkSequenceLength(vbLength, (int)inputStream.getPosition() - startPos, this);
            BER.checkSequenceLength(length, (int)inputStream.getPosition() - pduStartPos, this);
        }
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        int i;
        BER.encodeHeader(outputStream, this.type, this.getBERPayloadLength());
        if (this.type == -92) {
            this.enterprise.encodeBER(outputStream);
            this.agentAddress.encodeBER(outputStream);
            this.genericTrap.encodeBER(outputStream);
            this.specificTrap.encodeBER(outputStream);
            this.timestamp.encodeBER(outputStream);
        } else {
            this.requestID.encodeBER(outputStream);
            this.errorStatus.encodeBER(outputStream);
            this.errorIndex.encodeBER(outputStream);
        }
        int vbLength = 0;
        for (i = 0; i < this.variableBindings.size(); ++i) {
            vbLength += ((VariableBinding)this.variableBindings.get(i)).getBERLength();
        }
        BER.encodeHeader(outputStream, 48, vbLength);
        for (i = 0; i < this.variableBindings.size(); ++i) {
            ((VariableBinding)this.variableBindings.get(i)).encodeBER(outputStream);
        }
    }

    protected int getBERPayloadLengthPDU() {
        if (this.getType() != -92) {
            return super.getBERPayloadLengthPDU();
        }
        int length = 0;
        for (int i = 0; i < this.variableBindings.size(); ++i) {
            length += ((VariableBinding)this.variableBindings.get(i)).getBERLength();
        }
        length += BER.getBERLengthOfLength(length) + 1;
        length += this.agentAddress.getBERLength();
        length += this.enterprise.getBERLength();
        length += this.genericTrap.getBERLength();
        length += this.specificTrap.getBERLength();
        return length += this.timestamp.getBERLength();
    }

    public int getMaxRepetitions() {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED);
    }

    public void setMaxRepetitions(int maxRepetitions) {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED);
    }

    public void setMaxSizeScopedPDU(int maxSizeScopedPDU) {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED);
    }

    public void setNonRepeaters(int nonRepeaters) {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED);
    }

    private void checkV1TRAP() {
        if (this.getType() != -92) {
            throw new UnsupportedOperationException("Operation is only supported for SNMPv1 trap PDUs (V1TRAP)");
        }
    }

    public OID getEnterprise() {
        this.checkV1TRAP();
        return this.enterprise;
    }

    public void setEnterprise(OID enterprise) {
        this.checkV1TRAP();
        this.checkNull(enterprise);
        this.enterprise = (OID)enterprise.clone();
    }

    public IpAddress getAgentAddress() {
        this.checkV1TRAP();
        return this.agentAddress;
    }

    public void setAgentAddress(IpAddress agentAddress) {
        this.checkV1TRAP();
        this.checkNull(agentAddress);
        this.agentAddress = agentAddress;
    }

    public int getGenericTrap() {
        this.checkV1TRAP();
        return this.genericTrap.getValue();
    }

    public void setGenericTrap(int genericTrap) {
        this.checkV1TRAP();
        this.genericTrap.setValue(genericTrap);
    }

    public int getSpecificTrap() {
        this.checkV1TRAP();
        return this.specificTrap.getValue();
    }

    public void setSpecificTrap(int specificTrap) {
        this.checkV1TRAP();
        this.specificTrap.setValue(specificTrap);
    }

    public long getTimestamp() {
        this.checkV1TRAP();
        return this.timestamp.getValue();
    }

    public void setTimestamp(long timeStamp) {
        this.checkV1TRAP();
        this.timestamp.setValue(timeStamp);
    }

    protected void checkNull(Object parameter) {
        if (parameter == null) {
            throw new NullPointerException("Members of PDUv1 must not be null");
        }
    }

    public String toString() {
        if (this.type == -92) {
            StringBuffer buf = new StringBuffer();
            buf.append(PDU.getTypeString(this.type));
            buf.append("[reqestID=");
            buf.append(this.requestID);
            buf.append(",timestamp=");
            buf.append(this.timestamp);
            buf.append(",enterprise=");
            buf.append(this.enterprise);
            buf.append(",genericTrap=");
            buf.append(this.genericTrap);
            buf.append(",specificTrap=");
            buf.append(this.specificTrap);
            buf.append(", VBS[");
            for (int i = 0; i < this.variableBindings.size(); ++i) {
                buf.append(this.variableBindings.get(i));
                if (i + 1 >= this.variableBindings.size()) continue;
                buf.append("; ");
            }
            buf.append("]]");
            return buf.toString();
        }
        return super.toString();
    }
}

