/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageException;
import org.snmp4j.MutablePDU;
import org.snmp4j.PDU;
import org.snmp4j.TransportMapping;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BEROutputStream;
import org.snmp4j.event.AuthenticationFailureEvent;
import org.snmp4j.event.AuthenticationFailureListener;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.MutableStateReference;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.UnsupportedAddressClassException;

public class MessageDispatcherImpl
implements MessageDispatcher {
    private static final LogAdapter logger = LogFactory.getLogger(class$org$snmp4j$MessageDispatcherImpl == null ? (class$org$snmp4j$MessageDispatcherImpl = MessageDispatcherImpl.class$("org.snmp4j.MessageDispatcherImpl")) : class$org$snmp4j$MessageDispatcherImpl);
    private Vector mpm = new Vector(3);
    private Hashtable transportMappings = new Hashtable(5);
    private int nextTransactionID = new Random().nextInt(0x7FFFFFFD) + 1;
    private transient Vector commandResponderListeners;
    private transient Vector counterListeners;
    private transient Vector authenticationFailureListeners;
    private boolean checkOutgoingMsg = true;
    static /* synthetic */ Class class$org$snmp4j$MessageDispatcherImpl;

    public synchronized void addMessageProcessingModel(MessageProcessingModel model) {
        while (this.mpm.size() <= model.getID()) {
            this.mpm.add(null);
        }
        if (this.mpm.get(model.getID()) == null) {
            this.mpm.set(model.getID(), model);
        }
    }

    public synchronized void removeMessageProcessingModel(MessageProcessingModel model) {
        this.mpm.set(model.getID(), null);
    }

    public void addTransportMapping(TransportMapping transport) {
        if (this.transportMappings.get(transport.getSupportedAddressClass()) == null) {
            this.transportMappings.put(transport.getSupportedAddressClass(), transport);
        }
    }

    public TransportMapping removeTransportMapping(TransportMapping transport) {
        return (TransportMapping)this.transportMappings.remove(transport.getSupportedAddressClass());
    }

    public Collection getTransportMappings() {
        return this.transportMappings.values();
    }

    public synchronized int getNextRequestID() {
        int nextID;
        if ((nextID = this.nextTransactionID++) <= 0) {
            nextID = 1;
            this.nextTransactionID = 2;
        }
        return nextID;
    }

    protected PduHandle createPduHandle() {
        return new PduHandle(this.getNextRequestID());
    }

    protected void sendMessage(TransportMapping transport, Address destAddress, byte[] message) throws IOException {
        if (destAddress instanceof GenericAddress) {
            destAddress = ((GenericAddress)destAddress).getAddress();
        }
        if (transport == null) {
            String txt = "No transport mapping for address class: " + destAddress.getClass().getName() + "=" + destAddress;
            logger.error(txt);
            throw new IOException(txt);
        }
        transport.sendMessage(destAddress, message);
    }

    public TransportMapping getTransport(Address destAddress) {
        Class<?> addressClass = destAddress.getClass();
        TransportMapping transport = (TransportMapping)this.transportMappings.get(addressClass);
        return transport;
    }

    protected void dispatchMessage(TransportMapping sourceTransport, MessageProcessingModel mp, Address incomingAddress, BERInputStream wholeMessage) throws IOException {
        MutablePDU pdu = new MutablePDU();
        Integer32 messageProcessingModel = new Integer32();
        Integer32 securityModel = new Integer32();
        OctetString securityName = new OctetString();
        Integer32 securityLevel = new Integer32();
        PduHandle handle = this.createPduHandle();
        Integer32 maxSizeRespPDU = new Integer32(sourceTransport.getMaxInboundMessageSize());
        StatusInformation statusInfo = new StatusInformation();
        MutableStateReference stateReference = new MutableStateReference();
        int status = mp.prepareDataElements(this, incomingAddress, wholeMessage, messageProcessingModel, securityModel, securityName, securityLevel, pdu, handle, maxSizeRespPDU, statusInfo, stateReference);
        if (stateReference.getStateReference() != null) {
            stateReference.getStateReference().setTransportMapping(sourceTransport);
        }
        if (status == 0) {
            CommandResponderEvent e = new CommandResponderEvent(this, sourceTransport, incomingAddress, messageProcessingModel.getValue(), securityModel.getValue(), securityName.getValue(), securityLevel.getValue(), handle, pdu.getPdu(), maxSizeRespPDU.getValue(), stateReference.getStateReference());
            this.fireProcessPdu(e);
        } else {
            switch (status) {
                case -1414: 
                case -1412: 
                case -1402: {
                    AuthenticationFailureEvent event = new AuthenticationFailureEvent(this, incomingAddress, sourceTransport, status, wholeMessage);
                    this.fireAuthenticationFailure(event);
                    break;
                }
            }
            logger.warn(statusInfo.toString());
        }
    }

    public void processMessage(TransportMapping sourceTransport, Address incomingAddress, ByteBuffer wholeMessage) {
        this.processMessage(sourceTransport, incomingAddress, new BERInputStream(wholeMessage));
    }

    public void processMessage(TransportMapping sourceTransport, Address incomingAddress, BERInputStream wholeMessage) {
        this.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpInPkts));
        if (!wholeMessage.markSupported()) {
            String txt = "Message stream must support marks";
            logger.error(txt);
            throw new IllegalArgumentException(txt);
        }
        try {
            wholeMessage.mark(16);
            BER.MutableByte type = new BER.MutableByte();
            BER.decodeHeader(wholeMessage, type, false);
            if (type.getValue() != 48) {
                logger.error("ASN.1 parse error (message is not a sequence)");
                CounterEvent event = new CounterEvent(this, SnmpConstants.snmpInASNParseErrs);
                this.fireIncrementCounter(event);
            }
            Integer32 version = new Integer32();
            version.decodeBER(wholeMessage);
            MessageProcessingModel mp = (MessageProcessingModel)this.mpm.get(version.getValue());
            if (mp == null) {
                logger.warn("SNMP version " + version + " is not supported");
                CounterEvent event = new CounterEvent(this, SnmpConstants.snmpInBadVersions);
                this.fireIncrementCounter(event);
            } else {
                wholeMessage.reset();
                this.dispatchMessage(sourceTransport, mp, incomingAddress, wholeMessage);
            }
        }
        catch (Exception ex) {
            logger.error(ex);
            if (logger.isDebugEnabled()) {
                ex.printStackTrace();
            }
        }
        catch (OutOfMemoryError oex) {
            logger.error(oex);
        }
    }

    public PduHandle sendPdu(Address transportAddress, int messageProcessingModel, int securityModel, byte[] securityName, int securityLevel, PDU pdu, boolean expectResponse) throws MessageException {
        return this.sendPdu(null, transportAddress, messageProcessingModel, securityModel, securityName, securityLevel, pdu, expectResponse);
    }

    public PduHandle sendPdu(TransportMapping transport, Address transportAddress, int messageProcessingModel, int securityModel, byte[] securityName, int securityLevel, PDU pdu, boolean expectResponse) throws MessageException {
        try {
            MessageProcessingModel mp = (MessageProcessingModel)this.mpm.get(messageProcessingModel);
            if (mp == null) {
                throw new MessageException("Unsupported message processing model: " + messageProcessingModel);
            }
            if (!mp.isProtocolVersionSupported(messageProcessingModel)) {
                throw new MessageException("SNMP version " + messageProcessingModel + " is not supported " + "by message processing model " + messageProcessingModel);
            }
            if (transport == null) {
                transport = this.getTransport(transportAddress);
            }
            if (transport == null) {
                throw new UnsupportedAddressClassException("Unsupported address class (transport mapping): " + transportAddress.getClass().getName(), transportAddress.getClass());
            }
            this.checkOutgoingMsg(transportAddress, messageProcessingModel, pdu);
            PduHandle pduHandle = pdu.getRequestID().getValue() == 0 && pdu.getType() != -94 ? this.createPduHandle() : new PduHandle(pdu.getRequestID().getValue());
            pdu.setRequestID(new Integer32(pduHandle.getTransactionID()));
            GenericAddress destAddress = new GenericAddress();
            BEROutputStream outgoingMessage = new BEROutputStream();
            int status = mp.prepareOutgoingMessage(transportAddress, transport.getMaxInboundMessageSize(), messageProcessingModel, securityModel, securityName, securityLevel, pdu, expectResponse, pduHandle, destAddress, outgoingMessage);
            if (status != 0) {
                throw new MessageException("Message processing model " + mp.getID() + " returned error: " + status);
            }
            byte[] messageBytes = outgoingMessage.getBuffer().array();
            this.sendMessage(transport, transportAddress, messageBytes);
            return pduHandle;
        }
        catch (IndexOutOfBoundsException iobex) {
            throw new MessageException("Unsupported message processing model: " + messageProcessingModel);
        }
        catch (MessageException mex) {
            if (logger.isDebugEnabled()) {
                mex.printStackTrace();
            }
            throw mex;
        }
        catch (IOException iox) {
            if (logger.isDebugEnabled()) {
                iox.printStackTrace();
            }
            throw new MessageException(iox.getMessage());
        }
    }

    protected void checkOutgoingMsg(Address transportAddress, int messageProcessingModel, PDU pdu) throws MessageException {
        if (this.checkOutgoingMsg && messageProcessingModel == 0 && pdu.getType() == -91) {
            logger.warn("Converting GETBULK PDU to GETNEXT for SNMPv1 target: " + transportAddress);
            pdu.setType(-95);
            pdu.setMaxRepetitions(0);
        }
    }

    public int returnResponsePdu(int messageProcessingModel, int securityModel, byte[] securityName, int securityLevel, PDU pdu, int maxSizeResponseScopedPDU, StateReference stateReference, StatusInformation statusInformation) throws MessageException {
        try {
            MessageProcessingModel mp = (MessageProcessingModel)this.mpm.get(messageProcessingModel);
            if (mp == null) {
                throw new MessageException("Unsupported message processing model: " + messageProcessingModel);
            }
            TransportMapping transport = stateReference.getTransportMapping();
            if (transport == null) {
                transport = this.getTransport(stateReference.getAddress());
            }
            if (transport == null) {
                throw new MessageException("Unsupported address class (transport mapping): " + stateReference.getAddress().getClass().getName());
            }
            BEROutputStream outgoingMessage = new BEROutputStream();
            int status = mp.prepareResponseMessage(messageProcessingModel, transport.getMaxInboundMessageSize(), securityModel, securityName, securityLevel, pdu, maxSizeResponseScopedPDU, stateReference, statusInformation, outgoingMessage);
            if (status == 0) {
                this.sendMessage(transport, stateReference.getAddress(), outgoingMessage.getBuffer().array());
            }
            return status;
        }
        catch (ArrayIndexOutOfBoundsException aex) {
            throw new MessageException("Unsupported message processing model: " + messageProcessingModel);
        }
        catch (IOException iox) {
            throw new MessageException(iox.getMessage());
        }
    }

    public void releaseStateReference(int messageProcessingModel, PduHandle pduHandle) {
        MessageProcessingModel mp = this.getMessageProcessingModel(messageProcessingModel);
        if (mp == null) {
            throw new IllegalArgumentException("Unsupported message processing model: " + messageProcessingModel);
        }
        mp.releaseStateReference(pduHandle);
    }

    public synchronized void removeCommandResponder(CommandResponder l) {
        if (this.commandResponderListeners != null && this.commandResponderListeners.contains(l)) {
            Vector v = (Vector)this.commandResponderListeners.clone();
            v.removeElement(l);
            this.commandResponderListeners = v;
        }
    }

    public synchronized void addCommandResponder(CommandResponder l) {
        Vector v;
        Vector vector = v = this.commandResponderListeners == null ? new Vector(2) : (Vector)this.commandResponderListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.commandResponderListeners = v;
        }
    }

    protected void fireProcessPdu(CommandResponderEvent e) {
        if (this.commandResponderListeners != null) {
            Vector listeners = this.commandResponderListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((CommandResponder)listeners.elementAt(i)).processPdu(e);
                if (!e.isProcessed()) continue;
                return;
            }
        }
    }

    public MessageProcessingModel getMessageProcessingModel(int messageProcessingModel) {
        return (MessageProcessingModel)this.mpm.get(messageProcessingModel);
    }

    public synchronized void removeCounterListener(CounterListener counterListener) {
        if (this.counterListeners != null && this.counterListeners.contains(counterListener)) {
            Vector v = (Vector)this.counterListeners.clone();
            v.removeElement(counterListener);
            this.counterListeners = v;
        }
    }

    public synchronized void addCounterListener(CounterListener counterListener) {
        Vector v;
        Vector vector = v = this.counterListeners == null ? new Vector(2) : (Vector)this.counterListeners.clone();
        if (!v.contains(counterListener)) {
            v.addElement(counterListener);
            this.counterListeners = v;
        }
    }

    protected void fireIncrementCounter(CounterEvent event) {
        if (this.counterListeners != null) {
            Vector listeners = this.counterListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((CounterListener)listeners.elementAt(i)).incrementCounter(event);
            }
        }
    }

    public void setCheckOutgoingMsg(boolean checkOutgoingMsg) {
        this.checkOutgoingMsg = checkOutgoingMsg;
    }

    public boolean isCheckOutgoingMsg() {
        return this.checkOutgoingMsg;
    }

    public synchronized void addAuthenticationFailureListener(AuthenticationFailureListener l) {
        Vector v;
        Vector vector = v = this.authenticationFailureListeners == null ? new Vector(2) : (Vector)this.authenticationFailureListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.authenticationFailureListeners = v;
        }
    }

    public synchronized void removeAuthenticationFailureListener(AuthenticationFailureListener l) {
        if (this.authenticationFailureListeners != null && this.authenticationFailureListeners.contains(l)) {
            Vector v = (Vector)this.authenticationFailureListeners.clone();
            v.removeElement(l);
            this.authenticationFailureListeners = v;
        }
    }

    protected void fireAuthenticationFailure(AuthenticationFailureEvent event) {
        if (this.authenticationFailureListeners != null) {
            Vector listeners = this.authenticationFailureListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((AuthenticationFailureListener)listeners.elementAt(i)).authenticationFailure(event);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

