/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import com.sun.jna.Platform;
import gnu.io.CommPortIdentifier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;

public class Native {
    private static String nativeLibraryPath = null;
    private static boolean unpacked;
    private static final String libraryName = "rxtxSerial";
    private static final Object finalizer;

    static {
        finalizer = new Object(){

            protected void finalize() {
                Native.deleteNativeLibrary();
            }
        };
    }

    public static void load() {
        try {
            System.loadLibrary(libraryName);
            nativeLibraryPath = libraryName;
        }
        catch (UnsatisfiedLinkError e) {
            Native.loadNativeLibraryFromJar();
        }
    }

    private static void loadNativeLibraryFromJar() {
        String libname = System.mapLibraryName(libraryName);
        String arch = System.getProperty("os.arch");
        String name = System.getProperty("os.name");
        String resourceName = String.valueOf(Native.getNativeLibraryResourcePath(Platform.getOSType(), arch, name)) + "/" + libname;
        URL url = CommPortIdentifier.class.getResource(resourceName);
        if (url == null && Platform.isMac() && resourceName.endsWith(".dylib")) {
            resourceName = String.valueOf(resourceName.substring(0, resourceName.lastIndexOf(".dylib"))) + ".jnilib";
            url = CommPortIdentifier.class.getResource(resourceName);
        }
        if (url == null) {
            throw new UnsatisfiedLinkError("rxtxSerial (" + resourceName + ") not found in resource path");
        }
        File lib = null;
        if (url.getProtocol().toLowerCase().equals("file")) {
            try {
                lib = new File(new URI(url.toString()));
            }
            catch (URISyntaxException e) {
                lib = new File(url.getPath());
            }
            if (!lib.exists()) {
                throw new Error("File URL " + url + " could not be properly decoded");
            }
        } else {
            InputStream is = Native.class.getResourceAsStream(resourceName);
            if (is == null) {
                throw new Error("Can't obtain rxtxSerial InputStream");
            }
            FileOutputStream fos = null;
            try {
                try {
                    int count;
                    lib = File.createTempFile("rxtx", Platform.isWindows() ? ".dll" : null);
                    lib.deleteOnExit();
                    ClassLoader cl = Native.class.getClassLoader();
                    if (Platform.deleteNativeLibraryAfterVMExit() && (cl == null || cl.equals(ClassLoader.getSystemClassLoader()))) {
                        Runtime.getRuntime().addShutdownHook(new DeleteNativeLibrary(lib));
                    }
                    fos = new FileOutputStream(lib);
                    byte[] buf = new byte[1024];
                    while ((count = is.read(buf, 0, buf.length)) > 0) {
                        fos.write(buf, 0, count);
                    }
                }
                catch (IOException e) {
                    throw new Error("Failed to create temporary file for rxtxSerial library: " + e);
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            unpacked = true;
        }
        System.load(lib.getAbsolutePath());
        nativeLibraryPath = lib.getAbsolutePath();
    }

    private static String getNativeLibraryResourcePath(int osType, String arch, String name) {
        String osPrefix;
        arch = arch.toLowerCase();
        switch (osType) {
            case 2: {
                if ("i386".equals(arch)) {
                    arch = "x86";
                }
                osPrefix = "win32-" + arch;
                break;
            }
            case 0: {
                osPrefix = "darwin";
                break;
            }
            case 1: {
                if ("x86".equals(arch)) {
                    arch = "i386";
                } else if ("x86_64".equals(arch)) {
                    arch = "amd64";
                }
                osPrefix = "linux-" + arch;
                break;
            }
            case 3: {
                osPrefix = "sunos-" + arch;
                break;
            }
            default: {
                int space;
                osPrefix = name.toLowerCase();
                if ("x86".equals(arch)) {
                    arch = "i386";
                }
                if ("x86_64".equals(arch)) {
                    arch = "amd64";
                }
                if ("powerpc".equals(arch)) {
                    arch = "ppc";
                }
                if ((space = osPrefix.indexOf(" ")) != -1) {
                    osPrefix = osPrefix.substring(0, space);
                }
                osPrefix = String.valueOf(osPrefix) + "-" + arch;
            }
        }
        return "/gnu/io/" + osPrefix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean deleteNativeLibrary() {
        String path = nativeLibraryPath;
        if (path == null) return true;
        if (!unpacked) {
            return true;
        }
        File flib = new File(path);
        if (flib.delete()) {
            nativeLibraryPath = null;
            unpacked = false;
            return true;
        }
        try {
            Object lib;
            String name;
            ClassLoader cl = Native.class.getClassLoader();
            Field f = ClassLoader.class.getDeclaredField("nativeLibraries");
            f.setAccessible(true);
            List libs = (List)f.get(cl);
            Iterator i = libs.iterator();
            do {
                if (!i.hasNext()) {
                    return false;
                }
                lib = i.next();
                f = lib.getClass().getDeclaredField("name");
                f.setAccessible(true);
            } while (!(name = (String)f.get(lib)).equals(path) && name.indexOf(path) == -1 && !name.equals(flib.getCanonicalPath()));
            Method m = lib.getClass().getDeclaredMethod("finalize", new Class[0]);
            m.setAccessible(true);
            m.invoke(lib, new Object[0]);
            nativeLibraryPath = null;
            if (!unpacked) return true;
            if (!flib.exists()) return true;
            if (!flib.delete()) return false;
            unpacked = false;
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static class DeleteNativeLibrary
    extends Thread {
        private final File file;

        public DeleteNativeLibrary(File file) {
            this.file = file;
        }

        @Override
        public void run() {
            if (!Native.deleteNativeLibrary()) {
                try {
                    Runtime.getRuntime().exec(new String[]{String.valueOf(System.getProperty("java.home")) + "/bin/java", "-cp", System.getProperty("java.class.path"), this.getClass().getName(), this.file.getAbsolutePath()});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public static void main(String[] args) {
            File file;
            if (args.length == 1 && (file = new File(args[0])).exists()) {
                long start = System.currentTimeMillis();
                while (!file.delete() && file.exists()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() - start <= 5000L) continue;
                    System.err.println("Could not remove temp file: " + file.getAbsolutePath());
                    break;
                }
            }
            System.exit(0);
        }
    }
}

