/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import com.sun.jna.Platform;
import gnu.io.CommPortIdentifier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;

public class Native {
    private static String nativeLibraryPath = null;
    private static boolean unpacked;
    private static final String libraryName = "rxtxSerial";
    private static final Object finalizer;

    public static void load() {
        try {
            System.loadLibrary(libraryName);
            nativeLibraryPath = libraryName;
        }
        catch (UnsatisfiedLinkError e) {
            Native.loadNativeLibraryFromJar();
        }
    }

    private static void loadNativeLibraryFromJar() {
        String libname = System.mapLibraryName(libraryName);
        String arch = System.getProperty("os.arch");
        String name = System.getProperty("os.name");
        String resourceName = Native.getNativeLibraryResourcePath(Platform.getOSType(), arch, name) + "/" + libname;
        URL url = CommPortIdentifier.class.getResource(resourceName);
        if (url == null && Platform.isMac() && resourceName.endsWith(".dylib")) {
            resourceName = resourceName.substring(0, resourceName.lastIndexOf(".dylib")) + ".jnilib";
            url = CommPortIdentifier.class.getResource(resourceName);
        }
        if (url == null) {
            throw new UnsatisfiedLinkError("rxtxSerial (" + resourceName + ") not found in resource path");
        }
        File lib = null;
        if (url.getProtocol().toLowerCase().equals("file")) {
            try {
                lib = new File(new URI(url.toString()));
            }
            catch (URISyntaxException e) {
                lib = new File(url.getPath());
            }
            if (!lib.exists()) {
                throw new Error("File URL " + url + " could not be properly decoded");
            }
        } else {
            InputStream is = Native.class.getResourceAsStream(resourceName);
            if (is == null) {
                throw new Error("Can't obtain rxtxSerial InputStream");
            }
            FileOutputStream fos = null;
            try {
                int count;
                lib = File.createTempFile("rxtx", Platform.isWindows() ? ".dll" : null);
                lib.deleteOnExit();
                ClassLoader cl = Native.class.getClassLoader();
                if (Platform.deleteNativeLibraryAfterVMExit() && (cl == null || cl.equals(ClassLoader.getSystemClassLoader()))) {
                    Runtime.getRuntime().addShutdownHook(new DeleteNativeLibrary(lib));
                }
                fos = new FileOutputStream(lib);
                byte[] buf = new byte[1024];
                while ((count = is.read(buf, 0, buf.length)) > 0) {
                    fos.write(buf, 0, count);
                }
            }
            catch (IOException e) {
                throw new Error("Failed to create temporary file for rxtxSerial library: " + e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                }
            }
            unpacked = true;
        }
        System.load(lib.getAbsolutePath());
        nativeLibraryPath = lib.getAbsolutePath();
    }

    private static String getNativeLibraryResourcePath(int osType, String arch, String name) {
        String osPrefix;
        arch = arch.toLowerCase();
        switch (osType) {
            case 2: {
                if ("i386".equals(arch)) {
                    arch = "x86";
                }
                osPrefix = "win32-" + arch;
                break;
            }
            case 0: {
                osPrefix = "darwin";
                break;
            }
            case 1: {
                if ("x86".equals(arch)) {
                    arch = "i386";
                } else if ("x86_64".equals(arch)) {
                    arch = "amd64";
                }
                osPrefix = "linux-" + arch;
                break;
            }
            case 3: {
                osPrefix = "sunos-" + arch;
                break;
            }
            default: {
                int space;
                osPrefix = name.toLowerCase();
                if ("x86".equals(arch)) {
                    arch = "i386";
                }
                if ("x86_64".equals(arch)) {
                    arch = "amd64";
                }
                if ("powerpc".equals(arch)) {
                    arch = "ppc";
                }
                if ((space = osPrefix.indexOf(" ")) != -1) {
                    osPrefix = osPrefix.substring(0, space);
                }
                osPrefix = osPrefix + "-" + arch;
            }
        }
        return "/gnu/io/" + osPrefix;
    }

    private static boolean deleteNativeLibrary() {
        String path = nativeLibraryPath;
        if (path == null || !unpacked) {
            return true;
        }
        File flib = new File(path);
        if (flib.delete()) {
            nativeLibraryPath = null;
            unpacked = false;
            return true;
        }
        try {
            ClassLoader cl = Native.class.getClassLoader();
            Field f = ClassLoader.class.getDeclaredField("nativeLibraries");
            f.setAccessible(true);
            List libs = (List)f.get(cl);
            for (Object lib : libs) {
                f = lib.getClass().getDeclaredField("name");
                f.setAccessible(true);
                String name = (String)f.get(lib);
                if (!name.equals(path) && name.indexOf(path) == -1 && !name.equals(flib.getCanonicalPath())) continue;
                Method m = lib.getClass().getDeclaredMethod("finalize", new Class[0]);
                m.setAccessible(true);
                m.invoke(lib, new Object[0]);
                nativeLibraryPath = null;
                if (unpacked && flib.exists()) {
                    if (flib.delete()) {
                        unpacked = false;
                        return true;
                    }
                    return false;
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static {
        finalizer = new Object(){

            protected void finalize() {
                Native.deleteNativeLibrary();
            }
        };
    }

    private static class DeleteNativeLibrary
    extends Thread {
        private final File file;

        public DeleteNativeLibrary(File file) {
            this.file = file;
        }

        public void run() {
            if (!Native.deleteNativeLibrary()) {
                try {
                    Runtime.getRuntime().exec(new String[]{System.getProperty("java.home") + "/bin/java", "-cp", System.getProperty("java.class.path"), this.getClass().getName(), this.file.getAbsolutePath()});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public static void main(String[] args) {
            File file;
            if (args.length == 1 && (file = new File(args[0])).exists()) {
                long start = System.currentTimeMillis();
                while (!file.delete() && file.exists()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() - start <= 5000L) continue;
                    System.err.println("Could not remove temp file: " + file.getAbsolutePath());
                    break;
                }
            }
            System.exit(0);
        }
    }
}

