/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.snmp;

import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.DefaultMOTableRow;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.snmp.DisplayStringScalar;
import org.snmp4j.agent.mo.snmp.EnumeratedScalar;
import org.snmp4j.agent.request.RequestStatus;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class UpsOutputGroup
implements MOGroup {
    private EnumeratedScalar upsOutputSource;
    private MOScalar upsOutputFrequency;
    private MOScalar upsOutputNumLines;
    private MOScalar upsSaidaLigada;
    private DisplayStringScalar upsOutputLigar;
    private UpsOutputEnumeratedScalar upsTipoConsumo;
    private UpsOutputDisplayStringScalar upsPeriodoConsumo;
    private DisplayStringScalar upsResultadoConsumo;
    public static final int colUpsOutputVoltage = 2;
    public static final int colUpsOutputCurrent = 3;
    public static final int colUpsOutputTruePower = 4;
    public static final int colUpsOutputPercentLoad = 5;
    public static final int colUpsOutputPoteciaAparente = 6;
    private static final int idxUpsOutputVoltage = 0;
    private static final int idxUpsOutputCurrent = 1;
    private static final int idxUpsOutputTruePower = 2;
    private static final int idxUpsOutputPercentLoad = 3;
    private static final int idxUpsOutputPotenciaAparente = 4;
    private static MOTableSubIndex[] upsOutputEntryIndexes = new MOTableSubIndex[]{new MOTableSubIndex(2, 0, Integer.MAX_VALUE)};
    private static MOTableIndex upsOutputEntryIndex = new MOTableIndex(upsOutputEntryIndexes, true);
    private DefaultMOTable upsOutputEntry;
    private DefaultMOMutableTableModel upsOutputEntryModel;
    private Integer32[] vr;
    private Integer32 outputNumLines;
    private Integer32 outputSource;
    private Integer32 outputFrequency;
    private Integer32 tipoConsumo;
    private Integer32 saidaLigada;
    private OctetString outputLigar;
    private OID linhaUsada;
    private OctetString resultadoConsumo;

    public UpsOutputGroup(int numLinhas, int linhaUsada) {
        this.linhaUsada = new OID(String.valueOf(linhaUsada));
        this.outputSource = new Integer32(2);
        this.upsOutputSource = new EnumeratedScalar(new OID("1.3.6.1.2.1.33.1.4.1.0"), MOAccessImpl.ACCESS_READ_ONLY, this.outputSource, new int[]{1, 2, 3, 4, 5, 6, 7});
        this.outputFrequency = new Integer32(0);
        this.upsOutputFrequency = new MOScalar(new OID("1.3.6.1.2.1.33.1.4.2.0"), MOAccessImpl.ACCESS_READ_ONLY, this.outputFrequency);
        this.saidaLigada = new Integer32(0);
        this.upsSaidaLigada = new MOScalar(new OID("1.3.6.1.2.1.33.1.4.9.0"), MOAccessImpl.ACCESS_READ_ONLY, this.saidaLigada);
        this.outputNumLines = new Integer32(numLinhas);
        this.upsOutputNumLines = new MOScalar(new OID("1.3.6.1.2.1.33.1.4.3.0"), MOAccessImpl.ACCESS_READ_ONLY, this.outputNumLines);
        this.vr = new Integer32[5];
        int i = 0;
        while (i < this.vr.length) {
            this.vr[i] = new Integer32(0);
            ++i;
        }
        MOColumn[] upsOutputEntryColumns = new MOMutableColumn[this.vr.length];
        upsOutputEntryColumns[0] = new MOMutableColumn(2, 2, MOAccessImpl.ACCESS_READ_ONLY);
        upsOutputEntryColumns[1] = new MOMutableColumn(3, 2, MOAccessImpl.ACCESS_READ_ONLY);
        upsOutputEntryColumns[2] = new MOMutableColumn(4, 2, MOAccessImpl.ACCESS_READ_ONLY);
        upsOutputEntryColumns[3] = new MOMutableColumn(5, 2, MOAccessImpl.ACCESS_READ_ONLY);
        upsOutputEntryColumns[4] = new MOMutableColumn(6, 2, MOAccessImpl.ACCESS_READ_ONLY);
        this.upsOutputEntry = new DefaultMOTable(new OID("1.3.6.1.2.1.33.1.4.4.1"), upsOutputEntryIndex, upsOutputEntryColumns);
        this.upsOutputEntryModel = new DefaultMOMutableTableModel();
        this.upsOutputEntry.setModel(this.upsOutputEntryModel);
        this.outputLigar = new OctetString("true");
        this.upsOutputLigar = new DisplayStringScalar(new OID("1.3.6.1.2.1.33.1.4.5.0"), MOAccessImpl.ACCESS_READ_ONLY, this.outputLigar);
        this.tipoConsumo = new Integer32(1);
        this.upsTipoConsumo = new UpsOutputEnumeratedScalar(new OID("1.3.6.1.2.1.33.1.4.6.0"), MOAccessImpl.ACCESS_READ_WRITE, this.tipoConsumo, new int[]{1, 2, 3, 4});
        this.upsPeriodoConsumo = new UpsOutputDisplayStringScalar(new OID("1.3.6.1.2.1.33.1.4.7.0"), MOAccessImpl.ACCESS_READ_WRITE, new OctetString(""), 0, 32);
        this.resultadoConsumo = new OctetString("");
        this.upsResultadoConsumo = new DisplayStringScalar(new OID("1.3.6.1.2.1.33.1.4.8.0"), MOAccessImpl.ACCESS_READ_ONLY, this.resultadoConsumo);
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.upsOutputSource, context);
        server.register(this.upsOutputFrequency, context);
        server.register(this.upsOutputNumLines, context);
        server.register(this.upsOutputEntry, context);
        server.register(this.upsOutputLigar, context);
        server.register(this.upsTipoConsumo, context);
        server.register(this.upsPeriodoConsumo, context);
        server.register(this.upsResultadoConsumo, context);
        server.register(this.upsSaidaLigada, context);
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.upsOutputSource, context);
        server.unregister(this.upsOutputFrequency, context);
        server.unregister(this.upsOutputNumLines, context);
        server.unregister(this.upsOutputEntry, context);
        server.unregister(this.upsOutputLigar, context);
        server.unregister(this.upsTipoConsumo, context);
        server.unregister(this.upsPeriodoConsumo, context);
        server.unregister(this.upsResultadoConsumo, context);
        server.unregister(this.upsSaidaLigada, context);
    }

    public void addUpsOutputEntry(int index, int outputVoltage, int outputCurrent, int outputTruePower, int outputPercentLoad, int outputPotenciaAparente) {
        this.linhaUsada.setValue(String.valueOf(index));
        this.vr[0].setValue(outputVoltage);
        this.vr[1].setValue(outputCurrent);
        this.vr[2].setValue(outputTruePower);
        this.vr[3].setValue(outputPercentLoad);
        this.vr[4].setValue(outputPotenciaAparente);
        DefaultMOTableRow row = new DefaultMOTableRow(new OID(String.valueOf(index)), this.vr);
        this.upsOutputEntryModel.addRow(row);
    }

    public MOTableRow removeUpsOutputEntry(OID index) {
        return this.upsOutputEntryModel.removeRow(index);
    }

    public void setUpsOutputLigar(String vr) {
        this.outputLigar.setValue(vr);
        this.upsOutputLigar.setValue(this.outputLigar);
    }

    public String getUpsOutputLigar() {
        return this.upsOutputLigar.getValue().toString();
    }

    public UpsOutputEnumeratedScalar getUpsTipoHisConsumo() {
        return this.upsTipoConsumo;
    }

    public void setsUpsResultadoConsumo(String s) {
        this.resultadoConsumo.setValue(s);
        this.upsResultadoConsumo.setValue(this.resultadoConsumo);
    }

    public UpsOutputDisplayStringScalar getUpsPeriodoConsumo() {
        return this.upsPeriodoConsumo;
    }

    public Integer32 getUpsOutputFrequency() {
        return (Integer32)this.upsOutputFrequency.getValue();
    }

    public void setUpsOutputFrequency(int upsOutputFrequency) {
        this.outputFrequency.setValue(upsOutputFrequency);
        this.upsOutputFrequency.setValue(this.outputFrequency);
    }

    public Integer32 getUpsSaidaLigada() {
        return (Integer32)this.upsSaidaLigada.getValue();
    }

    public void setUpsSaidaLigada(int upsSaidaLigada) {
        this.saidaLigada.setValue(upsSaidaLigada);
        this.upsSaidaLigada.setValue(this.saidaLigada);
    }

    public Integer32 getUpsOutputNumLines() {
        return (Integer32)this.upsOutputNumLines.getValue();
    }

    public void setUpsOutputNumLines(int upsOutputNumLines) {
        this.outputNumLines.setValue(upsOutputNumLines);
        this.upsOutputNumLines.setValue(this.outputNumLines);
    }

    public Integer32 getUpsOutputSource() {
        return (Integer32)this.upsOutputSource.getValue();
    }

    public void setUpsOutputSource(int upsOutputSource) {
        this.outputSource.setValue(upsOutputSource);
        this.upsOutputSource.setValue(this.outputSource);
    }

    public MOTableRow getUpsOutputRow(OID index) {
        return this.upsOutputEntryModel.getRow(index);
    }

    public class UpsOutputDisplayStringScalar
    extends DisplayStringScalar {
        public boolean atualizacao;

        public UpsOutputDisplayStringScalar(OID oid, MOAccess access, OctetString value, int minSize, int maxSize) {
            super(oid, access, value, minSize, maxSize);
            this.atualizacao = false;
        }

        @Override
        public void commit(SubRequest request) {
            RequestStatus status = request.getStatus();
            VariableBinding vb = request.getVariableBinding();
            request.setUndoValue(this.getValue());
            this.setValue(vb.getVariable());
            status.setPhaseComplete(true);
            this.atualizacao = true;
        }

        @Override
        public void undo(SubRequest request) {
            RequestStatus status = request.getStatus();
            if (request.getUndoValue() != null && request.getUndoValue() instanceof Variable) {
                int errorStatus = this.setValue((Variable)request.getUndoValue());
                status.setErrorStatus(errorStatus);
                status.setPhaseComplete(true);
                this.atualizacao = true;
            } else {
                status.setErrorStatus(15);
            }
        }

        public boolean getAtualizacao() {
            return this.atualizacao;
        }

        public void setAtualizacao(boolean valor) {
            this.atualizacao = valor;
        }
    }

    public class UpsOutputEnumeratedScalar
    extends EnumeratedScalar {
        private boolean atualizacao;

        public UpsOutputEnumeratedScalar(OID arg0, MOAccess arg1, Integer32 arg2, int[] arg3) {
            super(arg0, arg1, arg2, arg3);
            this.atualizacao = false;
        }

        @Override
        public void commit(SubRequest request) {
            RequestStatus status = request.getStatus();
            VariableBinding vb = request.getVariableBinding();
            request.setUndoValue(this.getValue());
            this.setValue(vb.getVariable());
            status.setPhaseComplete(true);
            this.atualizacao = true;
        }

        @Override
        public void undo(SubRequest request) {
            RequestStatus status = request.getStatus();
            if (request.getUndoValue() != null && request.getUndoValue() instanceof Variable) {
                int errorStatus = this.setValue((Variable)request.getUndoValue());
                status.setErrorStatus(errorStatus);
                status.setPhaseComplete(true);
                this.atualizacao = true;
            } else {
                status.setErrorStatus(15);
            }
        }

        public boolean getAtualizacao() {
            return this.atualizacao;
        }

        public void setAtualizacao(boolean valor) {
            this.atualizacao = valor;
        }
    }
}

