/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.snmp;

import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.DefaultMOTableRow;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.snmp.DisplayStringScalar;
import org.snmp4j.agent.mo.snmp.EnumeratedScalar;
import org.snmp4j.agent.request.RequestStatus;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class UpsInputGroup
implements MOGroup {
    private MOScalar upsInputLineBads;
    private MOScalar upsInputNumLines;
    private UpsInputDisplayStringScalar upsInputLigar;
    public static final int colUpsInputFrequency = 2;
    public static final int colUpsInputVoltage = 3;
    public static final int colUpsInputCurrent = 4;
    public static final int colUpsInputTruePower = 5;
    public static final int colUpsInputPotenciaAparente = 6;
    private static final int idxUpsInputFrequency = 0;
    private static final int idxUpsInputVoltage = 1;
    private static final int idxUpsInputCurrent = 2;
    private static final int idxUpsInputTruePower = 3;
    private static final int idxUpsInputPotenciaAparente = 4;
    private static MOTableSubIndex[] upsInputEntryIndexes = new MOTableSubIndex[]{new MOTableSubIndex(2, 1, Integer.MAX_VALUE)};
    private static MOTableIndex upsInputEntryIndex = new MOTableIndex(upsInputEntryIndexes, true);
    private DefaultMOTable upsInputEntry;
    private DefaultMOMutableTableModel upsInputEntryModel;
    private OID linhaUsada;
    private Integer32[] vrTabela;
    private Counter32 inputLineBads;
    private OctetString inputLigar;

    public UpsInputGroup(String modeloUps, int numLinhas, int linhaUsada) {
        this.linhaUsada = new OID(String.valueOf(linhaUsada));
        this.inputLineBads = new Counter32(0L);
        this.upsInputLineBads = new MOScalar(new OID("1.3.6.1.2.1.33.1.3.1.0"), MOAccessImpl.ACCESS_READ_ONLY, this.inputLineBads);
        this.upsInputNumLines = new MOScalar(new OID("1.3.6.1.2.1.33.1.3.2.0"), MOAccessImpl.ACCESS_READ_ONLY, new Integer32(numLinhas));
        this.inputLigar = new OctetString("");
        this.upsInputLigar = new UpsInputDisplayStringScalar(new OID("1.3.6.1.2.1.33.1.3.4.0"), MOAccessImpl.ACCESS_READ_WRITE, this.inputLigar, 0, 5);
        this.vrTabela = new Integer32[5];
        int i = 0;
        while (i < this.vrTabela.length) {
            this.vrTabela[i] = new Integer32();
            ++i;
        }
        MOColumn[] upsInputEntryColumns = new MOMutableColumn[this.vrTabela.length];
        upsInputEntryColumns[0] = new MOMutableColumn(2, 2, MOAccessImpl.ACCESS_READ_ONLY);
        upsInputEntryColumns[1] = new MOMutableColumn(3, 2, MOAccessImpl.ACCESS_READ_ONLY);
        upsInputEntryColumns[2] = new MOMutableColumn(4, 2, MOAccessImpl.ACCESS_READ_ONLY);
        upsInputEntryColumns[3] = new MOMutableColumn(5, 2, MOAccessImpl.ACCESS_READ_ONLY);
        upsInputEntryColumns[4] = new MOMutableColumn(6, 2, MOAccessImpl.ACCESS_READ_ONLY);
        this.upsInputEntry = new DefaultMOTable(new OID("1.3.6.1.2.1.33.1.3.3.1"), upsInputEntryIndex, upsInputEntryColumns);
        this.upsInputEntryModel = new DefaultMOMutableTableModel();
        this.upsInputEntry.setModel(this.upsInputEntryModel);
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.upsInputLineBads, context);
        server.register(this.upsInputNumLines, context);
        server.register(this.upsInputLigar, context);
        server.register(this.upsInputEntry, context);
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.upsInputLineBads, context);
        server.unregister(this.upsInputNumLines, context);
        server.unregister(this.upsInputLigar, context);
        server.unregister(this.upsInputEntry, context);
    }

    public void incrementUpsInputLineBads() {
        this.inputLineBads.increment();
        this.upsInputLineBads.setValue(this.inputLineBads);
    }

    public void addUpsInputEntry(int index, int inputFrequency, int inputVoltage, int inputCurrent, int inputTruePower, int inputPotenciaAparente) {
        this.linhaUsada.setValue(String.valueOf(index));
        this.vrTabela[0].setValue(inputFrequency);
        this.vrTabela[1].setValue(inputVoltage);
        this.vrTabela[2].setValue(inputCurrent);
        this.vrTabela[3].setValue(inputTruePower);
        this.vrTabela[4].setValue(inputPotenciaAparente);
        DefaultMOTableRow row = new DefaultMOTableRow(this.linhaUsada, this.vrTabela);
        this.upsInputEntryModel.addRow(row);
    }

    public MOTableRow removeUpsInputEntry(OID index) {
        return this.upsInputEntryModel.removeRow(index);
    }

    public void setUpsInputLigar(String vr) {
        this.inputLigar.setValue(vr);
        this.upsInputLigar.setValue(this.inputLigar);
    }

    public UpsInputDisplayStringScalar getUpsInputLigar() {
        return this.upsInputLigar;
    }

    public Counter32 getUpsInputLineBads() {
        return (Counter32)this.upsInputLineBads.getValue();
    }

    public void setUpsInputLineBads(long valor) {
        this.upsInputLineBads.setValue(new Counter32(valor));
    }

    public Integer32 getUpsInputNumLines() {
        return (Integer32)this.upsInputNumLines.getValue();
    }

    public void setUpsInputNumLines(Integer32 upsInputNumLines) {
        this.upsInputNumLines.setValue(upsInputNumLines);
    }

    public MOTableRow getUpsInputRow(int index) {
        this.linhaUsada.setValue(String.valueOf(index));
        return this.upsInputEntryModel.getRow(this.linhaUsada);
    }

    class UpsInputDisplayStringScalar
    extends DisplayStringScalar {
        public boolean atualizacao;

        public UpsInputDisplayStringScalar(OID oid, MOAccess access, OctetString value, int minSize, int maxSize) {
            super(oid, access, value, minSize, maxSize);
            this.atualizacao = false;
        }

        @Override
        public void commit(SubRequest request) {
            RequestStatus status = request.getStatus();
            VariableBinding vb = request.getVariableBinding();
            request.setUndoValue(this.getValue());
            this.setValue(vb.getVariable());
            status.setPhaseComplete(true);
            this.atualizacao = true;
        }

        @Override
        public void undo(SubRequest request) {
            RequestStatus status = request.getStatus();
            if (request.getUndoValue() != null && request.getUndoValue() instanceof Variable) {
                int errorStatus = this.setValue((Variable)request.getUndoValue());
                status.setErrorStatus(errorStatus);
                status.setPhaseComplete(true);
                this.atualizacao = true;
            } else {
                status.setErrorStatus(15);
            }
        }

        public boolean getAtualizacao() {
            return this.atualizacao;
        }

        public void setAtualizacao(boolean valor) {
            this.atualizacao = valor;
        }
    }

    class UpsInputEnumeratedScalar
    extends EnumeratedScalar {
        private boolean atualizacao;

        public UpsInputEnumeratedScalar(OID arg0, MOAccess arg1, Integer32 arg2, int[] arg3) {
            super(arg0, arg1, arg2, arg3);
            this.atualizacao = false;
        }

        @Override
        public void commit(SubRequest request) {
            RequestStatus status = request.getStatus();
            VariableBinding vb = request.getVariableBinding();
            request.setUndoValue(this.getValue());
            this.setValue(vb.getVariable());
            status.setPhaseComplete(true);
            this.atualizacao = true;
        }

        @Override
        public void undo(SubRequest request) {
            RequestStatus status = request.getStatus();
            if (request.getUndoValue() != null && request.getUndoValue() instanceof Variable) {
                int errorStatus = this.setValue((Variable)request.getUndoValue());
                status.setErrorStatus(errorStatus);
                status.setPhaseComplete(true);
                this.atualizacao = true;
            } else {
                status.setErrorStatus(15);
            }
        }

        public boolean getAtualizacao() {
            return this.atualizacao;
        }

        public void setAtualizacao(boolean valor) {
            this.atualizacao = valor;
        }
    }
}

