/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.snmp;

import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.snmp.DisplayStringScalar;
import org.snmp4j.agent.request.RequestStatus;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class UpsIdentGroup
implements MOGroup {
    private DisplayStringScalar upsIdentManufacter;
    private DisplayStringScalar upsIdentModel;
    private DisplayStringScalar upsIdentUPSSoftwareVersion;
    private DisplayStringScalar upsIdentAgentSoftwareVersion;
    private UpsIdentDisplayStringScalar upsIdentName;
    private UpsIdentDisplayStringScalar upsIdentAttachedDevices;
    private UpsIdentMOScalar upsPortaPedidos;

    public UpsIdentGroup(String identManufactor, String model, String upsSoftwareVersion, String agentSoftwareVersion) {
        this.upsIdentManufacter = new DisplayStringScalar(new OID("1.3.6.1.2.1.33.1.1.1.0"), MOAccessImpl.ACCESS_READ_ONLY, new OctetString(identManufactor), 0, 31);
        this.upsIdentModel = new DisplayStringScalar(new OID("1.3.6.1.2.1.33.1.1.2.0"), MOAccessImpl.ACCESS_READ_ONLY, new OctetString(model), 0, 31);
        this.upsIdentUPSSoftwareVersion = new DisplayStringScalar(new OID("1.3.6.1.2.1.33.1.1.3.0"), MOAccessImpl.ACCESS_READ_ONLY, new OctetString(upsSoftwareVersion), 0, 63);
        this.upsIdentAgentSoftwareVersion = new DisplayStringScalar(new OID("1.3.6.1.2.1.33.1.1.4.0"), MOAccessImpl.ACCESS_READ_ONLY, new OctetString(agentSoftwareVersion), 0, 63);
        this.upsIdentName = new UpsIdentDisplayStringScalar(new OID("1.3.6.1.2.1.33.1.1.5.0"), MOAccessImpl.ACCESS_READ_WRITE, new OctetString(""), 0, 63);
        this.upsIdentAttachedDevices = new UpsIdentDisplayStringScalar(new OID("1.3.6.1.2.1.33.1.1.6.0"), MOAccessImpl.ACCESS_READ_WRITE, new OctetString(""), 0, 63);
        this.upsPortaPedidos = new UpsIdentMOScalar(new OID("1.3.6.1.2.1.33.1.1.7.0"), MOAccessImpl.ACCESS_READ_WRITE, new Integer32(-1));
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.upsIdentManufacter, context);
        server.register(this.upsIdentModel, context);
        server.register(this.upsIdentUPSSoftwareVersion, context);
        server.register(this.upsIdentAgentSoftwareVersion, context);
        server.register(this.upsIdentName, context);
        server.register(this.upsIdentAttachedDevices, context);
        server.register(this.upsPortaPedidos, context);
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.upsIdentManufacter, context);
        server.unregister(this.upsIdentModel, context);
        server.unregister(this.upsIdentUPSSoftwareVersion, context);
        server.unregister(this.upsIdentAgentSoftwareVersion, context);
        server.unregister(this.upsIdentName, context);
        server.unregister(this.upsIdentAttachedDevices, context);
        server.unregister(this.upsPortaPedidos, context);
    }

    public OctetString getUpsIdentAgentSoftwareVersion() {
        return (OctetString)this.upsIdentAgentSoftwareVersion.getValue();
    }

    public void setUpsIdentAgentSoftwareVersion(OctetString upsIdentAgentSoftwareVersion) {
        this.upsIdentAgentSoftwareVersion.setValue(upsIdentAgentSoftwareVersion);
    }

    public UpsIdentDisplayStringScalar getUpsIdentAttachedDevices() {
        return this.upsIdentAttachedDevices;
    }

    public void setUpsIdentAttachedDevices(OctetString upsIdentAttachedDevices) {
        this.upsIdentAttachedDevices.setValue(upsIdentAttachedDevices);
    }

    public void setUpsIdentAttachedDevicesAtualizacao(boolean valor) {
        this.upsIdentAttachedDevices.setAtualizacao(valor);
    }

    public OctetString getUpsIdentManufacter() {
        return (OctetString)this.upsIdentManufacter.getValue();
    }

    public void setUpsIdentManufacter(OctetString upsIdentManufacter) {
        this.upsIdentManufacter.setValue(upsIdentManufacter);
    }

    public OctetString getUpsIdentModel() {
        return (OctetString)this.upsIdentModel.getValue();
    }

    public void setUpsIdentModel(OctetString upsIdentModel) {
        this.upsIdentModel.setValue(upsIdentModel);
    }

    public UpsIdentDisplayStringScalar getUpsIdentName() {
        return this.upsIdentName;
    }

    public void setUpsIdentName(OctetString upsIdentName) {
        this.upsIdentName.setValue(upsIdentName);
    }

    public void setUpsIdentNameAtulizacao(boolean valor) {
        this.upsIdentName.setAtualizacao(valor);
    }

    public OctetString getUpsIdentUPSSoftwareVersion() {
        return (OctetString)this.upsIdentUPSSoftwareVersion.getValue();
    }

    public void setUpsIdentUPSSoftwareVersion(OctetString upsIdentUPSSoftwareVersion) {
        this.upsIdentUPSSoftwareVersion.setValue(upsIdentUPSSoftwareVersion);
    }

    public UpsIdentMOScalar getUpsPortaPedidos() {
        return this.upsPortaPedidos;
    }

    public void setUpsPortaPedidos(int upsPortaPedidos) {
        this.upsPortaPedidos.setValue(new Integer32(upsPortaPedidos));
    }

    class UpsIdentDisplayStringScalar
    extends DisplayStringScalar {
        public boolean atualizacao;

        public UpsIdentDisplayStringScalar(OID oid, MOAccess access, OctetString value, int minSize, int maxSize) {
            super(oid, access, value, minSize, maxSize);
            this.atualizacao = false;
        }

        @Override
        public void commit(SubRequest request) {
            RequestStatus status = request.getStatus();
            VariableBinding vb = request.getVariableBinding();
            request.setUndoValue(this.getValue());
            this.setValue(vb.getVariable());
            status.setPhaseComplete(true);
            this.atualizacao = true;
        }

        @Override
        public void undo(SubRequest request) {
            RequestStatus status = request.getStatus();
            if (request.getUndoValue() != null && request.getUndoValue() instanceof Variable) {
                int errorStatus = this.setValue((Variable)request.getUndoValue());
                status.setErrorStatus(errorStatus);
                status.setPhaseComplete(true);
                this.atualizacao = true;
            } else {
                status.setErrorStatus(15);
            }
        }

        public boolean getAtualizacao() {
            return this.atualizacao;
        }

        public void setAtualizacao(boolean valor) {
            this.atualizacao = valor;
        }
    }

    class UpsIdentMOScalar
    extends MOScalar {
        private boolean atualizacao;

        public UpsIdentMOScalar(OID arg0, MOAccess arg1, Variable arg2) {
            super(arg0, arg1, arg2);
            this.atualizacao = false;
        }

        @Override
        public void commit(SubRequest request) {
            RequestStatus status = request.getStatus();
            VariableBinding vb = request.getVariableBinding();
            request.setUndoValue(this.getValue());
            this.setValue(vb.getVariable());
            status.setPhaseComplete(true);
            this.atualizacao = true;
        }

        @Override
        public void undo(SubRequest request) {
            RequestStatus status = request.getStatus();
            if (request.getUndoValue() != null && request.getUndoValue() instanceof Variable) {
                int errorStatus = this.setValue((Variable)request.getUndoValue());
                status.setErrorStatus(errorStatus);
                status.setPhaseComplete(true);
                this.atualizacao = true;
            } else {
                status.setErrorStatus(15);
            }
        }

        public boolean getAtualizacao() {
            return this.atualizacao;
        }

        public void setAtualizacao(boolean valor) {
            this.atualizacao = valor;
        }
    }
}

