/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.snmp;

import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.DefaultMOTableRow;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.snmp.DisplayStringScalar;
import org.snmp4j.agent.request.RequestStatus;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class UpsBypassGroup
implements MOGroup {
    private MOScalar upsBypassFrequency;
    private MOScalar upsBypassNumLines;
    private UpsBypassDisplayStringScalar upsBypassAtivar;
    public static final int colUpsBypassVoltage = 2;
    public static final int colUpsBypassCurrent = 3;
    public static final int colUpsBypassPower = 4;
    private static final int idxUpsBypassVoltage = 0;
    private static final int idxUpsBypassCurrent = 1;
    private static final int idxUpsBypassPower = 2;
    private static MOTableSubIndex[] upsBypassEntryIndexes = new MOTableSubIndex[]{new MOTableSubIndex(2, 1, Integer.MAX_VALUE)};
    private static MOTableIndex upsBypassEntryIndex = new MOTableIndex(upsBypassEntryIndexes, true);
    private DefaultMOTable upsBypassEntry;
    private DefaultMOMutableTableModel upsBypassEntryModel;
    private Integer32[] vr;
    private OID linhaUsada = new OID("1");
    private OctetString bypassAtivar;

    public UpsBypassGroup() {
        this.vr = new Integer32[3];
        int i = 0;
        while (i < this.vr.length) {
            this.vr[i] = new Integer32(0);
            ++i;
        }
        this.upsBypassFrequency = new MOScalar(new OID("1.3.6.1.2.1.33.1.5.1.0"), MOAccessImpl.ACCESS_READ_ONLY, new Integer32(0));
        this.upsBypassNumLines = new MOScalar(new OID("1.3.6.1.2.1.33.1.5.2.0"), MOAccessImpl.ACCESS_READ_ONLY, new Integer32(1));
        this.bypassAtivar = new OctetString("");
        this.upsBypassAtivar = new UpsBypassDisplayStringScalar(new OID("1.3.6.1.2.1.33.1.5.4.0"), MOAccessImpl.ACCESS_READ_WRITE, this.bypassAtivar, 0, 5);
        MOColumn[] upsBypassEntryColumns = new MOMutableColumn[this.vr.length];
        upsBypassEntryColumns[0] = new MOMutableColumn(2, 2, MOAccessImpl.ACCESS_READ_ONLY);
        upsBypassEntryColumns[1] = new MOMutableColumn(3, 2, MOAccessImpl.ACCESS_READ_ONLY);
        upsBypassEntryColumns[2] = new MOMutableColumn(4, 2, MOAccessImpl.ACCESS_READ_ONLY);
        this.upsBypassEntry = new DefaultMOTable(new OID("1.3.6.1.2.1.33.1.5.3.1"), upsBypassEntryIndex, upsBypassEntryColumns);
        this.upsBypassEntryModel = new DefaultMOMutableTableModel();
        this.upsBypassEntry.setModel(this.upsBypassEntryModel);
        this.addUpsBypassEntry(1, 0, 0, 0);
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.upsBypassFrequency, context);
        server.register(this.upsBypassNumLines, context);
        server.register(this.upsBypassAtivar, context);
        server.register(this.upsBypassEntry, context);
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.upsBypassFrequency, context);
        server.unregister(this.upsBypassNumLines, context);
        server.unregister(this.upsBypassAtivar, context);
        server.unregister(this.upsBypassEntry, context);
    }

    public void addUpsBypassEntry(int index, int bypassVoltage, int bypassCurrent, int bypassPower) {
        this.linhaUsada.setValue(String.valueOf(index));
        this.vr[0].setValue(bypassVoltage);
        this.vr[1].setValue(bypassCurrent);
        this.vr[2].setValue(bypassPower);
        DefaultMOTableRow row = new DefaultMOTableRow(new OID(String.valueOf(index)), this.vr);
        this.upsBypassEntryModel.addRow(row);
    }

    public MOTableRow removeUpsBypassEntry(OID index) {
        return this.upsBypassEntryModel.removeRow(index);
    }

    public int getUpsBypassFrequency() {
        return this.upsBypassFrequency.getValue().toInt();
    }

    public int getUpsBypassNumLines() {
        return this.upsBypassNumLines.getValue().toInt();
    }

    public void setUpsBypassNumLines(Integer32 upsBypassNumLines) {
        this.upsBypassNumLines.setValue(upsBypassNumLines);
    }

    public MOTableRow getUpsBypassRow(OID index) {
        return this.upsBypassEntryModel.getRow(index);
    }

    public UpsBypassDisplayStringScalar getUpsBypassAtivar() {
        return this.upsBypassAtivar;
    }

    public void setUpsBypassAtivar(String upsBypassAtivar) {
        this.bypassAtivar.setValue(upsBypassAtivar);
        this.upsBypassAtivar.setValue(this.bypassAtivar);
    }

    public void setUpsBypassFrequency(int upsBypassFrequency) {
        this.upsBypassFrequency.setValue(new Integer32(upsBypassFrequency));
    }

    public void setUpsBypassNumLines(int upsNumLines) {
        this.upsBypassNumLines.setValue(new Integer32(upsNumLines));
    }

    class UpsBypassDisplayStringScalar
    extends DisplayStringScalar {
        public boolean atualizacao;

        public UpsBypassDisplayStringScalar(OID oid, MOAccess access, OctetString value, int minSize, int maxSize) {
            super(oid, access, value, minSize, maxSize);
            this.atualizacao = false;
        }

        @Override
        public void commit(SubRequest request) {
            RequestStatus status = request.getStatus();
            VariableBinding vb = request.getVariableBinding();
            request.setUndoValue(this.getValue());
            this.setValue(vb.getVariable());
            status.setPhaseComplete(true);
            this.atualizacao = true;
        }

        @Override
        public void undo(SubRequest request) {
            RequestStatus status = request.getStatus();
            if (request.getUndoValue() != null && request.getUndoValue() instanceof Variable) {
                int errorStatus = this.setValue((Variable)request.getUndoValue());
                status.setErrorStatus(errorStatus);
                status.setPhaseComplete(true);
                this.atualizacao = true;
            } else {
                status.setErrorStatus(15);
            }
        }

        public boolean getAtualizacao() {
            return this.atualizacao;
        }

        public void setAtualizacao(boolean valor) {
            this.atualizacao = valor;
        }
    }
}

