/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.snmp;

import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.snmp.AutonomousType;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;

public class UpsAlarmGroup
implements MOGroup {
    private MOScalar upsAlarmsPresent = new MOScalar(new OID("1.3.6.1.2.1.33.1.6.1.0"), MOAccessImpl.ACCESS_READ_ONLY, new Gauge32(0L));
    private static final int colUpsAlarmDescr = 2;
    private static final int colUpsAlarmTime = 3;
    private static final int idxUpaAlarmDescr = 0;
    private static final int idxUpaAlarmTime = 1;
    private static MOTableSubIndex[] upsAlarmEntryIndexes = new MOTableSubIndex[]{new MOTableSubIndex(2, 1, 24)};
    private static MOTableIndex upsAlarmEntryIndex = new MOTableIndex(upsAlarmEntryIndexes, false);
    private DefaultMOTable upsAlarmEntry;
    private DefaultMOMutableTableModel upsAlarmEntryModel;
    private int numAlarmesAtivos = 0;

    public UpsAlarmGroup() {
        MOColumn[] upsAlarmEntryColumns = new MOColumn[]{new AutonomousType(2, MOAccessImpl.ACCESS_READ_ONLY, new OID(), false), new MOColumn(3, 67, MOAccessImpl.ACCESS_READ_ONLY)};
        this.upsAlarmEntry = new DefaultMOTable(new OID("1.3.6.1.2.1.33.1.6.2.1"), upsAlarmEntryIndex, upsAlarmEntryColumns);
        this.upsAlarmEntryModel = (DefaultMOMutableTableModel)this.upsAlarmEntry.getModel();
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.upsAlarmsPresent, context);
        server.register(this.upsAlarmEntry, context);
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.upsAlarmsPresent, context);
        server.unregister(this.upsAlarmEntry, context);
    }

    public Gauge32 getUpsAlarmsPresent() {
        return (Gauge32)this.upsAlarmsPresent.getValue();
    }

    public void setUpsAlarmsPresent(Gauge32 upsAlarmsPresent) {
        this.upsAlarmsPresent.setValue(upsAlarmsPresent);
    }

    public void addUpsAlarmEntry(int alarmId, String alarmDescr, long alarmTime) {
        this.upsAlarmEntryModel.addRow(new DefaultMOMutableRow2PC(new OID(String.valueOf(alarmId)), new Variable[]{new OID(alarmDescr), new TimeTicks(alarmTime)}));
        this.addNumAlarmesAtivos();
    }

    public MOTableRow removeUpsAlarmEntry(int index) {
        this.dimNumAlarmesAtivos();
        return this.upsAlarmEntryModel.removeRow(new OID(String.valueOf(index)));
    }

    public MOTableRow getUpsAlarmRow(int index) {
        return this.upsAlarmEntryModel.getRow(new OID(String.valueOf(index)));
    }

    public void addNumAlarmesAtivos() {
        this.numAlarmesAtivos = this.numAlarmesAtivos < 25 ? ++this.numAlarmesAtivos : ++this.numAlarmesAtivos;
    }

    public void dimNumAlarmesAtivos() {
        if (this.numAlarmesAtivos != 0) {
            --this.numAlarmesAtivos;
        }
    }

    public int getNumAlarmesAtivos() {
        return this.numAlarmesAtivos;
    }
}

