/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.snmp;

import java.io.File;
import java.io.IOException;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.BaseAgent;
import org.snmp4j.agent.CommandProcessor;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.TransportDomains;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class AgenteSNMP
extends BaseAgent {
    protected UdpAddress localUdpAddress;
    protected TcpAddress localTcpAddress;
    protected int portaPedidos;
    protected String comunidadeLeitura;
    protected String comunidadeEscrita;
    protected final String index1Escrita = "private";
    protected final String index2Escrita = "private2";
    protected final String index1Leitura = "public";
    protected final String index2Leitura = "public2";
    protected final String indexTargetMIB = "sgm";
    protected String ipGerente;
    protected int portaTraps;
    protected int vSNMPTraps;
    protected String protocoloTransporte;

    public AgenteSNMP(File bootCounterFile, File configFile, String address) {
        super(bootCounterFile, configFile, new CommandProcessor(new OctetString(MPv3.createLocalEngineID())));
        this.localUdpAddress = new UdpAddress(address);
        this.localTcpAddress = new TcpAddress(address);
    }

    @Override
    protected void registerManagedObjects() {
    }

    @Override
    protected void unregisterManagedObjects() {
    }

    @Override
    protected void addUsmUser(USM arg0) {
    }

    @Override
    protected void addNotificationTargets(SnmpTargetMIB targetMIB, SnmpNotificationMIB notificationMIB) {
        targetMIB.addDefaultTDomains();
        notificationMIB.addNotifyEntry(new OctetString("default"), new OctetString("notify"), 1, 3);
        this.initTargetMIB(targetMIB);
    }

    @Override
    protected void addViews(VacmMIB vacm) {
        this.initVacmMIB(vacm);
    }

    protected void initVacmMIB(VacmMIB vacm) {
        vacm.addGroup(1, new OctetString("private"), new OctetString("leituraescrita"), 3);
        vacm.addGroup(2, new OctetString("private"), new OctetString("leituraescrita"), 3);
        vacm.addGroup(1, new OctetString("public"), new OctetString("soleitura"), 3);
        vacm.addGroup(2, new OctetString("public"), new OctetString("soleitura"), 3);
        vacm.addAccess(new OctetString("soleitura"), new OctetString(), 0, 1, 1, new OctetString("fullReadView"), new OctetString(""), new OctetString("fullNotifyView"), 3);
        vacm.addAccess(new OctetString("leituraescrita"), new OctetString(), 0, 1, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacm.addViewTreeFamily(new OctetString("fullReadView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("fullWriteView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("fullNotifyView"), new OID("1.3"), new OctetString(), 1, 3);
    }

    protected void initTargetMIB(SnmpTargetMIB targetMIB) {
        targetMIB.addTargetParams(new OctetString("sgm"), 0, 1, new OctetString("private"), 1, 3);
        targetMIB.addTargetAddress(new OctetString("sgm"), TransportDomains.transportDomainUdpIpv4, new OctetString(new UdpAddress("127.0.0.1/162").getValue()), 200, 1, new OctetString("notify"), new OctetString("sgm"), 3);
    }

    protected void initCommunityMIB(SnmpCommunityMIB communityMIB) {
        Variable[] com3sec = new Variable[]{new OctetString("public"), new OctetString("public"), this.getAgent().getContextEngineID(), new OctetString(), new OctetString(), new Integer32(3), new Integer32(1)};
        MOTableRow row3 = communityMIB.getSnmpCommunityEntry().createRow(new OctetString("public").toSubIndex(true), com3sec);
        communityMIB.getSnmpCommunityEntry().addRow(row3);
        Variable[] com4sec = new Variable[]{new OctetString("private"), new OctetString("private"), this.getAgent().getContextEngineID(), new OctetString(), new OctetString(), new Integer32(3), new Integer32(1)};
        MOTableRow row4 = communityMIB.getSnmpCommunityEntry().createRow(new OctetString("private").toSubIndex(true), com4sec);
        communityMIB.getSnmpCommunityEntry().addRow(row4);
    }

    @Override
    protected void initTransportMappings() throws IOException {
        this.transportMappings = new TransportMapping[2];
        this.transportMappings[0] = new DefaultUdpTransportMapping(this.localUdpAddress);
        this.transportMappings[1] = new DefaultTcpTransportMapping(this.localTcpAddress);
    }

    public String getLocalAddress() {
        return this.localUdpAddress.toString();
    }

    public void setLocalAddress(String address) {
        this.localUdpAddress.setValue(address);
        this.localTcpAddress.setValue(address);
    }

    @Override
    protected void addCommunities(SnmpCommunityMIB communityMIB) {
        this.initCommunityMIB(communityMIB);
    }

    public boolean changeReadOnlyComunityString(String antiga, String nova) {
        String index = "public";
        if (this.snmpCommunityMIB.getSnmpCommunityEntry().removeRow(new OctetString(index).toSubIndex(true)) == null) {
            index = "public2";
            if (this.snmpCommunityMIB.getSnmpCommunityEntry().removeRow(new OctetString(index).toSubIndex(true)) == null) {
                return false;
            }
            index = "public";
        } else {
            index = "public2";
        }
        Variable[] com3sec = new Variable[]{new OctetString(nova), new OctetString(nova), this.getAgent().getContextEngineID(), new OctetString(), new OctetString(), new Integer32(3), new Integer32(1)};
        MOTableRow row3 = this.snmpCommunityMIB.getSnmpCommunityEntry().createRow(new OctetString(index).toSubIndex(true), com3sec);
        if (!this.snmpCommunityMIB.getSnmpCommunityEntry().addRow(row3)) {
            return false;
        }
        if (this.vacmMIB.removeGroup(1, new OctetString(antiga)) && this.vacmMIB.removeGroup(2, new OctetString(antiga))) {
            this.vacmMIB.addGroup(1, new OctetString(nova), new OctetString("soleitura"), 3);
            this.vacmMIB.addGroup(2, new OctetString(nova), new OctetString("soleitura"), 3);
            return true;
        }
        return false;
    }

    public boolean changeReadWriteComunityString(String antiga, String nova) {
        String index = "private";
        if (this.snmpCommunityMIB.getSnmpCommunityEntry().removeRow(new OctetString(index).toSubIndex(true)) == null) {
            index = "private2";
            if (this.snmpCommunityMIB.getSnmpCommunityEntry().removeRow(new OctetString(index).toSubIndex(true)) == null) {
                return false;
            }
            index = "private";
        } else {
            index = "private2";
        }
        Variable[] com3sec = new Variable[]{new OctetString(nova), new OctetString(nova), this.getAgent().getContextEngineID(), new OctetString(), new OctetString(), new Integer32(3), new Integer32(1)};
        MOTableRow row3 = this.snmpCommunityMIB.getSnmpCommunityEntry().createRow(new OctetString(index).toSubIndex(true), com3sec);
        if (!this.snmpCommunityMIB.getSnmpCommunityEntry().addRow(row3)) {
            return false;
        }
        if (this.vacmMIB.removeGroup(1, new OctetString(antiga)) && this.vacmMIB.removeGroup(2, new OctetString(antiga))) {
            this.vacmMIB.addGroup(1, new OctetString(nova), new OctetString("leituraescrita"), 3);
            this.vacmMIB.addGroup(2, new OctetString(nova), new OctetString("leituraescrita"), 3);
            MOTableRow row = this.snmpTargetMIB.removeTargetParams(new OctetString("sgm"));
            if (row == null) {
                return false;
            }
            return this.snmpTargetMIB.addTargetParams(new OctetString("sgm"), row.getValue(0).toInt(), row.getValue(1).toInt(), new OctetString(nova), row.getValue(3).toInt(), 3);
        }
        return false;
    }

    public boolean changeConfigTraps(String ipGerente, int portaEnvio, int versao, String protocoloTransporte, String comEscrita) {
        if (this.snmpTargetMIB.removeTargetAddress(new OctetString("sgm")) != null && this.snmpTargetMIB.removeTargetParams(new OctetString("sgm")) != null) {
            OctetString end;
            OID pt;
            int mp = 0;
            int secModel = 0;
            if (versao == 1) {
                mp = 0;
                secModel = 1;
            } else {
                mp = 1;
                secModel = 2;
            }
            if (protocoloTransporte.equalsIgnoreCase("udp")) {
                pt = new OID(TransportDomains.transportDomainUdpIpv4);
                end = new OctetString(new UdpAddress(String.valueOf(ipGerente) + "/" + portaEnvio).getValue());
            } else {
                pt = new OID(TransportDomains.transportDomainTcpIpv4);
                end = new OctetString(new TcpAddress(String.valueOf(ipGerente) + "/" + portaEnvio).getValue());
            }
            return this.snmpTargetMIB.addTargetParams(new OctetString("sgm"), mp, secModel, new OctetString(comEscrita), 1, 3) && this.snmpTargetMIB.addTargetAddress(new OctetString("sgm"), pt, end, 200, 1, new OctetString("notify"), new OctetString("sgm"), 3);
        }
        return false;
    }

    public void updateConfigGeralSNMP() {
        String index = "public";
        OctetString com = (OctetString)this.snmpCommunityMIB.getSnmpCommunityEntry().getValue(new OID("1.3.6.1.6.3.18.1.1.1.2." + new OctetString(index).toSubIndex(true).toString()));
        if (com == null) {
            index = "public2";
            com = (OctetString)this.snmpCommunityMIB.getSnmpCommunityEntry().getValue(new OID("1.3.6.1.6.3.18.1.1.1.2." + new OctetString(index).toSubIndex(true).toString()));
        }
        if (com != null && !this.comunidadeLeitura.equals(com.toString())) {
            this.comunidadeLeitura = com.toString();
        }
        index = "private";
        com = (OctetString)this.snmpCommunityMIB.getSnmpCommunityEntry().getValue(new OID("1.3.6.1.6.3.18.1.1.1.2." + new OctetString(index).toSubIndex(true).toString()));
        if (com == null) {
            index = "private2";
            com = (OctetString)this.snmpCommunityMIB.getSnmpCommunityEntry().getValue(new OID("1.3.6.1.6.3.18.1.1.1.2." + new OctetString(index).toSubIndex(true).toString()));
        }
        if (com != null && !this.comunidadeEscrita.equals(com.toString())) {
            this.comunidadeEscrita = com.toString();
        }
    }

    public void updateConfigTraps() {
        OID tpAtual;
        String[] ipPorta;
        String ipGerente = String.valueOf(this.ipGerente) + "/" + this.portaTraps;
        String ipAtual = "";
        if (this.snmpTargetMIB.getTargetAddress(new OctetString("sgm")) != null) {
            ipAtual = this.snmpTargetMIB.getTargetAddress(new OctetString("sgm")).toString();
        }
        if (!ipGerente.equals(ipAtual) && (ipPorta = ipAtual.split("/")).length > 1) {
            this.ipGerente = ipPorta[0];
            this.portaTraps = Integer.parseInt(ipPorta[1]);
        }
        if ((tpAtual = (OID)this.snmpTargetMIB.getSnmpTargetAddrEntry().getValue(new OID("1.3.6.1.6.3.12.1.2.1.2." + new OctetString("sgm").toSubIndex(true)))) != null) {
            if ("1.3.6.1.2.1.100.1.1".equals(tpAtual.toString())) {
                this.protocoloTransporte = "udp";
            } else if ("1.3.6.1.2.1.100.1.5".equals(tpAtual.toString())) {
                this.protocoloTransporte = "tcp";
            }
        }
        if (this.snmpTargetMIB.getTargetParamsRow(new OctetString("sgm")) != null) {
            int vs = this.snmpTargetMIB.getTargetParamsRow(new OctetString("sgm")).getValue(0).toInt();
            if (vs == 0) {
                this.vSNMPTraps = 1;
            } else if (vs == 1) {
                this.vSNMPTraps = 2;
            }
        }
    }

    public void initConfigGeralSNMP(int portaPedidos, String comunidadeLeitura, String comunidadeEscrita) {
        this.portaPedidos = portaPedidos;
        this.comunidadeLeitura = comunidadeLeitura;
        this.comunidadeEscrita = comunidadeEscrita;
    }

    public void initConfigTraps(String ipGerente, int portaEnvio, int versao, String protocoloTransporte) {
        this.ipGerente = ipGerente;
        this.portaTraps = portaEnvio;
        this.vSNMPTraps = versao;
        this.protocoloTransporte = protocoloTransporte;
    }

    public void saveConfigSNMP() {
        this.saveConfig();
    }
}

