/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.snmp;

import br.com.schneider.sgm.controle.Controle;
import br.com.schneider.sgm.eventos.ControleListener;
import br.com.schneider.sgm.eventos.Evento;
import br.com.schneider.sgm.historico.HistoricoConsumo;
import br.com.schneider.sgm.servico.NotificadorHisConsumo;
import br.com.schneider.sgm.servico.NotificadorTrapOnBattery;
import br.com.schneider.sgm.servico.NotificadorTraps;
import br.com.schneider.sgm.snmp.AgenteSNMP;
import br.com.schneider.sgm.snmp.UpsAlarmGroup;
import br.com.schneider.sgm.snmp.UpsBatteryGroup;
import br.com.schneider.sgm.snmp.UpsBypassGroup;
import br.com.schneider.sgm.snmp.UpsConfigGroup;
import br.com.schneider.sgm.snmp.UpsControlGroup;
import br.com.schneider.sgm.snmp.UpsIdentGroup;
import br.com.schneider.sgm.snmp.UpsInputGroup;
import br.com.schneider.sgm.snmp.UpsOutputGroup;
import br.com.schneider.sgm.snmp.UpsTestGroup;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.util.ThreadPool;

public class AgenteSGM
extends AgenteSNMP
implements ControleListener,
ActionListener {
    private javax.swing.Timer timerPerMIB;
    protected UpsIdentGroup grupoIdent;
    protected UpsBatteryGroup grupoBateria;
    protected UpsInputGroup grupoEntrada;
    protected UpsOutputGroup grupoSaida;
    protected UpsControlGroup grupoControle;
    protected UpsAlarmGroup grupoAlarme;
    protected UpsConfigGroup grupoConfig;
    protected UpsTestGroup grupoTeste;
    protected UpsBypassGroup grupoBypass;
    protected String modeloUPS = "";
    public Controle feeder;
    private float tensaoEntrada;
    private boolean[] alarmesUpsMIB;
    private Evento[] alarmesMicrosol;
    private TimeTicks horaAlarme;
    private Timer timerUpsTrapOnBattery;
    private Timer timerUpsTestElapsedTime;
    private boolean enviaTrap;
    private Timer timerUpsSecondsOnBattery;
    private int numSecondsOnBattery;
    private int numElapsedTime;
    private int delayShutdown;
    private int delayStartup;
    private int tipoShutdown;
    private boolean updateUpsSecondsOnBattery;
    private boolean atualizaUpsConfigLowBattTime;
    private boolean atualizaUpsTestElapsedTime;
    private boolean remove24;
    private boolean removeAlarme;
    private boolean removeControle;
    private boolean[] diasAgenda;
    private HistoricoConsumo hisConsumo;
    private boolean execPrim;

    static {
        LogFactory.setLogFactory(new LogFactory());
    }

    public AgenteSGM(File bootCounterFile, File configFile, String address, Controle controle, HistoricoConsumo his) throws IOException {
        super(bootCounterFile, configFile, address);
        this.agent.setThreadPool(ThreadPool.create("RequestPool", 4));
        this.feeder = controle;
        File bootCounter = new File("AgenteSGMBC.cfg");
        File config = new File("AgenteSGMConfig.cfg");
        this.execPrim = !bootCounter.exists() || !config.exists();
        this.initConfigGeralSNMP(this.feeder.getPortaPedidos(), this.feeder.getComunidadeLeitura(), this.feeder.getComunidadeEscrita());
        this.initConfigTraps(this.feeder.getEnderecoGerente(), this.feeder.getPortaEnvio(), this.feeder.getVersaoSNMP(), this.feeder.getProtocoloSNMP());
        this.tensaoEntrada = 0.0f;
        this.alarmesUpsMIB = new boolean[24];
        int i = 0;
        while (i < this.alarmesUpsMIB.length) {
            this.alarmesUpsMIB[i] = false;
            ++i;
        }
        this.horaAlarme = new TimeTicks();
        this.timerUpsTrapOnBattery = new Timer();
        this.enviaTrap = false;
        this.timerUpsSecondsOnBattery = new Timer();
        this.timerUpsTestElapsedTime = new Timer();
        this.delayStartup = -1;
        this.delayShutdown = -1;
        this.numSecondsOnBattery = 0;
        this.updateUpsSecondsOnBattery = false;
        this.atualizaUpsConfigLowBattTime = true;
        this.remove24 = true;
        this.removeAlarme = true;
        this.removeControle = true;
        this.diasAgenda = new boolean[7];
        this.addShutdownHook();
        this.timerPerMIB = new javax.swing.Timer(1000, this);
        this.hisConsumo = his;
    }

    @Override
    protected void addNotificationTargets(SnmpTargetMIB targetMIB, SnmpNotificationMIB notificationMIB) {
        targetMIB.addDefaultTDomains();
        notificationMIB.addNotifyEntry(new OctetString("default"), new OctetString("notify"), 1, 3);
        if (this.execPrim) {
            this.initTargetMIB(this.snmpTargetMIB);
        }
    }

    @Override
    protected void addViews(VacmMIB vacm) {
        if (this.execPrim) {
            this.initVacmMIB(vacm);
        }
    }

    @Override
    protected void addCommunities(SnmpCommunityMIB communityMIB) {
        if (this.execPrim) {
            this.initCommunityMIB(communityMIB);
        }
    }

    @Override
    protected void registerSnmpMIBs() {
        this.grupoIdent = new UpsIdentGroup("Microsol", this.feeder.getPersistencia().getModeloUPSString(), "1.0", "1.0");
        this.grupoIdent.setUpsIdentName(new OctetString(this.feeder.getPersistencia().getNomeUPS()));
        this.grupoIdent.setUpsPortaPedidos(this.feeder.getPortaPedidos());
        this.grupoBateria = new UpsBatteryGroup(this.modeloUPS);
        this.grupoEntrada = new UpsInputGroup(this.modeloUPS, 1, 1);
        this.grupoSaida = new UpsOutputGroup(1, 1);
        this.grupoControle = new UpsControlGroup(this.modeloUPS);
        this.grupoAlarme = new UpsAlarmGroup();
        this.grupoConfig = new UpsConfigGroup();
        this.grupoTeste = new UpsTestGroup();
        this.grupoBypass = new UpsBypassGroup();
        super.registerSnmpMIBs();
    }

    @Override
    protected void registerManagedObjects() {
        try {
            this.grupoIdent.registerMOs(this.server, null);
            this.grupoBateria.registerMOs(this.server, null);
            this.grupoEntrada.registerMOs(this.server, null);
            this.grupoSaida.registerMOs(this.server, null);
            this.grupoControle.registerMOs(this.server, null);
            this.grupoAlarme.registerMOs(this.server, null);
            this.grupoConfig.registerMOs(this.server, null);
            this.grupoTeste.registerMOs(this.server, null);
            this.grupoBypass.registerMOs(this.server, null);
        }
        catch (DuplicateRegistrationException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.updateUpsIdentGroup();
        this.updateTestGroup();
        this.upadateUpsControlGroup();
        if (this.grupoSaida.getUpsTipoHisConsumo().getAtualizacao() && this.grupoSaida.getUpsTipoHisConsumo().getAtualizacao()) {
            NotificadorHisConsumo notificador = new NotificadorHisConsumo(this.grupoSaida, this.notificationOriginator, this.hisConsumo, this.snmpv2MIB.getSysUpTime().get());
            notificador.setDaemon(true);
            notificador.start();
        }
        this.saveConfig();
        this.updateVarAcessoRemoto();
    }

    public void updateVarAcessoRemoto() {
        this.updateConfigGeralSNMP();
        this.feeder.salvaPortaPedidos(this.portaPedidos);
        this.feeder.salvaComunidadeLeitura(this.comunidadeLeitura);
        this.feeder.salvaComunidadeEscrita(this.comunidadeEscrita);
        this.updateConfigTraps();
        this.feeder.salvaEnderecoGerente(this.ipGerente);
        this.feeder.salvaPortaEnvio(this.portaTraps);
        this.feeder.salvaVSnmp2(new Integer(this.vSNMPTraps));
        this.feeder.salvaProtocolo(this.protocoloTransporte);
        this.saveConfig();
        if (this.grupoIdent.getUpsPortaPedidos().getAtualizacao()) {
            this.portaPedidos = this.grupoIdent.getUpsPortaPedidos().getValue().toInt();
            this.feeder.salvaPortaPedidos(this.portaPedidos);
            this.grupoIdent.getUpsPortaPedidos().setAtualizacao(false);
            this.saveConfig();
            this.feeder.setLocalAdress(String.valueOf(this.feeder.getEnderecoIPLocal()) + "/" + this.portaPedidos);
        }
    }

    public void updateConfigGroup() {
        if (this.feeder.isTensaoEntrada220()) {
            this.grupoConfig.setUpsConfigInputVoltage(220);
        } else {
            this.grupoConfig.setUpsConfigInputVoltage(110);
        }
        this.grupoConfig.setUpsConfigInputFreq((int)this.feeder.getFrequenciaEntrada());
        if (this.feeder.isTensaoSaida220()) {
            this.grupoConfig.setUpsConfigOutputVoltage(220);
        } else {
            this.grupoConfig.setUpsConfigOutputVoltage(110);
        }
        this.grupoConfig.setUpsConfigOutputFreq((int)this.feeder.getFrequenciaSaida());
        this.grupoConfig.setUpsConfigOutputVA(this.feeder.getPotenciaNominalVA());
        this.grupoConfig.setUpsConfigOutputPower(this.feeder.getPotenciaNominalW());
        this.grupoConfig.setUpsConfigAudibleStatus(2);
        this.grupoConfig.setUpsConfigLowVoltageTransferPoint((int)this.feeder.getLimiteInferiorTensaoEntrada());
        this.grupoConfig.setUpsConfigHighVoltageTransferPoint((int)this.feeder.getLimiteSuperiorTensaoEntrada());
        if (this.feeder.isModoRede()) {
            this.grupoConfig.setUpsMicrosolRedeLigada(0);
        } else {
            this.grupoConfig.setUpsMicrosolRedeLigada(1);
        }
        if (this.feeder.isSuperAquecimento()) {
            this.grupoConfig.setUpsMicrosolSuperAquecimento(0);
            this.alarmesUpsMIB[4] = true;
        } else {
            this.grupoConfig.setUpsMicrosolSuperAquecimento(1);
            this.alarmesUpsMIB[4] = false;
        }
        if (this.feeder.isSobrecarga()) {
            this.grupoConfig.setUpsMicrosolSobrecarga(0);
            this.alarmesUpsMIB[7] = true;
        } else {
            this.grupoConfig.setUpsMicrosolSobrecarga(1);
            this.alarmesUpsMIB[7] = false;
        }
    }

    public void progUpdateTestElapsedTime() {
        this.timerUpsTestElapsedTime.schedule(new TimerTask(){

            @Override
            public void run() {
                UpsTestGroup upsTestGroup = AgenteSGM.this.grupoTeste;
                AgenteSGM agenteSGM = AgenteSGM.this;
                int n = agenteSGM.numElapsedTime + 1;
                agenteSGM.numElapsedTime = n;
                upsTestGroup.setUpsTestElapsedTime(n);
                AgenteSGM.this.atualizaUpsTestElapsedTime = false;
            }
        }, 1000L);
        this.atualizaUpsTestElapsedTime = true;
    }

    public void updateTestGroup() {
        if (this.grupoTeste.getUpsTestId().getAtualizacao()) {
            if (this.grupoTeste.getUpsTestId().getValue().toString() == "1.3.6.1.2.1.33.1.7.7.3") {
                this.grupoTeste.setUpsTestStartTime(this.snmpv2MIB.getSysUpTime().get().toInt());
                this.feeder.iniciarAutoteste();
                this.alarmesUpsMIB[23] = true;
                this.progUpdateTestElapsedTime();
            } else if (this.grupoTeste.getUpsTestId().getValue().toString() == "1.3.6.1.2.1.33.1.7.7.2") {
                this.feeder.finalizarAutoteste();
                this.grupoTeste.setUpsTestResultsSummary(4);
                this.alarmesUpsMIB[23] = false;
                if (this.atualizaUpsTestElapsedTime) {
                    this.timerUpsTestElapsedTime.cancel();
                    this.atualizaUpsTestElapsedTime = false;
                }
            }
            this.grupoTeste.getUpsTestId().setAtualizacao(false);
        }
    }

    public void updateBypassGroup() {
        if (this.grupoBypass.getUpsBypassAtivar().getAtualizacao()) {
            if (this.grupoBypass.getUpsBypassAtivar().getValue().toString().equalsIgnoreCase("true")) {
                if (this.feeder.ativaBypass()) {
                    this.alarmesUpsMIB[10] = true;
                }
            } else if (this.grupoBypass.getUpsBypassAtivar().getValue().toString().equalsIgnoreCase("false") && this.feeder.desativaBypass()) {
                this.alarmesUpsMIB[10] = false;
            }
            this.grupoBypass.getUpsBypassAtivar().setAtualizacao(false);
        }
        if (this.feeder.isBypassAtivado()) {
            this.grupoBypass.setUpsBypassAtivar("true");
        } else {
            this.grupoBypass.setUpsBypassAtivar("false");
        }
        this.grupoBypass.setUpsBypassFrequency((int)this.feeder.getFrequenciaBypass() * 10);
        this.grupoBypass.addUpsBypassEntry(1, (int)this.feeder.getTensaoBypass(), (int)this.feeder.getCorrenteBypass() * 10, (int)this.feeder.getPotenciaBypass() * 10);
    }

    public void updateUpsIdentGroup() {
        this.grupoIdent.setUpsIdentModel(new OctetString(this.feeder.getPersistencia().getModeloUPSString()));
        if (this.grupoIdent.getUpsIdentName().getAtualizacao()) {
            this.feeder.salvaNomeUPS(this.grupoIdent.getUpsIdentName().getValue().toString());
            this.grupoIdent.setUpsIdentNameAtulizacao(false);
        }
        if (this.grupoIdent.getUpsIdentAttachedDevices().getAtualizacao()) {
            this.feeder.setNomePCUPS(this.grupoIdent.getUpsIdentAttachedDevices().getValue().toString());
            this.grupoIdent.setUpsIdentAttachedDevicesAtualizacao(false);
        }
    }

    public void updateUpsBatteryGroup() {
        if (this.feeder == null) {
            return;
        }
        if (this.grupoBateria == null) {
            return;
        }
        this.grupoBateria.setUpsEstimatedMinutesRemaining(this.feeder.getAutonomiaBateria());
        this.grupoBateria.setUpsBatteryVoltage((int)(this.feeder.getTensaoBateria() * 10.0f));
        this.grupoBateria.setUpsBatteryTemperature((int)(this.feeder.getTemperaturaUPS() * 10.0f));
        this.grupoBateria.setUpsEstimatedChargeRemaining(this.feeder.getPercentualBateria());
        if (this.feeder.isUsandoSomenteBateria()) {
            this.alarmesUpsMIB[1] = true;
            if (this.feeder.isBateriaCritica() && this.feeder.isBateriaBaixa()) {
                this.alarmesUpsMIB[2] = false;
                this.alarmesUpsMIB[3] = true;
                this.grupoBateria.setUpsBatteryStatus(4);
            }
            if (!this.enviaTrap) {
                this.progEnvioUpsTrapOnBattery();
            }
            if (!this.updateUpsSecondsOnBattery) {
                this.progUpdateUpsSecondsOnBattery();
            }
        } else {
            this.alarmesUpsMIB[1] = false;
            if (!this.feeder.isBateriaCritica() && this.feeder.isBateriaBaixa()) {
                this.alarmesUpsMIB[3] = false;
            }
            if (!this.feeder.isBateriaCritica() && !this.feeder.isBateriaBaixa()) {
                this.alarmesUpsMIB[2] = false;
                this.atualizaUpsConfigLowBattTime = true;
                this.grupoConfig.getUpsConfigLowBattTime().setValue(0);
            }
            if (this.enviaTrap) {
                this.timerUpsTrapOnBattery.cancel();
            }
            if (this.updateUpsSecondsOnBattery) {
                this.timerUpsSecondsOnBattery.cancel();
            }
            this.numSecondsOnBattery = 0;
            this.grupoBateria.setUpsSecondsOnBattery(this.numSecondsOnBattery);
            this.grupoConfig.setUpsConfigLowBattTime(0);
        }
        if (this.feeder.isCarregandoBateria()) {
            this.grupoBateria.setUpsBatteryCarregando(0);
        } else {
            this.grupoBateria.setUpsBatteryCarregando(1);
        }
    }

    private void progEnvioUpsTrapOnBattery() {
        this.timerUpsTrapOnBattery.schedule(new TimerTask(){

            @Override
            public void run() {
                AgenteSGM.this.horaAlarme = AgenteSGM.this.snmpv2MIB.getSysUpTime().get();
                NotificadorTrapOnBattery notificador = new NotificadorTrapOnBattery(AgenteSGM.this.grupoBateria, AgenteSGM.this.grupoConfig, AgenteSGM.this.notificationOriginator, AgenteSGM.this.horaAlarme);
                notificador.setDaemon(true);
                notificador.start();
                AgenteSGM.this.enviaTrap = false;
            }
        }, 60000L);
        this.enviaTrap = true;
    }

    private void progUpdateUpsSecondsOnBattery() {
        this.timerUpsSecondsOnBattery.schedule(new TimerTask(){

            @Override
            public void run() {
                UpsBatteryGroup upsBatteryGroup = AgenteSGM.this.grupoBateria;
                AgenteSGM agenteSGM = AgenteSGM.this;
                int n = agenteSGM.numSecondsOnBattery + 1;
                agenteSGM.numSecondsOnBattery = n;
                upsBatteryGroup.setUpsSecondsOnBattery(n);
                AgenteSGM.this.updateUpsSecondsOnBattery = false;
            }
        }, 1000L);
        this.updateUpsSecondsOnBattery = true;
    }

    public void updateUpsInputGroup() {
        if (this.grupoEntrada.getUpsInputLigar().getAtualizacao()) {
            if (this.grupoEntrada.getUpsInputLigar().getValue().toString().equalsIgnoreCase("true")) {
                this.feeder.ligaEntrada();
            } else if (this.grupoEntrada.getUpsInputLigar().getValue().toString().equalsIgnoreCase("false")) {
                this.feeder.desligaEntrada();
            }
            this.grupoEntrada.getUpsInputLigar().setAtualizacao(false);
        }
        if (this.feeder.isEntradaLigada()) {
            this.grupoEntrada.setUpsInputLigar("true");
        } else {
            this.grupoEntrada.setUpsInputLigar("false");
        }
        this.tensaoEntrada = this.feeder.getTensaoEntrada();
        this.grupoEntrada.addUpsInputEntry(1, (int)(this.feeder.getFrequenciaEntrada() * 10.0f), (int)this.tensaoEntrada, (int)(this.feeder.getCorrenteEntrada() * 10.0f), (int)this.feeder.getPotenciaRealEntrada(), (int)this.feeder.getPotenciaAparenteEntrada());
        if (this.tensaoEntrada < this.feeder.getLimiteInferiorTensaoEntrada() || this.tensaoEntrada > this.feeder.getLimiteSuperiorTensaoEntrada()) {
            this.grupoEntrada.incrementUpsInputLineBads();
        }
    }

    public void updateUpsOutputGroup() {
        if (this.feeder.isSaidaLigada()) {
            this.grupoSaida.setUpsSaidaLigada(0);
        } else {
            this.grupoSaida.setUpsSaidaLigada(1);
        }
        if (this.feeder.isBypassAtivado()) {
            this.grupoSaida.setUpsOutputSource(4);
        }
        if (this.feeder.isUsandoSomenteBateria()) {
            this.grupoSaida.setUpsOutputSource(5);
        } else {
            this.grupoSaida.setUpsOutputSource(3);
        }
        this.grupoSaida.setUpsOutputFrequency((int)this.feeder.getFrequenciaSaida() * 10);
        this.grupoSaida.setUpsOutputNumLines(1);
        this.grupoSaida.addUpsOutputEntry(1, (int)this.feeder.getTensaoSaida(), (int)(this.feeder.getCorrenteSaida() * 10.0f), (int)this.feeder.getPotenciaReal(), (int)(this.feeder.getPotenciaAparente() * 100.0f / (float)this.feeder.getPotenciaNominalW()), (int)this.feeder.getPotenciaAparente());
    }

    public void updateUpsAlarmGroup() {
        this.horaAlarme = this.snmpv2MIB.getSysUpTime().get();
        this.alarmesMicrosol = this.feeder.getEventos();
        NotificadorTraps notificador = new NotificadorTraps(this.grupoAlarme, this.notificationOriginator, this.alarmesUpsMIB, this.alarmesMicrosol, this.horaAlarme);
        notificador.setDaemon(true);
        notificador.start();
        this.grupoAlarme.setUpsAlarmsPresent(new Gauge32((long)this.grupoAlarme.getNumAlarmesAtivos()));
    }

    public void upadateUpsControlGroup() {
        if (this.removeControle) {
            this.grupoControle.setUpsStartupAfterDelay(new Integer32(-1));
            this.removeControle = false;
        }
        this.tipoShutdown = this.grupoControle.getUpsShutdownType().getValue().toInt();
        if (this.grupoControle.getUpsShutdownAfterDelay().getAtualizacao()) {
            this.verificaDesligamento();
            this.grupoControle.getUpsShutdownAfterDelay().setAtualizacao(false);
        }
        if (this.grupoControle.getUpsStartupAfterDelay().getAtualizacao()) {
            this.vericaLigamentoSaida();
            this.grupoControle.getUpsStartupAfterDelay().setAtualizacao(false);
        }
        if (this.delayShutdown >= 0 && !this.grupoControle.getUpsShutdownAfterDelay().getAtualizacao()) {
            if (this.delayShutdown > 0) {
                --this.delayShutdown;
                if (this.delayShutdown <= 5) {
                    this.alarmesUpsMIB[22] = true;
                }
            } else {
                this.execDesligamento();
            }
            this.grupoControle.setUpsShutdownAfterDelay(this.delayShutdown);
        }
        if (this.delayStartup >= 0 && !this.grupoControle.getUpsStartupAfterDelay().getAtualizacao()) {
            if (this.delayStartup > 0) {
                --this.delayStartup;
            } else {
                this.execUpsStartUpAfterDelay();
            }
            this.grupoControle.setUpsStartupAfterDelay(this.delayStartup);
        }
    }

    private void vericaLigamentoSaida() {
        if (this.grupoControle.getUpsStartupAfterDelay().getValue().toInt() == -1) {
            this.delayStartup = -1;
        } else if (this.grupoControle.getUpsStartupAfterDelay().getValue().toInt() == 0) {
            this.execUpsStartUpAfterDelay();
        } else if (this.grupoControle.getUpsStartupAfterDelay().getValue().toInt() > 0) {
            this.delayStartup = this.grupoControle.getUpsStartupAfterDelay().getValue().toInt();
        }
    }

    private void verificaDesligamento() {
        if (this.grupoControle.getUpsShutdownAfterDelay().getValue().toInt() == -1) {
            this.delayShutdown = -1;
        } else if (this.grupoControle.getUpsShutdownAfterDelay().getValue().toInt() == 0) {
            this.execDesligamento();
        } else if (this.grupoControle.getUpsShutdownAfterDelay().getValue().toInt() > 0) {
            this.delayShutdown = this.grupoControle.getUpsShutdownAfterDelay().getValue().toInt();
        }
    }

    private void execDesligamento() {
        if (this.tipoShutdown == 1) {
            if (this.feeder.desligaSaida()) {
                this.alarmesUpsMIB[10] = true;
            }
            this.delayShutdown = -1;
        } else if (this.tipoShutdown == 2) {
            this.alarmesUpsMIB[11] = true;
            this.feeder.desligaUPS();
            this.delayShutdown = -1;
        }
        if (this.delayShutdown == -1) {
            this.grupoControle.setUpsShutdownAfterDelay(-1);
            this.horaAlarme = this.snmpv2MIB.getSysUpTime().get();
            NotificadorTraps notificador = new NotificadorTraps(this.grupoAlarme, this.notificationOriginator, this.alarmesUpsMIB, null, this.horaAlarme);
            notificador.setDaemon(true);
            notificador.start();
        }
    }

    private void execUpsStartUpAfterDelay() {
        this.delayStartup = -1;
        if (this.feeder.ligaSaida()) {
            this.grupoSaida.setUpsOutputLigar("true");
            this.alarmesUpsMIB[10] = false;
        } else {
            this.grupoSaida.setUpsOutputLigar("false");
            this.grupoControle.setUpsStartupAfterDelay(-1);
        }
    }

    private void updateAgendamento() {
        if (this.grupoControle.getUpsHoraLigar().getAtualizacao() || this.grupoControle.getUpsMinLigar().getAtualizacao() || this.grupoControle.getUpsHoraDesligar().getAtualizacao() || this.grupoControle.getUpsMinDesligar().getAtualizacao() || this.grupoControle.getUpsDiasAgenda().getAtualizacao()) {
            String[] dias = this.grupoControle.getUpsDiasAgenda().getValue().toString().split("-");
            if (dias.length == this.diasAgenda.length) {
                int i = 0;
                while (i < dias.length - 1) {
                    this.diasAgenda[i + 1] = dias[i].equalsIgnoreCase("true");
                    ++i;
                }
            }
            this.diasAgenda[0] = dias[6].equalsIgnoreCase("true");
            this.feeder.programaSemana(this.diasAgenda, this.grupoControle.getUpsHoraLigar().getValue().toInt(), this.grupoControle.getUpsMinLigar().getValue().toInt(), this.grupoControle.getUpsHoraDesligar().getValue().toInt(), this.grupoControle.getUpsMinDesligar().getValue().toInt());
            this.grupoControle.getUpsHoraLigar().setAtualizacao(false);
            this.grupoControle.getUpsMinLigar().setAtualizacao(false);
            this.grupoControle.getUpsHoraDesligar().setAtualizacao(false);
            this.grupoControle.getUpsMinDesligar().setAtualizacao(false);
            this.grupoControle.getUpsDiasAgenda().setAtualizacao(false);
        }
        this.grupoControle.setUpsHoraLigar(this.feeder.getHoraLigar());
        this.grupoControle.setUpsMinLigar(this.feeder.getMinutoLigar());
        this.grupoControle.setUpsHoraDesligar(this.feeder.getHoraDesligar());
        this.grupoControle.setUpsMinDesligar(this.feeder.getMinutoDesligar());
        boolean[] agenda = this.feeder.getDiasSemanaProgramados();
        String agendaS = "";
        int i = 0;
        while (i < agenda.length) {
            if (i > 0 && i <= agenda.length - 1) {
                agendaS = String.valueOf(agendaS) + "-";
            }
            agendaS = agenda[i] ? String.valueOf(agendaS) + "true" : String.valueOf(agendaS) + "false";
            ++i;
        }
        this.grupoControle.setUpsDiasAgenda(agendaS);
    }

    @Override
    protected void unregisterManagedObjects() {
    }

    public javax.swing.Timer getTimerPerMIB() {
        return this.timerPerMIB;
    }

    public void setControle(Controle controle) {
        this.feeder = controle;
    }

    public Controle getControle() {
        return this.feeder;
    }

    @Override
    public void notificaDados() {
        this.updateUpsBatteryGroup();
        this.updateUpsInputGroup();
        this.updateUpsOutputGroup();
        this.updateBypassGroup();
        this.updateConfigGroup();
        this.updateAgendamento();
        this.grupoControle.setUpsHorario(String.valueOf(this.feeder.getHora()) + ":" + this.feeder.getMinutos() + ":" + this.feeder.getSegundos());
        if (this.feeder.isTesteExecutando()) {
            if (!this.atualizaUpsTestElapsedTime) {
                this.progUpdateTestElapsedTime();
            }
        } else {
            this.alarmesUpsMIB[23] = false;
            this.atualizaUpsTestElapsedTime = false;
        }
        if (this.grupoControle.getUpsDownloadEventos().getAtualizacao()) {
            this.feeder.downloadEventos();
            this.grupoControle.getUpsDownloadEventos().setAtualizacao(false);
        }
        this.updateUpsAlarmGroup();
    }

    @Override
    public void notificaFalhaCom() {
        this.horaAlarme = this.snmpv2MIB.getSysUpTime().get();
        this.alarmesUpsMIB[19] = true;
        NotificadorTraps notificador = new NotificadorTraps(this.grupoAlarme, this.notificationOriginator, this.alarmesUpsMIB, null, this.horaAlarme);
        notificador.setDaemon(true);
        notificador.start();
    }

    @Override
    public void notificaRetornoCom() {
        this.horaAlarme = this.snmpv2MIB.getSysUpTime().get();
        this.alarmesUpsMIB[19] = false;
        NotificadorTraps notificador = new NotificadorTraps(this.grupoAlarme, this.notificationOriginator, this.alarmesUpsMIB, null, this.horaAlarme);
        notificador.setDaemon(true);
        notificador.start();
    }

    @Override
    public void notificaFalhaRede() {
    }

    @Override
    public void notificaRetornoRede() {
    }

    @Override
    public void notificaBateriaBaixa() {
        this.grupoBateria.setUpsBatteryStatus(3);
        this.alarmesUpsMIB[2] = true;
        if (this.atualizaUpsConfigLowBattTime) {
            this.grupoConfig.setUpsConfigLowBattTime(this.grupoBateria.getUpsEstimatedMinutesRemaining().getValue());
            this.atualizaUpsConfigLowBattTime = false;
        }
    }

    @Override
    public void notificaBateriaNormal() {
        this.grupoBateria.setUpsBatteryStatus(2);
    }

    @Override
    public void notificaCargaElevada() {
    }

    @Override
    public void notificaCargaNormal() {
    }

    @Override
    public void notificaTemperaturaElevada() {
    }

    @Override
    public void notificaTemperaturaNormal() {
    }

    @Override
    public void notificaUsandoBateria() {
        this.grupoSaida.setUpsOutputSource(5);
        this.alarmesUpsMIB[1] = true;
        if (!this.enviaTrap) {
            this.progEnvioUpsTrapOnBattery();
        }
        if (!this.updateUpsSecondsOnBattery) {
            this.progUpdateUpsSecondsOnBattery();
        }
    }

    @Override
    public void notificaNaoUsaBateria() {
        this.alarmesUpsMIB[1] = false;
    }

    @Override
    protected void addUsmUser(USM arg0) {
    }

    @Override
    public void notificaComunicacao() {
    }
}

