/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.servico;

import br.com.schneider.sgm.config.PathConfig;
import br.com.schneider.sgm.gui.PainelGraficos;
import br.com.schneider.sgm.historico.HistoricoConsumo;
import java.util.Calendar;

public class SalvaConsumo
implements Runnable {
    private HistoricoConsumo historico = new HistoricoConsumo(String.valueOf(PathConfig.getPathXML()) + "consumo.xml");
    private String[] resultado;
    private String[] valor;
    private String[] dia;
    private float consumo;
    private Calendar calendar;
    private double[] valorDia;
    private PainelGraficos painelGraficos;

    public SalvaConsumo(float consumo, PainelGraficos pg) {
        this.consumo = consumo;
        this.valorDia = new double[32];
        this.painelGraficos = pg;
    }

    @Override
    public void run() {
        this.salvaConsumo();
        this.painelGraficos.atualizaGraficos();
    }

    private void leMesAtual() {
        this.calendar = Calendar.getInstance();
        String data = Integer.toString(this.calendar.get(2) + 1);
        data = String.valueOf(data) + "-" + Integer.toString(this.calendar.get(1));
        this.resultado = this.historico.getConsumoDiario(data).split(", ");
        try {
            int i = 0;
            while (i < this.resultado.length) {
                this.valor = this.resultado[i].split("=");
                this.dia = this.valor[0].split("-");
                this.valorDia[Integer.parseInt((String)this.dia[2])] = Double.parseDouble(this.valor[1]);
                ++i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private float getAndSetConsumoDia() {
        this.leMesAtual();
        int diaAtual = this.calendar.get(5);
        this.consumo = (float)((double)this.consumo + this.valorDia[diaAtual]);
        return this.consumo;
    }

    private void salvaConsumo() {
        this.historico.inserirDia(this.getAndSetConsumoDia());
    }
}

