/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.servico;

import br.com.schneider.sgm.eventos.Evento;
import br.com.schneider.sgm.snmp.UpsAlarmGroup;
import br.com.schneider.sgm.snmp.UpsMibOids;
import java.util.GregorianCalendar;
import org.snmp4j.agent.NotificationOriginator;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.VariableBinding;

public class NotificadorTraps
extends Thread {
    private UpsAlarmGroup grupoAlarme;
    private NotificationOriginator notificationOriginator;
    private boolean[] alarmesUpsMIB;
    private Evento[] alarmesMicrosol;
    private TimeTicks horaAlarme;
    private GregorianCalendar dataSistema;
    private GregorianCalendar dataUPS;

    public NotificadorTraps(UpsAlarmGroup grupoAlarme, NotificationOriginator notificationOriginator, boolean[] alarmesUpsMIB, Evento[] alarmesMicrosol, TimeTicks horaAlarme) {
        this.grupoAlarme = grupoAlarme;
        this.notificationOriginator = notificationOriginator;
        this.alarmesUpsMIB = alarmesUpsMIB;
        this.alarmesMicrosol = alarmesMicrosol;
        this.horaAlarme = horaAlarme;
        this.dataSistema = new GregorianCalendar();
        this.dataUPS = new GregorianCalendar();
    }

    @Override
    public void run() {
        this.updateAlarmesUpsMIB();
        this.updateAlarmesMicrosol();
    }

    protected void updateAlarmesUpsMIB() {
        String descAlarme = "";
        int indice = 0;
        if (this.alarmesUpsMIB != null) {
            int i = 0;
            while (i < this.alarmesUpsMIB.length) {
                descAlarme = UpsMibOids.getWellKnownAlarm(++indice);
                if (this.alarmesUpsMIB[i]) {
                    if (this.grupoAlarme.getUpsAlarmRow(indice) == null) {
                        this.grupoAlarme.addUpsAlarmEntry(indice, descAlarme, this.horaAlarme.getValue());
                        this.notificationOriginator.notify(new OctetString(), new OID("1.3.6.1.2.1.33.2.3"), this.horaAlarme, new VariableBinding[]{new VariableBinding(new OID("1.3.6.1.2.1.33.1.6.2.1.2." + String.valueOf(indice)), new OID(descAlarme)), new VariableBinding(new OID("1.3.6.1.2.1.33.1.6.2.1.3"), new OctetString(this.horaAlarme.toString()))});
                    }
                } else if (this.grupoAlarme.getUpsAlarmRow(indice) != null) {
                    this.grupoAlarme.removeUpsAlarmEntry(indice);
                    this.notificationOriginator.notify(new OctetString(), new OID("1.3.6.1.2.1.33.2.4"), this.horaAlarme, new VariableBinding[]{new VariableBinding(new OID("1.3.6.1.2.1.33.1.6.2.1.2." + String.valueOf(indice)), new OID(descAlarme)), new VariableBinding(new OID("1.3.6.1.2.1.33.1.6.2.1.3"), new OctetString(this.horaAlarme.toString()))});
                }
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void updateAlarmesMicrosol() {
        block2: {
            i = 0;
            if (this.alarmesMicrosol == null) break block2;
            k = 0;
            ** GOTO lbl11
            {
                this.notificationOriginator.notify(new OctetString(), new OID("1.3.6.1.2.1.33.2.5"), this.horaAlarme, new VariableBinding[]{new VariableBinding(new OID("1.3.6.1.2.1.33.1.6.3.25"), new OctetString(this.alarmesMicrosol[i].getTipo())), new VariableBinding(new OID("1.3.6.1.2.1.33.1.6.3.25"), new OctetString(this.getDataHoraAlarmeMicrosol(this.alarmesMicrosol[i])))});
                ++i;
                do {
                    if (i <= this.alarmesMicrosol.length - 1 && this.alarmesMicrosol[i] != null) continue block0;
                    ++k;
lbl11:
                    // 2 sources

                } while (k < this.alarmesMicrosol.length);
            }
        }
    }

    protected String getDataHoraAlarmeMicrosol(Evento alarme) {
        this.dataSistema.setTimeInMillis(System.currentTimeMillis());
        this.dataSistema.set(2, 0);
        this.dataUPS.set(5, alarme.getDia());
        this.dataUPS.set(11, alarme.getHora());
        this.dataUPS.set(12, alarme.getMinuto());
        if (alarme.getDia() < this.dataSistema.get(5)) {
            if (this.dataSistema.get(2) == 0) {
                this.dataUPS.set(1, this.dataSistema.get(1) - 1);
                this.dataUPS.set(2, 11);
            } else {
                this.dataUPS.set(1, this.dataSistema.get(1));
                this.dataUPS.set(2, this.dataSistema.get(2) - 1);
            }
        } else {
            this.dataUPS.set(1, this.dataSistema.get(1));
            this.dataUPS.set(2, this.dataSistema.get(2));
        }
        return this.dataUPS.getTime().toString();
    }

    private Evento[] geraAlarmesMicrosol() {
        String[] listaAlarmes = new String[]{"SUBTENSAO_ENTRADA", "SOBRETENSAO_ENTRADA", "RETORNO_REDE_ELETRICA", "SOBRECARGA", "BATERIAS_DESCARREGADAS", "CHAVE_LIGADA", "CHAVE_DESLIGADA", "DESLIGAMENTO", "INICIALIZACAO", "DESLIGAMENTO_REMOTO", "SUPER_AQUECIMENTO", "DESLIGAMENTO_PROGAMADO", "ACIONAMENTO_PROGRAMADO", "SAIDA_SEM_CONSUMO", "BATERIA_BAIXA", "SAIDA_LIGADA", "BATERIAS_CARREGADAS"};
        Evento[] res = new Evento[listaAlarmes.length];
        GregorianCalendar dataSistema = new GregorianCalendar();
        dataSistema.setTimeInMillis(System.currentTimeMillis());
        int dia = 22;
        int hora = dataSistema.get(11);
        int min = dataSistema.get(12);
        int seg = dataSistema.get(13);
        int mes = dataSistema.get(2) + 1;
        int ano = dataSistema.get(1);
        int i = 0;
        while (i < res.length) {
            res[i] = new Evento(listaAlarmes[i], hora, min, seg, dia, mes, ano);
            ++i;
        }
        return res;
    }

    public static boolean[] geraAlarmes(boolean valor) {
        boolean[] res = new boolean[24];
        int i = 0;
        while (i < res.length) {
            res[i] = valor;
            ++i;
        }
        return res;
    }
}

