/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.servico;

import br.com.schneider.sgm.historico.HistoricoConsumo;
import br.com.schneider.sgm.snmp.UpsOutputGroup;
import org.snmp4j.agent.NotificationOriginator;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.VariableBinding;

public class NotificadorHisConsumo
extends Thread {
    private UpsOutputGroup grupoSaida;
    private NotificationOriginator notificationOriginator;
    private HistoricoConsumo hisConsumo;
    private TimeTicks horaTrap;

    public NotificadorHisConsumo(UpsOutputGroup grupoSaida, NotificationOriginator notificationOriginator, HistoricoConsumo hisConsumo, TimeTicks horaTrap) {
        this.grupoSaida = grupoSaida;
        this.notificationOriginator = notificationOriginator;
        this.hisConsumo = hisConsumo;
        this.horaTrap = horaTrap;
    }

    @Override
    public void run() {
        int tipoHisConsulta = ((Integer32)this.grupoSaida.getUpsTipoHisConsumo().getValue()).toInt();
        String periodoConsulta = ((OctetString)this.grupoSaida.getUpsPeriodoConsumo().getValue()).toString();
        String valor = "";
        switch (tipoHisConsulta) {
            case 1: {
                valor = this.hisConsumo.getConsumoDiario(periodoConsulta);
                break;
            }
            case 2: {
                valor = this.hisConsumo.getConsumoSemanal(periodoConsulta);
                break;
            }
            case 3: {
                valor = this.hisConsumo.getConsumoMensal(periodoConsulta);
                break;
            }
            case 4: {
                valor = this.hisConsumo.getConsumoAnual(periodoConsulta);
            }
        }
        this.grupoSaida.setsUpsResultadoConsumo(valor);
        this.notificationOriginator.notify(new OctetString(), new OID("1.3.6.1.2.1.33.2.6"), this.horaTrap, new VariableBinding[]{new VariableBinding(new OID("1.3.6.1.2.1.33.1.4.6"), new Integer32(tipoHisConsulta)), new VariableBinding(new OID("1.3.6.1.2.1.33.1.4.7"), new OctetString(periodoConsulta)), new VariableBinding(new OID("1.3.6.1.2.1.33.1.4.8"), new OctetString(valor))});
        this.grupoSaida.getUpsTipoHisConsumo().setAtualizacao(false);
        this.grupoSaida.getUpsTipoHisConsumo().setAtualizacao(false);
    }
}

