/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.servico;

import br.com.schneider.sgm.controle.Controle;
import br.com.schneider.sgm.eventos.BatTesteListener;
import br.com.schneider.sgm.eventos.ControleListener;
import java.util.logging.Logger;

public class BatTestHandler
implements Runnable,
ControleListener {
    private static final int AGUARDANDO_TESTE = 0;
    private static final int INICIANDO = 1;
    private static final int AGUARDANDO_DESLIGAR = 2;
    private static final int EXECUTANDO = 3;
    private static final int AGUARDANDO_LIGAR = 4;
    private static final int FINALIZANDO = 5;
    private static final int FALHA_TIMEOUT = 1;
    private static final int FALHA_BATERIA_MUITO_BAIXA = 2;
    private static final int FALHA_COMUNICACAO = 3;
    private static final int TIME_OUT_EXECUTANDO = 20;
    private static final int TIMEOUT = 10;
    private static final int AUTO_TESTE_DIARIO = 0;
    private static final int AUTO_TESTE_SEMANAL = 1;
    private static final int AUTO_TESTE_MENSAL = 2;
    private int horaTeste;
    private int minutoTeste;
    private int periodoAutoTeste;
    private boolean autoTesteEnabled;
    private boolean executandoAutoTeste;
    private char estado;
    private float tensaoBateriaInicial;
    private float potenciaInicial;
    private float tensaoBateriaFinal;
    private float potenciaFinal;
    private int tempoTeste;
    private int timeout;
    private BatTesteListener batListener = null;
    private static Logger log = Logger.getLogger(BatTestHandler.class.getName());
    private Controle controle;

    public BatTestHandler(Controle controle, BatTesteListener bat) {
        this.horaTeste = 0;
        this.minutoTeste = 0;
        this.periodoAutoTeste = 0;
        this.autoTesteEnabled = false;
        this.controle = controle;
        this.estado = '\u0000';
        this.batListener = bat;
        controle.addControleListener(this);
    }

    public BatTestHandler(int horaTeste, int minutoTeste, int periodoAutoTeste, boolean autoTesteEnabled, Controle controle) {
        this.horaTeste = horaTeste;
        this.minutoTeste = minutoTeste;
        this.periodoAutoTeste = periodoAutoTeste;
        this.autoTesteEnabled = autoTesteEnabled;
        this.controle = controle;
        this.controle.addControleListener(this);
        this.estado = '\u0000';
    }

    @Override
    public void run() {
        int timeout = 0;
        boolean iniciado = false;
        while (true) {
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.autoTesteEnabled) {
                return;
            }
            if (this.estado != '\u0000' && ++timeout > 20) {
                this.estado = '\u0000';
                this.batListener.testeBateriaAbortado(1);
            }
            if (this.controle.getHora() != this.horaTeste || this.controle.getMinutos() != this.minutoTeste) {
                iniciado = false;
                continue;
            }
            log.info("AUTO TESTE BATERIA - Verificando se Auto Teste Bateria \u00ef\u00bf\u00bd iniciado");
            if (iniciado || this.estado != '\u0000') continue;
            if (!this.controle.isBatteryTestAvailable()) {
                this.batListener.testeBateriaIndisponivel();
                iniciado = true;
                continue;
            }
            switch (this.periodoAutoTeste) {
                case 0: {
                    if (this.executandoAutoTeste) break;
                    this.iniciarAutoTeste();
                    iniciado = true;
                    break;
                }
                case 1: {
                    if (this.controle.getDiaSemana() != 1 || this.executandoAutoTeste) break;
                    this.iniciarAutoTeste();
                    iniciado = true;
                    break;
                }
                case 2: {
                    if (this.controle.getDiaMes() != 1 || this.executandoAutoTeste) break;
                    this.iniciarAutoTeste();
                    iniciado = true;
                }
            }
        }
    }

    private void iniciarAutoTeste() {
        this.controle.ligaEntrada();
        log.info("AUTO TESTE BATERIA -  iniciarAutoTeste()");
        if (this.controle.isRedeFalha()) {
            return;
        }
        if (!this.controle.isSaidaLigada()) {
            return;
        }
        if (this.controle.isBypassAtivado()) {
            return;
        }
        this.estado = '\u0001';
        this.executandoAutoTeste = true;
    }

    private void iniciando() {
        log.fine("AUTO TESTE BATERIA -  iniciando()");
        this.tensaoBateriaInicial = this.controle.getTensaoBateria();
        this.potenciaInicial = this.controle.getPotenciaReal();
        this.batListener.inicioTesteBateria();
    }

    private boolean executando() {
        log.info("AUTO TESTE BATERIA -  executando()");
        ++this.tempoTeste;
        return this.tempoTeste <= 60;
    }

    private void finaliza() {
        this.executandoAutoTeste = false;
        this.tensaoBateriaFinal = this.controle.getTensaoBateria();
        this.potenciaFinal = this.controle.getPotenciaReal();
        this.batListener.fimTesteBateria(this.controle.calculaEstadoBaterias(this.tensaoBateriaInicial, this.tensaoBateriaFinal, (this.potenciaFinal + this.potenciaInicial) / 2.0f, this.tempoTeste));
        this.estado = '\u0000';
        log.fine("AUTO TESTE BATERIA -  finaliza() : Final!");
    }

    private void autoTeste() {
        if (!this.executandoAutoTeste) {
            return;
        }
        if (this.timeout > 10 && this.estado != '\u0003') {
            this.abortar(1);
        }
        if (this.timeout > 20 && this.estado == '\u0003') {
            this.abortar(1);
        }
        if (this.controle.isBateriaBaixa()) {
            this.abortar(2);
        }
        switch (this.estado) {
            case '\u0001': {
                this.estado = (char)(this.estado + '\u0001');
                this.timeout = 0;
                break;
            }
            case '\u0002': {
                this.controle.desligaEntrada();
                if (!this.controle.isUsandoSomenteBateria()) {
                    this.tempoTeste = 0;
                    ++this.timeout;
                    log.fine("AUTO TESTE BATERIA -  Aguardando Desligar");
                    break;
                }
                this.estado = (char)(this.estado + '\u0001');
                this.timeout = 0;
                this.iniciando();
                break;
            }
            case '\u0003': {
                log.info("AUTO TESTE BATERIA - Executando");
                if (this.executando()) break;
                this.timeout = 0;
                this.estado = (char)(this.estado + '\u0001');
                break;
            }
            case '\u0004': {
                log.info("AUTO TESTE BATERIA - Aguardando Ligar");
                this.controle.ligaEntrada();
                if (this.controle.isUsandoSomenteBateria()) {
                    this.estado = (char)(this.estado + '\u0001');
                    ++this.timeout;
                    break;
                }
                this.timeout = 0;
                break;
            }
            case '\u0005': {
                this.finaliza();
            }
        }
    }

    private void abortar(int mensagem) {
        String msg = new String();
        this.controle.ligaEntrada();
        switch (mensagem) {
            case 2: {
                this.batListener.testeBateriaAbortado(2);
                msg = "abortado: bateria baixa";
                break;
            }
            case 1: {
                this.batListener.testeBateriaAbortado(1);
                msg = "abortado: timeout";
                break;
            }
            case 3: {
                this.batListener.testeBateriaAbortado(3);
                msg = "abortado: falha comunicacao";
            }
        }
        log.warning("AUTO TESTE BATERIA - abortar(): " + msg);
        this.executandoAutoTeste = false;
        this.controle.ligaEntrada();
    }

    public int getPeriodoAutoTeste() {
        return this.periodoAutoTeste;
    }

    public int getHoraTeste() {
        return this.horaTeste;
    }

    public int getMinutoTeste() {
        return this.minutoTeste;
    }

    public boolean getAutoTesteHabilitado() {
        return false;
    }

    public void setPeriodoAutoTeste(int periodo) {
        this.periodoAutoTeste = periodo;
    }

    public void setHoraTeste(int hora) {
        if (hora >= 0 && hora < 24) {
            this.horaTeste = hora;
        }
    }

    public void setMinutoTeste(int minuto) {
        if (minuto >= 0 && minuto < 60) {
            this.minutoTeste = minuto;
        }
    }

    public void setAutoTesteHabilitado(boolean tst) {
        this.autoTesteEnabled = tst;
    }

    @Override
    public void notificaBateriaBaixa() {
    }

    @Override
    public void notificaBateriaNormal() {
    }

    @Override
    public void notificaCargaElevada() {
    }

    @Override
    public void notificaCargaNormal() {
    }

    @Override
    public void notificaComunicacao() {
    }

    @Override
    public void notificaDados() {
        if (this.estado != '\u0000') {
            this.autoTeste();
        }
    }

    @Override
    public void notificaFalhaCom() {
    }

    @Override
    public void notificaFalhaRede() {
    }

    @Override
    public void notificaNaoUsaBateria() {
    }

    @Override
    public void notificaRetornoCom() {
    }

    @Override
    public void notificaRetornoRede() {
    }

    @Override
    public void notificaTemperaturaElevada() {
    }

    @Override
    public void notificaTemperaturaNormal() {
    }

    @Override
    public void notificaUsandoBateria() {
    }
}

