/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.serial;

import br.com.schneider.sgm.comunicacao.Communication;
import br.com.schneider.sgm.eventos.DriverListener;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import org.apache.commons.lang3.SystemUtils;

public class DriverSerial
implements SerialPortEventListener,
Communication {
    private final int MAXIMO_BYTES_LIDOS = 2000;
    private int[] pacote = new int[2000];
    private int delayLeitura;
    private BufferedInputStream entrada;
    private BufferedOutputStream saida;
    private CommPortIdentifier[] identificadoresPortas;
    private SerialPort portaSerial;
    private int quantidadePortas;
    private int indice = -1;
    private DriverListener ouvinteDriver;
    private String portaSerialEscolhida;
    private int tempoEspera;
    private int baudRate;
    private int dataBits;
    private int stopBit;
    private int paridade;

    public DriverSerial() {
        Enumeration enumeraPortas = CommPortIdentifier.getPortIdentifiers();
        this.identificadoresPortas = new CommPortIdentifier[30];
        this.quantidadePortas = 0;
        while (enumeraPortas.hasMoreElements()) {
            CommPortIdentifier portaId = (CommPortIdentifier)enumeraPortas.nextElement();
            if (portaId.getPortType() != 1) continue;
            this.identificadoresPortas[this.quantidadePortas++] = portaId;
        }
    }

    @Override
    public boolean restart() {
        switch (this.dataBits) {
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            default: {
                return false;
            }
        }
        switch (this.stopBit) {
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                return false;
            }
        }
        switch (this.paridade) {
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                return false;
            }
        }
        int i = 0;
        boolean encontrado = false;
        while (i < this.quantidadePortas) {
            if (this.identificadoresPortas[i].getName().equals(this.portaSerialEscolhida)) {
                encontrado = true;
                this.indice = i;
            }
            ++i;
        }
        if (!encontrado) {
            return false;
        }
        try {
            this.portaSerial = (SerialPort)this.identificadoresPortas[this.indice].open("DriverSerialUPS", this.tempoEspera);
        }
        catch (PortInUseException piue) {
            return false;
        }
        try {
            this.entrada = new BufferedInputStream(this.portaSerial.getInputStream());
            this.saida = new BufferedOutputStream(this.portaSerial.getOutputStream());
        }
        catch (IOException ioe) {
            return false;
        }
        try {
            this.portaSerial.addEventListener(this);
        }
        catch (TooManyListenersException tmle) {
            return false;
        }
        try {
            this.portaSerial.setSerialPortParams(this.baudRate, this.dataBits, this.stopBit, this.paridade);
            this.portaSerial.setRTS(false);
            this.portaSerial.setDTR(true);
        }
        catch (UnsupportedCommOperationException ucoe) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
        this.portaSerial.notifyOnDataAvailable(true);
        return true;
    }

    @Override
    public boolean open(String[] parametrosConfiguracao) {
        this.portaSerialEscolhida = parametrosConfiguracao[0];
        this.tempoEspera = Integer.parseInt(parametrosConfiguracao[1]);
        this.baudRate = Integer.parseInt(parametrosConfiguracao[2]);
        this.dataBits = Integer.parseInt(parametrosConfiguracao[3]);
        this.stopBit = Integer.parseInt(parametrosConfiguracao[4]);
        this.paridade = Integer.parseInt(parametrosConfiguracao[5]);
        this.delayLeitura = Integer.parseInt(parametrosConfiguracao[6]);
        return this.restart();
    }

    @Override
    public boolean close() {
        try {
            if (this.entrada != null) {
                this.entrada.close();
                this.entrada = null;
                System.out.println("fechou entrada");
            }
            if (this.saida != null) {
                this.saida.close();
                this.saida = null;
                System.out.println("fechou saida");
            }
            if (this.portaSerial != null) {
                this.portaSerial.close();
                this.portaSerial = null;
                System.out.println("fechou portaSerial");
            }
            this.indice = -1;
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
            ioe.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public BufferedInputStream getEntrada() {
        return this.entrada;
    }

    @Override
    public BufferedOutputStream getSaida() {
        return this.saida;
    }

    @Override
    public SerialPort getPortaSerial() {
        return this.portaSerial;
    }

    @Override
    public void serialEvent(SerialPortEvent spe) {
        switch (spe.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                try {
                    Thread.sleep(this.delayLeitura);
                    int bytes = this.entrada.available();
                    int i = 0;
                    while (i < bytes) {
                        this.pacote[i] = this.entrada.read();
                        ++i;
                    }
                    this.pacote[bytes] = bytes;
                    i = bytes + 1;
                    while (i < this.pacote.length) {
                        this.pacote[i] = -1;
                        ++i;
                    }
                    try {
                        this.ouvinteDriver.notifica();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                catch (IOException bytes) {
                    break;
                }
                catch (InterruptedException bytes) {
                    break;
                }
                catch (Exception e) {
                    this.close();
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public boolean sendBytes(int[] pct) {
        try {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < pct.length) {
                this.saida.write(pct[i]);
                sb.append(String.valueOf(Integer.toHexString(pct[i])) + " ");
                ++i;
            }
            this.saida.flush();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    @Override
    public boolean sendBytes(int[] pct, int delay) {
        try {
            int i = 0;
            while (i < pct.length) {
                this.saida.write(pct[i]);
                Thread.sleep(delay);
                ++i;
            }
            this.saida.flush();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public int[] getBytes() {
        return this.pacote;
    }

    protected void finalize() {
        this.close();
    }

    @Override
    public String[] getPortas() {
        String[] portas = new String[this.quantidadePortas];
        int i = 0;
        while (i < portas.length) {
            portas[i] = this.identificadoresPortas[i].getName();
            ++i;
        }
        return portas;
    }

    @Override
    public int getIndicePortaAtual() {
        return this.indice;
    }

    @Override
    public String getNomePortaAtual() {
        if (!SystemUtils.IS_OS_WINDOWS) {
            if (this.portaSerial != null) {
                return this.portaSerial.getName();
            }
            return null;
        }
        if (this.portaSerial != null) {
            return this.portaSerial.getName().replaceAll("[^a-zA-Z0-9]", "");
        }
        return null;
    }

    @Override
    public void addDriverListener(DriverListener ouvinteDriver) {
        this.ouvinteDriver = ouvinteDriver;
    }
}

