/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.rmi;

import br.com.schneider.sgm.controle.Controle;
import br.com.schneider.sgm.rmi.MensageiroImpl;
import br.com.schneider.sgm.rmi.MensageiroRMI;
import br.com.schneider.sgm.rmi.PolicyFileLocator;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Scanner;

public class ServidorRMI
extends UnicastRemoteObject {
    private static final long serialVersionUID = -8522236889550538760L;
    private static MensageiroRMI m = new MensageiroImpl();

    public void start(Controle controle, Boolean segurarPrompt) {
        try {
            m.setControle(controle);
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        System.setProperty("java.rmi.server.codebase", m.getClass().getProtectionDomain().getCodeSource().getLocation().toString());
        System.setProperty("java.security.policy", PolicyFileLocator.getLocationOfPolicyFile());
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        Registry registry = null;
        try {
            registry = LocateRegistry.createRegistry(1099);
        }
        catch (RemoteException e) {
            try {
                registry = LocateRegistry.getRegistry(1099);
            }
            catch (RemoteException e2) {
                System.err.println("Registro n\u00e3o pode ser inicializado");
            }
        }
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        try {
            MensageiroRMI stub = (MensageiroRMI)ServidorRMI.exportObject((Remote)m, 0);
            String nome = "sgm-rmi";
            registry.rebind(nome, stub);
            if (segurarPrompt.booleanValue()) {
                ServidorRMI.waitForExit();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private static void waitForExit() {
        String in;
        System.out.println("___________________________________________________________________________\n");
        System.out.println("Controlador do Servi\u00e7o_SGM instalado no Sistema Operacional com sucesso...");
        System.out.println("___________________________________________________________________________");
        System.out.println("Obs.: Caso voc\u00ea esteja utilizando o prompt/console, digite 's + enter' para");
        System.out.println("finalizar o programa. Caso contr\u00e1rio, desconsidere esta observa\u00e7\u00e3o.");
        System.out.println("___________________________________________________________________________");
        Scanner scanner = new Scanner(System.in);
        while (!(in = scanner.next()).equalsIgnoreCase("s")) {
        }
        System.out.println();
        System.exit(0);
    }
}

