/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.rmi;

import br.com.schneider.sgm.controle.Controle;
import br.com.schneider.sgm.rmi.MensageiroRMI;
import java.io.File;
import java.net.MalformedURLException;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class ClienteRMI {
    private static String nome = "sgm-rmi";

    public String abrirPortaUsbDoServico(Controle gui) {
        try {
            if (ClienteRMI.isObjetoResgistrado()) {
                gui.getDriver().close();
                MensageiroRMI m = (MensageiroRMI)Naming.lookup(nome);
                if (m != null) {
                    m.iniciarUsoPortaUSB();
                }
                return "N\u00e3o foi poss\u00edvel, via RMI, abrir a porta USB.";
            }
        }
        catch (RemoteException ex) {
            System.out.println(ex.getMessage());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (NotBoundException e) {
            e.printStackTrace();
        }
        return "N\u00e3o foi poss\u00edvel acessar o servi\u00e7o via RMI";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String fecharPortaUsbUtilizadaPeloServico() {
        try {
            File config = new File(String.valueOf(System.getenv("APPDATA")) + File.separator + "APC" + File.separator + "XML" + File.separator + "config.sgm");
            Boolean primeiraExec = !config.exists();
            if (primeiraExec.booleanValue()) {
                return "";
            }
            int cont = 0;
            do {
                if (ClienteRMI.isObjetoResgistrado()) {
                    MensageiroRMI m = (MensageiroRMI)Naming.lookup(nome);
                    if (m == null) return "Porta USB do sevi\u00e7o fechada com sucesso";
                    m.fecharUsoPortaUSB();
                    return "Porta USB do sevi\u00e7o fechada com sucesso";
                }
                this.sleep(1000);
            } while (++cont != 300);
            Runtime.getRuntime().exec("start rmiregistry");
            do {
                if (ClienteRMI.isObjetoResgistrado()) {
                    MensageiroRMI m = (MensageiroRMI)Naming.lookup(nome);
                    if (m == null) return "Porta USB do sevi\u00e7o fechada com sucesso";
                    m.fecharUsoPortaUSB();
                    return "Porta USB do sevi\u00e7o fechada com sucesso";
                }
                this.sleep(1000);
            } while (++cont != 180);
            String msgErro = "N\u00e3o foi poss\u00edvel, via RMI, fechar a porta USB ap\u00f3s 3 min. de tentativas.";
            System.out.println(msgErro);
            return msgErro;
        }
        catch (RemoteException ex) {
            System.out.println(ex.getMessage());
            return "";
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return "";
        }
        catch (NotBoundException e) {
            e.printStackTrace();
            return "";
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public String fecharPortaUsbUtilizadaPeloServico2() {
        try {
            int cont = 0;
            do {
                if (ClienteRMI.isObjetoResgistrado()) {
                    MensageiroRMI m = (MensageiroRMI)Naming.lookup(nome);
                    if (m == null) return "Porta USB do sevi\u00e7o fechada com sucesso";
                    m.fecharUsoPortaUSB();
                    return "Porta USB do sevi\u00e7o fechada com sucesso";
                }
                this.sleep(1000);
            } while (++cont != 60);
            String msgErro = "N\u00e3o foi poss\u00edvel, via RMI, fechar a porta USB ap\u00f3s 1 min. de tentativas.";
            System.out.println(msgErro);
            return msgErro;
        }
        catch (RemoteException ex) {
            System.out.println(ex.getMessage());
            return "";
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return "";
        }
        catch (NotBoundException e) {
            e.printStackTrace();
            return "";
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return "";
    }

    private void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static boolean isObjetoResgistrado() throws RemoteException {
        return ClienteRMI.isObjetoResgistrado(nome);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isObjetoResgistrado(String nome) {
        try {
            Registry registry = LocateRegistry.getRegistry();
            if (nome == null) {
                return false;
            }
            if (registry == null) {
                return false;
            }
            if (registry.list() == null) {
                return false;
            }
            String[] stringArray = registry.list();
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String nomedoObjetoRegistrado = stringArray[n2];
                if (nome.equals(nomedoObjetoRegistrado)) {
                    System.out.print(nomedoObjetoRegistrado);
                    return true;
                }
                ++n2;
            }
        }
        catch (ConnectException e) {
            return false;
        }
        catch (RemoteException e) {
            return false;
        }
    }
}

