/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.protocolo;

import br.com.schneider.sgm.eventos.Evento;
import br.com.schneider.sgm.protocolo.ProtocoloUPS;
import java.util.GregorianCalendar;
import java.util.Timer;
import java.util.TimerTask;

public class ProtocoloSolis
extends ProtocoloUPS {
    private final int TEMPO_TIMEOUT = 1000;
    private final int ANO_BASE = 1998;
    protected final int RECONHECIMENTO_COMANDO = 172;
    protected final int COMANDO_INEXISTENTE = 238;
    protected final int COMANDO_LIGAR_ENTRADA = 194;
    protected final int COMANDO_DESLIGAR_ENTRADA = 195;
    protected boolean esperaDumpping;
    protected int[] pacoteDados;
    protected int[] pacoteDumpping;
    protected int[] vetorBytes;
    protected int numeroAlarmesMicrosol = 0;
    protected Evento[] alarmesMicrosol;
    protected Evento evento;
    protected boolean modoContinuo;
    protected Timer timeout = new Timer();

    public ProtocoloSolis() {
        this.pacoteDados = new int[25];
        this.pacoteDumpping = new int[200];
        this.alarmesMicrosol = new Evento[100];
    }

    @Override
    public void notifica() {
        this.recebeDados();
    }

    @Override
    public void recebeDados() {
        System.out.println("Recebi!!!");
        this.vetorBytes = this.comunicador.getBytes();
        int i = 0;
        int checksum = 0;
        while (this.vetorBytes[i++] != -1) {
        }
        int numeroBytes = i - 2;
        block0 : switch (numeroBytes) {
            case 1: 
            case 2: 
            case 3: {
                if (this.esperaACK && this.vetorBytes[0] == 172) {
                    this.esperaACK = false;
                }
                if (!this.esperaACK) break;
                int cfr_ignored_0 = this.vetorBytes[0];
                break;
            }
            case 25: {
                if (this.vetorBytes[20] != this.pacoteDados[20]) {
                    this.pedidoDumpping();
                }
                if (this.vetorBytes[24] != 254) break;
                i = 0;
                while (i <= 24) {
                    this.pacoteDados[i] = this.vetorBytes[i];
                    ++i;
                }
                i = 0;
                while (i <= 22) {
                    checksum = this.pacoteDados[i] + checksum;
                    ++i;
                }
                if (this.pacoteDados[23] != (checksum %= 256)) break;
                this.trataPacoteDados();
                checksum = 0;
                break;
            }
            default: {
                if (this.vetorBytes[0] != 172 || numeroBytes < 5) break;
                boolean t = false;
                int j = 0;
                int z = 0;
                int cnt = 0;
                int pos = 1;
                while (this.vetorBytes[j] == 172) {
                    ++j;
                    ++z;
                }
                this.pacoteDumpping[0] = 172;
                checksum = 0;
                while (z < numeroBytes) {
                    this.pacoteDumpping[pos] = this.vetorBytes[z];
                    checksum += this.pacoteDumpping[pos];
                    if (++cnt == 3) {
                        cnt = 0;
                        if ((this.pacoteDumpping[pos] & 0x80) == 128) {
                            int checksum2 = checksum % 256;
                            if (checksum2 != this.vetorBytes[z + 1]) break block0;
                            this.pacoteDumpping[pos + 1] = this.vetorBytes[z + 1];
                            int numeroEventos = pos / 3;
                            this.trataPacoteDumpping(numeroEventos);
                            this.esperaDumpping = false;
                        }
                    }
                    ++z;
                    ++pos;
                }
                break block0;
            }
        }
    }

    @Override
    protected void trataPacoteDados() {
        this.setCabecalhoPacote(this.pacoteDados[0]);
        this.setTensaoSaida(this.pacoteDados[1]);
        this.setTensaoBateria(this.pacoteDados[3]);
        this.setTemperaturaUPS(this.pacoteDados[4]);
        this.setCorrenteSaida(this.pacoteDados[5]);
        this.setTensaoEntrada(this.pacoteDados[6]);
        this.setPotenciaReal(this.pacoteDados[7], this.pacoteDados[8]);
        this.setSegundos(this.pacoteDados[9]);
        this.setMinutos(this.pacoteDados[10]);
        this.setHora(this.pacoteDados[11]);
        this.setHoraLigar(this.pacoteDados[13]);
        this.setMinutoLigar(this.pacoteDados[14]);
        this.setHoraDesligar(this.pacoteDados[15]);
        this.setMinutoDesligar(this.pacoteDados[16]);
        this.setDiaSemana(this.pacoteDados[18]);
        this.setDiasSemanaProgramados(this.pacoteDados[17]);
        this.setDiaMes(this.pacoteDados[18]);
        this.setAno(this.pacoteDados[19]);
        this.setMes(this.pacoteDados[19]);
        this.setTensaoSaida220(this.pacoteDados[20]);
        this.setCarregandoBateria(this.pacoteDados[20]);
        this.setBateriaCritica(this.pacoteDados[20]);
        this.setModoBateria(this.pacoteDados[20]);
        this.setSuperAquecimento(this.pacoteDados[20]);
        this.setModoRede(this.pacoteDados[20]);
        this.setTensaoEntrada220(this.pacoteDados[20]);
        this.setSobrecarga(this.pacoteDados[20]);
        this.setModoBypass(this.pacoteDados[20]);
        this.setFrequenciaEntrada(this.pacoteDados[21], this.pacoteDados[22]);
        this.ouvinteProtocolo.notifica();
    }

    @Override
    public void trataPacoteDumpping(int numeroEventos) {
        GregorianCalendar calendar = new GregorianCalendar();
        this.setModoContinuo();
        this.esperaACK = false;
        int i = 0;
        while (i < numeroEventos) {
            int hora = (this.pacoteDumpping[i * 3 + 1] & 0xF8) >> 3;
            int minuto = (this.pacoteDumpping[i * 3 + 1] & 7) << 3 | (this.pacoteDumpping[i * 3 + 2] & 0xE0) >> 5;
            int segundo = calendar.get(13);
            int tipo = this.pacoteDumpping[i * 3 + 2] & 0x1F;
            int offSet = this.pacoteDumpping[i * 3 + 3] & 0x7F;
            int mesAtual = calendar.get(2) + 1;
            int anoAtual = calendar.get(1);
            if (hora <= 23 && minuto <= 59 && this.getDiaMes() + offSet <= 31) {
                this.evento = new Evento(tipo, hora, minuto, segundo, this.getDiaMes() + offSet, mesAtual, anoAtual);
                this.addEvento(this.evento);
            }
            ++i;
        }
        if ((this.pacoteDumpping[i * 3 + 3] & 0x80) == 1) {
            this.esperaDumpping = false;
        }
    }

    public void addEvento(Evento evt) {
        this.alarmesMicrosol[this.numeroAlarmesMicrosol] = evt;
        ++this.numeroAlarmesMicrosol;
    }

    @Override
    public boolean ligaSaida() {
        return false;
    }

    @Override
    public boolean desligaSaida() {
        return false;
    }

    @Override
    public boolean ativaBypass() {
        return false;
    }

    @Override
    public boolean desativaBypass() {
        return false;
    }

    @Override
    public boolean configuraRelogio(int segundos, int minutos, int horas) {
        int[] bytes = new int[12];
        int checksum = 0;
        int temp = 0;
        bytes[0] = 207;
        bytes[1] = horas;
        bytes[2] = minutos;
        bytes[3] = segundos;
        bytes[4] = this.getHoraLigar();
        bytes[5] = this.getMinutoLigar();
        bytes[6] = this.getHoraDesligar();
        bytes[7] = this.getMinutoDesligar();
        bytes[8] = this.getDiaSemana() << 5;
        bytes[8] = bytes[8] | this.getDiaMes();
        bytes[9] = this.getMes() << 4;
        bytes[9] = bytes[9] | this.getAno() - 1998;
        int semana = 0;
        temp = 0;
        boolean[] dias = this.getDiasSemanaProgramados();
        int i = 1;
        while (i < 7) {
            temp = dias[i] ? 1 : 0;
            semana |= temp << 7 - i;
            ++i;
        }
        temp = dias[0] ? 1 : 0;
        bytes[10] = semana |= temp;
        temp = this.modoContinuo ? 1 : 0;
        bytes[10] = bytes[10] | temp & 0x80;
        i = 0;
        while (i <= 10) {
            checksum += bytes[i];
            bytes[i] = bytes[i];
            ++i;
        }
        bytes[11] = checksum % 256;
        return this.enviaDados(bytes);
    }

    @Override
    public boolean configuraCalendario(int diaSemana, int diaMes, int mes, int ano) {
        int[] bytes = new int[12];
        int checksum = 0;
        int temp = 0;
        bytes[0] = 207;
        bytes[1] = this.getHora();
        bytes[2] = this.getMinutos();
        bytes[3] = this.getSegundos();
        bytes[4] = this.getHoraLigar();
        bytes[5] = this.getMinutoLigar();
        bytes[6] = this.getHoraDesligar();
        bytes[7] = this.getMinutoDesligar();
        bytes[8] = diaSemana << 5;
        bytes[8] = bytes[8] | diaMes;
        bytes[9] = mes << 4;
        bytes[9] = bytes[9] | ano - 1998;
        int semana = 0;
        temp = 0;
        boolean[] dias = this.getDiasSemanaProgramados();
        int i = 1;
        while (i < 7) {
            temp = dias[i] ? 1 : 0;
            semana |= temp << 7 - i;
            ++i;
        }
        temp = dias[0] ? 1 : 0;
        bytes[10] = semana |= temp;
        temp = this.modoContinuo ? 1 : 0;
        bytes[10] = bytes[10] | temp & 0x80;
        i = 0;
        while (i <= 10) {
            checksum += bytes[i];
            bytes[i] = bytes[i];
            ++i;
        }
        bytes[11] = checksum % 256;
        return this.enviaDados(bytes);
    }

    @Override
    public boolean programaSemana(boolean[] dias, int horaLigar, int minutoLigar, int horaDesligar, int minutoDesligar) {
        int[] bytes = new int[12];
        int checksum = 0;
        int temp = 0;
        bytes[0] = 207;
        bytes[1] = this.getHora();
        bytes[2] = this.getMinutos();
        bytes[3] = this.getSegundos();
        bytes[4] = horaLigar;
        bytes[5] = minutoLigar;
        bytes[6] = horaDesligar;
        bytes[7] = minutoDesligar;
        bytes[8] = this.getDiaSemana() << 5;
        bytes[8] = bytes[8] | this.getDiaMes();
        temp = this.getMes();
        bytes[9] = temp << 4;
        bytes[9] = bytes[9] | this.getAno() - 1998;
        int semana = 0;
        temp = 0;
        int i = 1;
        while (i < 7) {
            temp = dias[i] ? 1 : 0;
            semana |= temp << 7 - i;
            ++i;
        }
        temp = dias[0] ? 1 : 0;
        bytes[10] = semana |= temp;
        temp = this.modoContinuo ? 1 : 0;
        bytes[10] = bytes[10] | temp & 0x80;
        i = 0;
        while (i <= 10) {
            checksum += bytes[i];
            bytes[i] = bytes[i];
            ++i;
        }
        bytes[11] = checksum % 256;
        return this.enviaDados(bytes);
    }

    @Override
    public boolean configuraCalendarioRelogio(int diaSemana, int diaMes, int mes, int ano, int segundos, int minutos, int horas) {
        int[] bytes = new int[12];
        int checksum = 0;
        int temp = 0;
        bytes[0] = 207;
        bytes[1] = horas;
        bytes[2] = minutos;
        bytes[3] = segundos;
        bytes[4] = this.getHoraLigar();
        bytes[5] = this.getMinutoLigar();
        bytes[6] = this.getHoraDesligar();
        bytes[7] = this.getMinutoDesligar();
        bytes[8] = diaSemana << 5;
        bytes[8] = bytes[8] | diaMes;
        bytes[9] = mes << 4;
        bytes[9] = bytes[9] | ano - 1998;
        int semana = 0;
        temp = 0;
        boolean[] dias = this.getDiasSemanaProgramados();
        int i = 1;
        while (i < 7) {
            temp = dias[i] ? 1 : 0;
            semana |= temp << 7 - i;
            ++i;
        }
        temp = dias[0] ? 1 : 0;
        bytes[10] = semana |= temp;
        temp = this.modoContinuo ? 1 : 0;
        bytes[10] = bytes[10] | temp & 0x80;
        i = 0;
        while (i <= 10) {
            checksum += bytes[i];
            bytes[i] = bytes[i];
            ++i;
        }
        bytes[11] = checksum % 256;
        return this.enviaDados(bytes);
    }

    @Override
    public boolean configuraCalendarioRelogioSemana(int diaSemana, int diaMes, int mes, int ano, int segundos, int minutos, int horas, boolean[] dias, int horaLigar, int minutoLigar, int horaDesligar, int minutoDesligar) {
        int[] bytes = new int[12];
        int checksum = 0;
        int temp = 0;
        bytes[0] = 207;
        bytes[1] = horas;
        bytes[2] = minutos;
        bytes[3] = segundos;
        bytes[4] = horaLigar;
        bytes[5] = minutoLigar;
        bytes[6] = horaDesligar;
        bytes[7] = minutoDesligar;
        bytes[8] = diaSemana << 5;
        bytes[8] = bytes[8] | diaMes;
        temp = mes;
        bytes[9] = temp << 4;
        bytes[9] = bytes[9] | ano - 1998;
        int semana = 0;
        temp = 0;
        int i = 1;
        while (i < 7) {
            temp = dias[i] ? 1 : 0;
            semana |= temp << 7 - i;
            ++i;
        }
        temp = dias[0] ? 1 : 0;
        bytes[10] = semana |= temp;
        temp = this.modoContinuo ? 1 : 0;
        bytes[10] = bytes[10] | temp & 0x80;
        i = 0;
        while (i <= 10) {
            checksum += bytes[i];
            bytes[i] = bytes[i];
            ++i;
        }
        bytes[11] = checksum % 256;
        return this.enviaDados(bytes);
    }

    @Override
    public boolean shutdown() {
        int[] bytes = new int[10];
        int i = 0;
        while (i <= 9) {
            bytes[i] = 222;
            ++i;
        }
        return this.enviaDados(bytes);
    }

    @Override
    public boolean shutdownReligamento() {
        int[] bytes = new int[10];
        int i = 0;
        while (i <= 9) {
            bytes[i] = 221;
            ++i;
        }
        return this.enviaDados(bytes);
    }

    @Override
    public boolean setModoEvento() {
        int[] bytes = new int[2];
        int i = 0;
        while (i < 2) {
            bytes[i] = 206;
            ++i;
        }
        this.modoContinuo = false;
        return this.enviaDados(bytes);
    }

    @Override
    public boolean setModoContinuo() {
        int[] bytes = new int[2];
        int i = 0;
        while (i < 2) {
            bytes[i] = 204;
            ++i;
        }
        this.modoContinuo = true;
        return this.enviaDados(bytes);
    }

    @Override
    public boolean pedidoDumpping() {
        int[] bytes = new int[]{205};
        this.esperaDumpping = true;
        this.comandoAceito = 1;
        return this.enviaDados(bytes);
    }

    @Override
    public Evento[] downloadEventos() {
        if (this.numeroAlarmesMicrosol > 0) {
            Evento[] temp = (Evento[])this.alarmesMicrosol.clone();
            temp[this.numeroAlarmesMicrosol] = null;
            this.numeroAlarmesMicrosol = 0;
            this.alarmesMicrosol = new Evento[100];
            return temp;
        }
        return null;
    }

    @Override
    public boolean enviaDados(int[] pacote) {
        this.comandoAceito = 0;
        this.comunicador.sendBytes(pacote);
        this.timeout.schedule((TimerTask)new ProtocoloUPS.TimeoutEnvio(this), 1000L);
        this.esperaACK = true;
        while (this.comandoAceito == 0) {
        }
        if (this.comandoAceito == 1) {
            this.comandoAceito = 0;
            return true;
        }
        this.comandoAceito = 0;
        this.esperaACK = false;
        return false;
    }

    public void setFrequenciaEntrada(int frequenciaEntrada1, int frequenciaEntrada2) {
        this.frequenciaEntrada = frequenciaEntrada1 + frequenciaEntrada2 * 256;
    }

    public void setPotenciaReal(int potenciaReal1, int potenciaReal2) {
        this.potenciaReal = potenciaReal1 + potenciaReal2 * 256;
    }

    @Override
    public void setAno(int ano) {
        this.ano = (ano & 0xF) + 1998;
    }

    @Override
    public void setBateriaCritica(int bateriaCritica) {
        this.bateriaCritica = (bateriaCritica & 4) == 4;
    }

    @Override
    public void setCarregandoBateria(int carregandoBateria) {
        this.carregandoBateria = (carregandoBateria & 2) == 2 && this.getModoRede();
    }

    @Override
    public void setCorrenteSaida(int correnteSaida) {
        this.correnteSaida = correnteSaida;
    }

    @Override
    public void setDiaMes(int diaMes) {
        this.diaMes = diaMes & 0x1F;
    }

    @Override
    public void setDiaSemana(int diaSemana) {
        this.diaSemana = (diaSemana & 0xE0) >> 5;
    }

    @Override
    public void setHora(int hora) {
        this.hora = hora;
    }

    @Override
    public void setHoraDesligar(int horaDesligar) {
        this.horaDesligar = horaDesligar;
    }

    @Override
    public void setHoraLigar(int horaLigar) {
        this.horaLigar = horaLigar;
    }

    @Override
    public void setMes(int mes) {
        this.mes = (mes & 0xF0) >> 4;
    }

    @Override
    public void setMinutoDesligar(int minutoDesligar) {
        this.minutoDesligar = minutoDesligar;
    }

    @Override
    public void setMinutoLigar(int minutoLigar) {
        this.minutoLigar = minutoLigar;
    }

    @Override
    public void setMinutos(int minutos) {
        this.minutos = minutos;
    }

    @Override
    public void setModoBateria(int modoBateria) {
        this.modoBateria = (modoBateria & 8) == 8;
    }

    @Override
    public void setModoRede(int modoRede) {
        this.modoRede = (modoRede & 0x20) != 32;
    }

    @Override
    public void setSegundos(int segundos) {
        this.segundos = segundos;
    }

    @Override
    public void setSobrecarga(int sobrecarga) {
        this.sobrecarga = (sobrecarga & 0x80) == 128;
    }

    @Override
    public void setSuperAquecimento(int superAquecimento) {
        this.superAquecimento = (superAquecimento & 0x10) == 16;
    }

    @Override
    public void setTemperaturaUPS(int temperaturaUPS) {
        this.temperaturaUPS = temperaturaUPS;
    }

    @Override
    public void setTensaoBateria(int tensaoBateria) {
        this.tensaoBateria = tensaoBateria;
    }

    @Override
    public void setTensaoEntrada(int tensaoEntrada) {
        this.tensaoEntrada = tensaoEntrada;
    }

    @Override
    public void setTensaoEntrada220(int tensaoEntrada220) {
        this.tensaoEntrada220 = !this.getModoRede() && this.isTensaoEntrada220() ? true : (tensaoEntrada220 & 0x40) == 64;
    }

    @Override
    public void setTensaoSaida(int tensaoSaida) {
        this.tensaoSaida = tensaoSaida;
    }

    @Override
    public void setTensaoSaida220(int tensaoSaida220) {
        this.tensaoSaida220 = (tensaoSaida220 & 1) == 1;
    }

    @Override
    public void setDiasSemanaProgramados(int diasSemanaProgramados) {
        int[] mascara = new int[]{1, 2, 4, 8, 16, 32, 64};
        switch (this.diaSemana) {
            case 0: {
                this.diasSemanaProgramados[0] = (diasSemanaProgramados & mascara[0]) == mascara[0];
                this.diasSemanaProgramados[6] = (diasSemanaProgramados & mascara[1]) == mascara[1];
                this.diasSemanaProgramados[5] = (diasSemanaProgramados & mascara[2]) == mascara[2];
                this.diasSemanaProgramados[4] = (diasSemanaProgramados & mascara[3]) == mascara[3];
                this.diasSemanaProgramados[3] = (diasSemanaProgramados & mascara[4]) == mascara[4];
                this.diasSemanaProgramados[2] = (diasSemanaProgramados & mascara[5]) == mascara[5];
                this.diasSemanaProgramados[1] = (diasSemanaProgramados & mascara[6]) == mascara[6];
                break;
            }
            case 1: {
                this.diasSemanaProgramados[0] = (diasSemanaProgramados & mascara[1]) == mascara[1];
                this.diasSemanaProgramados[6] = (diasSemanaProgramados & mascara[2]) == mascara[2];
                this.diasSemanaProgramados[5] = (diasSemanaProgramados & mascara[3]) == mascara[3];
                this.diasSemanaProgramados[4] = (diasSemanaProgramados & mascara[4]) == mascara[4];
                this.diasSemanaProgramados[3] = (diasSemanaProgramados & mascara[5]) == mascara[5];
                this.diasSemanaProgramados[2] = (diasSemanaProgramados & mascara[6]) == mascara[6];
                this.diasSemanaProgramados[1] = (diasSemanaProgramados & mascara[0]) == mascara[0];
                break;
            }
            case 2: {
                this.diasSemanaProgramados[0] = (diasSemanaProgramados & mascara[2]) == mascara[2];
                this.diasSemanaProgramados[6] = (diasSemanaProgramados & mascara[3]) == mascara[3];
                this.diasSemanaProgramados[5] = (diasSemanaProgramados & mascara[4]) == mascara[4];
                this.diasSemanaProgramados[4] = (diasSemanaProgramados & mascara[5]) == mascara[5];
                this.diasSemanaProgramados[3] = (diasSemanaProgramados & mascara[6]) == mascara[6];
                this.diasSemanaProgramados[2] = (diasSemanaProgramados & mascara[0]) == mascara[0];
                this.diasSemanaProgramados[1] = (diasSemanaProgramados & mascara[1]) == mascara[1];
                break;
            }
            case 3: {
                this.diasSemanaProgramados[0] = (diasSemanaProgramados & mascara[3]) == mascara[3];
                this.diasSemanaProgramados[6] = (diasSemanaProgramados & mascara[4]) == mascara[4];
                this.diasSemanaProgramados[5] = (diasSemanaProgramados & mascara[5]) == mascara[5];
                this.diasSemanaProgramados[4] = (diasSemanaProgramados & mascara[6]) == mascara[6];
                this.diasSemanaProgramados[3] = (diasSemanaProgramados & mascara[0]) == mascara[0];
                this.diasSemanaProgramados[2] = (diasSemanaProgramados & mascara[1]) == mascara[1];
                this.diasSemanaProgramados[1] = (diasSemanaProgramados & mascara[2]) == mascara[2];
                break;
            }
            case 4: {
                this.diasSemanaProgramados[0] = (diasSemanaProgramados & mascara[4]) == mascara[4];
                this.diasSemanaProgramados[6] = (diasSemanaProgramados & mascara[5]) == mascara[5];
                this.diasSemanaProgramados[5] = (diasSemanaProgramados & mascara[6]) == mascara[6];
                this.diasSemanaProgramados[4] = (diasSemanaProgramados & mascara[0]) == mascara[0];
                this.diasSemanaProgramados[3] = (diasSemanaProgramados & mascara[1]) == mascara[1];
                this.diasSemanaProgramados[2] = (diasSemanaProgramados & mascara[2]) == mascara[2];
                this.diasSemanaProgramados[1] = (diasSemanaProgramados & mascara[3]) == mascara[3];
                break;
            }
            case 5: {
                this.diasSemanaProgramados[0] = (diasSemanaProgramados & mascara[5]) == mascara[5];
                this.diasSemanaProgramados[6] = (diasSemanaProgramados & mascara[6]) == mascara[6];
                this.diasSemanaProgramados[5] = (diasSemanaProgramados & mascara[0]) == mascara[0];
                this.diasSemanaProgramados[4] = (diasSemanaProgramados & mascara[1]) == mascara[1];
                this.diasSemanaProgramados[3] = (diasSemanaProgramados & mascara[2]) == mascara[2];
                this.diasSemanaProgramados[2] = (diasSemanaProgramados & mascara[3]) == mascara[3];
                this.diasSemanaProgramados[1] = (diasSemanaProgramados & mascara[4]) == mascara[4];
                break;
            }
            case 6: {
                this.diasSemanaProgramados[0] = (diasSemanaProgramados & mascara[6]) == mascara[6];
                this.diasSemanaProgramados[6] = (diasSemanaProgramados & mascara[0]) == mascara[0];
                this.diasSemanaProgramados[5] = (diasSemanaProgramados & mascara[1]) == mascara[1];
                this.diasSemanaProgramados[4] = (diasSemanaProgramados & mascara[2]) == mascara[2];
                this.diasSemanaProgramados[3] = (diasSemanaProgramados & mascara[3]) == mascara[3];
                this.diasSemanaProgramados[2] = (diasSemanaProgramados & mascara[4]) == mascara[4];
                this.diasSemanaProgramados[1] = (diasSemanaProgramados & mascara[5]) == mascara[5];
            }
        }
    }

    @Override
    public void setCabecalhoPacote(int cabecalhoPacote) {
        this.cabecalhoPacote = cabecalhoPacote;
    }

    @Override
    public void setAutonomiaBateria(int autonomiaBateria) {
    }

    @Override
    public void setBateriaBaixa(int bateriaBaixa) {
    }

    @Override
    public void setBateriaCarregada(int bateriaCarregada) {
    }

    @Override
    public void setBateriaDescarregada(int bateriaDescarregada) {
    }

    @Override
    public void setBypassAtivado(int bypassAtivado) {
        this.bypassAtivado = false;
    }

    @Override
    public void setCargaElevada(int cargaElevada) {
    }

    @Override
    public void setComandoAceito(int comandoAceito) {
    }

    @Override
    public void setCorrenteEntrada(int correnteEntrada) {
    }

    @Override
    public void setEntradaLigada(int entradaLigada) {
    }

    @Override
    public void setExpansorBateria(int expansorBateria) {
    }

    @Override
    public void setFatorPotenciaCarga(int fatorPotenciaCarga) {
    }

    @Override
    public void setFrequenciaEntrada(int frequenciaEntrada) {
    }

    @Override
    public void setFrequenciaSaida(int frequenciaSaida) {
    }

    @Override
    public void setLimiteInferiorTensaoEntrada(int limiteInferiorTensaoEntrada) {
    }

    @Override
    public void setLimiteInferiorTensaoSaida(int limiteInferiorTensaoSaida) {
    }

    @Override
    public void setLimiteSuperiorTensaoEntrada(int limiteSuperiorTensaoEntrada) {
    }

    @Override
    public void setLimiteSuperiorTensaoSaida(int limiteSuperiorTensaoSaida) {
    }

    @Override
    public void setModeloUPS(int modeloUPS) {
        this.modeloUPS = modeloUPS;
    }

    @Override
    public void setModoBypass(int modoBypass) {
        this.modoBypass = (modoBypass & 0x40) == 64;
        this.bypassAtivado = (modoBypass & 0x40) == 64;
    }

    @Override
    public void setNumeroTimeout(int numeroTimeout) {
    }

    @Override
    public void setPercentualBateria(int percentualBateria) {
    }

    @Override
    public void setPotenciaAparente(int potenciaAparente) {
    }

    @Override
    public void setPotenciaReal(int potenciaReal) {
    }

    @Override
    public void setSaidaLigada(int saidaLigada) {
    }

    @Override
    public void setTemperaturaElevada(int temperaturaElevada) {
    }

    @Override
    public void setTensaoBoost(int tensaoBoost) {
    }

    @Override
    public void setTensaoEntradaNominal(int tensaoEntradaNominal) {
    }

    @Override
    public void setTensaoSaidaNominal(int tensaoSaidaNominal) {
    }

    @Override
    public boolean ligaEntrada() {
        int[] bytes = new int[10];
        int i = 0;
        while (i <= 9) {
            bytes[i] = 194;
            ++i;
        }
        return this.enviaDados(bytes);
    }

    @Override
    public boolean desligaEntrada() {
        int[] bytes = new int[10];
        int i = 0;
        while (i <= 9) {
            bytes[i] = 195;
            ++i;
        }
        return this.enviaDados(bytes);
    }

    @Override
    public void pedidoDados() {
    }
}

