/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.protocolo;

import br.com.schneider.sgm.eventos.Evento;
import br.com.schneider.sgm.protocolo.ProtocoloUPS;
import java.util.GregorianCalendar;
import java.util.Timer;

public class ProtocoloRhino
extends ProtocoloUPS {
    private static final int TEMPO_TIMEOUT = 1000;
    private final int ANO_BASE = 2000;
    private static final int COMANDO_LIGA_ENTRADA = 1;
    private static final int COMANDO_DESLIGA_ENTRADA = 2;
    private static final int COMANDO_LIGA_SAIDA = 3;
    private static final int COMANDO_DESLIGA_SAIDA = 4;
    private static final int COMANDO_ATIVA_BYPASS = 5;
    private static final int COMANDO_DESATIVA_BYPASS = 6;
    private static final int COMANDO_APAGA_EVENTOS = 8;
    private static final int COMANDO_CONFIG_IP = 9;
    private static final int COMANDO_CONFIG_NUMERO_SERIE = 10;
    private static final int COMANDO_CONFIG_RELOGIO = 11;
    private static final int COMANDO_CONFIG_TIMER = 12;
    private static final int COMANDO_CONFIG_AUTO_TESTE = 13;
    private static final int COMANDO_CONFIG_NOME = 14;
    private static final int COMANDO_CONFIG_MSGS = 15;
    private static final int COMANDO_CONFIG_MAC = 16;
    private static final int COMANDO_DOWNLOAD_EVENTOS = 7;
    private static final int COMANDO_PACOTE_DADOS = 53;
    private static final int COMANDO_PACOTE_CONFIGURACAO = 54;
    private static final int DELAY_ENTRE_BYTES = 3;
    private static final int NUM_BYTES_PAC_DADOS = 38;
    private static final int EVENTO_FALHA_REDE = 1;
    private static final int EVENTO_RETORNO_REDE = 2;
    private static final int EVENTO_SHUTDOWN_AUT = 4;
    private static final int EVENTO_SHUTDOWN_COMANDO = 6;
    private static final int EVENTO_SHUTDOWN_CANCEL = 9;
    private static final int EVENTO_SOBRECARGA = 10;
    private static final int EVENTO_CARGA_NOMINAL = 11;
    private static final int EVENTO_SUPERAQUECIMENTO = 12;
    private static final int EVENTO_TEMP_NORMAL = 13;
    private static final int EVENTO_BATERIA_USO = 16;
    private static final int EVENTO_FIM_BATERIA_USO = 17;
    private static final int EVENTO_BATERIA_DESCARREGADA = 18;
    private static final int EVENTO_BATERIA_NORMAL = 19;
    private static final int EVENTO_BATERIA_CRITICA = 20;
    private static final int EVENTO_SUBTENSAO_ENTRADA = 22;
    private static final int EVENTO_SOBRETENSAO_ENTRADA = 23;
    private static final int EVENTO_DESL_AUS_CON = 25;
    private static final int EVENTO_SAIDA_LIGADA = 26;
    private static final int EVENTO_SAIDA_DESLIGADA = 27;
    private static final int EVENTO_SHUTDOWN_TIMER = 28;
    private static final int EVENTO_INICIALIZACAO = 30;
    private static final int EVENTO_BYPASS_ATIVADO = 41;
    private static final int EVENTO_BYPASS_DESATIVADO = 42;
    private static final int EVENTO_ENTRADA_LIGADA = 43;
    private static final int EVENTO_ENTRADA_DESLIGADA = 44;
    private static final int EVENTO_EVENTOS_APAGADOS = 45;
    private static final int EVENTO_AUTOTESTE_OK = 46;
    private static final int EVENTO_AUTOTESTE_FALHOU = 47;
    private static final int EVENTO_SOBRETENSAO_BOOST = 48;
    private static final int EVENTO_FALHA_SAIDA = 50;
    private static final int EVENTO_EM_AUTOTESTE = 52;
    private int[] vetorBytes;
    private Timer timeout = new Timer();
    private int numeroAlarmesMicrosol;
    private Evento[] alarmesMicrosol = new Evento[100];
    private int[] pacoteDados = new int[38];
    private int versaoFirmware;
    private int potenciaRealEntrada;
    private int potenciaAparenteEntrada;
    private int fatorPotenciaEntrada;
    private int potenciaRealSaida;
    private int potenciaAparenteSaida;
    private int fatorPotenciaSaida;
    private int rendimento;
    private int seculo;
    private boolean estouroRTC;
    private boolean timerHabilitado;
    private boolean autoHabilitado;
    private boolean boostLigado;
    private boolean bateriaDescarga;
    private boolean quadraturaAnteriorEntrada;
    private boolean quadratura;
    private boolean terminoXModem;
    private boolean emSincronismo;
    private boolean transmitirPacote;
    private boolean executarBeep;
    private boolean eventoGravando;
    private boolean redeAnterior;
    private boolean comandoExecutado;
    private boolean executarTeste;
    private boolean quadraturaAnteriorSaida;
    private boolean comandoSerial;
    private boolean sobretensao;
    private int ultimoEvento = 0;

    @Override
    public boolean ligaEntrada() {
        return this.enviaComando(1, null);
    }

    @Override
    public boolean desligaEntrada() {
        return this.enviaComando(2, null);
    }

    @Override
    public boolean ligaSaida() {
        return this.enviaComando(3, null);
    }

    @Override
    public boolean desligaSaida() {
        return this.enviaComando(4, null);
    }

    @Override
    public boolean ativaBypass() {
        return this.enviaComando(5, null);
    }

    @Override
    public boolean desativaBypass() {
        return this.enviaComando(6, null);
    }

    @Override
    public boolean configuraRelogio(int segundos, int minutos, int horas) {
        int[] bytes = new int[19];
        int checksum = 0;
        int temp = 0;
        bytes[0] = 1;
        bytes[1] = 11;
        bytes[2] = horas;
        bytes[3] = minutos;
        bytes[4] = segundos;
        bytes[5] = this.getDiaMes();
        bytes[6] = this.getMes();
        bytes[7] = this.getAno() - 2000;
        bytes[8] = 20;
        bytes[9] = this.getDiaSemana() + 1;
        bytes[10] = this.getHoraLigar();
        bytes[11] = this.getMinutoLigar();
        bytes[12] = this.getHoraDesligar();
        bytes[13] = this.getMinutoDesligar();
        int semana = 0;
        temp = 0;
        boolean[] dias = this.getDiasSemanaProgramados();
        int i = 1;
        while (i < 7) {
            temp = dias[i] ? 1 : 0;
            semana |= temp << 7 - i;
            ++i;
        }
        bytes[14] = semana;
        bytes[15] = 0;
        bytes[16] = 0;
        bytes[17] = 0;
        i = 1;
        while (i <= 17) {
            checksum += bytes[i];
            ++i;
        }
        bytes[18] = checksum % 256;
        return this.enviaDados(bytes);
    }

    @Override
    public boolean configuraCalendario(int diaSemana, int diaMes, int mes, int ano) {
        int[] bytes = new int[19];
        int checksum = 0;
        int temp = 0;
        bytes[0] = 1;
        bytes[1] = 11;
        bytes[2] = this.getHora();
        bytes[3] = this.getMinutos();
        bytes[4] = this.getSegundos();
        bytes[5] = diaMes;
        bytes[6] = mes;
        bytes[7] = ano - 2000;
        bytes[8] = 20;
        bytes[9] = diaSemana + 1;
        bytes[10] = this.getHoraLigar();
        bytes[11] = this.getMinutoLigar();
        bytes[12] = this.getHoraDesligar();
        bytes[13] = this.getMinutoDesligar();
        int semana = 0;
        boolean[] dias = this.getDiasSemanaProgramados();
        int i = 1;
        while (i < 7) {
            temp = dias[i] ? 1 : 0;
            semana |= temp << 7 - i;
            ++i;
        }
        bytes[14] = semana;
        bytes[15] = 0;
        bytes[16] = 0;
        bytes[17] = 0;
        i = 1;
        while (i <= 17) {
            checksum += bytes[i];
            ++i;
        }
        bytes[18] = checksum % 256;
        return this.enviaDados(bytes);
    }

    @Override
    public boolean programaSemana(boolean[] dias, int horaLigar, int minutoLigar, int horaDesligar, int minutoDesligar) {
        int[] bytes = new int[19];
        int checksum = 0;
        int temp = 0;
        bytes[0] = 1;
        bytes[1] = 11;
        bytes[2] = this.getHora();
        bytes[3] = this.getMinutos();
        bytes[4] = this.getSegundos();
        bytes[5] = this.diaMes;
        bytes[6] = this.mes;
        bytes[7] = this.ano - 2000;
        bytes[8] = 20;
        bytes[9] = this.diaSemana + 1;
        bytes[10] = horaLigar;
        bytes[11] = minutoLigar;
        bytes[12] = horaDesligar;
        bytes[13] = minutoDesligar;
        int semana = 0;
        int i = 1;
        while (i < 7) {
            temp = dias[i] ? 1 : 0;
            semana |= temp << 7 - i;
            ++i;
        }
        bytes[14] = semana;
        bytes[15] = 0;
        bytes[16] = 0;
        bytes[17] = 0;
        i = 1;
        while (i <= 17) {
            checksum += bytes[i];
            ++i;
        }
        bytes[18] = checksum % 256;
        return this.enviaDados(bytes);
    }

    @Override
    public boolean configuraCalendarioRelogioSemana(int diaSemana, int diaMes, int mes, int ano, int segundos, int minutos, int horas, boolean[] dias, int horaLigar, int minutoLigar, int horaDesligar, int minutoDesligar) {
        int[] bytes = new int[19];
        int checksum = 0;
        int temp = 0;
        bytes[0] = 1;
        bytes[1] = 11;
        bytes[2] = horas;
        bytes[3] = minutos;
        bytes[4] = segundos;
        bytes[5] = diaMes;
        bytes[6] = mes;
        bytes[7] = ano - 2000;
        bytes[8] = 20;
        bytes[9] = diaSemana + 1;
        bytes[10] = horaLigar;
        bytes[11] = minutoLigar;
        bytes[12] = horaDesligar;
        bytes[13] = minutoDesligar;
        int semana = 0;
        int i = 1;
        while (i < 7) {
            temp = dias[i] ? 1 : 0;
            semana |= temp << 7 - i;
            ++i;
        }
        bytes[14] = semana;
        bytes[15] = 0;
        bytes[16] = 0;
        bytes[17] = 0;
        i = 1;
        while (i <= 17) {
            checksum += bytes[i];
            ++i;
        }
        bytes[18] = checksum % 256;
        return this.enviaDados(bytes);
    }

    @Override
    public boolean configuraCalendarioRelogio(int diaSemana, int diaMes, int mes, int ano, int segundos, int minutos, int horas) {
        int[] bytes = new int[19];
        int checksum = 0;
        int temp = 0;
        bytes[0] = 1;
        bytes[1] = 11;
        bytes[2] = horas;
        bytes[3] = minutos;
        bytes[4] = segundos;
        bytes[5] = diaMes;
        bytes[6] = mes;
        bytes[7] = ano - 2000;
        bytes[8] = 20;
        bytes[9] = diaSemana + 1;
        bytes[10] = this.getHoraLigar();
        bytes[11] = this.getMinutoLigar();
        bytes[12] = this.getHoraDesligar();
        bytes[13] = this.getMinutoDesligar();
        int semana = 0;
        temp = 0;
        boolean[] dias = this.getDiasSemanaProgramados();
        int i = 1;
        while (i < 7) {
            temp = dias[i] ? 1 : 0;
            semana |= temp << 7 - i;
            ++i;
        }
        bytes[14] = semana;
        bytes[15] = 0;
        bytes[16] = 0;
        bytes[17] = 0;
        i = 1;
        while (i <= 17) {
            checksum += bytes[i];
            ++i;
        }
        bytes[18] = checksum % 256;
        return this.enviaDados(bytes);
    }

    public boolean configuraTimer(int timer) {
        String[] temp = new String[]{String.valueOf(timer)};
        return this.enviaComando(12, temp);
    }

    public boolean configuraAutoTeste() {
        return this.enviaComando(13, null);
    }

    public boolean configuraNome(String nome) {
        String[] temp = new String[]{nome};
        return this.enviaComando(14, temp);
    }

    public boolean configuraEnvioMensagens() {
        return this.enviaComando(15, null);
    }

    public boolean configuraMAC(String mac) {
        String[] temp = new String[]{mac};
        return this.enviaComando(16, temp);
    }

    @Override
    public boolean shutdown() {
        return false;
    }

    @Override
    public boolean shutdownReligamento() {
        return false;
    }

    @Override
    public Evento[] downloadEventos() {
        if (this.numeroAlarmesMicrosol > 0) {
            Evento[] temp = (Evento[])this.alarmesMicrosol.clone();
            temp[this.numeroAlarmesMicrosol] = null;
            this.numeroAlarmesMicrosol = 0;
            return temp;
        }
        return null;
    }

    public boolean apagaEventos() {
        return this.enviaComando(8, null);
    }

    public boolean configuraIP(String endereco) {
        String[] temp = new String[]{endereco};
        return this.enviaComando(9, temp);
    }

    public boolean configuraNumeroSerie(String numeroSerie) {
        String[] temp = new String[]{numeroSerie};
        return this.enviaComando(10, temp);
    }

    @Override
    public boolean setModoEvento() {
        return false;
    }

    @Override
    public boolean setModoContinuo() {
        return false;
    }

    @Override
    public void trataPacoteDumpping(int numeroEventoAtual) {
        GregorianCalendar calendar = new GregorianCalendar();
        if (numeroEventoAtual != this.ultimoEvento) {
            Evento evento;
            this.alarmesMicrosol[this.numeroAlarmesMicrosol] = evento = new Evento(this.traduzEventos(numeroEventoAtual), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(5), calendar.get(2) + 1, calendar.get(1));
            ++this.numeroAlarmesMicrosol;
            this.ultimoEvento = numeroEventoAtual;
        }
    }

    private String traduzEventos(int numeroEventoAtual) {
        switch (numeroEventoAtual) {
            case 47: {
                return "AUTO_TESTE_FALHOU";
            }
            case 46: {
                return "AUTO_TESTE_OK";
            }
            case 20: {
                return "BATERIA_CRITICA";
            }
            case 18: {
                return "BATERIA_DESCARREGADA";
            }
            case 19: {
                return "BATERIA_NORMAL";
            }
            case 16: {
                return "BATERIA_EM_USO";
            }
            case 41: {
                return "BYPASS_ATIVADO";
            }
            case 42: {
                return "BYPASS_DESATIVADO";
            }
            case 11: {
                return "CARGA_NOMINAL";
            }
            case 25: {
                return "DESLIGAMENTO_POR_AUSENCIA_DE_CONSUMO";
            }
            case 44: {
                return "ENTRADA_DESLIGADA";
            }
            case 43: {
                return "ENTRADA_LIGADA";
            }
            case 45: {
                return "EVENTOS_APAGADOS";
            }
            case 1: {
                return "FALHA_NA_REDE";
            }
            case 17: {
                return "FIM_DO_USO_DA_BATERIA";
            }
            case 30: {
                return "AUTO_TESTE_FALHOU";
            }
            case 2: {
                return "RETORNO_DA_REDE";
            }
            case 27: {
                return "SAIDA_DESLIGADA";
            }
            case 26: {
                return "SAIDA_LIGADA";
            }
            case 4: {
                return "SHUTDOWN_POR_AUTONOMIA";
            }
            case 9: {
                return "SHUTDOWN_CANCELADO";
            }
            case 6: {
                return "SHUTDOWN_POR_COMANDO";
            }
            case 28: {
                return "SHUTDOWN_POR_TIMER";
            }
            case 10: {
                return "SOBRECARGA";
            }
            case 23: {
                return "SOBRETENSAO_NA_ENTRADA";
            }
            case 48: {
                return "SOBRETENSAO_NO_BOOST";
            }
            case 22: {
                return "SUBTENSAO_NA_ENTRADA";
            }
            case 12: {
                return "SUPER_AQUECIMENTO";
            }
            case 13: {
                return "TEMPERATURA_NORMAL";
            }
            case 50: {
                return "FALHA_NA_SAIDA";
            }
            case 52: {
                return "EM_AUTOTESTE";
            }
        }
        return "EVENTO_DESCONHECIDO";
    }

    @Override
    protected void trataPacoteDados() {
        this.setCabecalhoPacote(this.pacoteDados[0]);
        this.setversaoFirmware(this.pacoteDados[1]);
        this.setTensaoEntrada(this.pacoteDados[2]);
        this.setCorrenteEntrada(this.pacoteDados[3]);
        this.setPotenciaRealEntrada(this.pacoteDados[4], this.pacoteDados[5]);
        this.setPotenciaAparenteEntrada(this.pacoteDados[6], this.pacoteDados[7]);
        this.setFatorPotenciaEntrada(this.pacoteDados[8]);
        this.setFrequenciaEntrada(this.pacoteDados[9], this.pacoteDados[10]);
        this.setTensaoSaida(this.pacoteDados[11]);
        this.setCorrenteSaida(this.pacoteDados[12]);
        this.setPotenciaRealSaida(this.pacoteDados[13], this.pacoteDados[14]);
        this.setPotenciaReal(this.pacoteDados[13] + 256 * this.pacoteDados[14]);
        this.setPotenciaAparenteSaida(this.pacoteDados[15], this.pacoteDados[16]);
        this.setPotenciaAparente(this.pacoteDados[15] + 256 * this.pacoteDados[16]);
        this.setFatorPotenciaSaida(this.pacoteDados[17]);
        this.setFrequenciaSaida(this.pacoteDados[18], this.pacoteDados[19]);
        this.setTensaoBateria(this.pacoteDados[20]);
        this.setTensaoBoost(this.pacoteDados[21], this.pacoteDados[22]);
        this.setTemperaturaUPS(this.pacoteDados[23]);
        this.setRendimento(this.pacoteDados[24]);
        this.trataPacoteDumpping(this.pacoteDados[25]);
        this.setHora(this.pacoteDados[26]);
        this.setMinutos(this.pacoteDados[27]);
        this.setSegundos(this.pacoteDados[28]);
        this.setDiaMes(this.pacoteDados[29]);
        this.setMes(this.pacoteDados[30]);
        this.setAno(this.pacoteDados[31]);
        this.setSeculo(this.pacoteDados[32]);
        this.setEstouroRTC(this.pacoteDados[33]);
        this.setSaidaLigada(this.pacoteDados[33]);
        this.setEntradaLigada(this.pacoteDados[33]);
        this.setBypassAtivado(this.pacoteDados[33]);
        this.setAutoHabilitado(this.pacoteDados[33]);
        this.setTimerHabilitado(this.pacoteDados[33]);
        this.setBoostLigado(this.pacoteDados[33]);
        this.setBateriaDescarga(this.pacoteDados[33]);
        this.setQuadraturaAnteriorEntrada(this.pacoteDados[34]);
        this.setQuadratura(this.pacoteDados[34]);
        this.setTerminoXModem(this.pacoteDados[34]);
        this.setEmSincronismo(this.pacoteDados[34]);
        this.setTransmitirPacote(this.pacoteDados[34]);
        this.setExecutarBeep(this.pacoteDados[34]);
        this.setEventoGravando(this.pacoteDados[35]);
        this.setModoRede(this.pacoteDados[35]);
        this.setRedeAnterior(this.pacoteDados[35]);
        this.setComandoExecutado(this.pacoteDados[35]);
        this.setTensaoSaidaNominal(this.pacoteDados[34]);
        this.setQuadraturaAnteriorSaida(this.pacoteDados[35]);
        this.setComandoSerial(this.pacoteDados[35]);
        this.setsobreTensao(this.pacoteDados[35]);
        if (this.ouvinteProtocolo != null) {
            this.ouvinteProtocolo.notifica();
        }
    }

    private void setversaoFirmware(int versao) {
        this.versaoFirmware = versao;
    }

    private void setPotenciaRealEntrada(int potencia1, int potencia2) {
        this.potenciaRealEntrada = potencia1 + potencia2 * 256;
    }

    private void setPotenciaAparenteEntrada(int potencia1, int potencia2) {
        this.potenciaAparenteEntrada = potencia1 + potencia2 * 256;
    }

    private void setFatorPotenciaEntrada(int fatorPotencia) {
        this.fatorPotenciaEntrada = fatorPotencia;
    }

    private void setFrequenciaEntrada(int frequencia1, int frequencia2) {
        this.frequenciaEntrada = (frequencia1 + frequencia2 * 256) / 10;
    }

    private void setPotenciaRealSaida(int potencia1, int potencia2) {
        this.potenciaReal = this.potenciaRealSaida = potencia1 + potencia2 * 256;
    }

    private void setPotenciaAparenteSaida(int potencia1, int potencia2) {
        this.potenciaAparente = this.potenciaAparenteSaida = potencia1 + potencia2 * 256;
    }

    private void setFatorPotenciaSaida(int fatorPotencia) {
        this.fatorPotenciaCarga = this.fatorPotenciaSaida = fatorPotencia;
    }

    private void setFrequenciaSaida(int frequencia1, int frequencia2) {
        this.frequenciaSaida = (frequencia1 + frequencia2 * 256) / 10;
    }

    private void setTensaoBoost(int tensao1, int tensao2) {
        this.tensaoBoost = tensao1 + tensao2 * 256;
    }

    private void setRendimento(int rendimento) {
        this.rendimento = rendimento;
    }

    private void setSeculo(int seculo) {
        this.seculo = seculo;
    }

    private void setEstouroRTC(int flag) {
        this.estouroRTC = (flag & 1) == 1;
    }

    private void setTimerHabilitado(int flag) {
        this.timerHabilitado = (flag & 0x20) == 32;
    }

    private void setAutoHabilitado(int flag) {
        this.autoHabilitado = (flag & 0x10) == 16;
    }

    private void setBoostLigado(int flag) {
        this.boostLigado = (flag & 0x40) == 64;
    }

    private void setBateriaDescarga(int flag) {
        this.bateriaDescarga = (flag & 0x80) == 128;
    }

    private void setQuadraturaAnteriorEntrada(int flag) {
        this.quadraturaAnteriorEntrada = (flag & 1) == 1;
    }

    private void setQuadratura(int flag) {
        this.quadratura = (flag & 2) == 2;
    }

    private void setTerminoXModem(int flag) {
        this.terminoXModem = (flag & 4) == 4;
    }

    private void setEmSincronismo(int flag) {
        this.emSincronismo = (flag & 8) == 8;
    }

    private void setTransmitirPacote(int flag) {
        this.transmitirPacote = (flag & 0x10) == 16;
    }

    private void setExecutarBeep(int flag) {
        this.executarBeep = (flag & 0x20) == 32;
    }

    private void setEventoGravando(int flag) {
        this.eventoGravando = (flag & 1) == 1;
    }

    private void setRedeAnterior(int flag) {
        this.redeAnterior = (flag & 4) == 4;
    }

    private void setComandoExecutado(int flag) {
        this.comandoExecutado = (flag & 8) == 8;
    }

    private void setExecutarTeste(int flag) {
        this.executarTeste = (flag & 0x10) == 16;
    }

    private void setQuadraturaAnteriorSaida(int flag) {
        this.quadraturaAnteriorSaida = (flag & 0x20) == 32;
    }

    private void setComandoSerial(int flag) {
        this.comandoSerial = (flag & 0x40) == 64;
    }

    private void setsobreTensao(int flag) {
        this.sobretensao = (flag & 0x80) == 128;
    }

    @Override
    public void recebeDados() {
        this.vetorBytes = this.comunicador.getBytes();
        int i = 0;
        int checksum = 0;
        while (this.vetorBytes[i++] != -1) {
        }
        int numeroBytes = i - 2;
        i = 0;
        while (i < 38) {
            this.pacoteDados[i] = this.vetorBytes[i];
            ++i;
        }
        switch (numeroBytes) {
            case 1: {
                break;
            }
            case 37: 
            case 38: {
                checksum = 0;
                i = 0;
                while (i < 36) {
                    checksum += this.pacoteDados[i];
                    ++i;
                }
                if (this.pacoteDados[36] != (checksum %= 256)) break;
                this.trataPacoteDados();
                break;
            }
        }
    }

    @Override
    public boolean enviaDados(int[] pacote) {
        this.comunicador.sendBytes(pacote, 3);
        this.esperaACK = false;
        return true;
    }

    @Override
    public void setAno(int ano) {
        this.ano = ano;
    }

    @Override
    public void setAutonomiaBateria(int autonomiaBateria) {
        this.autonomiaBateria = autonomiaBateria;
    }

    @Override
    public void setBateriaBaixa(int bateriaBaixa) {
    }

    @Override
    public void setBateriaCarregada(int bateriaCarregada) {
    }

    @Override
    public void setBateriaCritica(int bateriaCritica) {
    }

    @Override
    public void setBateriaDescarregada(int bateriaDescarregada) {
    }

    @Override
    public void setBypassAtivado(int bypassAtivado) {
        this.bypassAtivado = (bypassAtivado & 8) == 8;
        this.modoBypass = (bypassAtivado & 8) == 8;
    }

    @Override
    public void setCargaElevada(int cargaElevada) {
    }

    @Override
    public void setCarregandoBateria(int carregandoBateria) {
    }

    @Override
    public void setComandoAceito(int comandoAceito) {
    }

    @Override
    public void setCorrenteEntrada(int correnteEntrada) {
        this.correnteEntrada = correnteEntrada;
    }

    @Override
    public void setCorrenteSaida(int correnteSaida) {
        this.correnteSaida = correnteSaida;
    }

    @Override
    public void setDiaMes(int diaMes) {
        this.diaMes = diaMes;
    }

    @Override
    public void setDiaSemana(int diaSemana) {
        this.diaSemana = diaSemana;
    }

    @Override
    public void setFatorPotenciaCarga(int fatorPotenciaCarga) {
        this.fatorPotenciaCarga = fatorPotenciaCarga;
    }

    @Override
    public void setFrequenciaEntrada(int frequenciaEntrada) {
        this.frequenciaEntrada = frequenciaEntrada;
    }

    @Override
    public void setFrequenciaSaida(int frequenciaSaida) {
        this.frequenciaSaida = frequenciaSaida;
    }

    @Override
    public void setHora(int hora) {
        this.hora = hora;
    }

    @Override
    public void setHoraDesligar(int horaDesligar) {
        this.horaDesligar = horaDesligar;
    }

    @Override
    public void setHoraLigar(int horaLigar) {
        this.horaLigar = horaLigar;
    }

    @Override
    public void setLimiteInferiorTensaoEntrada(int limiteInferiorTensaoEntrada) {
        this.limiteInferiorTensaoEntrada = limiteInferiorTensaoEntrada;
    }

    @Override
    public void setLimiteInferiorTensaoSaida(int limiteInferiorTensaoSaida) {
        this.limiteInferiorTensaoSaida = limiteInferiorTensaoSaida;
    }

    @Override
    public void setLimiteSuperiorTensaoEntrada(int limiteSuperiorTensaoEntrada) {
        this.limiteSuperiorTensaoEntrada = limiteSuperiorTensaoEntrada;
    }

    @Override
    public void setLimiteSuperiorTensaoSaida(int limiteSuperiorTensaoSaida) {
        this.limiteSuperiorTensaoSaida = limiteSuperiorTensaoSaida;
    }

    @Override
    public void setMes(int mes) {
        this.mes = mes;
    }

    @Override
    public void setMinutoDesligar(int minutoDesligar) {
        this.minutoDesligar = minutoDesligar;
    }

    @Override
    public void setMinutoLigar(int minutoLigar) {
        this.minutoLigar = minutoLigar;
    }

    @Override
    public void setMinutos(int minutos) {
        this.minutos = minutos;
    }

    @Override
    public void setPercentualBateria(int percentualBateria) {
        this.percentualBateria = percentualBateria;
    }

    @Override
    public void setPotenciaAparente(int potenciaAparente) {
        this.potenciaAparente = potenciaAparente;
    }

    @Override
    public void setPotenciaReal(int potenciaReal) {
        this.potenciaReal = potenciaReal;
    }

    @Override
    public void setSegundos(int segundos) {
        this.segundos = segundos;
    }

    @Override
    public void setTemperaturaUPS(int temperaturaUPS) {
        this.temperaturaUPS = temperaturaUPS;
    }

    @Override
    public void setTensaoBateria(int tensaoBateria) {
        this.tensaoBateria = tensaoBateria;
    }

    @Override
    public void setTensaoBoost(int tensaoBoost) {
        this.tensaoBoost = tensaoBoost;
    }

    @Override
    public void setTensaoEntrada(int tensaoEntrada) {
        this.tensaoEntrada = tensaoEntrada;
    }

    @Override
    public void setTensaoEntradaNominal(int tensaoEntradaNominal) {
        this.tensaoEntradaNominal = tensaoEntradaNominal;
    }

    @Override
    public void setTensaoSaida(int tensaoSaida) {
        this.tensaoSaida = this.isSaidaLigada() ? (this.tensaoSaidaNominal == 220 ? 2 * (tensaoSaida - 5) : tensaoSaida + 6) : 0;
    }

    @Override
    public void setTensaoSaidaNominal(int tensaoSaidaNominal) {
        this.tensaoSaidaNominal = (tensaoSaidaNominal & 0x10) == 16 ? 110 : 220;
    }

    @Override
    public void setCabecalhoPacote(int cabecalhoPacote) {
        this.cabecalhoPacote = cabecalhoPacote;
    }

    @Override
    public void pedidoDados() {
        this.enviaComando(53, null);
    }

    public void pedidoConfiguracoes() {
        this.enviaComando(54, null);
    }

    private boolean enviaComando(int comando, String[] dadosAdicionais) {
        int[] pacoteComando = new int[19];
        int checksoma = 0;
        switch (comando) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 53: {
                pacoteComando[0] = 1;
                pacoteComando[1] = comando;
                int i = 2;
                while (i < 18) {
                    pacoteComando[i] = 0;
                    ++i;
                }
                i = 1;
                while (i < 18) {
                    checksoma += pacoteComando[i];
                    ++i;
                }
                pacoteComando[18] = checksoma;
                i = 0;
                if (i < 19) {
                    // empty if block
                }
            }
            case 11: 
            case 54: {
                int i;
                try {
                    pacoteComando[0] = 207;
                    int j = 1;
                    while (j < 7) {
                        pacoteComando[j] = Integer.valueOf(dadosAdicionais[j - 1]);
                        ++j;
                    }
                    pacoteComando[8] = Integer.valueOf(dadosAdicionais[7]) << 5;
                    pacoteComando[8] = pacoteComando[8] | Integer.valueOf(dadosAdicionais[8]);
                    pacoteComando[9] = Integer.valueOf(dadosAdicionais[9]) << 4;
                    pacoteComando[9] = pacoteComando[9] | Integer.valueOf(dadosAdicionais[10]) - 2;
                    pacoteComando[10] = Integer.valueOf(dadosAdicionais[11]) & 0x80;
                    pacoteComando[11] = 0;
                    i = 0;
                    while (i < 11) {
                        pacoteComando[11] = pacoteComando[11] + pacoteComando[i];
                        ++i;
                    }
                }
                catch (Exception exception) {}
                break;
            }
        }
        return this.enviaDados(pacoteComando);
    }

    @Override
    public boolean pedidoDumpping() {
        return false;
    }

    @Override
    public void notifica() {
        this.recebeDados();
    }

    public static void main(String[] args) {
    }

    @Override
    public void setDiasSemanaProgramados(int diasSemanaProgramados) {
    }

    @Override
    public void setEntradaLigada(int entradaLigada) {
        boolean bl = this.entradaLigada = (entradaLigada & 4) == 4;
        if (this.tensaoEntrada >= 210 && this.tensaoEntrada <= 230) {
            this.setTensaoEntrada220(true);
        } else {
            this.setTensaoEntrada220(false);
        }
    }

    @Override
    public void setExpansorBateria(int expansorBateria) {
    }

    @Override
    public void setModeloUPS(int modeloUPS) {
    }

    @Override
    public void setModoBateria(int modoBateria) {
    }

    @Override
    public void setModoBypass(int modoBypass) {
    }

    @Override
    public void setModoRede(int modoRede) {
        boolean bl = this.modoRede = (modoRede & 2) != 2;
        if (!this.modoRede) {
            if (this.isSaidaLigada()) {
                this.usandoSomenteBateria = true;
            }
        } else {
            this.usandoSomenteBateria = false;
        }
    }

    @Override
    public void setNumeroTimeout(int numeroTimeout) {
    }

    @Override
    public void setSaidaLigada(int saidaLigada) {
        boolean bl = this.saidaLigada = (saidaLigada & 2) == 2;
        if (this.tensaoSaida >= 210 && this.tensaoSaida <= 230) {
            this.setTensaoSaida220(true);
        } else {
            this.setTensaoSaida220(false);
        }
    }

    @Override
    public void setSobrecarga(int sobrecarga) {
    }

    @Override
    public void setSuperAquecimento(int superAquecimento) {
    }

    @Override
    public void setTemperaturaElevada(int temperaturaElevada) {
    }

    public void setTensaoEntrada220(boolean tensaoEntrada220) {
        this.tensaoEntrada220 = tensaoEntrada220;
    }

    public void setTensaoSaida220(boolean tensaoSaida220) {
        this.tensaoSaida220 = tensaoSaida220;
    }

    @Override
    public void setTensaoEntrada220(int tensaoEntrada220) {
    }

    @Override
    public void setTensaoSaida220(int tensaoSaida220) {
    }
}

