/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.protocolo;

import br.com.schneider.sgm.eventos.Evento;
import br.com.schneider.sgm.eventos.ProtocoloListener;
import br.com.schneider.sgm.protocolo.ProtocoloSolis;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class ProtocoloPS
extends ProtocoloSolis {
    protected int estadoRele;
    private int contRefreshTimer;
    protected static final int SOH_PAC_ACK = 172;
    protected static final int SOH_PAC_COM = 204;
    protected static final int COM_LIGAR_SAIDA = 1;
    protected static final int COM_DESLIGAR_SAIDA = 2;
    protected static final int COM_LIGAR_ENTRADA = 3;
    protected static final int COM_DESLIGAR_ENTRADA = 4;
    protected static final int COM_SHUTDOWN = 9;

    @Override
    public boolean ligaEntrada() {
        int[] bytes;
        bytes = new int[]{204, 3, 3, 2 * bytes[1]};
        return this.enviaDados(bytes);
    }

    @Override
    public boolean desligaEntrada() {
        int[] bytes;
        bytes = new int[]{204, 4, 4, 2 * bytes[1]};
        return this.enviaDados(bytes);
    }

    @Override
    public boolean ligaSaida() {
        int[] bytes;
        bytes = new int[]{204, 1, 1, 2 * bytes[1]};
        return this.enviaDados(bytes);
    }

    @Override
    public void setBateriaBaixa(int bateriaBaixa) {
    }

    @Override
    public boolean desligaSaida() {
        int[] bytes;
        bytes = new int[]{204, 2, 2, 2 * bytes[1]};
        return this.enviaDados(bytes);
    }

    protected void setConfiguracaoRele(int conf) {
        this.estadoRele = conf;
    }

    public int getConfiguracaoRele() {
        return this.estadoRele;
    }

    @Override
    public boolean enviaDados(int[] pacote) {
        this.comandoAceito = 1;
        this.comunicador.sendBytes(pacote);
        this.esperaACK = false;
        while (this.comandoAceito == 0) {
        }
        if (this.comandoAceito == 1) {
            this.comandoAceito = 0;
            return true;
        }
        this.comandoAceito = 0;
        return false;
    }

    @Override
    public void recebeDados() {
        this.vetorBytes = this.comunicador.getBytes();
        int i = 0;
        int checksum = 0;
        while (this.vetorBytes[i++] != -1) {
        }
        int numeroBytes = i - 2;
        this.esperaACK = false;
        block0 : switch (numeroBytes) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 25: {
                if (this.vetorBytes[20] != this.pacoteDados[20]) {
                    this.pedidoDumpping();
                }
                if ((this.vetorBytes[0] & 0xF0) != 176 || this.vetorBytes[24] != 254) break;
                i = 0;
                while (i <= 24) {
                    this.pacoteDados[i] = this.vetorBytes[i];
                    ++i;
                }
                i = 0;
                while (i <= 22) {
                    checksum = this.pacoteDados[i] + checksum;
                    ++i;
                }
                if (this.pacoteDados[23] != (checksum %= 256)) break;
                this.trataPacoteDados();
                if (this.contRefreshTimer++ > 260) {
                    this.contRefreshTimer = 0;
                    Calendar cal = Calendar.getInstance();
                    this.configuraRelogio(cal.get(13), cal.get(12), cal.get(11));
                }
                checksum = 0;
                break;
            }
            default: {
                if (this.esperaDumpping && this.vetorBytes[0] == 172 && numeroBytes >= 5) {
                    int numeroEventos;
                    boolean t = false;
                    if ((numeroBytes - 2) % 3 == 0) {
                        i = 0;
                        while (i <= numeroBytes - 1) {
                            this.pacoteDumpping[i] = this.vetorBytes[i];
                            ++i;
                        }
                        i = 1;
                        while (i < numeroBytes - 1) {
                            checksum = this.pacoteDumpping[i] + checksum;
                            ++i;
                        }
                        if (this.pacoteDumpping[numeroBytes - 1] == (checksum %= 256)) {
                            numeroEventos = (numeroBytes - 2) / 3;
                            this.trataPacoteDumpping(numeroEventos);
                            checksum = 0;
                        } else {
                            t = true;
                        }
                    } else {
                        t = true;
                    }
                    if (!t) break;
                    int cont = 0;
                    i = 1;
                    while (i < numeroBytes - 1) {
                        checksum = this.vetorBytes[i] + checksum;
                        if (++cont >= 3) {
                            cont = 0;
                            if (this.vetorBytes[i + 1] == checksum % 256 && (this.modeloUPS == (this.vetorBytes[i + 2] & 0xF) || this.vetorBytes[i + 2] == 172 || this.vetorBytes[i + 2] == 238)) {
                                int k = 0;
                                while (k <= i + 1) {
                                    this.pacoteDumpping[k] = this.vetorBytes[k];
                                    ++k;
                                }
                                numeroEventos = i / 3;
                                this.trataPacoteDumpping(numeroEventos);
                                checksum = 0;
                                break block0;
                            }
                        }
                        ++i;
                    }
                    break;
                }
                if (!this.esperaACK || this.vetorBytes[0] != 172) break;
                this.esperaACK = false;
            }
        }
    }

    @Override
    public boolean setModoContinuo() {
        return true;
    }

    @Override
    public void trataPacoteDumpping(int numeroEventos) {
        GregorianCalendar calendar = new GregorianCalendar();
        int i = 0;
        while (i < numeroEventos) {
            int hora = (this.pacoteDumpping[i * 3 + 1] & 0xF8) >> 3;
            int minuto = (this.pacoteDumpping[i * 3 + 1] & 7) << 3 | (this.pacoteDumpping[i * 3 + 2] & 0xE0) >> 5;
            int segundo = calendar.get(13);
            int tipo = this.pacoteDumpping[i * 3 + 2] & 0x1F;
            int offSet = this.pacoteDumpping[i * 3 + 3] & 0x7F;
            int mesAtual = calendar.get(2) + 1;
            int anoAtual = calendar.get(1);
            if (hora <= 23 && minuto <= 59 && this.getDiaMes() + offSet <= 31) {
                this.evento = new Evento(tipo, hora, minuto, segundo, this.getDiaMes() + offSet, mesAtual, anoAtual);
                this.addEvento(this.evento);
            }
            ++i;
        }
        if ((this.pacoteDumpping[i * 3 + 3] & 0x80) == 1) {
            this.esperaDumpping = false;
        }
    }

    @Override
    public void addEvento(Evento e) {
        this.alarmesMicrosol[this.numeroAlarmesMicrosol] = e;
        ++this.numeroAlarmesMicrosol;
    }

    @Override
    protected void trataPacoteDados() {
        this.setCabecalhoPacote(this.pacoteDados[0]);
        this.setTensaoSaida(this.pacoteDados[1]);
        this.setTensaoEntrada(this.pacoteDados[2]);
        this.setTensaoBateria(this.pacoteDados[3]);
        this.setTemperaturaUPS(this.pacoteDados[4]);
        this.setCorrenteSaida(this.pacoteDados[5]);
        this.setConfiguracaoRele(this.pacoteDados[6]);
        this.setPotenciaReal(this.pacoteDados[7], this.pacoteDados[8]);
        this.setSegundos(this.pacoteDados[9]);
        this.setMinutos(this.pacoteDados[10]);
        this.setHora(this.pacoteDados[11]);
        this.setHoraLigar(this.pacoteDados[13]);
        this.setMinutoLigar(this.pacoteDados[14]);
        this.setHoraDesligar(this.pacoteDados[15]);
        this.setMinutoDesligar(this.pacoteDados[16]);
        this.setDiaSemana(this.pacoteDados[18]);
        this.setDiasSemanaProgramados(this.pacoteDados[17]);
        this.setDiaMes(this.pacoteDados[18]);
        this.setAno(this.pacoteDados[19]);
        this.setMes(this.pacoteDados[19]);
        this.setTensaoSaida220(this.pacoteDados[20]);
        this.setBateriaCritica(this.pacoteDados[20]);
        this.setModoBateria(this.pacoteDados[20]);
        this.setSuperAquecimento(this.pacoteDados[20]);
        this.setModoRede(this.pacoteDados[20]);
        this.setCarregandoBateria(this.pacoteDados[20]);
        this.setTensaoEntrada220(this.pacoteDados[20]);
        this.setSobrecarga(this.pacoteDados[20]);
        this.setFrequenciaEntrada(this.pacoteDados[21], this.pacoteDados[22]);
        this.setSaidaLigada(this.pacoteDados[20]);
        if (this.ouvinteProtocolo != null) {
            this.ouvinteProtocolo.notifica();
        }
    }

    @Override
    public void setTensaoEntrada220(int tensaoEntrada220) {
        this.tensaoEntrada220 = (tensaoEntrada220 & 0x40) == 64;
    }

    @Override
    public void setSaidaLigada(int saidaLigada) {
        this.saidaLigada = (saidaLigada & 8) == 8;
    }

    @Override
    public void addProtocoloListener(ProtocoloListener ouvinteProtocolo) {
        this.ouvinteProtocolo = ouvinteProtocolo;
    }

    @Override
    public boolean shutdown() {
        int[] bytes;
        bytes = new int[]{204, 9, 9, 2 * bytes[1]};
        return this.enviaDados(bytes);
    }
}

