/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.persistencia;

import br.com.schneider.sgm.config.InstanciaSGM;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Persistencia {
    public static final int SOLIS_M11 = 171;
    public static final int SOLIS_M15 = 175;
    public static final int SOLIS_M14 = 174;
    public static final int SOLIS_M13 = 173;
    public static final int SOLISDC_M15 = 207;
    public static final int CABECALHO_RHINO = 194;
    public static final int PS800 = 185;
    private InstanciaSGM sgmConf;
    private boolean primeiraExec;
    private boolean flagPersistencia;

    public Persistencia() {
        File config = new File("config.sgm");
        boolean bl = this.primeiraExec = !config.exists();
        if (!this.primeiraExec) {
            try {
                ObjectInputStream input = new ObjectInputStream(new FileInputStream(config));
                this.sgmConf = (InstanciaSGM)input.readObject();
                input.close();
                config = null;
            }
            catch (Exception e) {
                this.sgmConf = new InstanciaSGM();
                this.sgmConf.setIdioma("PORTUGUES");
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
        } else {
            this.sgmConf = new InstanciaSGM();
            this.sgmConf.setIdioma("PORTUGUES");
            this.sgmConf.setCaminhoArquivoXMLEVENTOS(config.getAbsolutePath());
        }
    }

    public Persistencia(String caminho) {
        File config = new File(String.valueOf(File.separator) + caminho + File.separator + "config.sgm");
        boolean bl = this.primeiraExec = !config.exists();
        if (!this.primeiraExec) {
            try {
                ObjectInputStream input = new ObjectInputStream(new FileInputStream(config));
                this.sgmConf = (InstanciaSGM)input.readObject();
                input.close();
                config = null;
            }
            catch (Exception e) {
                this.sgmConf = new InstanciaSGM();
                this.sgmConf.setIdioma("PORTUGUES");
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
        } else {
            this.sgmConf = new InstanciaSGM();
            this.sgmConf.setIdioma("PORTUGUES");
            this.sgmConf.setCaminhoArquivoXMLEVENTOS(caminho);
        }
    }

    public void salvaConf() {
        try {
            ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(new File(String.valueOf(this.getCaminhoArquivoXMLEVENTOS()) + "config.sgm")));
            output.writeObject(this.sgmConf);
            output.flush();
            output.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean isPrimeiraExec() {
        return this.primeiraExec;
    }

    public int getAutonoMinima() {
        return this.sgmConf.getAutonoMinima();
    }

    public boolean getFlagPersistencia() {
        return this.flagPersistencia;
    }

    public String[] getDestinatarios() {
        if (this.sgmConf.getDestinatarios() == null) {
            String[] str = new String[]{""};
            return str;
        }
        return this.sgmConf.getDestinatarios();
    }

    public InstanciaSGM getSgmConf() {
        return this.sgmConf;
    }

    public String getEnderecoSMTP() {
        return this.sgmConf.getEnderecoSMTP();
    }

    public int getPortaSMTP() {
        return this.sgmConf.getPortaSMTP();
    }

    public int getEvento() {
        return this.sgmConf.getEvento();
    }

    public int getExpansorBateria() {
        return this.sgmConf.getExpansorBateria();
    }

    public int getFamilia() {
        return this.sgmConf.getFamilia();
    }

    public boolean isFlagAutentic() {
        return this.sgmConf.isFlagAutentic();
    }

    public boolean isFlagShutFalhaEletrica() {
        return this.sgmConf.isFlagShutFalhaEletrica();
    }

    public boolean isFlagShutFimAut() {
        return this.sgmConf.isFlagShutFimAut();
    }

    public Object getIdioma() {
        return this.sgmConf.getIdioma();
    }

    public boolean[][] getMensagens() {
        return this.sgmConf.getMensagens();
    }

    public String getPorta() {
        return this.sgmConf.getPorta();
    }

    public String getRemetente() {
        return this.sgmConf.getRemetente();
    }

    public String getScript() {
        return this.sgmConf.getScript();
    }

    public String getSenha() {
        try {
            return new String(new BASE64Decoder().decodeBuffer(this.sgmConf.getSenha()), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public int getTempoFalhaEletrica() {
        return this.sgmConf.getTempoFalhaEletrica();
    }

    public String getUsuario() {
        return this.sgmConf.getUsuario();
    }

    public int getModeloUPS() {
        return this.sgmConf.getModeloUPS();
    }

    public int getPortaRemota() {
        return this.sgmConf.getPortaRemota();
    }

    public boolean isModoRemoto() {
        return this.sgmConf.isModoRemoto();
    }

    public double getValorKW() {
        return this.sgmConf.getValorKW();
    }

    public String getModeloUPSString() {
        switch (this.getModeloUPS()) {
            case 194: {
                return "RHINO";
            }
            case 207: {
                return "SOLISDC 15";
            }
            case 173: {
                return "SOLIS 13";
            }
            case 174: {
                return "SOLIS 14";
            }
            case 175: {
                return "SOLIS 15";
            }
            case 171: {
                return "SOLIS 11";
            }
            case 185: {
                return "PS 800";
            }
        }
        return "Desconhecido";
    }

    public String getComunidadeEscrita() {
        return this.sgmConf.getComunidadeEscrita();
    }

    public String getComunidadeLeitura() {
        return this.sgmConf.getComunidadeLeitura();
    }

    public String getEnderecoGerente() {
        return this.sgmConf.getEnderecoGerente();
    }

    public String getNomeUPS() {
        return this.sgmConf.getNomeUPS();
    }

    public int getPortaEnvio() {
        return this.sgmConf.getPortaEnvio();
    }

    public int getPortaPedidos() {
        return this.sgmConf.getPortaPedidos();
    }

    public int getProtocoloTransporte() {
        return this.sgmConf.getProtocoloTransporte();
    }

    public int getVSNMP() {
        return this.sgmConf.getVSNMP();
    }

    public int getUPSServerPort() {
        return this.sgmConf.getUPSServerPort();
    }

    public Object getUPSServerClients() {
        return this.sgmConf.getUPSServerClients();
    }

    public boolean isUPSServerEnabled() {
        return this.sgmConf.isUPSServerEnabled();
    }

    public int getPeriodoTeste() {
        return this.sgmConf.getPeriodoTeste();
    }

    public int getHoraTeste() {
        return this.sgmConf.getHoraTeste();
    }

    public int getMinutoTeste() {
        return this.sgmConf.getMinutoTeste();
    }

    public boolean getAutoTesteEnabled() {
        return this.sgmConf.getAutoTesteEnabled();
    }

    public boolean getModoLogging() {
        return this.sgmConf.getModoLogging();
    }

    public String getCaminhoArquivoXMLEVENTOS() {
        return this.sgmConf.getCaminhoArquivoXMLEVENTOS();
    }

    public String getProvedorEscolhido() {
        return this.sgmConf.getProvedorEscolhido() == null ? "" : this.sgmConf.getProvedorEscolhido();
    }

    public void setAutonoMinima(int autonoMinima) {
        this.sgmConf.setAutonoMinima(autonoMinima);
    }

    public void setDestinatarios(String[] destinatarios) {
        this.sgmConf.setDestinatarios(destinatarios);
    }

    public void setEnderecoSMTP(String enderecoSMTP) {
        this.sgmConf.setEnderecoSMTP(enderecoSMTP);
    }

    public void setPortaSMTP(int portaSMTP) {
        this.sgmConf.setPortaSMTP(portaSMTP);
    }

    public void setEvento(int evento) {
        this.sgmConf.setEvento(evento);
    }

    public void setExpansorBateria(int expansorBateria) {
        this.sgmConf.setExpansorBateria(expansorBateria);
    }

    public void setFamilia(int familia) {
        this.sgmConf.setFamilia(familia);
    }

    public void setFlagAutentic(boolean flagAutentic) {
        this.sgmConf.setFlagAutentic(flagAutentic);
    }

    public void setFlagShutFalhaEletrica(boolean flagShutFalhaEletrica) {
        this.sgmConf.setFlagShutFalhaEletrica(flagShutFalhaEletrica);
    }

    public void setFlagShutFimAut(boolean flagShutFimAut) {
        this.sgmConf.setFlagShutFimAut(flagShutFimAut);
    }

    public void setIdioma(String idioma) {
        this.sgmConf.setIdioma(idioma);
    }

    public void setMensagens(boolean[][] mensagens) {
        this.sgmConf.setMensagens(mensagens);
    }

    public void setPorta(String porta) {
        this.sgmConf.setPorta(porta);
    }

    public void setRemetente(String remetente) {
        this.sgmConf.setRemetente(remetente);
    }

    public void setScript(String script) {
        this.sgmConf.setScript(script);
    }

    public void setSenha(String senha) {
        this.sgmConf.setSenha(new BASE64Encoder().encode(senha.getBytes()));
    }

    public void setTempoFalhaEletrica(int tempoFalhaEletrica) {
        this.sgmConf.setTempoFalhaEletrica(tempoFalhaEletrica);
    }

    public void setUsuario(String usuario) {
        this.sgmConf.setUsuario(usuario);
    }

    public void setModeloUPS(int modeloUPS) {
        this.sgmConf.setModeloUPS(modeloUPS);
    }

    public void setComunidadeEscrita(String comunidadeEscrita) {
        this.sgmConf.setComunidadeEscrita(comunidadeEscrita);
    }

    public void setComunidadeLeitura(String comunidadeLeitura) {
        this.sgmConf.setComunidadeLeitura(comunidadeLeitura);
    }

    public void setEnderecoGerente(String enderecoGerente) {
        this.sgmConf.setEnderecoGerente(enderecoGerente);
    }

    public void setIdioma(Object idioma) {
        this.sgmConf.setIdioma(idioma);
    }

    public void setNomeUPS(String nomeUPS) {
        this.sgmConf.setNomeUPS(nomeUPS);
    }

    public void setPortaEnvio(int portaEnvio) {
        this.sgmConf.setPortaEnvio(portaEnvio);
    }

    public void setPortaPedidos(int portaPedidos) {
        this.sgmConf.setPortaPedidos(portaPedidos);
    }

    public void setProtocoloTransporte(int protocoloTransporte) {
        this.sgmConf.setProtocoloTransporte(protocoloTransporte);
    }

    public void setVSNMP(int vsnmp) {
        this.sgmConf.setVSNMP(vsnmp);
    }

    public void setModoRemoto(boolean modoRemoto) {
        this.sgmConf.setModoRemoto(modoRemoto);
    }

    public void setPortaRemota(int portaRemota) {
        this.sgmConf.setPortaRemota(portaRemota);
    }

    public void setPrimeiraExec(boolean primeiraExec) {
        this.primeiraExec = primeiraExec;
    }

    public void setSgmConf(InstanciaSGM sgmConf) {
        this.sgmConf = sgmConf;
    }

    public void setValorKw(double valor) {
        this.sgmConf.setValorKW(valor);
    }

    public void getUPSServerPort(int port) {
        this.sgmConf.setUPSServerPort(port);
    }

    public void setUPSServerClients(Object a) {
        this.sgmConf.setUPSServerClients(a);
    }

    public void setUPSServerEnabled(boolean b) {
        this.sgmConf.setUPSServerEnabled(b);
    }

    public void setPeriodoAutoTeste(int periodo) {
        this.sgmConf.setPeriodoAutoTeste(periodo);
    }

    public void setHoraTeste(int horaTeste) {
        this.sgmConf.setHoraTeste(horaTeste);
    }

    public void setMinutoTeste(int minutoTeste) {
        this.sgmConf.setMinutoTeste(minutoTeste);
    }

    public void setAutoTeste(boolean enable) {
        this.sgmConf.setAutoTeste(enable);
    }

    public void setModoLogging(boolean enable) {
        this.sgmConf.setModoLogging(enable);
    }

    public void setCaminhoArquivoXMLEVENTOS(String caminhoArquivoXML) {
        this.sgmConf.setCaminhoArquivoXMLEVENTOS(caminhoArquivoXML);
    }

    public void setProvedorEscolhido(String provedorEscolhido) {
        this.sgmConf.setProvedorEscolhido(provedorEscolhido);
    }
}

