/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.log;

import br.com.schneider.sgm.config.PathConfig;
import br.com.schneider.sgm.controle.Controle;
import br.com.schneider.sgm.eventos.ControleListener;
import br.com.schneider.sgm.eventos.Evento;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class LogControl
implements ControleListener {
    private Controle control;
    private float corrMinSaida;
    private float corrMaxSaida;
    private float corrMedSaida;
    private float tenMinSaida;
    private float tenMaxSaida;
    private float tenMedSaida;
    private float tenMinEnt;
    private float tenMaxEnt;
    private float tenMedEnt;
    private int contPacotesDados;
    private static final int MAX_COUNTING = 300;
    private Evento[] eventos;
    private boolean enableLogging = false;
    private DecimalFormat formatador = new DecimalFormat("000.00");
    private static final String fileVin = String.valueOf(PathConfig.getPathXML()) + "varVINlog.xml";
    private static final String fileVout = String.valueOf(PathConfig.getPathXML()) + "varVOUTlog.xml";
    private static final String fileCout = String.valueOf(PathConfig.getPathXML()) + "varCOUTlog.xml";

    public LogControl(Controle cntr) {
        this.control = cntr;
        this.corrMinSaida = 0.0f;
        this.corrMaxSaida = 0.0f;
        this.corrMedSaida = 0.0f;
        this.tenMinSaida = 0.0f;
        this.tenMaxSaida = 0.0f;
        this.tenMedSaida = 0.0f;
        this.tenMinEnt = 0.0f;
        this.tenMaxEnt = 0.0f;
        this.tenMedEnt = 0.0f;
        this.contPacotesDados = 0;
        this.eventos = new Evento[3];
    }

    public void setLogEnabled(boolean en) {
        this.enableLogging = en;
    }

    @Override
    public void notificaDados() {
        GregorianCalendar calendar = new GregorianCalendar();
        if (this.contPacotesDados == 0) {
            this.corrMinSaida = this.control.getCorrenteSaida();
            this.tenMinSaida = this.control.getTensaoSaida();
            this.tenMinEnt = this.control.getTensaoEntrada();
        }
        if (this.corrMinSaida > this.control.getCorrenteSaida()) {
            this.corrMinSaida = this.control.getCorrenteSaida();
        }
        if (this.tenMinSaida > this.control.getTensaoSaida()) {
            this.tenMinSaida = this.control.getTensaoSaida();
        }
        if (this.tenMinEnt > this.control.getTensaoEntrada()) {
            this.tenMinEnt = this.control.getTensaoEntrada();
        }
        if (this.corrMaxSaida < this.control.getCorrenteSaida()) {
            this.corrMaxSaida = this.control.getCorrenteSaida();
        }
        if (this.tenMaxSaida < this.control.getTensaoSaida()) {
            this.tenMaxSaida = this.control.getTensaoSaida();
        }
        if (this.tenMaxEnt < this.control.getTensaoEntrada()) {
            this.tenMaxEnt = this.control.getTensaoEntrada();
        }
        ++this.contPacotesDados;
        if (this.contPacotesDados == 300) {
            this.contPacotesDados = 0;
            if (this.enableLogging) {
                int dia = calendar.get(5);
                int hora = calendar.get(11);
                int minuto = calendar.get(12);
                int mes = calendar.get(2);
                int ano = calendar.get(1);
                this.eventos[0] = new Evento("VENT (V)", hora, minuto, 0, dia, mes, ano);
                this.inserirEvento(fileVin, this.eventos[0], this.formatador.format(this.tenMinEnt), this.formatador.format(this.tenMaxEnt));
                this.eventos[1] = new Evento("VOUT (V)", hora, minuto, 0, dia, mes, ano);
                this.inserirEvento(fileVout, this.eventos[1], this.formatador.format(this.tenMinSaida), this.formatador.format(this.tenMaxSaida));
                this.eventos[2] = new Evento("COUT (A)", hora, minuto, 0, dia, mes, ano);
                this.inserirEvento(fileCout, this.eventos[2], this.formatador.format(this.corrMinSaida), this.formatador.format(this.corrMaxSaida));
            }
        }
    }

    private synchronized boolean inserirEvento(String filename, Evento e, String min, String max) {
        SAXBuilder builder = new SAXBuilder();
        try {
            File f = new File(filename);
            Document doc = builder.build(f);
            Element evt = new Element("amostra");
            evt.setAttribute("min", min);
            evt.setAttribute("max", max);
            evt.setAttribute("data", String.valueOf(e.getAno()) + "-" + e.getMes() + "-" + e.getDia());
            evt.setAttribute("hora", String.valueOf(e.getHora()) + ":" + e.getMinuto() + ":" + e.getSegundo());
            evt.setText(e.getTipo());
            doc.getRootElement().addContent(evt);
            XMLOutputter serializer = new XMLOutputter();
            serializer.setFormat(Format.getPrettyFormat());
            serializer.output(doc, (Writer)new FileWriter(f));
            return true;
        }
        catch (JDOMException jdomx) {
            this.criaArquivo(filename);
        }
        catch (IOException iox) {
            this.criaArquivo(filename);
        }
        return false;
    }

    private void criaArquivo(String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<varlog xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"varlog.xsd\">\n</varlog>");
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void notificaBateriaBaixa() {
    }

    @Override
    public void notificaBateriaNormal() {
    }

    @Override
    public void notificaCargaElevada() {
    }

    @Override
    public void notificaCargaNormal() {
    }

    @Override
    public void notificaComunicacao() {
    }

    @Override
    public void notificaFalhaCom() {
    }

    @Override
    public void notificaFalhaRede() {
    }

    @Override
    public void notificaNaoUsaBateria() {
    }

    @Override
    public void notificaRetornoCom() {
    }

    @Override
    public void notificaRetornoRede() {
    }

    @Override
    public void notificaTemperaturaElevada() {
    }

    @Override
    public void notificaTemperaturaNormal() {
    }

    @Override
    public void notificaUsandoBateria() {
    }
}

