/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.historico;

import br.com.schneider.sgm.config.PathConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class HistoricoConsumo {
    private final int CONSUMO_DIARIO = 1;
    private final int CONSUMO_SEMANAL = 2;
    private final int CONSUMO_MENSAL = 3;
    private final int CONSUMO_ANUAL = 4;
    private final int INSERIR_DIA = 5;
    private final int INSERIR_SEMANA = 6;
    private final int INSERIR_MES = 7;
    private final int INSERIR_ANO = 8;
    private final int BUSCAR_DIA = 9;
    private int tipoBusca = 1;
    private Vector res;
    private Hashtable hash;
    private GregorianCalendar data = new GregorianCalendar();
    private File arquivo;
    private Document doc;
    private int[] interI;
    private String ano;
    private String mes;
    private String dia;
    private String semana;
    private float resF;
    private Element newDay;
    private Element year;
    private Element month;
    private Element week;
    private boolean inseriu;

    public HistoricoConsumo(String nomeArquivo) {
        this.data.setTimeInMillis(System.currentTimeMillis());
        this.interI = new int[3];
        this.arquivo = new File(nomeArquivo);
        SAXBuilder builder = new SAXBuilder();
        try {
            this.doc = builder.build(this.arquivo);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getSemana(int dia) {
        if (dia <= 7) {
            return "1";
        }
        if (dia > 7 && dia <= 14) {
            return "2";
        }
        if (dia > 14 && dia <= 21) {
            return "3";
        }
        if (dia > 21 && dia <= 27) {
            return "4";
        }
        return "5";
    }

    public String intToNomeDia(int dia) {
        switch (dia) {
            case 1: {
                return "domingo";
            }
            case 2: {
                return "segunda";
            }
            case 3: {
                return "terca";
            }
            case 4: {
                return "quarta";
            }
            case 5: {
                return "quinta";
            }
            case 6: {
                return "sexta";
            }
            case 7: {
                return "sabado";
            }
        }
        return null;
    }

    private void preparaElem() {
        if (this.ano == null) {
            this.week = new Element("semana");
            this.week.setAttribute("id", this.getSemana(this.interI[0]));
            this.week.addContent(this.newDay);
            this.month = new Element("mes");
            this.month.setAttribute("id", String.valueOf(this.interI[1]));
            this.month.addContent(this.week);
            this.year = new Element("ano");
            this.year.setAttribute("id", String.valueOf(this.interI[2]));
            this.year.addContent(this.month);
            this.tipoBusca = 8;
        } else if (this.mes == null) {
            this.week = new Element("semana");
            this.week.setAttribute("id", this.getSemana(this.interI[0]));
            this.week.addContent(this.newDay);
            this.month = new Element("mes");
            this.month.setAttribute("id", String.valueOf(this.interI[1]));
            this.month.addContent(this.week);
            this.tipoBusca = 7;
        } else if (this.semana == null) {
            this.week = new Element("semana");
            this.week.setAttribute("id", this.getSemana(this.interI[0]));
            this.week.addContent(this.newDay);
            this.tipoBusca = 6;
        }
    }

    private void criaDia(Element elem) {
        int diaAtual = 0;
        List children = elem.getContent();
        for (Object child : children) {
            Element dia;
            if (!(child instanceof Element) || (diaAtual = Integer.parseInt((dia = (Element)child).getAttributeValue("id"))) != this.interI[0]) continue;
            dia.setText(this.newDay.getText());
            this.semana = elem.getAttributeValue("semana");
            this.inseriu = true;
            return;
        }
        if (!this.inseriu) {
            elem.addContent(this.newDay);
            this.semana = elem.getAttributeValue("semana");
            this.inseriu = true;
            return;
        }
    }

    public boolean inserirDia(float valor) {
        this.interI[0] = this.data.get(5);
        this.interI[1] = this.data.get(2) + 1;
        this.interI[2] = this.data.get(1);
        this.newDay = new Element("dia");
        this.newDay.setAttribute("id", String.valueOf(this.interI[0]));
        this.newDay.setAttribute("nome", this.intToNomeDia(this.data.get(7)));
        this.newDay.setAttribute("semana", this.getSemana(this.interI[0]));
        this.newDay.setText(String.valueOf(valor));
        this.tipoBusca = 5;
        this.ano = null;
        this.mes = null;
        this.semana = null;
        this.buscaConsumo(this.doc, 0, null);
        if (this.inseriu) {
            this.inseriu = false;
            XMLOutputter serializer = new XMLOutputter();
            serializer.setFormat(Format.getPrettyFormat());
            try {
                serializer.output(this.doc, (Writer)new FileWriter(this.arquivo));
                return true;
            }
            catch (IOException iOException) {}
        } else {
            this.preparaElem();
            this.buscaConsumo(this.doc, 0, null);
            if (this.inseriu) {
                this.inseriu = false;
                XMLOutputter serializer = new XMLOutputter();
                serializer.setFormat(Format.getPrettyFormat());
                try {
                    serializer.output(this.doc, (Writer)new FileWriter(this.arquivo));
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private void buscaConsumo(Object o, int depth, String data) {
        block31: {
            Element elem;
            block34: {
                block33: {
                    block32: {
                        block30: {
                            if (!(o instanceof Document)) break block30;
                            Document doc = (Document)o;
                            List children = doc.getContent();
                            for (Object child : children) {
                                this.buscaConsumo(child, depth + 1, null);
                                if (!this.inseriu) continue;
                                return;
                            }
                            break block31;
                        }
                        if (!(o instanceof Element)) break block31;
                        elem = (Element)o;
                        if (elem.getName() != "consumo") break block32;
                        switch (this.tipoBusca) {
                            case 8: {
                                elem.addContent(this.year);
                                this.inseriu = true;
                                return;
                            }
                        }
                        List children = elem.getContent();
                        for (Object child : children) {
                            this.buscaConsumo(child, depth + 1, null);
                            if (!this.inseriu) continue;
                            return;
                        }
                        break block31;
                    }
                    if (elem.getName() != "ano") break block33;
                    if (Integer.parseInt(elem.getAttributeValue("id")) == this.interI[2]) {
                        if (this.tipoBusca == 7) {
                            elem.addContent(this.month);
                            this.inseriu = true;
                            return;
                        }
                        this.ano = elem.getAttributeValue("id");
                        List children = elem.getContent();
                        for (Object child : children) {
                            this.buscaConsumo(child, depth + 1, this.ano);
                            if (!this.inseriu) continue;
                            return;
                        }
                    }
                    break block31;
                }
                if (elem.getName() != "mes") break block34;
                switch (this.tipoBusca) {
                    case 6: {
                        if (Integer.parseInt(elem.getAttributeValue("id")) == this.interI[1]) {
                            elem.addContent(this.week);
                            this.inseriu = true;
                            return;
                        }
                    }
                    case 4: {
                        this.mes = elem.getAttributeValue("id");
                        this.resF = 0.0f;
                        List children = elem.getContent();
                        for (Object child : children) {
                            this.buscaConsumo(child, depth + 1, String.valueOf(data) + "-" + this.mes);
                        }
                        break block31;
                    }
                    default: {
                        if (Integer.parseInt(elem.getAttributeValue("id")) == this.interI[1]) {
                            this.mes = elem.getAttributeValue("id");
                            List children = elem.getContent();
                            for (Object child : children) {
                                this.buscaConsumo(child, depth + 1, String.valueOf(data) + "-" + this.mes);
                                if (!this.inseriu) continue;
                                return;
                            }
                        }
                        break block31;
                    }
                }
            }
            if (elem.getName() == "semana") {
                if (this.tipoBusca == 5) {
                    if (Integer.parseInt(elem.getAttributeValue("id")) == Integer.parseInt(this.newDay.getAttributeValue("semana"))) {
                        this.criaDia(elem);
                        return;
                    }
                } else {
                    List children = elem.getContent();
                    for (Object child : children) {
                        this.buscaConsumo(child, depth + 1, data);
                    }
                }
            } else if (elem.getName() == "dia") {
                switch (this.tipoBusca) {
                    case 1: {
                        this.dia = elem.getAttributeValue("id");
                        this.res.add(String.valueOf(data) + "-" + this.dia + "=" + elem.getValue());
                        break;
                    }
                    case 2: {
                        if (Integer.parseInt(this.semana) != Integer.parseInt(elem.getAttributeValue("semana"))) {
                            this.semana = elem.getAttributeValue("semana");
                        }
                        this.resF += Float.parseFloat(elem.getValue());
                        this.hash.put(String.valueOf(data) + "-" + this.semana, new Float(this.resF));
                        break;
                    }
                    case 3: {
                        this.resF += Float.parseFloat(elem.getValue());
                        break;
                    }
                    case 4: {
                        this.resF += Float.parseFloat(elem.getValue());
                        this.hash.put(data, new Float(this.resF));
                    }
                }
            }
        }
    }

    public String getConsumoDiario(String mesAno) {
        String[] inter = mesAno.split("-");
        this.interI[1] = Integer.parseInt(inter[0]);
        this.interI[2] = Integer.parseInt(inter[1]);
        this.tipoBusca = 1;
        this.res = new Vector();
        this.ano = null;
        this.mes = null;
        this.semana = null;
        this.buscaConsumo(this.doc, 0, null);
        if (this.res != null) {
            String resS = this.res.toString().substring(1, this.res.toString().length() - 1);
            this.res = null;
            return resS;
        }
        return null;
    }

    public String getConsumoSemanal(String mesAno) {
        String[] inter = mesAno.split("-");
        this.interI[1] = Integer.parseInt(inter[0]);
        this.interI[2] = Integer.parseInt(inter[1]);
        this.semana = "1";
        this.tipoBusca = 2;
        this.hash = new Hashtable();
        this.resF = 0.0f;
        this.buscaConsumo(this.doc, 0, null);
        if (this.hash != null) {
            String s = this.hash.toString().substring(1, this.hash.toString().length() - 1);
            this.hash = null;
            return s;
        }
        return null;
    }

    public String getConsumoMensal(String mesAno) {
        String[] inter = mesAno.split("-");
        this.interI[1] = Integer.parseInt(inter[0]);
        this.interI[2] = Integer.parseInt(inter[1]);
        this.tipoBusca = 3;
        this.resF = 0.0f;
        this.buscaConsumo(this.doc, 0, null);
        if (this.resF != 0.0f) {
            return String.valueOf(this.resF);
        }
        return null;
    }

    public String getConsumoAnual(String ano) {
        this.interI[2] = Integer.parseInt(ano);
        this.tipoBusca = 4;
        this.hash = new Hashtable();
        this.resF = 0.0f;
        this.buscaConsumo(this.doc, 0, null);
        if (this.hash != null) {
            String s = this.hash.toString().substring(1, this.hash.toString().length() - 1);
            this.hash = null;
            return s;
        }
        return null;
    }

    public static void main(String[] args) {
        HistoricoConsumo his = new HistoricoConsumo(String.valueOf(PathConfig.getPathXML()) + "consumo.xml");
    }
}

