/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.historico;

import br.com.schneider.sgm.eventos.Evento;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Historico {
    private String nomeDocumento;
    private Vector res;
    private String ano;
    private String mes;
    private String tipo;
    private String dia;
    private String hora;
    private String min;
    private String seg;
    private int tipoBusca;
    private boolean removeu;
    private Element oldChild;
    private int numeroRegistros;
    private static final int BUSCAR = 1;
    private static final int REMOVER = 2;
    private static final int DUMP = 3;
    private static final int NUMERO_MAXIMO_REGISTROS_A_VISUALIZAR = 999;

    public Historico(String nomeDocumento) {
        this.nomeDocumento = nomeDocumento;
        this.tipoBusca = 0;
        this.removeu = false;
    }

    public void setNomeDocumento(String nomeDocumento) {
        this.nomeDocumento = nomeDocumento;
    }

    public synchronized boolean inserirEvento(Evento e, int mes, int ano) {
        SAXBuilder builder = new SAXBuilder();
        try {
            File f = new File(this.nomeDocumento);
            Document doc = builder.build(f);
            Element evt = new Element("evento");
            this.mes = mes < 10 ? "0" : "";
            this.mes = String.valueOf(this.mes) + mes;
            this.dia = e.getDia() < 10 ? "0" : "";
            this.dia = String.valueOf(this.dia) + String.valueOf(e.getDia());
            this.dia = e.getDia() < 10 ? "0" : "";
            this.dia = String.valueOf(this.dia) + e.getDia();
            this.hora = e.getHora() < 10 ? "0" : "";
            this.hora = String.valueOf(this.hora) + e.getHora();
            this.min = e.getMinuto() < 10 ? "0" : "";
            this.min = String.valueOf(this.min) + e.getMinuto();
            this.seg = e.getSegundo() < 10 ? "0" : "";
            this.seg = String.valueOf(this.seg) + e.getSegundo();
            this.tipo = e.getTipo();
            evt.setAttribute("data", String.valueOf(ano) + "-" + this.mes + "-" + this.dia);
            evt.setAttribute("hora", String.valueOf(this.hora) + ":" + this.min + ":" + this.seg);
            evt.setText(this.tipo);
            doc.getRootElement().addContent(evt);
            XMLOutputter serializer = new XMLOutputter();
            serializer.setFormat(Format.getPrettyFormat());
            serializer.output(doc, (Writer)new FileWriter(f));
            return true;
        }
        catch (JDOMException jdomx) {
            this.criaArquivo();
        }
        catch (IOException iox) {
            this.criaArquivo();
        }
        return false;
    }

    public void criaArquivo() {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.nomeDocumento));
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<eventos xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"eventos.xsd\">\n</eventos>");
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void buscaEventos(Object o, int depth) {
        block10: {
            block9: {
                if (!(o instanceof Document)) break block9;
                Document doc = (Document)o;
                List children = doc.getContent();
                for (Object child : children) {
                    this.buscaEventos(child, depth + 1);
                }
                break block10;
            }
            if (!(o instanceof Element)) break block10;
            Element elem = (Element)o;
            if (elem.getName() == "evento") {
                String[] data = elem.getAttributeValue("data").split("-");
                switch (this.tipoBusca) {
                    case 1: {
                        if (!data[0].equals(this.ano) || !data[1].equals(this.mes)) break;
                        this.res.add(String.valueOf(elem.getAttributeValue("data")) + "xxx" + elem.getAttributeValue("hora") + "xxx" + elem.getValue());
                        break;
                    }
                    case 3: {
                        this.res.add(String.valueOf(elem.getAttributeValue("data")) + "xxx" + elem.getAttributeValue("hora") + "xxx" + elem.getValue());
                        break;
                    }
                    case 2: {
                        if (!this.removeu) {
                            String[] hora = elem.getAttributeValue("hora").split(":");
                            if (!data[0].equals(this.ano) || !data[1].equals(this.mes) || !hora[0].equals(this.hora) || !hora[1].equals(this.min) || !elem.getValue().equalsIgnoreCase(this.tipo)) break;
                            this.removeu = true;
                            this.oldChild = elem;
                            return;
                        }
                        return;
                    }
                }
            }
            List children = elem.getContent();
            for (Object child : children) {
                this.buscaEventos(child, depth + 1);
                if (!this.removeu) continue;
                this.removeu = elem.removeContent(this.oldChild);
                return;
            }
        }
    }

    public Evento[] getEventos() {
        SAXBuilder builder = new SAXBuilder();
        this.res = new Vector();
        try {
            Document doc = builder.build(new File(this.nomeDocumento));
            this.tipoBusca = 3;
            this.buscaEventos(doc, 0);
            if (this.res != null) {
                int numeroRegistros = this.res.size();
                int excesso = 999 - numeroRegistros;
                int registroInicial = excesso < 0 ? Math.abs(excesso) : 0;
                Evento[] eventos = new Evento[this.res.size()];
                int i = registroInicial;
                while (i < this.res.size()) {
                    String[] eventoS = ((String)this.res.get(i - registroInicial)).split("xxx");
                    String[] data = eventoS[0].split("-");
                    String[] hora = eventoS[1].split(":");
                    eventos[i] = new Evento(eventoS[2], Integer.parseInt(hora[0]), Integer.parseInt(hora[1]), Integer.parseInt(hora[2]), Integer.parseInt(data[2]), Integer.parseInt(data[1]), Integer.parseInt(data[0]));
                    ++i;
                }
                return eventos;
            }
            return null;
        }
        catch (JDOMException jDOMException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Evento[] getEventos(int ano, int mes) {
        this.ano = String.valueOf(ano);
        this.mes = mes < 10 ? "0" : "";
        this.mes = String.valueOf(this.mes) + String.valueOf(mes);
        SAXBuilder builder = new SAXBuilder();
        this.res = new Vector();
        try {
            Document doc = builder.build(new File(this.nomeDocumento));
            this.tipoBusca = 1;
            this.buscaEventos(doc, 0);
            if (this.res != null) {
                Evento[] eventos = new Evento[this.res.size()];
                int i = 0;
                while (i < this.res.size()) {
                    String[] eventoS = ((String)this.res.get(i)).split("xxx");
                    String[] data = eventoS[0].split("-");
                    String[] hora = eventoS[1].split(":");
                    eventos[i] = new Evento(eventoS[2], Integer.parseInt(hora[0]), Integer.parseInt(hora[1]), Integer.parseInt(hora[2]), Integer.parseInt(data[2]), mes, ano);
                    ++i;
                }
                return eventos;
            }
            return null;
        }
        catch (JDOMException jDOMException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public boolean removerEvento(Evento e, int mes, int ano) {
        try {
            this.ano = String.valueOf(ano);
            this.mes = mes < 10 ? "0" : "";
            this.mes = String.valueOf(this.mes) + String.valueOf(mes);
            this.dia = e.getDia() < 10 ? "0" : "";
            this.dia = String.valueOf(this.dia) + String.valueOf(e.getDia());
            this.hora = e.getHora() < 10 ? "0" : "";
            this.hora = String.valueOf(this.hora) + String.valueOf(e.getHora());
            this.min = e.getMinuto() < 10 ? "0" : "";
            this.min = String.valueOf(this.min) + String.valueOf(e.getMinuto());
            this.tipo = e.getTipo();
            SAXBuilder builder = new SAXBuilder();
            File f = new File(this.nomeDocumento);
            Document doc = builder.build(f);
            this.tipoBusca = 2;
            this.buscaEventos(doc, 0);
            if (this.removeu) {
                XMLOutputter serializer = new XMLOutputter();
                serializer.output(doc, (Writer)new FileWriter(f));
                this.removeu = false;
                return true;
            }
        }
        catch (JDOMException builder) {
        }
        catch (IOException builder) {
        }
        catch (Exception evt) {
            evt.printStackTrace();
        }
        return false;
    }
}

