/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.gui;

import br.com.schneider.sgm.gui.Barra2;
import br.com.schneider.sgm.internacionalizacao.Idioma;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

class PainelSaida
extends JPanel {
    private JLabel corrente;
    private JLabel frequencia;
    private JLabel labelCorrente;
    private JLabel labelFrequencia;
    private JLabel labelSaida;
    private JLabel labelTensao;
    Barra2 panelBarraTensao;
    private JLabel saida;
    private DecimalFormat formatador;
    private String titulo;
    private ImageIcon imagemFundo;
    private float barraLimSuperior;
    private float barraLimInferior;
    private JPanel enchimento4;

    public PainelSaida(String caminhoFiguras) {
        this.initComponents();
        this.imagemFundo = new ImageIcon(String.valueOf(caminhoFiguras) + "painelSuperior.png");
        this.formatador = new DecimalFormat("0.0");
        this.validarIdioma();
    }

    public void setBarraLimSuperior(float limite) {
        this.barraLimSuperior = limite;
        this.panelBarraTensao.setLimSuperior(this.barraLimSuperior);
    }

    public void setBarraLimInferior(float limite) {
        this.barraLimInferior = limite;
        this.panelBarraTensao.setLimInferior(this.barraLimInferior);
    }

    public float getBarraLimInferior() {
        return this.barraLimInferior;
    }

    public float getBarraLimSuperior() {
        return this.barraLimSuperior;
    }

    public void validarIdioma() {
        this.titulo = ResourceBundle.getBundle(Idioma.getIdioma()).getString("SAIDA");
        this.enchimento4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), "  " + this.titulo, 0, 0, new Font("Trebuchet", 1, 12)));
        this.labelTensao.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("TENSAO_EFICAZ"));
        this.labelSaida.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("SAIDA_NOMINAL"));
        this.labelCorrente.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("CORRENTE"));
        this.labelFrequencia.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("FREQUENCIA"));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.imagemFundo.getImage(), 0, 0, null);
    }

    private void initComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Dimension d = new Dimension(205, 170);
        Font fonte11P = new Font("Trebuchet", 0, 11);
        Font fonte11B = new Font("Trebuchet", 1, 11);
        Font fonte12P = new Font("Trebuchet", 0, 12);
        Font fonte12B = new Font("Trebuchet", 1, 12);
        Insets insets = new Insets(0, 32, 10, 0);
        this.labelSaida = new JLabel();
        this.saida = new JLabel();
        this.labelTensao = new JLabel();
        this.panelBarraTensao = new Barra2();
        this.labelCorrente = new JLabel();
        this.corrente = new JLabel();
        this.labelFrequencia = new JLabel();
        this.frequencia = new JLabel();
        this.barraLimSuperior = 150.0f;
        this.barraLimInferior = 95.0f;
        this.panelBarraTensao.setLimInferior(this.barraLimInferior);
        this.panelBarraTensao.setLimSuperior(this.barraLimSuperior);
        this.titulo = ResourceBundle.getBundle(Idioma.getIdioma()).getString("SAIDA");
        this.enchimento4 = new JPanel();
        this.setLayout(new FlowLayout(1, 0, 3));
        this.setOpaque(false);
        this.add(this.enchimento4);
        this.enchimento4.setLayout(new GridBagLayout());
        this.enchimento4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), "  " + this.titulo, 0, 0, fonte12B));
        this.enchimento4.setMaximumSize(d);
        this.enchimento4.setMinimumSize(d);
        this.enchimento4.setOpaque(false);
        this.enchimento4.setPreferredSize(d);
        this.labelSaida.setFont(fonte12B);
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.enchimento4.add((Component)this.labelSaida, gridBagConstraints);
        this.saida.setFont(fonte12P);
        this.saida.setText("110V");
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = insets;
        this.enchimento4.add((Component)this.saida, gridBagConstraints);
        this.labelTensao.setFont(fonte11B);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.enchimento4.add((Component)this.labelTensao, gridBagConstraints);
        this.panelBarraTensao.setMinimumSize(new Dimension(10, 45));
        this.panelBarraTensao.setPreferredSize(new Dimension(10, 45));
        this.panelBarraTensao.setRequestFocusEnabled(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.enchimento4.add((Component)this.panelBarraTensao, gridBagConstraints);
        this.labelCorrente.setFont(fonte11B);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.enchimento4.add((Component)this.labelCorrente, gridBagConstraints);
        this.corrente.setFont(fonte11P);
        this.corrente.setText("A");
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = insets;
        this.enchimento4.add((Component)this.corrente, gridBagConstraints);
        this.labelFrequencia.setFont(fonte11B);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.enchimento4.add((Component)this.labelFrequencia, gridBagConstraints);
        this.frequencia.setFont(fonte11P);
        this.frequencia.setText("0.00Hz");
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = insets;
        this.enchimento4.add((Component)this.frequencia, gridBagConstraints);
    }

    public void setLabelCorrente(JLabel l) {
        this.labelCorrente = l;
    }

    public void setLabelSaida(JLabel l) {
        this.labelSaida = l;
    }

    public void setLabelFrequencia(JLabel l) {
        this.labelFrequencia = l;
    }

    public void setCorrente(JLabel l) {
        this.corrente = l;
    }

    public void setSaida(JLabel l) {
        this.saida = l;
    }

    public void setFrequencia(JLabel l) {
        this.frequencia = l;
    }

    public void setLabelTensao(JLabel l) {
        this.labelTensao = l;
    }

    public void setCorrente(float f) {
        this.corrente.setText(String.valueOf(this.formatador.format(f)) + "A");
    }

    public void setSaida(boolean i) {
        this.saida.setText(String.valueOf(i ? "222" : "110") + "V");
    }

    public void setSaida(int i) {
        this.saida.setText(String.valueOf(i) + "V");
    }

    public void setFrequencia(float f) {
        this.frequencia.setText(String.valueOf(this.formatador.format(f)) + "Hz");
    }

    public JLabel getLabelCorrente() {
        return this.labelCorrente;
    }

    public JLabel getLabelSaida() {
        return this.labelSaida;
    }

    public JLabel getLabelFrequencia() {
        return this.labelFrequencia;
    }

    public JLabel getCorrente() {
        return this.corrente;
    }

    public JLabel getSaida() {
        return this.saida;
    }

    public JLabel getFrequencia() {
        return this.frequencia;
    }

    public JLabel getLabelTensao() {
        return this.labelTensao;
    }
}

