/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.gui;

import br.com.schneider.sgm.internacionalizacao.Idioma;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class PainelSMTP
extends JPanel {
    private static final long serialVersionUID = -1800727996848387795L;
    private JButton btnCancel;
    private JButton btnOk;
    private JCheckBox cbAutenticacao;
    private JLabel labelDestinatario;
    private JLabel labelEndServidor;
    private JLabel labelPorta;
    private JLabel labelRemetente;
    private JLabel labelSMTP;
    private JLabel labelSenha;
    private JLabel labelUsuario;
    private JPasswordField pfSenha;
    private JTextField tfDestinatario;
    private JTextField tfEndServidor;
    private JTextField tfPorta;
    private JTextField tfRemetente;
    private JTextField tfUsuario;
    private JComboBox<String> cmbProvedores;
    private JLabel labelProvedor;
    private int antigaPorta;
    private boolean flag;
    private String provedorEscolhido;

    public PainelSMTP() {
        this.initComponents();
        this.validarIdioma();
        this.addListeners();
    }

    private void habilitarCamposEmail(boolean value) {
        this.tfDestinatario.setEnabled(value);
        this.tfRemetente.setEnabled(value);
        this.tfPorta.setEnabled(value);
        this.tfEndServidor.setEnabled(value);
        this.cbAutenticacaoSelected(value);
        this.tfDestinatario.setEditable(value);
        this.tfRemetente.setEditable(value);
        this.tfPorta.setEditable(value);
        this.tfEndServidor.setEditable(value);
    }

    private void addListeners() {
        this.cbAutenticacao.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                PainelSMTP.this.cbAutenticacaoSelected(PainelSMTP.this.cbAutenticacao.isSelected());
                PainelSMTP.this.flag = true;
            }
        });
        this.tfUsuario.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                PainelSMTP.this.flag = true;
            }
        });
        this.tfRemetente.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                PainelSMTP.this.flag = true;
            }
        });
        this.tfPorta.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                PainelSMTP.this.flag = true;
            }
        });
        this.tfDestinatario.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                PainelSMTP.this.flag = true;
            }
        });
        this.tfEndServidor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                PainelSMTP.this.flag = true;
            }
        });
        this.pfSenha.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                PainelSMTP.this.flag = true;
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PainelSMTP.this.flag = false;
            }
        });
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PainelSMTP.this.flag = false;
            }
        });
        this.cmbProvedores.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                String valorSelecionado = (String)cb.getSelectedItem();
                PainelSMTP.this.atualizarCamposEmail(valorSelecionado);
            }
        });
    }

    public void atualizarCamposEmail(String valorSelecionado) {
        if (valorSelecionado.equals(this.provedorEscolhido)) {
            return;
        }
        switch (valorSelecionado) {
            case "GMAIL": {
                this.tfEndServidor.setText("smtp.gmail.com");
                this.alterarValorDefaultPorta();
                this.setProvedor(valorSelecionado);
                break;
            }
            case "LIVE": {
                this.tfEndServidor.setText("smtp.live.com");
                this.alterarValorDefaultPorta();
                this.setProvedor(valorSelecionado);
                break;
            }
            case "YAHOO": {
                this.tfEndServidor.setText("smtp.mail.yahoo.com");
                this.alterarValorDefaultPorta();
                this.setProvedor(valorSelecionado);
                break;
            }
            case "CUSTOM": {
                this.habilitarCamposEmail(true);
                this.cbAutenticacaoSelected(false);
                this.cbAutenticacao.setSelected(false);
                this.setProvedor(valorSelecionado);
                break;
            }
            default: {
                this.limparCamposEmail();
            }
        }
    }

    private void alterarValorDefaultPorta() {
        boolean isPortaComZeroVaziaouNula;
        boolean bl = isPortaComZeroVaziaouNula = this.tfPorta.getText() == null || this.tfPorta.getText().equals("") || this.tfPorta.getText().equals("0");
        if (isPortaComZeroVaziaouNula) {
            this.tfPorta.setText("587");
        }
    }

    private void limparCamposEmail() {
        this.tfDestinatario.setText("");
        this.tfEndServidor.setText("");
        this.tfPorta.setText("");
        this.tfRemetente.setText("");
        this.pfSenha.setText("");
        this.tfUsuario.setText("");
    }

    public boolean isPortaValida() {
        try {
            this.antigaPorta = Integer.parseInt(this.tfPorta.getText());
            return true;
        }
        catch (NumberFormatException nfe) {
            this.tfPorta.setText(Integer.toString(this.antigaPorta));
            return false;
        }
    }

    public int getPorta() {
        try {
            return Integer.parseInt(this.tfPorta.getText());
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public void cbAutenticacaoSelected(boolean b) {
        this.labelUsuario.setEnabled(b);
        this.labelSenha.setEnabled(b);
        this.tfUsuario.setEnabled(b);
        this.pfSenha.setEnabled(b);
        if (!b) {
            this.tfUsuario.setBackground(new Color(230, 230, 230));
            this.pfSenha.setBackground(new Color(230, 230, 230));
        } else {
            this.tfUsuario.setBackground(Color.WHITE);
            this.pfSenha.setBackground(Color.WHITE);
        }
    }

    public String[] getCamposSMTP() {
        String[] retorno = new String[]{this.tfEndServidor.getText(), this.tfUsuario.getText(), this.pfSenha.getText(), this.tfRemetente.getText(), this.tfDestinatario.getText(), this.tfPorta.getText()};
        return retorno;
    }

    public void validarIdioma() {
        this.labelSenha.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("SENHA"));
        this.btnOk.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("OK"));
        this.btnCancel.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("CANCELAR"));
        this.labelEndServidor.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("ENDERECO_SERVIDOR"));
        this.labelUsuario.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("USUARIO"));
        this.labelSMTP.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("SMTP"));
        this.labelRemetente.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("REMETENTE"));
        this.labelDestinatario.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("DESTINATARIO"));
        this.labelPorta.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("PORTA"));
        this.labelProvedor.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("PROVEDOR"));
        this.cbAutenticacao.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("AUTENTICACAO"));
    }

    private void initComponents() {
        Font fonte11 = new Font("Trebuchet", 0, 11);
        Font fonte12N = new Font("Trebuchet", 1, 12);
        this.labelSenha = new JLabel();
        this.pfSenha = new JPasswordField();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.tfUsuario = new JTextField();
        this.tfEndServidor = new JTextField();
        this.labelEndServidor = new JLabel();
        this.labelUsuario = new JLabel();
        this.labelSMTP = new JLabel();
        this.labelProvedor = new JLabel();
        this.labelRemetente = new JLabel();
        this.tfRemetente = new JTextField();
        this.labelDestinatario = new JLabel();
        this.tfDestinatario = new JTextField();
        this.labelPorta = new JLabel();
        this.tfPorta = new JTextField();
        this.cbAutenticacao = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(384, 335));
        this.setMinimumSize(new Dimension(384, 335));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(384, 335));
        this.labelProvedor.setFont(fonte11);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, -20, 0);
        this.add((Component)this.labelProvedor, gridBagConstraints);
        this.labelSenha.setFont(fonte11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 5, 0);
        this.add((Component)this.labelSenha, gridBagConstraints);
        this.pfSenha.setBorder(new SoftBevelBorder(1, new Color(204, 204, 204), new Color(204, 204, 204), null, null));
        this.pfSenha.setMaximumSize(new Dimension(100, 19));
        this.pfSenha.setMinimumSize(new Dimension(100, 19));
        this.pfSenha.setPreferredSize(new Dimension(100, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.pfSenha, gridBagConstraints);
        this.btnOk.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(160, 160, 160)));
        this.btnOk.setFocusPainted(false);
        this.btnOk.setHorizontalTextPosition(0);
        this.btnOk.setMaximumSize(new Dimension(101, 30));
        this.btnOk.setMinimumSize(new Dimension(101, 30));
        this.btnOk.setPreferredSize(new Dimension(101, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 0, 10, 24);
        this.add((Component)this.btnOk, gridBagConstraints);
        this.btnCancel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(160, 160, 160)));
        this.btnCancel.setFocusPainted(false);
        this.btnCancel.setMaximumSize(new Dimension(101, 30));
        this.btnCancel.setMinimumSize(new Dimension(101, 30));
        this.btnCancel.setPreferredSize(new Dimension(101, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, -14, 10, 46);
        this.add((Component)this.btnCancel, gridBagConstraints);
        this.tfUsuario.setBorder(new SoftBevelBorder(1, new Color(204, 204, 204), new Color(204, 204, 204), null, null));
        this.tfUsuario.setMaximumSize(new Dimension(100, 19));
        this.tfUsuario.setMinimumSize(new Dimension(100, 19));
        this.tfUsuario.setPreferredSize(new Dimension(100, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 25);
        this.add((Component)this.tfUsuario, gridBagConstraints);
        this.tfEndServidor.setBorder(new SoftBevelBorder(1, new Color(204, 204, 204), new Color(204, 204, 204), null, null));
        this.tfEndServidor.setMinimumSize(new Dimension(100, 19));
        this.tfEndServidor.setPreferredSize(new Dimension(100, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 25);
        this.add((Component)this.tfEndServidor, gridBagConstraints);
        this.labelEndServidor.setFont(fonte11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 5, 0);
        this.add((Component)this.labelEndServidor, gridBagConstraints);
        this.labelUsuario.setFont(fonte11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 5, 0);
        this.add((Component)this.labelUsuario, gridBagConstraints);
        this.labelSMTP.setFont(fonte12N);
        this.labelSMTP.setMaximumSize(new Dimension(60, 15));
        this.labelSMTP.setMinimumSize(new Dimension(60, 15));
        this.labelSMTP.setPreferredSize(new Dimension(60, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 15, 0);
        this.add((Component)this.labelSMTP, gridBagConstraints);
        this.labelRemetente.setFont(fonte11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 5, 0);
        this.add((Component)this.labelRemetente, gridBagConstraints);
        this.tfRemetente.setBorder(new SoftBevelBorder(1, new Color(204, 204, 204), new Color(204, 204, 204), null, null));
        this.tfRemetente.setMaximumSize(new Dimension(100, 19));
        this.tfRemetente.setMinimumSize(new Dimension(100, 19));
        this.tfRemetente.setPreferredSize(new Dimension(100, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 25);
        this.add((Component)this.tfRemetente, gridBagConstraints);
        this.labelDestinatario.setFont(fonte11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 5, 0);
        this.add((Component)this.labelDestinatario, gridBagConstraints);
        this.tfDestinatario.setBorder(new SoftBevelBorder(1, new Color(204, 204, 204), new Color(204, 204, 204), null, null));
        this.tfDestinatario.setMaximumSize(new Dimension(100, 19));
        this.tfDestinatario.setMinimumSize(new Dimension(100, 19));
        this.tfDestinatario.setPreferredSize(new Dimension(100, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 25);
        this.add((Component)this.tfDestinatario, gridBagConstraints);
        this.labelPorta.setFont(fonte11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 5, 0);
        this.add((Component)this.labelPorta, gridBagConstraints);
        this.tfPorta.setBorder(new SoftBevelBorder(1, new Color(204, 204, 204), new Color(204, 204, 204), null, null));
        this.tfPorta.setMaximumSize(new Dimension(100, 19));
        this.tfPorta.setMinimumSize(new Dimension(100, 19));
        this.tfPorta.setPreferredSize(new Dimension(100, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 25);
        this.add((Component)this.tfPorta, gridBagConstraints);
        this.cbAutenticacao.setFont(fonte11);
        this.cbAutenticacao.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbAutenticacao.setFocusable(false);
        this.cbAutenticacao.setOpaque(false);
        this.cbAutenticacao.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.cbAutenticacao, gridBagConstraints);
        String[] provedores = new String[]{"LIVE", "GMAIL", "YAHOO", "CUSTOM"};
        this.cmbProvedores = new JComboBox<String>(provedores);
        if (this.provedorEscolhido != null) {
            this.atualizarCamposEmail(this.provedorEscolhido);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 25);
        this.add(this.cmbProvedores, gridBagConstraints);
    }

    public int getAntigaPorta() {
        return this.antigaPorta;
    }

    public JButton getBtnCancel() {
        return this.btnCancel;
    }

    public JButton getBtnOk() {
        return this.btnOk;
    }

    public JCheckBox getCbAutenticacao() {
        return this.cbAutenticacao;
    }

    public boolean isFlag() {
        return this.flag;
    }

    public boolean getFlag() {
        return this.flag;
    }

    public JLabel getLabelDestinatario() {
        return this.labelDestinatario;
    }

    public JLabel getLabelEndServidor() {
        return this.labelEndServidor;
    }

    public JLabel getLabelPorta() {
        return this.labelPorta;
    }

    public JLabel getLabelRemetente() {
        return this.labelRemetente;
    }

    public JLabel getLabelSenha() {
        return this.labelSenha;
    }

    public JLabel getLabelSMTP() {
        return this.labelSMTP;
    }

    public JLabel getLabelUsuario() {
        return this.labelUsuario;
    }

    public JPasswordField getPfSenha() {
        return this.pfSenha;
    }

    public JTextField getTfDestinatario() {
        return this.tfDestinatario;
    }

    public JTextField getTfEndServidor() {
        return this.tfEndServidor;
    }

    public JTextField getTfPorta() {
        return this.tfPorta;
    }

    public JTextField getTfRemetente() {
        return this.tfRemetente;
    }

    public JTextField getTfUsuario() {
        return this.tfUsuario;
    }

    public String getProvedor() {
        return this.provedorEscolhido;
    }

    public void setAntigaPorta(int antigaPorta) {
        this.antigaPorta = antigaPorta;
    }

    public void setBtnCancel(JButton btnCancel) {
        this.btnCancel = btnCancel;
    }

    public void setBtnOk(JButton btnOk) {
        this.btnOk = btnOk;
    }

    public void setCbAutenticacao(JCheckBox cbAutenticacao) {
        this.cbAutenticacao = cbAutenticacao;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public void setLabelDestinatario(JLabel labelDestinatario) {
        this.labelDestinatario = labelDestinatario;
    }

    public void setLabelEndServidor(JLabel labelEndServidor) {
        this.labelEndServidor = labelEndServidor;
    }

    public void setLabelPorta(JLabel labelPorta) {
        this.labelPorta = labelPorta;
    }

    public void setLabelRemetente(JLabel labelRemetente) {
        this.labelRemetente = labelRemetente;
    }

    public void setLabelSenha(JLabel labelSenha) {
        this.labelSenha = labelSenha;
    }

    public void setLabelSMTP(JLabel labelSMTP) {
        this.labelSMTP = labelSMTP;
    }

    public void setLabelUsuario(JLabel labelUsuario) {
        this.labelUsuario = labelUsuario;
    }

    public void setPfSenha(JPasswordField pfSenha) {
        this.pfSenha = pfSenha;
    }

    public void setTfDestinatario(JTextField tfDestinatario) {
        this.tfDestinatario = tfDestinatario;
    }

    public void setTfEndServidor(JTextField tfEndServidor) {
        this.tfEndServidor = tfEndServidor;
    }

    public void setTfPorta(JTextField tfPorta) {
        this.tfPorta = tfPorta;
    }

    public void setTfRemetente(JTextField tfRemetente) {
        this.tfRemetente = tfRemetente;
    }

    public void setTfUsuario(JTextField tfUsuario) {
        this.tfUsuario = tfUsuario;
    }

    public void setProvedor(String provedorEscolhido) {
        this.provedorEscolhido = provedorEscolhido;
    }

    public JComboBox<String> getCmbProvedores() {
        return this.cmbProvedores;
    }

    public void setCmbProvedores(JComboBox<String> cmbProvedores) {
        this.cmbProvedores = cmbProvedores;
    }

    private boolean isStrNulaOuVazia(String str) {
        return str == null || str.equals("");
    }

    private boolean isStrNulaOuVazia(char[] chars) {
        try {
            return chars == null || chars.length == 0;
        }
        catch (Exception e) {
            return true;
        }
    }
}

