/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.gui;

import br.com.schneider.sgm.internacionalizacao.Idioma;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

class PainelPotencia
extends JPanel {
    private JLabel fPot;
    private JLabel labelBoost;
    private JLabel boost;
    private JLabel labelFPot;
    private JLabel labelPotAp;
    private JLabel labelPotReal;
    private JLabel potAp;
    private JLabel potReal;
    private DecimalFormat formatador;
    private DecimalFormat formatador2;
    private String titulo;
    private ImageIcon imagemFundo;
    private JPanel enchimento;

    public PainelPotencia(String caminhoImagem) {
        this.initComponents();
        this.imagemFundo = new ImageIcon(String.valueOf(caminhoImagem) + "painelInferior.png");
        this.formatador = new DecimalFormat("0.0");
        this.formatador2 = new DecimalFormat("0.00");
    }

    public void validarIdioma() {
        this.titulo = ResourceBundle.getBundle(Idioma.getIdioma()).getString("POTENCIA");
        this.enchimento.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), "  " + this.titulo, 0, 1, new Font("Trebuchet", 1, 12)));
        this.labelPotAp.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("POTENCIA_APARENTE"));
        this.labelPotReal.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("POTENCIA_REAL"));
        this.labelFPot.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("FATOR_DE_POTENCIA"));
        this.labelBoost.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("BOOST"));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.imagemFundo.getImage(), 0, 0, null);
    }

    private void initComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Dimension d = new Dimension(205, 135);
        Font fonte = new Font("Trebuchet", 0, 11);
        Font fonte1 = new Font("Trebuchet", 1, 11);
        Font fonte12B = new Font("Trebuchet", 1, 12);
        Insets insets = new Insets(0, 0, 10, 0);
        Insets insets2 = new Insets(0, 20, 10, 0);
        this.labelBoost = new JLabel();
        this.boost = new JLabel();
        this.labelPotAp = new JLabel();
        this.potAp = new JLabel();
        this.labelPotReal = new JLabel();
        this.potReal = new JLabel();
        this.labelFPot = new JLabel();
        this.fPot = new JLabel();
        this.titulo = ResourceBundle.getBundle(Idioma.getIdioma()).getString("POTENCIA");
        this.enchimento = new JPanel();
        this.setLayout(new FlowLayout(1, 0, 3));
        this.setOpaque(false);
        this.add(this.enchimento);
        this.enchimento.setLayout(new GridBagLayout());
        this.enchimento.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), "  " + this.titulo, 0, 1, fonte12B));
        this.enchimento.setMaximumSize(d);
        this.enchimento.setMinimumSize(d);
        this.enchimento.setOpaque(false);
        this.enchimento.setPreferredSize(d);
        this.labelPotAp.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("POTENCIA_APARENTE"));
        this.labelPotAp.setFont(fonte1);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.enchimento.add((Component)this.labelPotAp, gridBagConstraints);
        this.potAp.setFont(fonte);
        this.potAp.setText("VA");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = insets2;
        this.enchimento.add((Component)this.potAp, gridBagConstraints);
        this.labelPotReal.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("POTENCIA_REAL"));
        this.labelPotReal.setFont(fonte1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.enchimento.add((Component)this.labelPotReal, gridBagConstraints);
        this.potReal.setFont(fonte);
        this.potReal.setText("000.0W");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = insets2;
        this.enchimento.add((Component)this.potReal, gridBagConstraints);
        this.labelFPot.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("FATOR_DE_POTENCIA"));
        this.labelFPot.setFont(fonte1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.enchimento.add((Component)this.labelFPot, gridBagConstraints);
        this.fPot.setFont(fonte);
        this.fPot.setText("FP");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = insets2;
        this.enchimento.add((Component)this.fPot, gridBagConstraints);
    }

    public void setFPot(JLabel l) {
        this.fPot = l;
    }

    public void setLabelFPot(JLabel l) {
        this.labelFPot = l;
    }

    public void setLabelPotAp(JLabel l) {
        this.labelPotAp = l;
    }

    public void setLabelPotReal(JLabel l) {
        this.labelPotReal = l;
    }

    public void setPotAp(JLabel l) {
        this.potAp = l;
    }

    public void setPotReal(JLabel l) {
        this.potReal = l;
    }

    public void setBoost(JLabel boost) {
        this.boost = boost;
    }

    public void setLabelBoost(JLabel labelBoost) {
        this.labelBoost = labelBoost;
    }

    public void setFPot(float f) {
        this.fPot.setText(this.formatador2.format(f));
    }

    public void setPotAp(float f) {
        this.potAp.setText(String.valueOf(this.formatador.format(f)) + "VA");
    }

    public void setPotReal(float f) {
        this.potReal.setText(String.valueOf(this.formatador.format(f)) + "W");
    }

    public void setBoost(float f) {
        this.boost.setText(this.formatador.format(f));
    }

    public JLabel getFPot() {
        return this.fPot;
    }

    public JLabel getLabelFPot() {
        return this.labelFPot;
    }

    public JLabel getLabelPotAp() {
        return this.labelPotAp;
    }

    public JLabel getLabelPotReal() {
        return this.labelPotReal;
    }

    public JLabel getPotAp() {
        return this.potAp;
    }

    public JLabel getPotReal() {
        return this.potReal;
    }
}

