/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.gui;

import br.com.schneider.sgm.eventos.Evento;
import br.com.schneider.sgm.gui.InterfaceGrafica;
import br.com.schneider.sgm.historico.Historico;
import br.com.schneider.sgm.internacionalizacao.Idioma;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class PainelHistorico
extends JPanel {
    private JButton btnLimparSelecao;
    private JButton btnLimparTudo;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable tabelaAlarmes;
    private String[] tituloAlarmesCol;
    private String tituloAlarmes;
    private Object[][] dadosTabela1;
    private int selectedRow = -1;
    private TableModel tableModel;
    private String caminhoFiguras;
    private int linhaAtual;
    private InterfaceGrafica interfaceGrafica;
    private Historico historico;
    private boolean flagRetorno;
    private boolean painelAtivo;
    private DefaultTableModel tableEvento;

    public PainelHistorico(String caminhoFiguras, InterfaceGrafica interfaceGrafica, Evento[] evts) {
        this.initComponents(evts.length);
        this.interfaceGrafica = interfaceGrafica;
        this.caminhoFiguras = caminhoFiguras;
        this.tableModel = this.tabelaAlarmes.getModel();
        this.inserirRegistros(evts, false);
        this.addListeners();
    }

    public void inserirRegistros(Evento[] eventos, boolean novaLinha) {
        block6: {
            try {
                if (eventos == null) break block6;
                int i = 0;
                while (i < eventos.length) {
                    block7: {
                        if (eventos[i] != null) {
                            String evento;
                            try {
                                evento = ResourceBundle.getBundle(Idioma.getIdioma()).getString(eventos[i].getTipo());
                            }
                            catch (MissingResourceException e) {
                                break block7;
                            }
                            String data = eventos[i].getDia() < 10 ? "0" + Integer.toString(eventos[i].getDia()) : Integer.toString(eventos[i].getDia());
                            data = eventos[i].getMes() < 10 ? String.valueOf(data) + " / 0" + eventos[i].getMes() : String.valueOf(data) + " / " + eventos[i].getMes();
                            data = String.valueOf(data) + " / " + eventos[i].getAno();
                            String hora = eventos[i].getHora() < 10 ? "0" + Integer.toString(eventos[i].getHora()) : Integer.toString(eventos[i].getHora());
                            String minuto = eventos[i].getMinuto() < 10 ? "0" + Integer.toString(eventos[i].getMinuto()) : Integer.toString(eventos[i].getMinuto());
                            String segundo = eventos[i].getSegundo() < 10 ? "0" + Integer.toString(eventos[i].getSegundo()) : Integer.toString(eventos[i].getSegundo());
                            String horario = String.valueOf(hora) + " : " + minuto + " : " + segundo;
                            this.addLine(evento, data, horario, novaLinha);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void validarIdioma() {
        this.btnLimparTudo.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("LIMPAR_TUDO"));
        this.btnLimparSelecao.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("LIMPAR_SELECAO"));
        this.tituloAlarmesCol[1] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("DATA");
        this.tituloAlarmesCol[2] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("HORARIO");
        this.tituloAlarmesCol[0] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("EVENTO_REGISTRADO");
        this.tituloAlarmes = ResourceBundle.getBundle(Idioma.getIdioma()).getString("HISTORICO_DE_ALARMES");
        this.tabelaAlarmes.setBorder(new SoftBevelBorder(1));
        this.tabelaAlarmes.getColumnModel().getColumn(0).setHeaderValue(this.tituloAlarmesCol[0]);
        this.tabelaAlarmes.getColumnModel().getColumn(1).setHeaderValue(this.tituloAlarmesCol[1]);
        this.tabelaAlarmes.getColumnModel().getColumn(2).setHeaderValue(this.tituloAlarmesCol[2]);
    }

    public boolean getRow() {
        return this.selectedRow >= 0;
    }

    private void addListeners() {
        this.tabelaAlarmes.setSelectionMode(0);
        ListSelectionModel rowSM = this.tabelaAlarmes.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    PainelHistorico.this.selectedRow = lsm.getMinSelectionIndex();
                }
            }
        });
    }

    public boolean limpaTabela() {
        this.tableEvento.setRowCount(0);
        this.linhaAtual = 0;
        return true;
    }

    public void addLine(String evento, String data, String horario, boolean novaLinha) {
        if (novaLinha) {
            Object[] t = new String[]{"", "", ""};
            this.tableEvento.addRow(t);
        }
        this.tableModel.setValueAt(evento, this.linhaAtual, 0);
        this.tableModel.setValueAt(data, this.linhaAtual, 1);
        this.tableModel.setValueAt(horario, this.linhaAtual, 2);
        ++this.linhaAtual;
    }

    private void initComponents(int numeroRegistros) {
        this.jPanel1 = new JPanel();
        this.btnLimparTudo = new JButton();
        this.btnLimparSelecao = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tabelaAlarmes = new JTable();
        this.tituloAlarmes = ResourceBundle.getBundle(Idioma.getIdioma()).getString("HISTORICO_DE_ALARMES");
        this.tituloAlarmesCol = new String[3];
        this.tituloAlarmesCol[0] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("EVENTO_REGISTRADO");
        this.tituloAlarmesCol[1] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("DATA");
        this.tituloAlarmesCol[2] = ResourceBundle.getBundle(Idioma.getIdioma()).getString("HORARIO");
        this.dadosTabela1 = new Object[numeroRegistros][3];
        this.setLayout(new BorderLayout());
        this.setMaximumSize(new Dimension(515, 300));
        this.setMinimumSize(new Dimension(515, 300));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(515, 300));
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jPanel1.setOpaque(false);
        this.btnLimparTudo.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("LIMPAR_TUDO"));
        this.btnLimparTudo.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(160, 160, 160)));
        this.btnLimparTudo.setFocusPainted(false);
        this.btnLimparTudo.setMaximumSize(new Dimension(140, 31));
        this.btnLimparTudo.setMinimumSize(new Dimension(140, 31));
        this.btnLimparTudo.setPreferredSize(new Dimension(140, 31));
        this.jPanel1.add(this.btnLimparTudo);
        this.btnLimparSelecao.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("LIMPAR_SELECAO"));
        this.btnLimparSelecao.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(160, 160, 160)));
        this.btnLimparSelecao.setFocusPainted(false);
        this.btnLimparSelecao.setMaximumSize(new Dimension(140, 31));
        this.btnLimparSelecao.setMinimumSize(new Dimension(140, 31));
        this.btnLimparSelecao.setPreferredSize(new Dimension(140, 31));
        this.jPanel1.add(this.btnLimparSelecao);
        this.add((Component)this.jPanel1, "South");
        this.tabelaAlarmes.setBorder(new SoftBevelBorder(1));
        this.tableEvento = new DefaultTableModel(this.dadosTabela1, this.tituloAlarmesCol){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[3];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        };
        this.tabelaAlarmes.setModel(this.tableEvento);
        this.tabelaAlarmes.setGridColor(new Color(241, 241, 241));
        this.tabelaAlarmes.setRequestFocusEnabled(false);
        TableColumnModel tt = this.tabelaAlarmes.getColumnModel();
        TableColumn ttt = tt.getColumn(0);
        ttt.setPreferredWidth(250);
        this.jScrollPane1.setViewportView(this.tabelaAlarmes);
        this.jScrollPane1.setAutoscrolls(true);
        this.add((Component)this.jScrollPane1, "Center");
    }

    public JButton getBtnLimparSelecao() {
        return this.btnLimparSelecao;
    }

    public JButton getBtnLimparTudo() {
        return this.btnLimparTudo;
    }

    public JPanel getJPanel1() {
        return this.jPanel1;
    }

    public JScrollPane getJScrollPane1() {
        return this.jScrollPane1;
    }

    public JTable getTabelaAlarmes() {
        return this.tabelaAlarmes;
    }

    public String getTituloAlarmes() {
        return this.tituloAlarmes;
    }

    public String[] getTituloAlarmesCol() {
        return this.tituloAlarmesCol;
    }

    public void setBtnLimparSelecao(JButton btnLimparSelecao) {
        this.btnLimparSelecao = btnLimparSelecao;
    }

    public void setBtnLimparTudo(JButton btnLimparTudo) {
        this.btnLimparTudo = btnLimparTudo;
    }

    public void setJPanel1(JPanel panel1) {
        this.jPanel1 = panel1;
    }

    public void setJScrollPane1(JScrollPane scrollPane1) {
        this.jScrollPane1 = scrollPane1;
    }

    public void setTabelaAlarmes(JTable tabelaAlarmes) {
        this.tabelaAlarmes = tabelaAlarmes;
    }

    public void setTituloAlarmes(String tituloAlarmes) {
        this.tituloAlarmes = tituloAlarmes;
    }

    public void setTituloAlarmesCol(String[] tituloAlarmesCol) {
        this.tituloAlarmesCol = tituloAlarmesCol;
    }

    public String getCaminhoFiguras() {
        return this.caminhoFiguras;
    }

    public Object[][] getDadosTabela1() {
        return this.dadosTabela1;
    }

    public boolean isFlagRetorno() {
        return this.flagRetorno;
    }

    public Historico getHistorico() {
        return this.historico;
    }

    public InterfaceGrafica getInterfaceGrafica() {
        return this.interfaceGrafica;
    }

    public int getLinhaAtual() {
        return this.linhaAtual;
    }

    public boolean isPainelAtivo() {
        return this.painelAtivo;
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public DefaultTableModel getTableEvento() {
        return this.tableEvento;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setSelectedRow(int i) {
        this.selectedRow = i;
        this.linhaAtual = this.tableEvento.getRowCount();
    }
}

