/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.gui;

import br.com.schneider.sgm.gui.Barra1;
import br.com.schneider.sgm.internacionalizacao.Idioma;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

class PainelEntrada
extends JPanel {
    private JLabel corrente;
    private JLabel entrada;
    private float barraLimSuperior;
    private float barraLimInferior;
    private JLabel frequencia;
    private JLabel labelCorrente;
    private JLabel labelEntrada;
    private JLabel labelFrequencia;
    private JLabel labelTensao;
    Barra1 panelBarraTensao;
    private DecimalFormat formatador;
    private String titulo;
    private ImageIcon imagemFundo;
    private JPanel enchimento2;

    public PainelEntrada(String caminhoFiguras) {
        this.initComponents();
        this.imagemFundo = new ImageIcon(String.valueOf(caminhoFiguras) + "painelSuperior.png");
        this.formatador = new DecimalFormat("0.0");
        this.validarIdioma();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.imagemFundo.getImage(), 0, 0, null);
    }

    public void setBarraLimSuperior(float limite) {
        this.barraLimSuperior = limite;
        this.panelBarraTensao.setLimSuperior(this.barraLimSuperior);
    }

    public void setBarraLimInferior(float limite) {
        this.barraLimInferior = limite;
        this.panelBarraTensao.setLimInferior(this.barraLimInferior);
    }

    public float getBarraLimInferior() {
        return this.barraLimInferior;
    }

    public float getBarraLimSuperior() {
        return this.barraLimSuperior;
    }

    public void validarIdioma() {
        this.titulo = ResourceBundle.getBundle(Idioma.getIdioma()).getString("ENTRADA");
        this.enchimento2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), "  " + this.titulo, 0, 0, new Font("Trebuchet", 1, 12)));
        this.labelEntrada.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("ENTRADA_NOMINAL"));
        this.labelTensao.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("TENSAO_EFICAZ"));
        this.labelCorrente.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("CORRENTE"));
        this.labelFrequencia.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("FREQUENCIA"));
    }

    private void initComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Dimension d = new Dimension(205, 170);
        Font fonte11B = new Font("Trebuchet", 1, 11);
        Font fonte11P = new Font("Trebuchet", 0, 11);
        Font fonte12B = new Font("Trebuchet", 1, 12);
        Font fonte12P = new Font("Trebuchet", 0, 12);
        Insets insets = new Insets(0, 32, 15, 0);
        this.labelEntrada = new JLabel();
        this.entrada = new JLabel();
        this.panelBarraTensao = new Barra1();
        this.labelTensao = new JLabel();
        this.labelCorrente = new JLabel();
        this.corrente = new JLabel();
        this.labelFrequencia = new JLabel();
        this.frequencia = new JLabel();
        this.barraLimSuperior = 150.0f;
        this.barraLimInferior = 90.0f;
        this.panelBarraTensao.setLimSuperior(this.barraLimSuperior);
        this.panelBarraTensao.setLimInferior(this.barraLimInferior);
        this.titulo = ResourceBundle.getBundle(Idioma.getIdioma()).getString("ENTRADA");
        this.enchimento2 = new JPanel();
        this.setLayout(new FlowLayout(1, 0, 3));
        this.setOpaque(false);
        this.add(this.enchimento2);
        this.enchimento2.setLayout(new GridBagLayout());
        this.enchimento2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), "  " + this.titulo, 0, 0, fonte12B));
        this.enchimento2.setMaximumSize(d);
        this.enchimento2.setMinimumSize(d);
        this.enchimento2.setOpaque(false);
        this.enchimento2.setPreferredSize(d);
        this.labelEntrada.setFont(fonte12B);
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.enchimento2.add((Component)this.labelEntrada, gridBagConstraints);
        this.entrada.setFont(fonte12P);
        this.entrada.setText("110V");
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = insets;
        this.enchimento2.add((Component)this.entrada, gridBagConstraints);
        this.labelTensao.setFont(fonte11B);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.enchimento2.add((Component)this.labelTensao, gridBagConstraints);
        this.panelBarraTensao.setMinimumSize(new Dimension(10, 45));
        this.panelBarraTensao.setPreferredSize(new Dimension(10, 45));
        this.panelBarraTensao.setRequestFocusEnabled(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.enchimento2.add((Component)this.panelBarraTensao, gridBagConstraints);
        this.labelCorrente.setFont(fonte11B);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.enchimento2.add((Component)this.labelCorrente, gridBagConstraints);
        this.corrente.setFont(fonte11P);
        this.corrente.setText("A");
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = insets;
        this.enchimento2.add((Component)this.corrente, gridBagConstraints);
        this.labelFrequencia.setFont(fonte11B);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.enchimento2.add((Component)this.labelFrequencia, gridBagConstraints);
        this.frequencia.setFont(fonte11P);
        this.frequencia.setText("0.00Hz");
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = insets;
        this.enchimento2.add((Component)this.frequencia, gridBagConstraints);
    }

    public void setLabelCorrente(JLabel l) {
        this.labelCorrente = l;
    }

    public void setLabelEntrada(JLabel l) {
        this.labelEntrada = l;
    }

    public void setLabelFrequencia(JLabel l) {
        this.labelFrequencia = l;
    }

    public void setCorrente(JLabel l) {
        this.corrente = l;
    }

    public void setEntrada(JLabel l) {
        this.entrada = l;
    }

    public void setFrequencia(JLabel l) {
        this.frequencia = l;
    }

    public void setLabelTensao(JLabel l) {
        this.labelTensao = l;
    }

    public void setCorrente(float f) {
        this.corrente.setText(String.valueOf(this.formatador.format(f)) + "A");
    }

    public void setEntrada(boolean i) {
        this.entrada.setText(String.valueOf(i ? "220" : "110") + "V");
    }

    public void setEntrada(int i) {
        this.entrada.setText(String.valueOf(i) + "V");
    }

    public void setFrequencia(float f) {
        this.frequencia.setText(String.valueOf(this.formatador.format(f)) + "Hz");
    }

    public JLabel getLabelCorrente() {
        return this.labelCorrente;
    }

    public JLabel getLabelEntrada() {
        return this.labelEntrada;
    }

    public JLabel getLabelFrequencia() {
        return this.labelFrequencia;
    }

    public JLabel getCorrente() {
        return this.corrente;
    }

    public JLabel getEntrada() {
        return this.entrada;
    }

    public JLabel getFrequencia() {
        return this.frequencia;
    }

    public JLabel getLabelTensao() {
        return this.labelTensao;
    }
}

