/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.gui;

import br.com.schneider.sgm.gui.PainelDec;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PainelBarrado
extends PainelDec {
    private static final long serialVersionUID = 2198731463974630460L;
    public static final byte APAGADO = 1;
    public static final byte ALERTA = 2;
    public static final byte OK = 3;
    private JPanel painelIndicadores;
    private JPanel preenche;
    private JLabel[] indicadores;
    private Icon[] leds;
    private JLabel rotuloTitulo;
    private Font fonteIndicadores;
    private Color corIndicadores;
    private GridLayout layoutIndicadores;

    public PainelBarrado(String caminhoImagem, String caminhoLeds, int espHorizontal, int espVertical, String titulo) {
        super(caminhoImagem, espHorizontal, espVertical);
        this.rotuloTitulo = new JLabel(titulo);
        this.rotuloTitulo.setHorizontalAlignment(0);
        this.rotuloTitulo.setVerticalAlignment(0);
        this.rotuloTitulo.setPreferredSize(new Dimension(125, 20));
        this.add((Component)this.rotuloTitulo, "North");
        this.indicadores = new JLabel[10];
        this.leds = new Icon[3];
        this.leds[0] = new ImageIcon(String.valueOf(caminhoLeds) + "Apagado.png");
        this.leds[1] = new ImageIcon(String.valueOf(caminhoLeds) + "Alerta.png");
        this.leds[2] = new ImageIcon(String.valueOf(caminhoLeds) + "ok.png");
        this.layoutIndicadores = new GridLayout(0, 2);
        this.painelIndicadores = new JPanel(this.layoutIndicadores);
        this.painelIndicadores.setPreferredSize(new Dimension(125, 151));
        this.painelIndicadores.setOpaque(false);
        this.add((Component)this.painelIndicadores, "Center");
        this.preenche = new JPanel();
        this.preenche.setPreferredSize(new Dimension(3, 151));
        this.preenche.setOpaque(false);
        this.add((Component)this.preenche, "West");
    }

    public void addIndicador(String indicador) {
        this.indicadores[this.layoutIndicadores.getRows()] = new JLabel(indicador, this.leds[0], 2);
        this.layoutIndicadores.setRows(this.layoutIndicadores.getRows() + 1);
        this.painelIndicadores.add(this.indicadores[this.layoutIndicadores.getRows() - 1]);
    }

    public void setIndicador(int i, JLabel label) {
        this.indicadores[i] = label;
    }

    public JLabel getIndicador(int i) {
        return this.indicadores[i];
    }

    public JPanel getPainelIndicador() {
        return this.painelIndicadores;
    }

    public JLabel getRotuloTitulo() {
        return this.rotuloTitulo;
    }

    public void setRotuloTitulo(JLabel rotuloTitulo) {
        this.rotuloTitulo = rotuloTitulo;
    }

    public Font getFonteIndicadores() {
        return this.fonteIndicadores;
    }

    public void setFonteIndicadores(Font fonteIndicadores) {
        this.fonteIndicadores = fonteIndicadores;
        int i = 0;
        while (i < this.layoutIndicadores.getRows()) {
            this.indicadores[i].setFont(fonteIndicadores);
            ++i;
        }
    }

    public Color getCorIndicadores() {
        return this.corIndicadores;
    }

    public void setCorIndicadores(Color corIndicadores) {
        this.corIndicadores = corIndicadores;
        int i = 0;
        while (i < this.layoutIndicadores.getRows()) {
            this.indicadores[i].setForeground(corIndicadores);
            ++i;
        }
    }

    public void chaveiaLed(int estado, int indicador) {
        switch (estado) {
            case 1: {
                this.indicadores[indicador].setIcon(this.leds[0]);
                break;
            }
            case 2: {
                this.indicadores[indicador].setIcon(this.leds[1]);
                break;
            }
            case 3: {
                this.indicadores[indicador].setIcon(this.leds[2]);
            }
        }
    }
}

