/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.gui;

import br.com.schneider.sgm.internacionalizacao.Idioma;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PainelAutoTeste
extends JPanel {
    private static final long serialVersionUID = 4306578214258553153L;
    private boolean flag;
    private boolean autoTesteEnabled;
    private JSpinner spinnerHoraTeste;
    private DecimalFormat formatador;
    private JCheckBox chkHabilitaTeste;
    private JRadioButton radioDia;
    private JRadioButton radioSemana;
    private JRadioButton radioMensal;
    private ButtonGroup periodoGroup;
    private JSpinner spinnerMinutoTeste;
    private JLabel labelDoisPontos;
    private JLabel labelTitulo;
    private int horaTeste;
    private int minutoTeste;
    private int periodoAutoTeste;
    private JButton btnCancel;
    private JButton btnOk;
    private JPanel panelHoraTeste;
    private JPanel panelPeriodo;
    private String[] minuto = new String[]{"-1", "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60"};
    private String[] hora = new String[]{"-1", "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24"};

    public PainelAutoTeste() {
        this.formatador = new DecimalFormat("00");
        this.initComponents();
        this.addListeners();
    }

    public void validarIdioma() {
        this.labelTitulo.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("CONFIGURACOES_AUTO_TESTE_BATERIA"));
        this.panelHoraTeste.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(120, 120, 120)), ResourceBundle.getBundle(Idioma.getIdioma()).getString("HORA_TESTE")));
        this.panelPeriodo.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(120, 120, 120)), ResourceBundle.getBundle(Idioma.getIdioma()).getString("PERIODO_TESTE")));
        this.chkHabilitaTeste.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("HABILITAR_TESTE"));
        this.btnCancel.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("CANCELAR"));
        this.radioDia.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("DIARIO"));
        this.radioMensal.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("MENSAL"));
        this.radioSemana.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("SEMANAL"));
    }

    private void addListeners() {
        this.spinnerHoraTeste.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SpinnerModel modelo = PainelAutoTeste.this.spinnerHoraTeste.getModel();
                String aux = (String)modelo.getValue();
                Integer aux2 = new Integer(aux);
                int i = aux2;
                if (i == 24) {
                    modelo.setValue("00");
                }
                if (i == -1) {
                    modelo.setValue("23");
                }
                PainelAutoTeste.this.setFlag(true);
            }
        });
        this.spinnerMinutoTeste.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SpinnerModel modelo = PainelAutoTeste.this.spinnerMinutoTeste.getModel();
                String aux = (String)modelo.getValue();
                Integer aux2 = new Integer(aux);
                int i = aux2;
                if (i == 60) {
                    modelo.setValue("00");
                }
                if (i == -1) {
                    modelo.setValue("59");
                }
                PainelAutoTeste.this.setFlag(true);
            }
        });
        this.radioMensal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PainelAutoTeste.this.setFlag(true);
            }
        });
        this.radioSemana.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PainelAutoTeste.this.setFlag(true);
            }
        });
        this.radioDia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PainelAutoTeste.this.setFlag(true);
            }
        });
        this.chkHabilitaTeste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PainelAutoTeste.this.setFlag(true);
            }
        });
    }

    private void initComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Dimension d = new Dimension(384, 335);
        Font fonte11 = new Font("Trebuchet", 0, 11);
        Font fonte12Negrito = new Font("Trebuchet", 1, 12);
        this.setLayout(new GridBagLayout());
        this.setBackground(new Color(255, 255, 255));
        this.setMaximumSize(d);
        this.setMinimumSize(d);
        this.setOpaque(false);
        this.setPreferredSize(d);
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.spinnerMinutoTeste = new JSpinner();
        this.spinnerHoraTeste = new JSpinner();
        this.labelDoisPontos = new JLabel();
        this.labelTitulo = new JLabel();
        this.panelHoraTeste = new JPanel();
        this.panelPeriodo = new JPanel();
        this.chkHabilitaTeste = new JCheckBox();
        this.radioDia = new JRadioButton();
        this.radioSemana = new JRadioButton();
        this.radioMensal = new JRadioButton();
        this.periodoGroup = new ButtonGroup();
        this.periodoGroup.add(this.radioDia);
        this.periodoGroup.add(this.radioSemana);
        this.periodoGroup.add(this.radioMensal);
        this.labelTitulo.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("CONFIGURACOES_AUTO_TESTE_BATERIA"));
        this.labelTitulo.setFocusable(false);
        this.labelTitulo.setFont(fonte12Negrito);
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 40, 8, 0);
        this.add((Component)this.labelTitulo, gridBagConstraints);
        Dimension agendamento = new Dimension(330, 60);
        this.panelHoraTeste.setLayout(new GridBagLayout());
        this.panelHoraTeste.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(120, 120, 120)), ResourceBundle.getBundle(Idioma.getIdioma()).getString("HORA_TESTE")));
        this.panelHoraTeste.setMaximumSize(agendamento);
        this.panelHoraTeste.setMinimumSize(agendamento);
        this.panelHoraTeste.setPreferredSize(agendamento);
        this.panelHoraTeste.setOpaque(false);
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.panelHoraTeste, gridBagConstraints);
        this.panelPeriodo.setLayout(new GridBagLayout());
        this.panelPeriodo.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(120, 120, 120)), ResourceBundle.getBundle(Idioma.getIdioma()).getString("PERIODO_TESTE")));
        this.panelPeriodo.setMaximumSize(agendamento);
        this.panelPeriodo.setMinimumSize(agendamento);
        this.panelPeriodo.setPreferredSize(agendamento);
        this.panelPeriodo.setOpaque(false);
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.add((Component)this.panelPeriodo, gridBagConstraints);
        this.chkHabilitaTeste.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("HABILITAR_TESTE"));
        this.chkHabilitaTeste.setFont(fonte11);
        this.chkHabilitaTeste.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkHabilitaTeste.setFocusable(false);
        this.chkHabilitaTeste.setOpaque(false);
        this.chkHabilitaTeste.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.add((Component)this.chkHabilitaTeste, gridBagConstraints);
        this.btnOk.setFont(fonte12Negrito);
        this.btnOk.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("OK"));
        this.btnOk.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(160, 160, 160)));
        this.btnOk.setFocusPainted(false);
        this.btnOk.setMaximumSize(new Dimension(100, 30));
        this.btnOk.setMinimumSize(new Dimension(100, 30));
        this.btnOk.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 30;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(50, 30, 0, 0);
        this.add((Component)this.btnOk, gridBagConstraints);
        this.btnCancel.setFont(fonte12Negrito);
        this.btnCancel.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("CANCELAR"));
        this.btnCancel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(160, 160, 160)));
        this.btnCancel.setFocusPainted(false);
        this.btnCancel.setMaximumSize(new Dimension(100, 30));
        this.btnCancel.setMinimumSize(new Dimension(100, 30));
        this.btnCancel.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 30;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(50, 10, 0, 0);
        this.add((Component)this.btnCancel, gridBagConstraints);
        this.radioDia.setFont(fonte12Negrito);
        this.radioDia.setMaximumSize(new Dimension(100, 20));
        this.radioDia.setMinimumSize(new Dimension(100, 20));
        this.radioDia.setPreferredSize(new Dimension(100, 20));
        this.radioDia.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("DIARIO"));
        this.radioDia.setOpaque(false);
        this.radioDia.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioDia.setFocusPainted(false);
        this.radioDia.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelPeriodo.add((Component)this.radioDia, gridBagConstraints);
        this.radioSemana.setFont(fonte12Negrito);
        this.radioSemana.setMaximumSize(new Dimension(100, 20));
        this.radioSemana.setMinimumSize(new Dimension(100, 20));
        this.radioSemana.setPreferredSize(new Dimension(100, 20));
        this.radioSemana.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("SEMANAL"));
        this.radioSemana.setOpaque(false);
        this.radioSemana.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioSemana.setFocusPainted(false);
        this.radioSemana.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelPeriodo.add((Component)this.radioSemana, gridBagConstraints);
        this.radioMensal.setFont(fonte12Negrito);
        this.radioMensal.setMaximumSize(new Dimension(100, 20));
        this.radioMensal.setMinimumSize(new Dimension(100, 20));
        this.radioMensal.setPreferredSize(new Dimension(100, 20));
        this.radioMensal.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("MENSAL"));
        this.radioMensal.setOpaque(false);
        this.radioMensal.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioMensal.setFocusPainted(false);
        this.radioMensal.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelPeriodo.add((Component)this.radioMensal, gridBagConstraints);
        this.spinnerHoraTeste.setFont(fonte12Negrito);
        this.spinnerHoraTeste.setMaximumSize(new Dimension(40, 20));
        this.spinnerHoraTeste.setMinimumSize(new Dimension(40, 20));
        this.spinnerHoraTeste.setPreferredSize(new Dimension(40, 20));
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelHoraTeste.add((Component)this.spinnerHoraTeste, gridBagConstraints);
        SpinnerListModel modeloHoraDesligar = new SpinnerListModel(Arrays.asList(this.hora));
        this.spinnerHoraTeste.setModel(modeloHoraDesligar);
        modeloHoraDesligar.setValue("18");
        this.labelDoisPontos.setFont(fonte12Negrito);
        this.labelDoisPontos.setText(":");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelHoraTeste.add((Component)this.labelDoisPontos, gridBagConstraints);
        this.spinnerMinutoTeste.setFont(fonte12Negrito);
        this.spinnerMinutoTeste.setMaximumSize(new Dimension(40, 20));
        this.spinnerMinutoTeste.setMinimumSize(new Dimension(40, 20));
        this.spinnerMinutoTeste.setPreferredSize(new Dimension(40, 20));
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelHoraTeste.add((Component)this.spinnerMinutoTeste, gridBagConstraints);
        SpinnerListModel modeloMinutoDesligar = new SpinnerListModel(Arrays.asList(this.minuto));
        this.spinnerMinutoTeste.setModel(modeloMinutoDesligar);
        modeloMinutoDesligar.setValue("30");
    }

    public void validateForm() {
        this.flag = false;
        if (this.radioDia.isSelected()) {
            this.setPeriodoAutoTeste(0);
        } else if (this.radioSemana.isSelected()) {
            this.setPeriodoAutoTeste(1);
        } else if (this.radioMensal.isSelected()) {
            this.setPeriodoAutoTeste(2);
        }
        this.setMinutoTeste(Integer.parseInt((String)this.spinnerMinutoTeste.getModel().getValue()));
        this.setHoraTeste(Integer.parseInt((String)this.spinnerHoraTeste.getModel().getValue()));
        this.setAutoTesteHabilitado(this.chkHabilitaTeste.isSelected());
    }

    public JButton getBtnCancel() {
        return this.btnCancel;
    }

    public boolean getFlag() {
        return this.flag;
    }

    public JButton getBtnOk() {
        return this.btnOk;
    }

    public int getPeriodoAutoTeste() {
        return this.periodoAutoTeste;
    }

    public int getHoraTeste() {
        return this.horaTeste;
    }

    public int getMinutoTeste() {
        return this.minutoTeste;
    }

    public boolean getAutoTesteHabilitado() {
        return this.autoTesteEnabled;
    }

    public void setPeriodoAutoTeste(int periodo) {
        this.periodoAutoTeste = periodo;
        switch (periodo) {
            case 0: {
                this.radioDia.setSelected(true);
                break;
            }
            case 1: {
                this.radioSemana.setSelected(true);
                break;
            }
            case 2: {
                this.radioMensal.setSelected(true);
            }
        }
    }

    public void setHoraTeste(int hora) {
        if (hora >= 0 && hora < 24) {
            this.horaTeste = hora;
        }
        this.spinnerHoraTeste.getModel().setValue(this.formatador.format(this.horaTeste));
    }

    public void setMinutoTeste(int minuto) {
        if (minuto >= 0 && minuto < 60) {
            this.minutoTeste = minuto;
        }
        this.spinnerMinutoTeste.getModel().setValue(this.formatador.format(this.minutoTeste));
    }

    public void setAutoTesteHabilitado(boolean tst) {
        this.autoTesteEnabled = tst;
        this.chkHabilitaTeste.setSelected(this.autoTesteEnabled);
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }
}

