/*
 * Decompiled with CFR 0.152.
 */
package br.com.schneider.sgm.gui;

import br.com.schneider.sgm.controle.Controle;
import br.com.schneider.sgm.eventos.ControleListener;
import br.com.schneider.sgm.eventos.Evento;
import br.com.schneider.sgm.gui.BotaoDec;
import br.com.schneider.sgm.gui.PainelBarrado;
import br.com.schneider.sgm.gui.PainelCentral;
import br.com.schneider.sgm.gui.PainelComando;
import br.com.schneider.sgm.gui.PainelConfig;
import br.com.schneider.sgm.gui.PainelDec;
import br.com.schneider.sgm.gui.PainelGraficos;
import br.com.schneider.sgm.gui.PainelHistorico;
import br.com.schneider.sgm.gui.PainelMonitorCentral;
import br.com.schneider.sgm.gui.PainelSobre;
import br.com.schneider.sgm.gui.PainelSuperior;
import br.com.schneider.sgm.gui.PopUp;
import br.com.schneider.sgm.gui.PopUpAlerta;
import br.com.schneider.sgm.gui.TrataStatusAlertas;
import br.com.schneider.sgm.internacionalizacao.Idioma;
import br.com.schneider.sgm.servico.ExecutaAcaoRede;
import java.awt.AWTException;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class InterfaceGrafica
extends JFrame
implements ControleListener {
    private Hashtable<String, Integer> messagePopupCache = new Hashtable();
    private static final long serialVersionUID = 8673075460832518164L;
    private boolean energiaPop;
    private boolean energiaEmail;
    private boolean bateriaPop;
    private boolean bateriaEmail;
    private boolean cargaPop;
    private boolean cargaEmail;
    private boolean temperaturaPop;
    private boolean temperaturaEmail;
    private boolean bateriaUsoPop;
    private boolean bateriaUsoEmail;
    private boolean comEmail;
    private int xPop;
    private int yPop;
    private PainelDec painelFundo;
    private PainelCentral painelFuncional;
    private PainelSuperior painelSuperior;
    private JPanel painelStatusAlertas;
    private BotaoDec botaoMinimizar;
    private BotaoDec botaoTray;
    private BotaoDec botaoFechar;
    private BotaoDec botaoMonitor;
    private BotaoDec botaoGraficos;
    private BotaoDec botaoConfiguracoes;
    private BotaoDec botaoComandos;
    private BotaoDec botaoHistorico;
    private BotaoDec botaoSobre;
    private JLabel rotuloMonitor;
    private JLabel rotuloConfiguracoes;
    private JLabel rotuloGrafico;
    private JLabel rotuloHistorico;
    private JLabel rotuloSobre;
    private JLabel rotuloComandos;
    private PainelMonitorCentral painelMonitoramento;
    private PainelGraficos painelGraficos;
    private PainelComando painelComandos;
    private PainelConfig painelConfig;
    private PainelHistorico painelHistorico;
    private PainelSobre painelSobre;
    private SystemTray systemTray;
    private TrayIcon iconeTray;
    private boolean liga;
    private TrataEventos trataEventos;
    private TrataStatusAlertas trataStsAls;
    private PainelBarrado painelStatus;
    private PainelBarrado painelAlertas;
    private Controle controle;
    private String caminhoFiguras;
    private DecimalFormat formatador;
    private boolean comunicou = false;
    private final String VALIDA_ENDERECO_IP = "\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b";
    private boolean flagPedidos;
    private String pedidoAntigo;
    private Calendar calendar;
    private boolean monitor;
    private boolean graficos;

    public InterfaceGrafica(String caminhoFigura, Controle controle, String[] portasSeriais) {
        super("SGM Light " + controle.getVersaoSoftware());
        this.caminhoFiguras = caminhoFigura;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                InterfaceGrafica.this.encerraAplicativo();
            }
        });
        this.setResizable(false);
        this.setIconImage(new ImageIcon(String.valueOf(this.caminhoFiguras) + "IconeSGM.png").getImage());
        this.painelFundo = new PainelDec(String.valueOf(this.caminhoFiguras) + "Fundo.png", 0, 2);
        this.trataEventos = new TrataEventos();
        this.controle = controle;
        this.trataStsAls = new TrataStatusAlertas();
        Idioma.setIdiomaPortugues();
        this.calendar = Calendar.getInstance();
        this.calendar.setLenient(true);
        this.painelSuperior = new PainelSuperior(50, 0, 700, 76, this);
        this.botaoTray = new BotaoDec(String.valueOf(this.caminhoFiguras) + "Tray.png", String.valueOf(this.caminhoFiguras) + "TrayP.png", 22, 12);
        this.botaoTray.setRolloverIcon(new ImageIcon(String.valueOf(this.caminhoFiguras) + "TrayR.png"));
        this.botaoTray.addActionListener(this.trataEventos);
        this.painelSuperior.getControleJanela().add(this.botaoTray);
        this.botaoMinimizar = new BotaoDec(String.valueOf(this.caminhoFiguras) + "Minimizar.png", String.valueOf(this.caminhoFiguras) + "MinimizarP.png", 20, 12);
        this.botaoMinimizar.setRolloverIcon(new ImageIcon(String.valueOf(this.caminhoFiguras) + "MinimizarR.png"));
        this.botaoMinimizar.addActionListener(this.trataEventos);
        this.painelSuperior.getControleJanela().add(this.botaoMinimizar);
        this.botaoFechar = new BotaoDec(String.valueOf(this.caminhoFiguras) + "Fechar.png", String.valueOf(this.caminhoFiguras) + "FecharP.png", 30, 12);
        this.botaoFechar.setRolloverIcon(new ImageIcon(String.valueOf(this.caminhoFiguras) + "FecharR.png"));
        this.botaoFechar.addActionListener(this.trataEventos);
        this.painelSuperior.getControleJanela().add(this.botaoFechar);
        this.painelSuperior.getControleJanela().add(new JLabel("       "));
        this.botaoMonitor = new BotaoDec(String.valueOf(this.caminhoFiguras) + "Monitor.png", String.valueOf(this.caminhoFiguras) + "MonitorP.png", 46, 35);
        this.botaoMonitor.setRolloverIcon(new ImageIcon(String.valueOf(this.caminhoFiguras) + "MonitorR.png"));
        this.botaoMonitor.setFocusPainted(false);
        this.botaoMonitor.addActionListener(this.trataEventos);
        this.painelSuperior.getPainelBotoes().add(this.botaoMonitor);
        this.botaoGraficos = new BotaoDec(String.valueOf(this.caminhoFiguras) + "Grafico.png", String.valueOf(this.caminhoFiguras) + "GraficoP.png", 46, 35);
        this.botaoGraficos.setRolloverIcon(new ImageIcon(String.valueOf(this.caminhoFiguras) + "GraficoR.png"));
        this.botaoGraficos.setFocusPainted(false);
        this.botaoGraficos.addActionListener(this.trataEventos);
        this.painelSuperior.getPainelBotoes().add(this.botaoGraficos);
        this.botaoConfiguracoes = new BotaoDec(String.valueOf(this.caminhoFiguras) + "Configuracoes.png", String.valueOf(this.caminhoFiguras) + "ConfiguracoesP.png", 46, 35);
        this.botaoConfiguracoes.setRolloverIcon(new ImageIcon(String.valueOf(this.caminhoFiguras) + "ConfiguracoesR.png"));
        this.botaoConfiguracoes.setFocusPainted(false);
        this.botaoConfiguracoes.addActionListener(this.trataEventos);
        this.painelSuperior.getPainelBotoes().add(this.botaoConfiguracoes);
        this.botaoComandos = new BotaoDec(String.valueOf(this.caminhoFiguras) + "Comandos.png", String.valueOf(this.caminhoFiguras) + "ComandosP.png", 46, 35);
        this.botaoComandos.setRolloverIcon(new ImageIcon(String.valueOf(this.caminhoFiguras) + "ComandosR.png"));
        this.botaoComandos.setFocusPainted(false);
        this.botaoComandos.addActionListener(this.trataEventos);
        this.painelSuperior.getPainelBotoes().add(this.botaoComandos);
        this.botaoHistorico = new BotaoDec(String.valueOf(this.caminhoFiguras) + "Historico.png", String.valueOf(this.caminhoFiguras) + "HistoricoP.png", 46, 35);
        this.botaoHistorico.setRolloverIcon(new ImageIcon(String.valueOf(this.caminhoFiguras) + "HistoricoR.png"));
        this.botaoHistorico.setFocusPainted(false);
        this.botaoHistorico.addActionListener(this.trataEventos);
        this.painelSuperior.getPainelBotoes().add(this.botaoHistorico);
        this.botaoSobre = new BotaoDec(String.valueOf(this.caminhoFiguras) + "Sobre.png", String.valueOf(this.caminhoFiguras) + "SobreP.png", 46, 35);
        this.botaoSobre.setRolloverIcon(new ImageIcon(String.valueOf(this.caminhoFiguras) + "SobreR.png"));
        this.botaoSobre.setFocusPainted(false);
        this.botaoSobre.addActionListener(this.trataEventos);
        this.painelSuperior.getPainelBotoes().add(this.botaoSobre);
        this.rotuloMonitor = new JLabel(ResourceBundle.getBundle(Idioma.getIdioma()).getString("MONITOR"));
        this.rotuloMonitor.setForeground(Color.BLACK);
        this.rotuloMonitor.setHorizontalAlignment(0);
        this.rotuloMonitor.setFont(new Font("Trebuchet MS", 1, 9));
        this.painelSuperior.getPainelRotulos().add(this.rotuloMonitor);
        this.rotuloGrafico = new JLabel(ResourceBundle.getBundle(Idioma.getIdioma()).getString("GRAFICO"));
        this.rotuloGrafico.setForeground(Color.BLACK);
        this.rotuloGrafico.setHorizontalAlignment(0);
        this.rotuloGrafico.setFont(new Font("Trebuchet MS", 1, 9));
        this.painelSuperior.getPainelRotulos().add(this.rotuloGrafico);
        this.rotuloConfiguracoes = new JLabel(ResourceBundle.getBundle(Idioma.getIdioma()).getString("CONFIGURACOES"));
        this.rotuloConfiguracoes.setForeground(Color.BLACK);
        this.rotuloConfiguracoes.setHorizontalAlignment(0);
        this.rotuloConfiguracoes.setFont(new Font("Trebuchet MS", 1, 9));
        this.painelSuperior.getPainelRotulos().add(this.rotuloConfiguracoes);
        this.rotuloComandos = new JLabel(ResourceBundle.getBundle(Idioma.getIdioma()).getString("COMANDOS"));
        this.rotuloComandos.setForeground(Color.BLACK);
        this.rotuloComandos.setHorizontalAlignment(0);
        this.rotuloComandos.setFont(new Font("Trebuchet MS", 1, 9));
        this.painelSuperior.getPainelRotulos().add(this.rotuloComandos);
        this.rotuloHistorico = new JLabel(ResourceBundle.getBundle(Idioma.getIdioma()).getString("HISTORICO"));
        this.rotuloHistorico.setForeground(Color.BLACK);
        this.rotuloHistorico.setHorizontalAlignment(0);
        this.rotuloHistorico.setFont(new Font("Trebuchet MS", 1, 9));
        this.painelSuperior.getPainelRotulos().add(this.rotuloHistorico);
        this.rotuloSobre = new JLabel(ResourceBundle.getBundle(Idioma.getIdioma()).getString("SOBRE"));
        this.rotuloSobre.setForeground(Color.BLACK);
        this.rotuloSobre.setHorizontalAlignment(0);
        this.rotuloSobre.setFont(new Font("Trebuchet MS", 1, 9));
        this.painelSuperior.getPainelRotulos().add(this.rotuloSobre);
        this.painelFundo.add((Component)this.painelSuperior, "North");
        this.painelStatusAlertas = new JPanel(new FlowLayout(3, 0, 0));
        this.painelStatusAlertas.setPreferredSize(new Dimension(145, 355));
        this.painelStatusAlertas.setOpaque(false);
        this.painelStatus = new PainelBarrado(String.valueOf(this.caminhoFiguras) + "Painel_barrado.png", this.caminhoFiguras, 0, 0, ResourceBundle.getBundle(Idioma.getIdioma()).getString("STATUS"));
        this.painelStatus.setPreferredSize(new Dimension(125, 171));
        this.painelStatus.getRotuloTitulo().setFont(new Font("SansSerif", 1, 11));
        this.painelStatus.getRotuloTitulo().setForeground(Color.BLACK);
        this.painelStatus.addIndicador(ResourceBundle.getBundle(Idioma.getIdioma()).getString("CARREGANDO"));
        this.painelStatus.addIndicador(ResourceBundle.getBundle(Idioma.getIdioma()).getString("USANDO_BATERIA"));
        this.painelStatus.addIndicador(ResourceBundle.getBundle(Idioma.getIdioma()).getString("REDE_LIGADA"));
        this.painelStatus.addIndicador(ResourceBundle.getBundle(Idioma.getIdioma()).getString("SAIDA_LIGADA"));
        this.painelStatus.setFonteIndicadores(new Font("SansSerif", 1, 9));
        this.painelStatus.setCorIndicadores(Color.BLACK);
        this.painelStatus.setOpaque(false);
        this.painelStatusAlertas.add(this.painelStatus);
        JPanel preenche1 = new JPanel();
        preenche1.setPreferredSize(new Dimension(140, 13));
        preenche1.setOpaque(false);
        this.painelStatusAlertas.add(preenche1);
        this.painelAlertas = new PainelBarrado(String.valueOf(this.caminhoFiguras) + "Painel_barrado.png", this.caminhoFiguras, 0, 0, ResourceBundle.getBundle(Idioma.getIdioma()).getString("ALERTAS"));
        this.painelAlertas.setPreferredSize(new Dimension(125, 171));
        this.painelAlertas.getRotuloTitulo().setFont(new Font("SansSerif", 1, 11));
        this.painelAlertas.getRotuloTitulo().setForeground(Color.BLACK);
        this.painelAlertas.addIndicador(ResourceBundle.getBundle(Idioma.getIdioma()).getString("SUPER_AQUECIMENTO"));
        this.painelAlertas.addIndicador(ResourceBundle.getBundle(Idioma.getIdioma()).getString("BATERIA_BAIXA"));
        this.painelAlertas.addIndicador(ResourceBundle.getBundle(Idioma.getIdioma()).getString("SOBRECARGA"));
        this.painelAlertas.addIndicador(ResourceBundle.getBundle(Idioma.getIdioma()).getString("ATIVA_BYPASS"));
        this.painelAlertas.setFonteIndicadores(new Font("SansSerif", 1, 9));
        this.painelAlertas.setCorIndicadores(Color.BLACK);
        this.painelAlertas.setOpaque(false);
        this.painelStatusAlertas.add(this.painelAlertas);
        this.painelFundo.add((Component)this.painelStatusAlertas, "East");
        this.painelFuncional = new PainelCentral(this.caminhoFiguras, this);
        this.painelFuncional.setPreferredSize(new Dimension(515, 355));
        this.painelFuncional.setOpaque(false);
        this.painelFundo.add((Component)this.painelFuncional, "Center");
        this.painelMonitoramento = new PainelMonitorCentral(this.caminhoFiguras);
        this.painelFuncional.getPainelCentral().add((Component)this.painelMonitoramento, "PainelMonitor");
        this.painelComandos = new PainelComando(this.caminhoFiguras, this);
        this.painelComandos.getBtnAgendar().addActionListener(this.trataEventos);
        this.painelComandos.getBtnAgendar2().addActionListener(this.trataEventos);
        this.painelComandos.getBtnShutdown().addActionListener(this.trataEventos);
        this.painelComandos.getBtnShutdownReligamento().addActionListener(this.trataEventos);
        this.painelComandos.getTextFieldAutonomia().addActionListener(this.trataEventos);
        this.painelComandos.getTextFieldTempoFalha().addActionListener(this.trataEventos);
        this.painelFuncional.getPainelCentral().add((Component)this.painelComandos, "PainelComandos");
        this.painelConfig = new PainelConfig(this.caminhoFiguras, this);
        JComboBox serialComboBox = this.painelConfig.getPainelUPS().getComboBoxSerial();
        int i = 0;
        while (i < portasSeriais.length) {
            serialComboBox.addItem(portasSeriais[i]);
            ++i;
        }
        this.painelConfig.getPainelUPS().setFlag(false);
        this.painelConfig.getPainelConfigGeral().getBtnOk().addActionListener(this.trataEventos);
        this.painelConfig.getPainelConfigGeral().getComboBoxIdioma().addActionListener(this.trataEventos);
        this.painelConfig.getPainelConfigGeral().getBtnProcura().addActionListener(this.trataEventos);
        this.painelConfig.getPbc().getBtnGeral().addActionListener(this.trataEventos);
        this.painelConfig.getPbc().getBtnSNMP().addActionListener(this.trataEventos);
        this.painelConfig.getPbc().getBtnGeral().addActionListener(this.trataEventos);
        this.painelConfig.getPbc().getBtnUPS().addActionListener(this.trataEventos);
        this.painelConfig.getPainelUPS().getBtnOk().addActionListener(this.trataEventos);
        this.painelConfig.getPainelMensg().getBtnOk().addActionListener(this.trataEventos);
        this.painelConfig.getPainelSMTP().getBtnOk().addActionListener(this.trataEventos);
        this.painelConfig.getPainelSMTP().getBtnCancel().addActionListener(this.trataEventos);
        this.painelConfig.getPainelSNMP().getBtnOk().addActionListener(this.trataEventos);
        this.painelConfig.getPainelSNMP().getBtnCancel().addActionListener(this.trataEventos);
        this.painelConfig.getPainelSNMP().getTfPedidos().addCaretListener(this.trataEventos);
        this.painelConfig.getPainelAutoTeste().getBtnOk().addActionListener(this.trataEventos);
        this.painelConfig.getPainelAutoTeste().getBtnCancel().addActionListener(this.trataEventos);
        this.painelFuncional.getPainelCentral().add((Component)this.painelConfig, "PainelConfig");
        this.painelHistorico = new PainelHistorico(this.caminhoFiguras, this, controle.getArrayEventos());
        this.painelFuncional.getPainelCentral().add((Component)this.painelHistorico, "PainelHistorico");
        this.painelHistorico.getBtnLimparSelecao().addActionListener(this.trataEventos);
        this.painelHistorico.getBtnLimparTudo().addActionListener(this.trataEventos);
        this.painelGraficos = new PainelGraficos(this.caminhoFiguras, this);
        this.painelFuncional.getPainelCentral().add((Component)this.painelGraficos, "PainelGraficos");
        this.painelSobre = new PainelSobre(this.caminhoFiguras, controle.getVersaoSoftware());
        this.painelFuncional.getPainelCentral().add((Component)this.painelSobre, "PainelSobre");
        JPanel preenche2 = new JPanel();
        preenche2.setPreferredSize(new Dimension(20, 515));
        preenche2.setOpaque(false);
        this.painelFundo.add((Component)preenche2, "West");
        this.getContentPane().add(this.painelFundo);
        if (SystemTray.isSupported()) {
            this.systemTray = SystemTray.getSystemTray();
            this.iconeTray = new TrayIcon(new ImageIcon(String.valueOf(this.caminhoFiguras) + "IconeSGMTray.png").getImage(), "SGM Lite");
            this.iconeTray.addMouseListener(this.trataEventos);
            this.iconeTray.setImageAutoSize(true);
            try {
                this.systemTray.add(this.iconeTray);
            }
            catch (AWTException awte) {
                System.err.println(awte);
            }
        }
        this.setUndecorated(true);
        this.setSize(700, 450);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.xPop = this.painelSuperior.getPosJanX() + 180;
        this.yPop = this.painelSuperior.getPosJanY() + 150;
        Point p = this.getLocationOnScreen();
        this.painelSuperior.setPosJanX(new Double(p.getX()).shortValue());
        this.painelSuperior.setPosJanY(new Double(p.getY()).shortValue());
        if (controle.isPrimeiraExecucao()) {
            CardLayout card = (CardLayout)this.getPainelCentral().getLayout();
            card.show(this.getPainelCentral(), "PainelConfig");
            this.getPainelConfig();
            card = (CardLayout)PainelConfig.getPanelSlave().getLayout();
            this.getPainelConfig();
            card.show(PainelConfig.getPanelSlave(), "painelUPS");
        }
        this.formatador = new DecimalFormat("00");
        this.validarIdioma();
        this.painelFuncional.mudaPrompt(2, 2);
        this.limpaGUI();
    }

    public void lePersistencia() {
        if (this.controle.getPersistencia().isPrimeiraExec()) {
            this.controle.salvaPersistenciaSNMP(161, "public", "private", "127.0.0.1", 162, 0, 0);
            this.controle.salvaNomeUPS("vazio");
            this.controle.salvaMensagens(this.painelConfig.getPainelMensg().getCheckBoxSelected());
            this.painelConfig.getPainelSMTP().getTfPorta().setText("587");
        } else {
            this.painelConfig.getPainelConfigGeral().getComboBoxIdioma().setSelectedItem(this.controle.getIdiomaPersistencia());
            this.validarAllIdioma();
            this.painelConfig.getPainelConfigGeral().getComboBoxEvento().setSelectedIndex(this.controle.getEventoPersistencia());
            this.painelConfig.getPainelConfigGeral().getCbVarLogging().setSelected(this.controle.getModoLoggingPersitencia());
            this.painelConfig.getPainelConfigGeral().getTfScript().setText(this.controle.getScript());
            boolean[][] temp = this.controle.getMensagensPersistencia();
            this.painelConfig.getPainelMensg().getCbEnergiaEmail().setSelected(temp[0][0]);
            this.painelConfig.getPainelMensg().getCbEnergiaPop().setSelected(temp[0][1]);
            this.painelConfig.getPainelMensg().getCbBateriaFracaEmail().setSelected(temp[1][0]);
            this.painelConfig.getPainelMensg().getCbBateriaFracaPop().setSelected(temp[1][1]);
            this.painelConfig.getPainelMensg().getCbSobrecargaEmail().setSelected(temp[2][0]);
            this.painelConfig.getPainelMensg().getCbSobrecargaPop().setSelected(temp[2][1]);
            this.painelConfig.getPainelMensg().getCbAquecimentoEmail().setSelected(temp[3][0]);
            this.painelConfig.getPainelMensg().getCbAquecimentoPop().setSelected(temp[3][1]);
            this.painelConfig.getPainelMensg().getCbBateriaUsoEmail().setSelected(temp[4][0]);
            this.painelConfig.getPainelMensg().getCbBateriaUsoPop().setSelected(temp[4][1]);
            this.painelConfig.getPainelMensg().getCbComunicaEmail().setSelected(temp[5][0]);
            this.setMensagens();
            this.painelConfig.getPainelUPS().getComboBoxSerial().setSelectedItem(this.controle.getPortaSerial());
            int n = this.controle.getFamiliaUPSPersistencia();
            switch (n) {
                case 1: {
                    this.painelConfig.getPainelUPS().getRadioSolis().setSelected(true);
                    break;
                }
                case 2: {
                    this.painelConfig.getPainelUPS().getRadioRhino().setSelected(true);
                    break;
                }
                case 3: {
                    this.painelConfig.getPainelUPS().getRadioStay().setSelected(true);
                }
            }
            this.painelConfig.getPainelUPS().getTextFieldExpanBat().setText(Integer.toString(this.controle.getExpansorBateriaPersistencia()));
            if (this.controle.getNomeUPSPersistencia().equals("vazio")) {
                this.painelConfig.getPainelUPS().getNomeUPS().setText("");
            } else {
                this.painelConfig.getPainelUPS().getNomeUPS().setText(this.controle.getNomeUPSPersistencia());
            }
            this.painelConfig.getPainelSMTP().getTfEndServidor().setText(this.controle.getEnderecoSMTPPersistencia());
            this.painelConfig.getPainelSMTP().getCbAutenticacao().setSelected(this.controle.getFlagAutenticacoPersistencia());
            this.painelConfig.getPainelSMTP().cbAutenticacaoSelected(this.controle.getFlagAutenticacoPersistencia());
            this.painelConfig.getPainelSMTP().getTfUsuario().setText(this.controle.getUsuarioPersistencia());
            this.painelConfig.getPainelSMTP().getPfSenha().setText(this.controle.getSenhaPersistencia());
            this.painelConfig.getPainelSMTP().getTfRemetente().setText(this.controle.getRemetentePersistencia());
            String[] tempDest = this.controle.getDestinatariosPersistencia();
            String tempDest2 = "";
            int i = 0;
            while (i < tempDest.length) {
                tempDest2 = String.valueOf(tempDest2) + tempDest[i] + ", ";
                ++i;
            }
            this.painelConfig.getPainelSMTP().getTfDestinatario().setText(tempDest2);
            if (this.painelConfig.getPainelSMTP().getTfDestinatario().getText().equals(", ")) {
                this.painelConfig.getPainelSMTP().getTfDestinatario().setText("");
            }
            this.painelConfig.getPainelSMTP().getTfPorta().setText(Integer.toString(this.controle.getPortaSMTPPersistencia()));
            if (!this.controle.getProvedorEscolhidoPersitencia().equals("")) {
                this.painelConfig.getPainelSMTP().setProvedor(this.controle.getProvedorEscolhidoPersitencia());
                this.painelConfig.getPainelSMTP().getCmbProvedores().setSelectedItem(this.controle.getProvedorEscolhidoPersitencia());
            } else {
                this.painelConfig.getPainelSMTP().setProvedor("");
            }
            this.painelConfig.getPainelSNMP().getTfPedidos().setText(Integer.toString(this.controle.getPortaPedidos()));
            this.painelConfig.getPainelSNMP().getTfLeitura().setText(this.controle.getComunidadeLeitura());
            this.painelConfig.getPainelSNMP().getTfEscrita().setText(this.controle.getComunidadeEscrita());
            this.painelConfig.getPainelSNMP().getTfGerente().setText(this.controle.getEnderecoGerente());
            this.painelConfig.getPainelSNMP().getTfEnvio().setText(Integer.toString(this.controle.getPortaEnvio()));
            this.painelConfig.getPainelSNMP().getCbSNMP().setSelectedIndex(this.controle.getVSNMP());
            this.painelConfig.getPainelSNMP().getCbTransporte().setSelectedIndex(this.controle.getProtocoloTransportePersistencia());
            this.painelComandos.getTextFieldAutonomia().setText(Integer.toString(this.controle.getAutonomiaMinimaPersistencia()));
            this.painelComandos.getCbAutonomia().setSelected(this.controle.getFlagShutFimAut());
            this.painelComandos.getTextFieldTempoFalha().setText(Integer.toString(this.controle.getTempoFalhaEletrica()));
            this.painelComandos.getCbTempoFalha().setSelected(this.controle.getFlagShutFalhaEletrica());
            if (this.painelComandos.getCbAutonomia().isSelected()) {
                this.controle.setFlagShutFimAut(true);
                this.controle.setAutonomiaMinima(this.painelComandos.getTempoAutonomia());
            }
            if (this.painelComandos.getCbTempoFalha().isSelected()) {
                this.controle.setTempoFalha(this.painelComandos.getTempoFalha());
                this.controle.setShutdownTempoFalha(true);
            }
            this.painelConfig.getPainelConfigGeral().getTfPortaShutdownRemoto().setText(Integer.toString(this.controle.getPortaRemota()));
            this.painelConfig.getPainelConfigGeral().getCbShutdownRemoto().setSelected(this.controle.getModoRemoto());
            this.painelConfig.getPainelAutoTeste().setAutoTesteHabilitado(this.controle.getAutoTesteEnabledPersitencia());
            this.painelConfig.getPainelAutoTeste().setHoraTeste(this.controle.getHoraTestePersistencia());
            this.painelConfig.getPainelAutoTeste().setMinutoTeste(this.controle.getMinutoTestePersistencia());
            this.painelConfig.getPainelAutoTeste().setPeriodoAutoTeste(this.controle.getPeriodoTestePersistencia());
            this.painelGraficos.setValorKW(this.controle.getValorKw());
            this.painelComandos.setFlag(false);
            this.painelConfig.getPainelConfigGeral().setFlag(false);
            this.painelConfig.getPainelMensg().setFlag(false);
            this.painelConfig.getPainelSMTP().setFlag(false);
            this.painelConfig.getPainelSNMP().setFlag(false);
            this.painelConfig.getPainelUPS().setFlag(false);
            this.painelConfig.getPainelAutoTeste().setFlag(false);
        }
    }

    public void validarAllIdioma() {
        if (this.painelConfig.getPainelConfigGeral().getComboBoxIdioma().getSelectedItem().equals("ENGLISH")) {
            Idioma.setIdiomaIngles();
        } else {
            Idioma.setIdiomaPortugues();
        }
        int j = this.painelConfig.getPainelConfigGeral().getComboBoxEvento().getSelectedIndex();
        this.setEventos(this.controle.getTipoEventos());
        this.painelConfig.getPainelConfigGeral().validarIdioma();
        this.painelConfig.getPbc().validarIdioma();
        this.painelConfig.getPainelMensg().validarIdioma();
        this.painelConfig.getPainelUPS().validarIdioma();
        this.painelConfig.getPainelSMTP().validarIdioma();
        this.painelConfig.getPainelSNMP().validarIdioma();
        this.painelConfig.getPainelAutoTeste().validarIdioma();
        this.painelComandos.validarIdioma();
        this.painelHistorico.validarIdioma();
        this.painelMonitoramento.painelPotencia.validarIdioma();
        this.painelMonitoramento.painelTemperatura.validarIdioma();
        this.painelMonitoramento.painelEntrada.validarIdioma();
        this.painelMonitoramento.painelBateria.validarIdioma();
        this.painelMonitoramento.painelSaida.validarIdioma();
        this.painelFuncional.validarIdioma();
        this.painelFuncional.mudaPrompt(2, 2);
        this.painelGraficos.validarIdioma();
        this.painelSobre.validarIdioma();
        this.validarIdioma();
        this.painelConfig.getPainelConfigGeral().getComboBoxEvento().setSelectedIndex(j);
    }

    public void validarIdioma() {
        this.rotuloSobre.setText(String.valueOf(ResourceBundle.getBundle(Idioma.getIdioma()).getString("SOBRE")) + "      ");
        this.rotuloHistorico.setText(String.valueOf(ResourceBundle.getBundle(Idioma.getIdioma()).getString("HISTORICO")) + "    ");
        this.rotuloComandos.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("COMANDOS"));
        this.rotuloConfiguracoes.setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("CONFIGURACOES"));
        this.rotuloMonitor.setText("      " + ResourceBundle.getBundle(Idioma.getIdioma()).getString("MONITOR"));
        this.rotuloGrafico.setText("   " + ResourceBundle.getBundle(Idioma.getIdioma()).getString("GRAFICO"));
        this.painelStatus.getRotuloTitulo().setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("STATUS"));
        this.painelAlertas.getRotuloTitulo().setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("ALERTAS"));
        this.painelStatus.getIndicador(0).setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("CARREGANDO"));
        this.painelStatus.getIndicador(1).setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("USANDO_BATERIA"));
        this.painelStatus.getIndicador(2).setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("REDE_LIGADA"));
        this.painelStatus.getIndicador(3).setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("SAIDA_LIGADA"));
        this.painelAlertas.getIndicador(0).setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("SUPER_AQUECIMENTO"));
        this.painelAlertas.getIndicador(1).setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("BATERIA_BAIXA"));
        this.painelAlertas.getIndicador(2).setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("SOBRECARGA"));
        this.painelAlertas.getIndicador(3).setText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("ATIVA_BYPASS"));
    }

    private void encerraAplicativo() {
        if (this.painelConfig.getPainelConfigGeral().getComboBoxEvento().getSelectedIndex() == 17 && this.controle.isFlagShutdown()) {
            Evento evt = new Evento("SHUTDOWN", this.calendar.get(10), this.calendar.get(12), this.calendar.get(13), this.calendar.get(5), this.calendar.get(2), this.calendar.get(1));
            Evento[] evts = new Evento[]{evt};
            this.controle.verificaArquivoLote(evts);
        }
        String[] tempDest = this.painelConfig.getPainelSMTP().getTfDestinatario().getText().split(", ");
        this.controle.encerraAplicativo(this.painelConfig.getPainelConfigGeral().getComboBoxIdioma().getSelectedItem(), this.painelConfig.getPainelConfigGeral().getComboBoxEvento().getSelectedIndex(), this.painelConfig.getPainelConfigGeral().getTfScript().getText(), this.painelConfig.getPainelMensg().getCheckBoxSelected(), this.painelConfig.getPainelUPS().getExpansorBateria(), this.painelConfig.getPainelUPS().getNomeUPS().getText(), this.painelConfig.getPainelSMTP().getTfEndServidor().getText(), this.painelConfig.getPainelSMTP().getCbAutenticacao().isSelected(), this.painelConfig.getPainelSMTP().getTfUsuario().getText(), this.painelConfig.getPainelSMTP().getPfSenha().getText(), this.painelConfig.getPainelSMTP().getTfRemetente().getText(), tempDest, this.painelConfig.getPainelSMTP().getPorta(), Integer.parseInt(this.painelConfig.getPainelSNMP().getTfPedidos().getText()), this.painelConfig.getPainelSNMP().getTfLeitura().getText(), this.painelConfig.getPainelSNMP().getTfEscrita().getText(), this.painelConfig.getPainelSNMP().getTfGerente().getText(), Integer.parseInt(this.painelConfig.getPainelSNMP().getTfEnvio().getText()), this.painelConfig.getPainelSNMP().getCbSNMP().getSelectedIndex(), this.painelConfig.getPainelSNMP().getCbTransporte().getSelectedIndex(), this.painelComandos.getTempoAutonomia(), this.painelComandos.getTempoFalha(), this.painelConfig.getPainelConfigGeral().getPorta(), this.painelConfig.getPainelConfigGeral().getCbShutdownRemoto().isSelected(), Double.parseDouble(this.painelGraficos.getValorKW()), this.painelComandos.getCbAutonomia().isSelected(), this.painelComandos.getCbTempoFalha().isSelected(), this.painelConfig.getPainelSMTP().getProvedor());
    }

    public void eventoOcorreu(Evento[] evento) {
        if (evento != null) {
            this.painelHistorico.inserirRegistros(evento, true);
        }
    }

    @Override
    public void notificaDados() {
        if (!this.comunicou) {
            this.comunicou = true;
        }
        if (this.controle.isFlagShutdown()) {
            this.encerraAplicativo();
        }
        this.eventoOcorreu(this.controle.getEventos());
        this.painelGraficos.getGraficoCorrente().addValue(this.controle.getCorrenteEntrada(), this.controle.getCorrenteSaida());
        this.painelGraficos.getGraficoTensao().addValue(this.controle.getTensaoEntrada(), this.controle.getTensaoSaida());
        this.painelGraficos.getGraficoPotencia().addValue(this.controle.getPotenciaReal(), this.controle.getPotenciaAparente());
        this.painelGraficos.getGraficoBateria().addValue(this.controle.getTensaoBateria());
        this.painelMonitoramento.painelEntrada.setEntrada((int)this.controle.getTensaoEntradaNominal());
        float f1 = this.controle.getTensaoEntrada() - this.controle.getLimiteInferiorTensaoEntrada();
        float f2 = this.controle.getLimiteSuperiorTensaoEntrada() - this.controle.getLimiteInferiorTensaoEntrada();
        this.painelMonitoramento.painelEntrada.panelBarraTensao.setCont(Math.round(20.0f * (f1 / f2)), this.controle.getTensaoEntrada());
        this.painelMonitoramento.painelEntrada.setCorrente(this.controle.getCorrenteEntrada());
        this.painelMonitoramento.painelEntrada.setFrequencia(this.controle.getFrequenciaEntrada());
        this.painelMonitoramento.painelEntrada.setBarraLimSuperior(this.controle.getLimiteSuperiorTensaoEntrada());
        this.painelMonitoramento.painelEntrada.setBarraLimInferior(this.controle.getLimiteInferiorTensaoEntrada());
        this.painelMonitoramento.painelSaida.setSaida((int)this.controle.getTensaoSaidaNominal());
        float f4 = this.controle.getTensaoSaida() - this.controle.getLimiteInferiorTensaoSaida();
        float f3 = this.controle.getLimiteSuperiorTensaoSaida() - this.controle.getLimiteInferiorTensaoSaida();
        this.painelMonitoramento.painelSaida.panelBarraTensao.setCont(Math.round(20.0f * (f4 / f3)), this.controle.getTensaoSaida());
        this.painelMonitoramento.painelSaida.setCorrente(this.controle.getCorrenteSaida());
        this.painelMonitoramento.painelSaida.setFrequencia(this.controle.getFrequenciaSaida());
        this.painelMonitoramento.painelSaida.setBarraLimSuperior(this.controle.getLimiteSuperiorTensaoSaida());
        this.painelMonitoramento.painelSaida.setBarraLimInferior(this.controle.getLimiteInferiorTensaoSaida());
        this.painelMonitoramento.painelPotencia.setPotAp(this.controle.getPotenciaAparente());
        this.painelMonitoramento.painelPotencia.setPotReal(this.controle.getPotenciaReal());
        this.painelMonitoramento.painelPotencia.setFPot(this.controle.getFatorPotenciaCarga());
        this.painelMonitoramento.painelBateria.panelBarraTensaoBat.setCont(Math.round((float)this.controle.getPercentualBateria() / 5.0f));
        this.painelMonitoramento.painelBateria.setAutonomia(this.controle.getAutonomiaBateria());
        this.painelMonitoramento.painelBateria.setTensao(this.controle.getTensaoBateria());
        this.painelMonitoramento.painelTemperatura.panelBarraTemp.setCont(Math.round(this.controle.getTemperaturaUPS() / 2.0f));
        this.painelMonitoramento.painelTemperatura.panelBarraTemp.disabled = !this.controle.isTemperaturaAvaliable();
        this.trataStsAls.setCarregandoBateria(this.controle.isCarregandoBateria());
        this.trataStsAls.setBateriaEmUso(this.controle.isUsandoSomenteBateria());
        this.trataStsAls.setModoInversor(this.controle.isSaidaLigada());
        this.trataStsAls.setFalhaRede(this.controle.isModoRede());
        this.trataStsAls.setBateriaBaixa(this.controle.isBateriaBaixa());
        this.trataStsAls.setBateriaCritica(this.controle.isBateriaCritica());
        this.trataStsAls.setTemperaturaElevada(this.controle.isTemperaturaElevada());
        this.trataStsAls.setSuperAquecimento(this.controle.isSuperAquecimento());
        this.trataStsAls.setCargaElevada(this.controle.isCargaElevada());
        this.trataStsAls.setSobrecarga(this.controle.isSobrecarga());
        this.trataStsAls.setBypass(this.controle.isModoBypass());
        this.trataStsAls.processaStatusAlertas();
        if (this.trataStsAls.getIndicaCarregandoBateria() != 0) {
            if (this.trataStsAls.getIndicaCarregandoBateria() == 1) {
                this.painelStatus.chaveiaLed(3, 0);
            } else {
                this.painelStatus.chaveiaLed(1, 0);
            }
        }
        if (this.trataStsAls.getIndicaBateriaEmUso() != 0) {
            if (this.trataStsAls.getIndicaBateriaEmUso() == 1) {
                this.painelStatus.chaveiaLed(3, 1);
            } else {
                this.painelStatus.chaveiaLed(1, 1);
            }
        }
        if (this.trataStsAls.getIndicaFalhaRede() != 0) {
            if (this.trataStsAls.getIndicaFalhaRede() == 1) {
                this.painelStatus.chaveiaLed(3, 2);
            } else {
                this.painelStatus.chaveiaLed(1, 2);
            }
        }
        if (this.trataStsAls.getIndicaModoInversor() != 0) {
            if (this.trataStsAls.getIndicaModoInversor() == 1) {
                this.painelStatus.chaveiaLed(3, 3);
            } else {
                this.painelStatus.chaveiaLed(1, 3);
            }
        }
        if (this.trataStsAls.getIndicaTemperaturaElevada() == 1 && !this.trataStsAls.getSuperAquecimento()) {
            if (this.liga) {
                this.painelAlertas.chaveiaLed(2, 0);
            } else {
                this.painelAlertas.chaveiaLed(1, 0);
            }
        } else if (!this.trataStsAls.getSuperAquecimento()) {
            this.painelAlertas.chaveiaLed(1, 0);
        }
        if (this.trataStsAls.getIndicaSuperAquecimento() != 0) {
            if (this.trataStsAls.getIndicaSuperAquecimento() == 1) {
                this.painelAlertas.chaveiaLed(2, 0);
            } else {
                this.painelAlertas.chaveiaLed(1, 0);
            }
        }
        if (this.trataStsAls.getIndicaBateriaBaixa() == 1 && !this.trataStsAls.getBateriaCritica()) {
            if (this.liga) {
                this.painelAlertas.chaveiaLed(2, 1);
            } else {
                this.painelAlertas.chaveiaLed(1, 1);
            }
        } else if (!this.trataStsAls.getBateriaCritica()) {
            this.painelAlertas.chaveiaLed(1, 1);
        }
        if (this.trataStsAls.getIndicaBateriaCritica() != 0) {
            if (this.trataStsAls.getIndicaBateriaCritica() == 1) {
                this.painelAlertas.chaveiaLed(2, 1);
            } else {
                this.painelAlertas.chaveiaLed(1, 1);
            }
        }
        if (this.trataStsAls.getIndicaCargaElevada() == 1 && !this.trataStsAls.getSobrecarga()) {
            if (this.liga) {
                this.painelAlertas.chaveiaLed(2, 2);
            } else {
                this.painelAlertas.chaveiaLed(1, 2);
            }
        } else if (!this.trataStsAls.getSobrecarga()) {
            this.painelAlertas.chaveiaLed(1, 2);
        }
        if (this.trataStsAls.getIndicaSobrecarga() != 0) {
            if (this.trataStsAls.getIndicaSobrecarga() == 1) {
                this.painelAlertas.chaveiaLed(2, 2);
            } else {
                this.painelAlertas.chaveiaLed(1, 2);
            }
        }
        if (this.trataStsAls.getIndicaBypass() == 1 && !this.trataStsAls.getBypass()) {
            if (this.liga) {
                this.painelAlertas.chaveiaLed(2, 3);
            } else {
                this.painelAlertas.chaveiaLed(1, 3);
            }
        } else if (!this.trataStsAls.getBypass()) {
            this.painelAlertas.chaveiaLed(1, 3);
        }
        if (this.trataStsAls.getIndicaBypass() != 0) {
            if (this.trataStsAls.getIndicaBypass() == 1) {
                this.painelAlertas.chaveiaLed(2, 3);
            } else {
                this.painelAlertas.chaveiaLed(1, 3);
            }
        }
        this.liga = !this.liga;
    }

    @Override
    public void notificaFalhaCom() {
        Calendar cal = Calendar.getInstance();
        this.limpaGUI();
        String messageKey = "Sem_comunicacao_com_o_UPS__Horario";
        this.mostraPopUpAlerta(messageKey, String.valueOf(ResourceBundle.getBundle(Idioma.getIdioma()).getString(messageKey)) + this.formatador.format(this.controle.getHora()) + ":" + this.formatador.format(this.controle.getMinutos()), true);
        Evento evt = new Evento("FALHA_NA_COMUNICACAO", cal.get(11), cal.get(12), cal.get(13), cal.get(5), cal.get(2) + 1, cal.get(1));
        Evento[] evts = new Evento[]{evt};
        this.controle.salvaEventos(evts);
        this.controle.putEventos(evts);
        this.eventoOcorreu(evts);
    }

    @Override
    public void notificaRetornoCom() {
        Calendar cal = Calendar.getInstance();
        String messageKey = "Retorno_da_comunicacao_com_UPS__Horario";
        this.mostraPopUpAlerta(messageKey, String.valueOf(ResourceBundle.getBundle(Idioma.getIdioma()).getString(messageKey)) + this.formatador.format(this.controle.getHora()) + ":" + this.formatador.format(this.controle.getMinutos()), false);
        Evento evt = new Evento("RETORNO_DE_COMUNICACAO", cal.get(11), cal.get(12), cal.get(13), cal.get(5), cal.get(2) + 1, cal.get(1));
        Evento[] evts = new Evento[]{evt};
        this.controle.salvaEventos(evts);
        this.controle.putEventos(evts);
        this.eventoOcorreu(evts);
    }

    @Override
    public void notificaFalhaRede() {
        if (this.energiaPop) {
            String messageKey = "Falta_de_energia__Horario";
            this.mostraPopUpAlerta(messageKey, String.valueOf(ResourceBundle.getBundle(Idioma.getIdioma()).getString(messageKey)) + this.formatador.format(this.controle.getHora()) + ":" + this.formatador.format(this.controle.getMinutos()), true);
        }
    }

    @Override
    public void notificaRetornoRede() {
        if (this.energiaPop) {
            String messageKey = "Retorno_de_energia__Horario";
            this.mostraPopUpAlerta(messageKey, String.valueOf(ResourceBundle.getBundle(Idioma.getIdioma()).getString(messageKey)) + this.formatador.format(this.controle.getHora()) + ":" + this.formatador.format(this.controle.getMinutos()), false);
        }
    }

    @Override
    public void notificaBateriaBaixa() {
        if (this.bateriaPop) {
            String messageKey = "A_bateria_esta_fraca__Horario";
            this.mostraPopUpAlerta(messageKey, String.valueOf(ResourceBundle.getBundle(Idioma.getIdioma()).getString(messageKey)) + this.formatador.format(this.controle.getHora()) + ":" + this.formatador.format(this.controle.getMinutos()), true);
        }
    }

    @Override
    public void notificaBateriaNormal() {
        if (this.bateriaPop) {
            String messageKey = "A_bateria_esta_normal__Horario";
            this.mostraPopUpAlerta(messageKey, String.valueOf(ResourceBundle.getBundle(Idioma.getIdioma()).getString(messageKey)) + this.formatador.format(this.controle.getHora()) + ":" + this.formatador.format(this.controle.getMinutos()), false);
        }
    }

    @Override
    public void notificaCargaElevada() {
        if (this.cargaPop) {
            String messageKey = "A_carga_esta_elevada__Horario";
            this.mostraPopUpAlerta(messageKey, String.valueOf(ResourceBundle.getBundle(Idioma.getIdioma()).getString(messageKey)) + this.formatador.format(this.controle.getHora()) + ":" + this.formatador.format(this.controle.getMinutos()), true);
        }
    }

    @Override
    public void notificaCargaNormal() {
        if (this.cargaPop) {
            String messageKey = "A_carga_esta_normal__Horario";
            this.mostraPopUpAlerta(messageKey, String.valueOf(ResourceBundle.getBundle(Idioma.getIdioma()).getString(messageKey)) + this.formatador.format(this.controle.getHora()) + ":" + this.formatador.format(this.controle.getMinutos()), false);
        }
    }

    @Override
    public void notificaTemperaturaElevada() {
        if (this.temperaturaPop) {
            String messageKey = "A_temperatura_esta_elevada__Horario";
            this.mostraPopUpAlerta(messageKey, String.valueOf(ResourceBundle.getBundle(Idioma.getIdioma()).getString(messageKey)) + this.formatador.format(this.controle.getHora()) + ":" + this.formatador.format(this.controle.getMinutos()), true);
        }
    }

    @Override
    public void notificaTemperaturaNormal() {
        if (this.temperaturaPop) {
            String messageKey = "A_temperatura_esta_normal__Horario";
            this.mostraPopUpAlerta(messageKey, String.valueOf(ResourceBundle.getBundle(Idioma.getIdioma()).getString(messageKey)) + this.formatador.format(this.controle.getHora()) + ":" + this.formatador.format(this.controle.getMinutos()), false);
        }
    }

    @Override
    public void notificaUsandoBateria() {
        if (this.bateriaUsoPop) {
            String messageKey = "A_bateria_esta_em_uso__Horario";
            this.mostraPopUpAlerta(messageKey, String.valueOf(ResourceBundle.getBundle(Idioma.getIdioma()).getString(messageKey)) + this.formatador.format(this.controle.getHora()) + ":" + this.formatador.format(this.controle.getMinutos()), true);
        }
    }

    @Override
    public void notificaNaoUsaBateria() {
        if (this.bateriaUsoPop) {
            String messageKey = "A_bateria_nao_esta_mais_em_uso__Horario";
            this.mostraPopUpAlerta(messageKey, String.valueOf(ResourceBundle.getBundle(Idioma.getIdioma()).getString(messageKey)) + this.formatador.format(this.controle.getHora()) + ":" + this.formatador.format(this.controle.getMinutos()), false);
        }
    }

    @Override
    public void notificaComunicacao() {
        this.controle.setExpansorBateria(this.painelConfig.getPainelUPS().getExpansorBateria());
        this.painelMonitoramento.coletaDados();
        CardLayout card = (CardLayout)this.getPainelCentral().getLayout();
        card.show(this.getPainelCentral(), "PainelMonitor");
        this.painelFuncional.mudaPrompt(0, 0);
    }

    public void mostraPopUpAlerta(String messageKey, String mensagem, boolean alerta) {
        if (!this.addPopupCache(messageKey)) {
            return;
        }
        PopUpAlerta falha = new PopUpAlerta(String.valueOf(this.caminhoFiguras) + "PopUp.png", this.caminhoFiguras, mensagem, this.caminhoFiguras, this, alerta);
        falha.setMessageKey(messageKey);
    }

    public synchronized boolean addPopupCache(String message) {
        if (this.messagePopupCache.containsKey(message)) {
            return false;
        }
        this.messagePopupCache.put(message, 1);
        return true;
    }

    public synchronized void delPopupCache(String message) {
        if (this.messagePopupCache.containsKey(message)) {
            this.messagePopupCache.remove(message);
        }
    }

    public void mostraPopUp(String mensagem) {
        if (!this.addPopupCache(mensagem)) {
            return;
        }
        PopUpAlerta falha = new PopUpAlerta(String.valueOf(this.caminhoFiguras) + "PopUp.png", this.caminhoFiguras, String.valueOf(ResourceBundle.getBundle(Idioma.getIdioma()).getString(mensagem)) + this.formatador.format(this.controle.getHora()) + ":" + this.formatador.format(this.controle.getMinutos()), this.caminhoFiguras, this, true);
        falha.setMessageKey(mensagem);
    }

    public void atualizaProgramacao() {
        boolean[] prog = this.controle.getDiasSemanaProgramados();
        this.painelComandos.getCbDomingo().setSelected(prog[0]);
        this.painelComandos.getCbSegunda().setSelected(prog[1]);
        this.painelComandos.getCbTerca().setSelected(prog[2]);
        this.painelComandos.getCbQuarta().setSelected(prog[3]);
        this.painelComandos.getCbQuinta().setSelected(prog[4]);
        this.painelComandos.getCbSexta().setSelected(prog[5]);
        this.painelComandos.getCbSabado().setSelected(prog[6]);
        if (prog[0] && prog[1] && prog[2] && prog[3] && prog[4] && prog[5] && prog[6]) {
            this.painelComandos.getCbTodos().setSelected(true);
        } else {
            this.painelComandos.getCbTodos().setSelected(false);
        }
        this.painelComandos.getSpinnerHoraLigar().getModel().setValue(this.formatador.format(this.controle.getHoraLigar()));
        this.painelComandos.getSpinnerHoraDesligar().getModel().setValue(this.formatador.format(this.controle.getHoraDesligar()));
        this.painelComandos.getSpinnerMinutoLigar().getModel().setValue(this.formatador.format(this.controle.getMinutoLigar()));
        this.painelComandos.getSpinnerMinutoDesligar().getModel().setValue(this.formatador.format(this.controle.getMinutoDesligar()));
        this.painelComandos.setFlag(false);
    }

    public void limpaGUI() {
        this.painelMonitoramento.painelEntrada.setEntrada(0);
        this.painelMonitoramento.painelEntrada.setCorrente(0.0f);
        this.painelMonitoramento.painelEntrada.setFrequencia(0.0f);
        this.painelMonitoramento.painelEntrada.panelBarraTensao.setCont(0, 0.0f);
        this.painelMonitoramento.painelEntrada.setBarraLimSuperior(0.0f);
        this.painelMonitoramento.painelEntrada.setBarraLimInferior(0.0f);
        this.painelMonitoramento.painelSaida.setSaida(0);
        this.painelMonitoramento.painelSaida.panelBarraTensao.setCont(0, 0.0f);
        this.painelMonitoramento.painelSaida.setCorrente(0.0f);
        this.painelMonitoramento.painelSaida.setFrequencia(0.0f);
        this.painelMonitoramento.painelSaida.setBarraLimSuperior(0.0f);
        this.painelMonitoramento.painelSaida.setBarraLimInferior(0.0f);
        this.painelMonitoramento.painelPotencia.setPotAp(0.0f);
        this.painelMonitoramento.painelPotencia.setPotReal(0.0f);
        this.painelMonitoramento.painelPotencia.setFPot(0.0f);
        this.painelMonitoramento.painelBateria.panelBarraTensaoBat.setCont(-1);
        this.painelMonitoramento.painelBateria.setAutonomia(0);
        this.painelMonitoramento.painelBateria.setTensao(0.0f);
        this.painelMonitoramento.painelTemperatura.panelBarraTemp.setCont(-1);
        this.trataStsAls.setCarregandoBateria(false);
        this.trataStsAls.setBateriaEmUso(false);
        this.trataStsAls.setModoInversor(false);
        this.trataStsAls.setFalhaRede(false);
        this.trataStsAls.setBateriaBaixa(false);
        this.trataStsAls.setBateriaCritica(false);
        this.trataStsAls.setTemperaturaElevada(false);
        this.trataStsAls.setSuperAquecimento(false);
        this.trataStsAls.setCargaElevada(false);
        this.trataStsAls.setSobrecarga(false);
        this.trataStsAls.processaStatusAlertas();
        this.painelStatus.chaveiaLed(1, 0);
        this.painelStatus.chaveiaLed(1, 1);
        this.painelStatus.chaveiaLed(1, 2);
        this.painelStatus.chaveiaLed(1, 3);
        this.painelAlertas.chaveiaLed(1, 0);
        this.painelAlertas.chaveiaLed(1, 1);
        this.painelAlertas.chaveiaLed(1, 2);
        this.painelGraficos.stopCharts();
    }

    protected boolean programaSemana() {
        boolean[] temp = new boolean[]{this.painelComandos.getCbDomingo().isSelected(), this.painelComandos.getCbSegunda().isSelected(), this.painelComandos.getCbTerca().isSelected(), this.painelComandos.getCbQuarta().isSelected(), this.painelComandos.getCbQuinta().isSelected(), this.painelComandos.getCbSexta().isSelected(), this.painelComandos.getCbSabado().isSelected()};
        return this.controle.programaSemana(temp, this.painelComandos.getHoraLigar(), this.painelComandos.getMinutoLigar(), this.painelComandos.getHoraDesligar(), this.painelComandos.getMinutoDesligar());
    }

    private void btnAgendarOnClick() {
        if (this.programaSemana()) {
            PopUp popUp = new PopUp(String.valueOf(this.caminhoFiguras) + "PopUp.png", this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Agendamento_realizado_com_sucesso"), this.caminhoFiguras, 10, 10, this, false, true);
        } else {
            PopUpAlerta popUpAlerta = new PopUpAlerta(String.valueOf(this.caminhoFiguras) + "PopUp.png", this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Agendamento_realizado_sem_sucesso"), this.caminhoFiguras, this, true);
        }
    }

    private void btnSNMPOnClick() {
        boolean escrita = false;
        boolean leitura = false;
        boolean traps = false;
        boolean portaPedido = false;
        boolean getAndSet = false;
        if (this.painelConfig.getPainelSNMP().isFlagGetAndSet()) {
            PopUp pop;
            portaPedido = true;
            String ip = this.controle.getEnderecoIPLocal();
            if (this.painelConfig.getPainelSNMP().isPedidosInvalido()) {
                pop = new PopUp(String.valueOf(this.caminhoFiguras) + "PopUp.png", this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Forneca_um_valor_valido_para_a_porta_de_pedidos"), this.caminhoFiguras, 10, 10, this, true, true);
                this.painelConfig.getPainelSNMP().getPortaPedidos();
                getAndSet = true;
            } else {
                if (this.flagPedidos && !this.pedidoAntigo.equals(this.painelConfig.getPainelSNMP().getTfPedidos().getText())) {
                    this.controle.salvaPortaPedidos(this.painelConfig.getPainelSNMP().getPortaPedidos());
                    ip = String.valueOf(ip) + "/" + this.painelConfig.getPainelSNMP().getPortaPedidos();
                    this.controle.salvaPortaPedidos(this.painelConfig.getPainelSNMP().getPortaPedidos());
                    this.controle.setLocalAdress(ip);
                }
                this.flagPedidos = false;
                if (this.painelConfig.getPainelSNMP().getTfLeitura().getText().equals(this.painelConfig.getPainelSNMP().getTfEscrita().getText())) {
                    pop = new PopUp(String.valueOf(this.caminhoFiguras) + "PopUp.png", this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Comunidade_de_leitura_e_de_escrita_devem_possuir_valores_diferentes"), this.caminhoFiguras, 10, 10, this, true, true);
                    this.painelConfig.getPainelSNMP().getBtnCancel().doClick();
                    getAndSet = true;
                } else {
                    String antigaComunidade;
                    String novaComunidade;
                    if (this.painelConfig.getPainelSNMP().isFlagLeitura() && this.controle.setComunidadeLeitura(novaComunidade = this.painelConfig.getPainelSNMP().getTfLeitura().getText(), antigaComunidade = this.painelConfig.getPainelSNMP().getLeituraAntiga())) {
                        leitura = true;
                    }
                    if (this.painelConfig.getPainelSNMP().isFlagEscrita() && this.controle.setComunidadeEscrita(novaComunidade = this.painelConfig.getPainelSNMP().getTfEscrita().getText(), antigaComunidade = this.painelConfig.getPainelSNMP().getEscritaAntiga())) {
                        escrita = true;
                    }
                }
            }
            if (!getAndSet) {
                if (escrita || leitura || portaPedido) {
                    pop = new PopUp(String.valueOf(this.caminhoFiguras) + "PopUp.png", this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Configuracao_de_gets_e_sets_do_SNMP_realizada_com_sucesso"), this.caminhoFiguras, 10, 10, this, false, true);
                    this.controle.salvaPortaPedidos(this.painelConfig.getPainelSNMP().getPortaPedidos());
                    this.controle.salvaComunidadeEscrita(this.painelConfig.getPainelSNMP().getTfEscrita().getText());
                    this.controle.salvaComunidadeLeitura(this.painelConfig.getPainelSNMP().getTfLeitura().getText());
                } else {
                    String mensagem = "";
                    if (!leitura) {
                        mensagem = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Troca_de_comunidade_de_escrita_nao_pode_ser_realizada");
                    }
                    if (!escrita) {
                        mensagem = String.valueOf(mensagem) + "\n" + ResourceBundle.getBundle(Idioma.getIdioma()).getString("Troca_de_comunidade_de_leitura_nao_pode_ser_realizada");
                    }
                    PopUp popUp = new PopUp(String.valueOf(this.caminhoFiguras) + "PopUp.png", this.caminhoFiguras, mensagem, this.caminhoFiguras, 10, 10, this, true, true);
                }
            }
        }
        if (this.painelConfig.getPainelSNMP().isFlagTraps()) {
            PopUp pop;
            if (!this.painelConfig.getPainelSNMP().getTfGerente().getText().matches("\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b")) {
                pop = new PopUp(String.valueOf(this.caminhoFiguras) + "PopUp.png", this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Entre_com_um_endereco_de_IP_valido"), this.caminhoFiguras, 10, 10, this, true, true);
                this.painelConfig.getPainelSNMP().getBtnCancel().doClick();
            } else if (this.painelConfig.getPainelSNMP().isEnvioInvalido()) {
                pop = new PopUp(String.valueOf(this.caminhoFiguras) + "PopUp.png", this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Forneca_um_valor_valido_para_a_porta_de_envio"), this.caminhoFiguras, 10, 10, this, true, true);
                this.painelConfig.getPainelSNMP().getPortaEnvio();
            } else {
                traps = this.controle.setConfigTraps(this.painelConfig.getPainelSNMP().getTfGerente().getText(), Integer.parseInt(this.painelConfig.getPainelSNMP().getTfEnvio().getText()), this.painelConfig.getPainelSNMP().getCbSNMP().getSelectedIndex() + 1, this.painelConfig.getPainelSNMP().getCbTransporte().getSelectedItem().toString(), this.painelConfig.getPainelSNMP().getTfEscrita().getText());
                if (traps) {
                    pop = new PopUp(String.valueOf(this.caminhoFiguras) + "PopUp.png", this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Configuracao_de_traps_do_SNMP_realizada_com_sucesso"), this.caminhoFiguras, 10, 10, this, false, true);
                } else {
                    String mensagem = "";
                    if (!traps) {
                        mensagem = ResourceBundle.getBundle(Idioma.getIdioma()).getString("Configuracao_de_traps_nao_pode_ser_realizada");
                    }
                    PopUp popUp = new PopUp(String.valueOf(this.caminhoFiguras) + "PopUp.png", this.caminhoFiguras, mensagem, this.caminhoFiguras, 10, 10, this, true, true);
                }
                this.controle.salvaEnderecoGerente(this.painelConfig.getPainelSNMP().getTfGerente().getText());
                this.controle.salvaPortaEnvio(Integer.parseInt(this.painelConfig.getPainelSNMP().getTfEnvio().getText()));
                this.controle.salvaProtocolo(this.painelConfig.getPainelSNMP().getCbTransporte().getSelectedIndex());
                this.controle.salvaVSnmp(this.painelConfig.getPainelSNMP().getCbSNMP().getSelectedIndex());
            }
        }
        this.painelConfig.getPainelSNMP().setFlagTraps(false);
        this.painelConfig.getPainelSNMP().setFlagGetAndSet(false);
    }

    private void enterSNMP() {
        this.painelConfig.getPainelSNMP().getTfPedidos().setText(Integer.toString(this.controle.getPortaPedidos()));
        this.pedidoAntigo = Integer.toString(this.controle.getPortaPedidos());
        this.painelConfig.getPainelSNMP().getTfLeitura().setText(this.controle.getComunidadeLeitura());
        this.painelConfig.getPainelSNMP().getTfEscrita().setText(this.controle.getComunidadeEscrita());
        this.painelConfig.getPainelSNMP().getTfGerente().setText(this.controle.getEnderecoGerente());
        this.painelConfig.getPainelSNMP().getTfEnvio().setText(Integer.toString(this.controle.getPortaEnvio()));
        this.painelConfig.getPainelSNMP().getCbSNMP().setSelectedIndex(this.controle.getVSNMP());
        this.painelConfig.getPainelSNMP().getCbTransporte().setSelectedIndex(this.controle.getProtocoloTransportePersistencia());
        this.painelConfig.getPainelSNMP().setFlagLeitura(false);
        this.painelConfig.getPainelSNMP().setFlagEscrita(false);
        this.painelConfig.getPainelSNMP().setFlagGetAndSet(false);
        this.painelConfig.getPainelSNMP().setFlagTraps(false);
        this.painelConfig.getPainelSNMP().setFlag(false);
    }

    private void enterGeral() {
        this.painelConfig.getPainelConfigGeral().getTfPortaShutdownRemoto().setText(Integer.toString(this.controle.getPortaRemota()));
        this.painelConfig.getPainelConfigGeral().getCbShutdownRemoto().setSelected(this.controle.getModoRemoto());
        this.painelConfig.getPainelConfigGeral().setFlag(false);
    }

    private void enterUPS() {
        if (this.controle.getNomeUPSPersistencia().equals("vazio")) {
            this.painelConfig.getPainelUPS().getNomeUPS().setText("");
        } else {
            this.painelConfig.getPainelUPS().getNomeUPS().setText(this.controle.getNomeUPSPersistencia());
        }
        this.painelConfig.getPainelUPS().getTextFieldExpanBat().setText(Integer.toString(this.controle.getExpansorBateriaPersistencia()));
        this.painelConfig.getPainelUPS().setFlag(false);
    }

    private void enterSMTP() {
        this.painelConfig.getPainelSMTP().getTfEndServidor().setText(this.controle.getEnderecoSMTPPersistencia());
        this.painelConfig.getPainelSMTP().getCbAutenticacao().setSelected(this.controle.getFlagAutenticacoPersistencia());
        this.painelConfig.getPainelSMTP().getTfUsuario().setText(this.controle.getUsuarioPersistencia());
        this.painelConfig.getPainelSMTP().getPfSenha().setText(this.controle.getSenhaPersistencia());
        this.painelConfig.getPainelSMTP().getTfRemetente().setText(this.controle.getRemetentePersistencia());
        String[] tempDest = this.controle.getDestinatariosPersistencia();
        String tempDest2 = "";
        int i = 0;
        while (i < tempDest.length) {
            tempDest2 = String.valueOf(tempDest2) + tempDest[i] + ", ";
            ++i;
        }
        this.painelConfig.getPainelSMTP().getTfDestinatario().setText(tempDest2);
        if (this.painelConfig.getPainelSMTP().getTfDestinatario().getText().equals(", ")) {
            this.painelConfig.getPainelSMTP().getTfDestinatario().setText("");
        }
        this.painelConfig.getPainelSMTP().getTfPorta().setText(Integer.toString(this.controle.getPortaSMTPPersistencia()));
        this.painelConfig.getPainelSMTP().setFlag(false);
    }

    public PainelConfig getPainelConfig() {
        return this.painelConfig;
    }

    public PainelComando getPainelComando() {
        return this.painelComandos;
    }

    public int getXPop() {
        return this.xPop;
    }

    public int getYPop() {
        return this.yPop;
    }

    public PainelBarrado getPainelStatus() {
        return this.painelStatus;
    }

    public PainelBarrado getPainelAlertas() {
        return this.painelAlertas;
    }

    public JPanel getPainelCentral() {
        return this.painelFuncional.getPainelCentral();
    }

    public PainelMonitorCentral getPainelMonitor() {
        return this.painelMonitoramento;
    }

    public PainelCentral getPainelFuncional() {
        return this.painelFuncional;
    }

    public PainelGraficos getPainelGraficos() {
        return this.painelGraficos;
    }

    public boolean isBateriaUsoEmail() {
        return this.bateriaUsoEmail;
    }

    public boolean isBateriaUsoPop() {
        return this.bateriaUsoPop;
    }

    public boolean isBateriaEmail() {
        return this.bateriaEmail;
    }

    public boolean isBateriaPop() {
        return this.bateriaPop;
    }

    public boolean isCargaEmail() {
        return this.cargaEmail;
    }

    public boolean isCargaPop() {
        return this.cargaPop;
    }

    public boolean isEnergiaEmail() {
        return this.energiaEmail;
    }

    public boolean isComunicou() {
        return this.comunicou;
    }

    public boolean isEnergiaPop() {
        return this.energiaPop;
    }

    public boolean isComEmail() {
        return this.comEmail;
    }

    public boolean isTemperaturaEmail() {
        return this.temperaturaEmail;
    }

    public boolean isTemperaturaPop() {
        return this.temperaturaPop;
    }

    public void setEventos(String[] eventos) {
        JComboBox eventosBox = this.painelConfig.getPainelConfigGeral().getComboBoxEvento();
        eventosBox.removeAllItems();
        int i = 0;
        while (i < eventos.length) {
            eventosBox.addItem(ResourceBundle.getBundle(Idioma.getIdioma()).getString(eventos[i]));
            ++i;
        }
        this.painelConfig.getPainelConfigGeral().setFlag(false);
    }

    public void setXPop(int xPop) {
        this.xPop = xPop;
    }

    public void setYPop(int yPop) {
        this.yPop = yPop;
    }

    public void setBateriaUsoEmail(boolean bateriaUsoEmail) {
        this.bateriaUsoEmail = bateriaUsoEmail;
    }

    public void setBateriaUsoPop(boolean bateriaUsoPop) {
        this.bateriaUsoPop = bateriaUsoPop;
    }

    public void setBateriaEmail(boolean bateriaEmail) {
        this.bateriaEmail = bateriaEmail;
    }

    public void setBateriaPop(boolean bateriaPop) {
        this.bateriaPop = bateriaPop;
    }

    public void setFlagMonitor(boolean b) {
        this.monitor = b;
    }

    public void setFlagGrafico(boolean b) {
        this.graficos = b;
    }

    public void setCargaEmail(boolean cargaEmail) {
        this.cargaEmail = cargaEmail;
    }

    public void setCargaPop(boolean cargaPop) {
        this.cargaPop = cargaPop;
    }

    public void setEnergiaEmail(boolean energiaEmail) {
        this.energiaEmail = energiaEmail;
    }

    public void setEnergiaPop(boolean energiaPop) {
        this.energiaPop = energiaPop;
    }

    public void setComEmail(boolean comEmail) {
        this.comEmail = comEmail;
    }

    public void setTemperaturaEmail(boolean temperaturaEmail) {
        this.temperaturaEmail = temperaturaEmail;
    }

    public void setTemperaturaPop(boolean temperaturaPop) {
        this.temperaturaPop = temperaturaPop;
    }

    public void setMensagens() {
        this.controle.setMensagens(this.painelConfig.getPainelMensg().getCheckBoxSelected());
        this.controle.salvaMensagens(this.painelConfig.getPainelMensg().getCheckBoxSelected());
        this.energiaEmail = this.painelConfig.getPainelMensg().getCheckBoxSelected()[0][0];
        this.energiaPop = this.painelConfig.getPainelMensg().getCheckBoxSelected()[0][1];
        this.bateriaEmail = this.painelConfig.getPainelMensg().getCheckBoxSelected()[1][0];
        this.bateriaPop = this.painelConfig.getPainelMensg().getCheckBoxSelected()[1][1];
        this.cargaEmail = this.painelConfig.getPainelMensg().getCheckBoxSelected()[2][0];
        this.cargaPop = this.painelConfig.getPainelMensg().getCheckBoxSelected()[2][1];
        this.temperaturaEmail = this.painelConfig.getPainelMensg().getCheckBoxSelected()[3][0];
        this.temperaturaPop = this.painelConfig.getPainelMensg().getCheckBoxSelected()[3][1];
        this.bateriaUsoEmail = this.painelConfig.getPainelMensg().getCheckBoxSelected()[4][0];
        this.bateriaUsoPop = this.painelConfig.getPainelMensg().getCheckBoxSelected()[4][1];
        this.comEmail = this.painelConfig.getPainelMensg().getCheckBoxSelected()[5][0];
    }

    class TrataEventos
    implements ActionListener,
    MouseListener,
    CaretListener {
        private CardLayout card;

        TrataEventos() {
        }

        @Override
        public void caretUpdate(CaretEvent ce) {
            if (ce.getSource() == InterfaceGrafica.this.painelConfig.getPainelSNMP().getTfPedidos() && !InterfaceGrafica.this.flagPedidos) {
                InterfaceGrafica.this.flagPedidos = true;
                InterfaceGrafica.this.pedidoAntigo = InterfaceGrafica.this.painelConfig.getPainelSNMP().getTfPedidos().getText();
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getSource() == InterfaceGrafica.this.botaoMonitor) {
                this.card = (CardLayout)InterfaceGrafica.this.getPainelCentral().getLayout();
                this.card.show(InterfaceGrafica.this.getPainelCentral(), "PainelMonitor");
                InterfaceGrafica.this.painelMonitoramento.coletaDados();
                boolean b1 = InterfaceGrafica.this.painelConfig.getPbc().isConfigChanged();
                boolean b2 = InterfaceGrafica.this.painelComandos.isPainelComandoChanged();
                if (InterfaceGrafica.this.painelConfig.getPbc().isConfigChanged()) {
                    this.card = (CardLayout)InterfaceGrafica.this.getPainelCentral().getLayout();
                    this.card.show(InterfaceGrafica.this.getPainelCentral(), "PainelConfig");
                    InterfaceGrafica.this.painelConfig.getPbc().configChanged();
                }
                if (b2) {
                    this.card = (CardLayout)InterfaceGrafica.this.getPainelCentral().getLayout();
                    this.card.show(InterfaceGrafica.this.getPainelCentral(), "PainelComandos");
                    InterfaceGrafica.this.painelComandos.painelComandosChanged();
                }
                if (!b1 && !b2) {
                    InterfaceGrafica.this.painelFuncional.mudaPrompt(0, 0);
                }
                InterfaceGrafica.this.painelGraficos.stopCharts();
            } else if (ae.getSource() == InterfaceGrafica.this.botaoConfiguracoes) {
                this.card = (CardLayout)InterfaceGrafica.this.getPainelCentral().getLayout();
                this.card.show(InterfaceGrafica.this.getPainelCentral(), "PainelConfig");
                if (InterfaceGrafica.this.painelComandos.isPainelComandoChanged()) {
                    this.card = (CardLayout)InterfaceGrafica.this.getPainelCentral().getLayout();
                    this.card.show(InterfaceGrafica.this.getPainelCentral(), "PainelComandos");
                    InterfaceGrafica.this.painelComandos.painelComandosChanged();
                } else {
                    InterfaceGrafica.this.painelFuncional.mudaPrompt(2, 2);
                    InterfaceGrafica.this.painelGraficos.stopCharts();
                    InterfaceGrafica.this.painelMonitoramento.paraColetaDados();
                    InterfaceGrafica.this.enterSNMP();
                    InterfaceGrafica.this.enterUPS();
                    InterfaceGrafica.this.enterGeral();
                }
            } else if (ae.getSource() == InterfaceGrafica.this.botaoGraficos) {
                this.card = (CardLayout)InterfaceGrafica.this.getPainelCentral().getLayout();
                this.card.show(InterfaceGrafica.this.getPainelCentral(), "PainelGraficos");
                InterfaceGrafica.this.painelGraficos.restartCharts();
                boolean b1 = InterfaceGrafica.this.painelConfig.getPbc().isConfigChanged();
                boolean b2 = InterfaceGrafica.this.painelComandos.isPainelComandoChanged();
                if (InterfaceGrafica.this.painelConfig.getPbc().isConfigChanged()) {
                    this.card = (CardLayout)InterfaceGrafica.this.getPainelCentral().getLayout();
                    this.card.show(InterfaceGrafica.this.getPainelCentral(), "PainelConfig");
                    InterfaceGrafica.this.painelConfig.getPbc().configChanged();
                }
                if (b2) {
                    this.card = (CardLayout)InterfaceGrafica.this.getPainelCentral().getLayout();
                    this.card.show(InterfaceGrafica.this.getPainelCentral(), "PainelComandos");
                    InterfaceGrafica.this.painelComandos.painelComandosChanged();
                }
                if (!b1 && !b2) {
                    InterfaceGrafica.this.painelFuncional.mudaPrompt(1, 1);
                }
                InterfaceGrafica.this.painelMonitoramento.paraColetaDados();
            } else if (ae.getSource() == InterfaceGrafica.this.botaoComandos) {
                this.card = (CardLayout)InterfaceGrafica.this.getPainelCentral().getLayout();
                this.card.show(InterfaceGrafica.this.getPainelCentral(), "PainelComandos");
                if (InterfaceGrafica.this.comunicou) {
                    InterfaceGrafica.this.atualizaProgramacao();
                }
                if (InterfaceGrafica.this.painelConfig.getPbc().isConfigChanged()) {
                    this.card = (CardLayout)InterfaceGrafica.this.getPainelCentral().getLayout();
                    this.card.show(InterfaceGrafica.this.getPainelCentral(), "PainelConfig");
                    InterfaceGrafica.this.painelConfig.getPbc().configChanged();
                } else {
                    InterfaceGrafica.this.painelFuncional.mudaPrompt(3, 3);
                }
                InterfaceGrafica.this.painelGraficos.stopCharts();
                InterfaceGrafica.this.painelMonitoramento.paraColetaDados();
            } else if (ae.getSource() == InterfaceGrafica.this.botaoHistorico) {
                this.card = (CardLayout)InterfaceGrafica.this.getPainelCentral().getLayout();
                this.card.show(InterfaceGrafica.this.getPainelCentral(), "PainelHistorico");
                boolean b1 = InterfaceGrafica.this.painelConfig.getPbc().isConfigChanged();
                boolean b2 = InterfaceGrafica.this.painelComandos.isPainelComandoChanged();
                InterfaceGrafica.this.controle.pedidoDumpping();
                if (InterfaceGrafica.this.painelConfig.getPbc().isConfigChanged()) {
                    this.card = (CardLayout)InterfaceGrafica.this.getPainelCentral().getLayout();
                    this.card.show(InterfaceGrafica.this.getPainelCentral(), "PainelConfig");
                    InterfaceGrafica.this.painelConfig.getPbc().configChanged();
                }
                if (b2) {
                    this.card = (CardLayout)InterfaceGrafica.this.getPainelCentral().getLayout();
                    this.card.show(InterfaceGrafica.this.getPainelCentral(), "PainelComandos");
                    InterfaceGrafica.this.painelComandos.painelComandosChanged();
                }
                if (!b1 && !b2) {
                    InterfaceGrafica.this.painelFuncional.mudaPrompt(4, 4);
                }
                InterfaceGrafica.this.painelGraficos.stopCharts();
                InterfaceGrafica.this.painelMonitoramento.paraColetaDados();
            } else if (ae.getSource() == InterfaceGrafica.this.botaoSobre) {
                this.card = (CardLayout)InterfaceGrafica.this.getPainelCentral().getLayout();
                this.card.show(InterfaceGrafica.this.getPainelCentral(), "PainelSobre");
                boolean b1 = InterfaceGrafica.this.painelConfig.getPbc().isConfigChanged();
                boolean b2 = InterfaceGrafica.this.painelComandos.isPainelComandoChanged();
                if (InterfaceGrafica.this.painelConfig.getPbc().isConfigChanged()) {
                    this.card = (CardLayout)InterfaceGrafica.this.getPainelCentral().getLayout();
                    this.card.show(InterfaceGrafica.this.getPainelCentral(), "PainelConfig");
                    InterfaceGrafica.this.painelConfig.getPbc().configChanged();
                }
                if (b2) {
                    this.card = (CardLayout)InterfaceGrafica.this.getPainelCentral().getLayout();
                    this.card.show(InterfaceGrafica.this.getPainelCentral(), "PainelComandos");
                    InterfaceGrafica.this.painelComandos.painelComandosChanged();
                }
                if (!b1 && !b2) {
                    InterfaceGrafica.this.painelFuncional.mudaPrompt(5, 5);
                }
                InterfaceGrafica.this.painelGraficos.stopCharts();
                InterfaceGrafica.this.painelMonitoramento.paraColetaDados();
            } else if (ae.getSource() == InterfaceGrafica.this.botaoMinimizar) {
                InterfaceGrafica.this.setState(1);
            } else if (ae.getSource() == InterfaceGrafica.this.botaoTray) {
                InterfaceGrafica.this.setState(1);
                InterfaceGrafica.this.setVisible(false);
                InterfaceGrafica.this.painelMonitoramento.paraColetaDados();
                InterfaceGrafica.this.painelGraficos.stopCharts();
            } else if (ae.getSource() == InterfaceGrafica.this.botaoFechar) {
                InterfaceGrafica.this.encerraAplicativo();
            } else if (ae.getSource() == InterfaceGrafica.this.painelConfig.getPbc().getBtnSNMP()) {
                InterfaceGrafica.this.enterSNMP();
            } else if (ae.getSource() == InterfaceGrafica.this.painelConfig.getPbc().getBtnGeral()) {
                InterfaceGrafica.this.enterGeral();
            } else if (ae.getSource() == InterfaceGrafica.this.painelConfig.getPbc().getBtnUPS()) {
                InterfaceGrafica.this.enterUPS();
            } else if (ae.getSource() == InterfaceGrafica.this.painelConfig.getPainelUPS().getBtnOk()) {
                boolean falhou = false;
                Component falha = null;
                if (InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfPorta().getText().equals("0") || InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfPorta().getText().equals("587")) {
                    InterfaceGrafica.this.controle.salvaPortaSMTP(587);
                    InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfPorta().setText(Integer.toString(InterfaceGrafica.this.controle.getPortaSMTPPersistencia()));
                    InterfaceGrafica.this.painelConfig.getPainelSMTP().setFlag(false);
                }
                if (InterfaceGrafica.this.painelConfig.getPainelUPS().getExpansorBateria() != -1) {
                    if (!InterfaceGrafica.this.controle.configuraUPSEtapa1(InterfaceGrafica.this.painelConfig.getPainelUPS().getTipoUps(), InterfaceGrafica.this.painelConfig.getPainelUPS().getPorta())) {
                        falha = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Erro_de_configuracao__Verifique_a_familia_de_UPS_selecionada"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, true, true);
                        falhou = true;
                    } else if (falha != null && falha.isVisible()) {
                        ((Window)falha).dispose();
                    }
                }
                if (InterfaceGrafica.this.painelConfig.getPainelUPS().isExpansorBateriaValido()) {
                    InterfaceGrafica.this.controle.salvaExpansorBateria(InterfaceGrafica.this.painelConfig.getPainelUPS().getExpansorBateria());
                    if (InterfaceGrafica.this.painelConfig.getPainelUPS().getNomeUPS().getText().equals("")) {
                        InterfaceGrafica.this.controle.salvaNomeUPS("vazio");
                    } else {
                        InterfaceGrafica.this.controle.salvaNomeUPS(InterfaceGrafica.this.painelConfig.getPainelUPS().getNomeUPS().getText());
                    }
                    InterfaceGrafica.this.controle.setExpansorBateria(InterfaceGrafica.this.painelConfig.getPainelUPS().getExpansorBateria());
                    if (!falhou) {
                        PopUp popUp = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Sucesso_na_configuracao_do_ups"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, false, true);
                    }
                } else {
                    InterfaceGrafica.this.painelConfig.getPainelUPS().getExpansorBateria();
                }
            } else if (ae.getSource() == InterfaceGrafica.this.painelConfig.getPainelConfigGeral().getBtnProcura()) {
                JFileChooser chooser = new JFileChooser();
                chooser.setApproveButtonText(ResourceBundle.getBundle(Idioma.getIdioma()).getString("Abrir"));
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    InterfaceGrafica.this.painelConfig.getPainelConfigGeral().getTfScript().setText(chooser.getSelectedFile().toString());
                }
            } else if (ae.getSource() == InterfaceGrafica.this.painelConfig.getPainelMensg().getBtnOk()) {
                PopUp pop;
                boolean enter = true;
                InterfaceGrafica.this.setMensagens();
                if ((InterfaceGrafica.this.energiaEmail || InterfaceGrafica.this.bateriaEmail || InterfaceGrafica.this.cargaEmail || InterfaceGrafica.this.temperaturaEmail || InterfaceGrafica.this.bateriaUsoEmail) && (InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfEndServidor().getText().equals("") || InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfPorta().getText().equals(""))) {
                    pop = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Endereco_do_servidor_ou_a_porta_de_email_nao_estao_configurados_corretamente__Emails_nao_poderao_ser_enviados_corretamente_ate_que_o_erro_seja_corrigido"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, true, true);
                    enter = false;
                }
                if (enter) {
                    pop = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Sucesso_na_configuracao_de_mensagens"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, false, true);
                }
            } else if (ae.getSource() == InterfaceGrafica.this.painelConfig.getPainelAutoTeste().getBtnOk()) {
                InterfaceGrafica.this.painelConfig.getPainelAutoTeste().validateForm();
                InterfaceGrafica.this.controle.configuraAutoTeste(InterfaceGrafica.this.painelConfig.getPainelAutoTeste().getAutoTesteHabilitado(), InterfaceGrafica.this.painelConfig.getPainelAutoTeste().getHoraTeste(), InterfaceGrafica.this.painelConfig.getPainelAutoTeste().getMinutoTeste(), InterfaceGrafica.this.painelConfig.getPainelAutoTeste().getPeriodoAutoTeste());
                PopUp pop = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Sucesso_na_configuracao_de_auto_teste"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, false, true);
                InterfaceGrafica.this.painelConfig.getPainelAutoTeste().setFlag(false);
            } else if (ae.getSource() == InterfaceGrafica.this.painelConfig.getPainelAutoTeste().getBtnCancel()) {
                InterfaceGrafica.this.painelConfig.getPainelAutoTeste().setHoraTeste(InterfaceGrafica.this.controle.getHoraTestePersistencia());
                InterfaceGrafica.this.painelConfig.getPainelAutoTeste().setMinutoTeste(InterfaceGrafica.this.controle.getMinutoTestePersistencia());
                InterfaceGrafica.this.painelConfig.getPainelAutoTeste().setPeriodoAutoTeste(InterfaceGrafica.this.controle.getPeriodoTestePersistencia());
                InterfaceGrafica.this.painelConfig.getPainelAutoTeste().setAutoTesteHabilitado(InterfaceGrafica.this.controle.getAutoTesteEnabledPersitencia());
                InterfaceGrafica.this.painelConfig.getPainelAutoTeste().setFlag(false);
            } else if (ae.getSource() == InterfaceGrafica.this.painelConfig.getPainelConfigGeral().getBtnOk()) {
                boolean sucesso = false;
                if (InterfaceGrafica.this.painelConfig.getPainelConfigGeral().getCbVarLogging().isSelected()) {
                    InterfaceGrafica.this.controle.salvaModoLogging(true);
                } else {
                    InterfaceGrafica.this.controle.salvaModoLogging(false);
                }
                if (InterfaceGrafica.this.painelConfig.getPainelConfigGeral().getCbShutdownRemoto().isSelected()) {
                    if (InterfaceGrafica.this.painelConfig.getPainelConfigGeral().isPortaValida()) {
                        InterfaceGrafica.this.controle.salvaPortaRemota(InterfaceGrafica.this.painelConfig.getPainelConfigGeral().getPorta());
                        if (!InterfaceGrafica.this.controle.isModoRemoto()) {
                            ((InterfaceGrafica)InterfaceGrafica.this).controle.executaAcaoRede = new ExecutaAcaoRede();
                            ((InterfaceGrafica)InterfaceGrafica.this).controle.executaAcaoRede.setPortaEscuta(InterfaceGrafica.this.controle.getPortaRemota());
                            ((InterfaceGrafica)InterfaceGrafica.this).controle.executaAcaoRede.start();
                        }
                        InterfaceGrafica.this.controle.salvaModoRemoto(true);
                        sucesso = true;
                    } else {
                        InterfaceGrafica.this.controle.salvaModoRemoto(false);
                    }
                } else {
                    sucesso = true;
                }
                InterfaceGrafica.this.validarAllIdioma();
                InterfaceGrafica.this.controle.salvaEventoGatilho(InterfaceGrafica.this.painelConfig.getPainelConfigGeral().getComboBoxEvento().getSelectedIndex());
                InterfaceGrafica.this.controle.salvaScript(InterfaceGrafica.this.painelConfig.getPainelConfigGeral().getTfScript().getText());
                if (!(InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfEndServidor().getText().equals("") || InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfUsuario().getText().equals("") || InterfaceGrafica.this.painelConfig.getPainelSMTP().getPfSenha().getPassword().equals(""))) {
                    InterfaceGrafica.this.controle.setEnderecoSMTP(InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfEndServidor().getText());
                    InterfaceGrafica.this.controle.setUsuario(InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfUsuario().getText());
                    InterfaceGrafica.this.controle.setSenha(InterfaceGrafica.this.painelConfig.getPainelSMTP().getPfSenha().getPassword().toString());
                }
                if (sucesso) {
                    PopUp pop = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Sucesso_na_configuracao_geral"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, false, true);
                } else {
                    PopUp pop = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Entre_com_um_valor_valido_para_a_porta_de_comunicacao_remota"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, true, true);
                }
            } else if (ae.getSource() == InterfaceGrafica.this.painelConfig.getPainelSMTP().getBtnOk()) {
                if (InterfaceGrafica.this.painelConfig.getPainelSMTP().isPortaValida()) {
                    if (InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfEndServidor().getText().equals("") || InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfPorta().getText().equals("")) {
                        InterfaceGrafica.this.painelConfig.getPainelMensg().clearEmail();
                        InterfaceGrafica.this.controle.salvaMensagens(InterfaceGrafica.this.painelConfig.getPainelMensg().getCheckBoxSelected());
                        PopUp sucesso = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("O_sistema_nao_podera_lancar_email_ate_que_os_campos_de_endereco_do_gerente_e_porta_de_envio_sejam_preenchidos__Todo_o_envio_de_mensagens_por_email_foi_cancelado"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, false, true);
                    } else {
                        String[] temp = InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfDestinatario().getText().split(", ");
                        InterfaceGrafica.this.controle.configuraEmail(temp, InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfRemetente().getText(), InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfEndServidor().getText(), InterfaceGrafica.this.painelConfig.getPainelSMTP().getPorta(), InterfaceGrafica.this.painelConfig.getPainelSMTP().getCbAutenticacao().isSelected(), InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfUsuario().getText(), InterfaceGrafica.this.painelConfig.getPainelSMTP().getPfSenha().getText());
                        PopUp pop = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Sucesso_na_configuracao_do_email"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, false, true);
                    }
                } else {
                    PopUp temp = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Entre_com_um_valor_valido_para_a_porta_de_envio_do_smtp"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, true, true);
                }
            } else if (ae.getSource() == InterfaceGrafica.this.painelConfig.getPainelConfigGeral().getBtnCancel()) {
                InterfaceGrafica.this.painelConfig.getPainelConfigGeral().getTfPortaShutdownRemoto().setText(Integer.toString(InterfaceGrafica.this.controle.getPortaRemota()));
                InterfaceGrafica.this.painelConfig.getPainelConfigGeral().getCbShutdownRemoto().setSelected(InterfaceGrafica.this.controle.getModoRemoto());
                InterfaceGrafica.this.painelConfig.getPainelConfigGeral().setFlag(false);
            } else if (ae.getSource() == InterfaceGrafica.this.painelConfig.getPainelSMTP().getBtnCancel()) {
                String[] tempDest = InterfaceGrafica.this.controle.getDestinatariosPersistencia();
                String tempDest2 = "";
                int i = 0;
                while (i < tempDest.length) {
                    tempDest2 = String.valueOf(tempDest2) + tempDest[i] + ", ";
                    ++i;
                }
                if (InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfDestinatario().getText().equals(", ")) {
                    InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfDestinatario().setText("");
                }
                InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfDestinatario().setText(tempDest2);
                InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfEndServidor().setText(InterfaceGrafica.this.controle.getEnderecoSMTPPersistencia());
                InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfPorta().setText(Integer.toString(InterfaceGrafica.this.controle.getPortaSMTPPersistencia()));
                System.out.println("Porta-cance\u00e7ameto: " + InterfaceGrafica.this.controle.getPortaSMTPPersistencia());
                InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfRemetente().setText(InterfaceGrafica.this.controle.getRemetentePersistencia());
                InterfaceGrafica.this.painelConfig.getPainelSMTP().getTfUsuario().setText(InterfaceGrafica.this.controle.getUsuarioPersistencia());
                InterfaceGrafica.this.painelConfig.getPainelSMTP().getPfSenha().setText(InterfaceGrafica.this.controle.getSenhaPersistencia());
                InterfaceGrafica.this.painelConfig.getPainelSMTP().getCbAutenticacao().setSelected(InterfaceGrafica.this.controle.getFlagAutenticacoPersistencia());
                InterfaceGrafica.this.painelConfig.getPainelSMTP().setFlag(false);
                InterfaceGrafica.this.painelConfig.getPainelSMTP().setProvedor(InterfaceGrafica.this.controle.getProvedorEscolhidoPersitencia());
                InterfaceGrafica.this.painelConfig.getPainelSMTP().getCmbProvedores().setSelectedItem(InterfaceGrafica.this.controle.getProvedorEscolhidoPersitencia());
                InterfaceGrafica.this.painelConfig.getPainelSMTP().atualizarCamposEmail(InterfaceGrafica.this.controle.getProvedorEscolhidoPersitencia());
            } else if (ae.getSource() == InterfaceGrafica.this.painelConfig.getPainelSNMP().getBtnOk()) {
                InterfaceGrafica.this.btnSNMPOnClick();
            } else if (ae.getSource() == InterfaceGrafica.this.painelConfig.getPainelSNMP().getBtnCancel()) {
                InterfaceGrafica.this.painelConfig.getPainelSNMP().getTfPedidos().setText(Integer.toString(InterfaceGrafica.this.controle.getPortaPedidos()));
                InterfaceGrafica.this.painelConfig.getPainelSNMP().getTfLeitura().setText(InterfaceGrafica.this.controle.getComunidadeLeitura());
                InterfaceGrafica.this.painelConfig.getPainelSNMP().getTfEscrita().setText(InterfaceGrafica.this.controle.getComunidadeEscrita());
                InterfaceGrafica.this.painelConfig.getPainelSNMP().getTfGerente().setText(InterfaceGrafica.this.controle.getEnderecoGerente());
                InterfaceGrafica.this.painelConfig.getPainelSNMP().getTfEnvio().setText(Integer.toString(InterfaceGrafica.this.controle.getPortaEnvio()));
                InterfaceGrafica.this.painelConfig.getPainelSNMP().getCbSNMP().setSelectedIndex(InterfaceGrafica.this.controle.getVSNMP());
                InterfaceGrafica.this.painelConfig.getPainelSNMP().getCbTransporte().setSelectedIndex(InterfaceGrafica.this.controle.getProtocoloTransportePersistencia());
                InterfaceGrafica.this.painelConfig.getPainelSNMP().setFlagLeitura(false);
                InterfaceGrafica.this.painelConfig.getPainelSNMP().setFlagEscrita(false);
                InterfaceGrafica.this.painelConfig.getPainelSNMP().setFlag(false);
            } else if (ae.getSource() == InterfaceGrafica.this.painelComandos.getBtnAgendar()) {
                Calendar calendar = Calendar.getInstance();
                calendar.setLenient(true);
                if (InterfaceGrafica.this.painelComandos.getDiasSemana()[calendar.get(7) - 1]) {
                    Calendar compare = Calendar.getInstance();
                    compare.set(calendar.get(1), calendar.get(2), calendar.get(5), InterfaceGrafica.this.painelComandos.getHoraDesligar(), InterfaceGrafica.this.painelComandos.getMinutoDesligar());
                    calendar.add(12, 5);
                    int result = compare.compareTo(calendar);
                    if (result > 0) {
                        InterfaceGrafica.this.btnAgendarOnClick();
                    } else {
                        calendar.add(12, -5);
                        result = compare.compareTo(calendar);
                        if (result > 0) {
                            PopUp pop = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Tempo_para_desligamento_do_SO_provavelmente_insuficiente__Deseja_continuar"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, false, false);
                            pop.getBtnYes().addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent ae) {
                                    InterfaceGrafica.this.btnAgendarOnClick();
                                    InterfaceGrafica.this.controle.encerraSO();
                                    InterfaceGrafica.this.encerraAplicativo();
                                }
                            });
                        } else {
                            InterfaceGrafica.this.btnAgendarOnClick();
                        }
                    }
                } else {
                    InterfaceGrafica.this.btnAgendarOnClick();
                }
            } else if (ae.getSource() == InterfaceGrafica.this.painelComandos.getBtnAgendar2()) {
                PopUp calendar;
                if (InterfaceGrafica.this.painelComandos.getCbAutonomia().isSelected()) {
                    InterfaceGrafica.this.controle.setFlagShutFimAut(true);
                    if (InterfaceGrafica.this.painelComandos.isTempoAutonomiaValido()) {
                        InterfaceGrafica.this.controle.setAutonomiaMinima(InterfaceGrafica.this.painelComandos.getTempoAutonomia());
                        calendar = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Modificacao_de_tempo_de_shutdown_apos_fim_de_autonomia_foi_realizado_com_sucesso"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, false, true);
                    } else {
                        calendar = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Modificacao_nao_confirmada__Entre_com_um_valor_valido"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, true, true);
                    }
                }
                if (InterfaceGrafica.this.painelComandos.getCbTempoFalha().isSelected()) {
                    InterfaceGrafica.this.controle.setShutdownTempoFalha(true);
                    if (InterfaceGrafica.this.painelComandos.isTempoFalhaValido()) {
                        InterfaceGrafica.this.controle.setTempoFalha(InterfaceGrafica.this.painelComandos.getTempoFalha());
                        calendar = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Modificacao_de_tempo_de_shutdown_apos_falha_na_rede_eletrica_foi_realizado_com_sucesso"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, false, true);
                    } else {
                        calendar = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Modificacao_nao_confirmada__Entre_com_um_valor_valido"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, true, true);
                    }
                }
            } else if (ae.getSource() == InterfaceGrafica.this.painelComandos.getBtnShutdown()) {
                PopUp pop = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Deseja_realizar_o_shutdown_imediato"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, false, false);
                pop.getBtnYes().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        InterfaceGrafica.this.controle.desligaUPS();
                    }
                });
            } else if (ae.getSource() == InterfaceGrafica.this.painelComandos.getBtnShutdownReligamento()) {
                PopUp pop = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Deseja_realizar_o_shutdown_com_religamento"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, false, false);
                pop.getBtnYes().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        InterfaceGrafica.this.controle.religaUPS();
                    }
                });
            } else if (ae.getSource() == InterfaceGrafica.this.painelHistorico.getBtnLimparSelecao()) {
                if (InterfaceGrafica.this.painelHistorico.getTableModel().getRowCount() != 0) {
                    if (!InterfaceGrafica.this.painelHistorico.getRow()) {
                        PopUp pop = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Linha_vazia__Escolha_um_registro_valido"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, true, true);
                    } else {
                        PopUp pop2 = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Deseja_apagar_o_registro_selecionado_do_historico"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, false, false);
                        pop2.getBtnYes().addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (InterfaceGrafica.this.controle.excluirEvento(InterfaceGrafica.this.painelHistorico.getSelectedRow())) {
                                    InterfaceGrafica.this.painelHistorico.getTableEvento().removeRow(InterfaceGrafica.this.painelHistorico.getSelectedRow());
                                    InterfaceGrafica.this.painelHistorico.setSelectedRow(-1);
                                } else {
                                    PopUp popUp = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Erro_ao_apagar_o_registro_selecionado_do_historico"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, true, true);
                                }
                            }
                        });
                        pop2.getBtnNo().addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                            }
                        });
                    }
                }
            } else if (ae.getSource() == InterfaceGrafica.this.painelHistorico.getBtnLimparTudo() && InterfaceGrafica.this.painelHistorico.getTableModel().getRowCount() != 0) {
                final ListSelectionModel lsm = InterfaceGrafica.this.painelHistorico.getTabelaAlarmes().getSelectionModel();
                lsm.setSelectionMode(2);
                InterfaceGrafica.this.painelHistorico.getTabelaAlarmes().selectAll();
                PopUp pop = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Deseja_apagar_todos_os_registros_do_historico"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, false, false);
                pop.getBtnYes().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (InterfaceGrafica.this.controle.excluirTodosEventos()) {
                            InterfaceGrafica.this.painelHistorico.limpaTabela();
                        } else {
                            PopUp pop = new PopUp(String.valueOf(InterfaceGrafica.this.caminhoFiguras) + "PopUp.png", InterfaceGrafica.this.caminhoFiguras, ResourceBundle.getBundle(Idioma.getIdioma()).getString("Erro_ao_apagar_todos_os_registros_do_historico"), InterfaceGrafica.this.caminhoFiguras, 10, 10, InterfaceGrafica.this, true, true);
                            lsm.setSelectionMode(0);
                        }
                    }
                });
                pop.getBtnNo().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        InterfaceGrafica.this.painelHistorico.getTabelaAlarmes().clearSelection();
                        lsm.setSelectionMode(0);
                    }
                });
            }
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (InterfaceGrafica.this.monitor) {
                InterfaceGrafica.this.painelMonitoramento.coletaDados();
            } else if (InterfaceGrafica.this.graficos) {
                InterfaceGrafica.this.painelGraficos.restartCharts();
            }
            InterfaceGrafica.this.setVisible(true);
            InterfaceGrafica.this.setState(0);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
        }

        @Override
        public void mouseEntered(MouseEvent me) {
        }

        @Override
        public void mouseExited(MouseEvent me) {
        }

        @Override
        public void mousePressed(MouseEvent me) {
        }
    }
}

